/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFolderRepository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class LocalFolderRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    public boolean isSuitable(OWLModel oWLModel, String string) {
        if (string.trim().startsWith("file:")) {
            try {
                URI uRI = new URI(string.trim());
                File file = new File(uRI.getPath());
                return file.isDirectory();
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
        }
        return false;
    }

    public Repository createRepository(OWLModel oWLModel, String string) {
        try {
            URI uRI = new URI(string);
            return new LocalFolderRepository(new File(uRI.getPath()), RepositoryUtil.isForcedToBeReadOnly(uRI.getQuery()), RepositoryUtil.getBooleanProperty("Recursive", uRI.getQuery()));
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println(uRISyntaxException.getMessage());
            return null;
        }
    }
}

