/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactory;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractStreamBasedRepositoryImpl;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import edu.stanford.smi.protegex.owl.repository.util.URLInputSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPRepository
extends AbstractStreamBasedRepositoryImpl {
    private static transient Logger log = Log.getLogger(HTTPRepository.class);
    private URL ontologyURL;
    private URI ontologyName;

    public HTTPRepository(URL uRL) {
        this.ontologyURL = uRL;
        this.ontologyName = null;
        this.update();
    }

    @Override
    public String getRepositoryDescriptor() {
        return this.ontologyURL.toString();
    }

    @Override
    public String getOntologyLocationDescription(URI uRI) {
        String string = "";
        if (this.ontologyName.equals(uRI)) {
            string = this.ontologyURL.toString();
        }
        return string;
    }

    private void update() {
        try {
            PrintStream printStream = System.err;
            System.setErr(new PrintStream(new OutputStream(){

                public void write(int n) throws IOException {
                }
            }));
            OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(new URLInputSource(this.ontologyURL));
            this.ontologyName = ontologyNameExtractor.getOntologyName();
            System.setErr(printStream);
        }
        catch (IOException iOException) {
            Log.getLogger().warning("Could not get ontology from URL: " + this.ontologyURL);
        }
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    public URL getOntologyURL() {
        return this.ontologyURL;
    }

    @Override
    public boolean contains(URI uRI) {
        if (this.ontologyName != null) {
            return this.ontologyName.equals(uRI);
        }
        return false;
    }

    @Override
    public void refresh() {
        this.update();
    }

    @Override
    public Collection<URI> getOntologies() {
        if (this.ontologyName != null) {
            return Collections.singleton(this.ontologyName);
        }
        return Collections.emptyList();
    }

    public URL getLocation(URI uRI) {
        if (uRI == null) {
            return null;
        }
        if (uRI.equals(this.ontologyName)) {
            return this.ontologyURL;
        }
        return null;
    }

    @Override
    public InputStream getInputStream(URI uRI) throws OntologyLoadException {
        return ProtegeOWLParser.getInputStream(this.ontologyURL);
    }

    @Override
    public boolean isWritable(URI uRI) {
        try {
            File file = new File(new URI(this.ontologyURL.toString()));
            return file.canWrite();
        }
        catch (Exception exception) {
            Log.emptyCatchBlock((Throwable)exception);
            return false;
        }
    }

    @Override
    public OutputStream getOutputStream(URI uRI) throws IOException {
        FileOutputStream fileOutputStream = null;
        if (this.isWritable(uRI)) {
            try {
                File file = new File(new URI(this.ontologyURL.toString()));
                fileOutputStream = new FileOutputStream(file);
            }
            catch (URISyntaxException uRISyntaxException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
            }
        }
        return fileOutputStream;
    }

    @Override
    public String getRepositoryDescription() {
        return "URL";
    }

    static {
        RepositoryFactory repositoryFactory = RepositoryFactory.getInstance();
        repositoryFactory.registerRepositoryFactoryPlugin(new HTTPRepositoryFactoryPlugin());
    }
}

