/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractStreamBasedRepositoryImpl;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import edu.stanford.smi.protegex.owl.repository.util.URLInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForcedURLRetrievalRepository
extends AbstractStreamBasedRepositoryImpl {
    private URL url;
    private URI uri;
    private URI actualOntologyName;

    public ForcedURLRetrievalRepository(URL uRL) {
        this.url = uRL;
        this.uri = null;
        this.refresh();
    }

    @Override
    public boolean contains(URI uRI) {
        if (this.uri != null) {
            return uRI.equals(this.uri);
        }
        return false;
    }

    @Override
    public void refresh() {
        try {
            OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(new URLInputSource(this.url));
            if (ontologyNameExtractor.isPossiblyValidOntology()) {
                this.actualOntologyName = ontologyNameExtractor.getOntologyName();
                try {
                    this.uri = new URI(this.url.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
                }
            } else {
                this.uri = null;
            }
        }
        catch (IOException iOException) {
            this.uri = null;
        }
    }

    @Override
    public Collection<URI> getOntologies() {
        return Collections.singleton(this.uri);
    }

    @Override
    public InputStream getInputStream(URI uRI) throws OntologyLoadException {
        if (this.uri != null) {
            return ProtegeOWLParser.getInputStream(this.url);
        }
        return null;
    }

    @Override
    public boolean isWritable(URI uRI) {
        return false;
    }

    @Override
    public OutputStream getOutputStream(URI uRI) throws IOException {
        return null;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public String getRepositoryDescription() {
        return "Forced HTTP retrieval";
    }

    @Override
    public String getOntologyLocationDescription(URI uRI) {
        return this.url.toString() + " [actual ontology at this location: " + this.actualOntologyName + "]";
    }

    @Override
    public String getRepositoryDescriptor() {
        return this.url.toString();
    }
}

