/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.FTPRepository;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class FTPRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    public boolean isSuitable(OWLModel oWLModel, String string) {
        if (oWLModel.getProject() != null && oWLModel.getProject().getProjectURI() != null) {
            try {
                URI uRI = new URI(string);
                return uRI.getScheme().equals("ftp");
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
        }
        return false;
    }

    public Repository createRepository(OWLModel oWLModel, String string) {
        try {
            URI uRI = oWLModel.getProject().getProjectURI();
            File file = new File(uRI);
            URI uRI2 = file.getParentFile().toURI();
            URI uRI3 = new URI(string);
            FTPRepository fTPRepository = new FTPRepository(uRI3, uRI2);
            return fTPRepository;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

