/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractStreamBasedRepositoryImpl;
import edu.stanford.smi.protegex.owl.repository.impl.FTPRepositoryPasswordProvider;
import edu.stanford.smi.protegex.owl.repository.util.FileInputSource;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPRepository
extends AbstractStreamBasedRepositoryImpl {
    private static final transient Logger log = Log.getLogger(FTPRepository.class);
    private URI ftpURI;
    private URI projectDirectory;
    private File localCopy;
    private URI ontologyName;
    private static FTPRepositoryPasswordProvider passwordProvider = new FTPRepositoryPasswordProvider(){

        public String getUserName() {
            return null;
        }

        public String getPassword() {
            JPasswordField jPasswordField = new JPasswordField();
            LabeledComponent labeledComponent = new LabeledComponent("FTP Password", (Component)jPasswordField);
            JOptionPane.showMessageDialog(null, labeledComponent, "Password", 1);
            return new String(jPasswordField.getPassword());
        }
    };

    public FTPRepository(URI uRI, URI uRI2) {
        this.ftpURI = uRI;
        this.projectDirectory = uRI2;
        this.setLocalFile();
    }

    @Override
    public boolean contains(URI uRI) {
        if (this.ontologyName != null) {
            return this.ontologyName.equals(uRI);
        }
        return false;
    }

    private void setLocalFile() {
        try {
            File file = new File(this.ftpURI.getPath());
            URI uRI = new URI(new URL(this.projectDirectory.toURL(), file.getName()).toString());
            this.localCopy = new File(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", malformedURLException);
        }
    }

    public void ftpGet() {
        try {
            FTPClient fTPClient = new FTPClient();
            fTPClient.setRemoteHost(this.ftpURI.getHost());
            fTPClient.connect();
            if (passwordProvider != null) {
                fTPClient.login(this.ftpURI.getUserInfo(), passwordProvider.getPassword());
            }
            File file = new File(this.ftpURI.getPath());
            fTPClient.chdir(file.getParentFile().toString());
            FileOutputStream fileOutputStream = new FileOutputStream(this.localCopy);
            fTPClient.get((OutputStream)fileOutputStream, file.getName());
            fTPClient.quit();
            OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(new FileInputSource(this.localCopy));
            this.ontologyName = ontologyNameExtractor.getOntologyName();
            log.info("ftp get = " + ontologyNameExtractor.getOntologyName());
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
        catch (FTPException fTPException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", fTPException);
        }
    }

    public void ftpPut() {
        try {
            FTPClient fTPClient = new FTPClient();
            fTPClient.setRemoteHost(this.ftpURI.getHost());
            fTPClient.connect();
            if (passwordProvider != null) {
                fTPClient.login(this.ftpURI.getUserInfo(), passwordProvider.getPassword());
            }
            File file = new File(this.ftpURI.getPath());
            fTPClient.chdir(file.getParentFile().toString());
            FileInputStream fileInputStream = new FileInputStream(this.localCopy);
            fTPClient.put((InputStream)fileInputStream, file.getName());
            fTPClient.quit();
            log.info("Put!");
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
        catch (FTPException fTPException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", fTPException);
        }
    }

    @Override
    public void refresh() {
        this.ftpGet();
    }

    @Override
    public Collection<URI> getOntologies() {
        if (this.ontologyName != null) {
            return Collections.singleton(this.ontologyName);
        }
        return Collections.emptyList();
    }

    @Override
    public InputStream getInputStream(URI uRI) throws OntologyLoadException {
        if (this.contains(uRI)) {
            if (this.isWritable(uRI)) {
                try {
                    return new FileInputStream(this.localCopy);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new OntologyLoadException((Throwable)fileNotFoundException, "Could not find file: " + this.localCopy);
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isWritable(URI uRI) {
        if (this.contains(uRI)) {
            return this.localCopy.exists() && this.localCopy.canWrite();
        }
        return false;
    }

    @Override
    public OutputStream getOutputStream(URI uRI) throws IOException {
        if (this.contains(uRI)) {
            if (this.isWritable(uRI)) {
                return new FileOutputStream(this.localCopy);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public String getRepositoryDescription() {
        return "FTP Repository (" + this.ftpURI + ")";
    }

    @Override
    public String getOntologyLocationDescription(URI uRI) {
        if (this.localCopy != null) {
            return this.localCopy.toString();
        }
        return "";
    }

    @Override
    public String getRepositoryDescriptor() {
        return this.ftpURI.toString();
    }

    public static void setFTPRepositoryPasswordProvider(FTPRepositoryPasswordProvider fTPRepositoryPasswordProvider) {
        passwordProvider = fTPRepositoryPasswordProvider;
    }

    public static void main(String[] stringArray) {
        try {
            FTPRepositoryPasswordProvider fTPRepositoryPasswordProvider = new FTPRepositoryPasswordProvider(){

                public String getUserName() {
                    return null;
                }

                public String getPassword() {
                    JPasswordField jPasswordField = new JPasswordField();
                    JOptionPane.showMessageDialog(null, jPasswordField, "Password", 1);
                    return new String(jPasswordField.getPassword());
                }
            };
            FTPRepository.setFTPRepositoryPasswordProvider(fTPRepositoryPasswordProvider);
            String string = "ftp://horridgm@kiss.cs.man.ac.uk:21/home/M02/cc/horridgm/ontologies/TeachingFlattened.owl";
            URI uRI = new URI(string);
            System.out.println("Scheme: " + uRI.getScheme());
            System.out.println("Host: " + uRI.getHost());
            System.out.println("Port: " + uRI.getPort());
            System.out.println("UserInfo: " + uRI.getUserInfo());
            System.out.println("Path: " + uRI.getPath());
            File file = new File(uRI.getPath());
            System.out.println("FileName: " + file.getName());
            System.out.println("FileDirectory: " + file.getParentFile());
            URI uRI2 = new File("/Users/matthewhorridge/Desktop").toURI();
            FTPRepository fTPRepository = new FTPRepository(uRI, uRI2);
            fTPRepository.ftpGet();
            fTPRepository.ftpPut();
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
    }
}

