/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractStreamBasedRepositoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DublinCoreDLVersionRedirectRepository
extends AbstractStreamBasedRepositoryImpl {
    private URI dublinCoreOntologyURI;
    private URL redirectURL;
    public static final String DESCRIPTOR = "[Dublin Core DL Redirect]";
    public static final String DC = "http://purl.org/dc/elements/1.1/";
    public static final String DC_ALT = "http://protege.stanford.edu/plugins/owl/dc/protege-dc.owl";

    public DublinCoreDLVersionRedirectRepository() {
        try {
            this.dublinCoreOntologyURI = new URI(DC);
            this.redirectURL = new URL(DC_ALT);
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
    }

    @Override
    public boolean contains(URI uRI) {
        return this.dublinCoreOntologyURI.equals(uRI);
    }

    @Override
    public void refresh() {
    }

    @Override
    public Collection<URI> getOntologies() {
        return Collections.singleton(this.dublinCoreOntologyURI);
    }

    @Override
    public InputStream getInputStream(URI uRI) throws OntologyLoadException {
        return ProtegeOWLParser.getInputStream(this.redirectURL);
    }

    @Override
    public boolean isWritable(URI uRI) {
        return false;
    }

    @Override
    public OutputStream getOutputStream(URI uRI) throws IOException {
        return null;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public String getRepositoryDescription() {
        return "Dublin Core DL Version";
    }

    @Override
    public String getOntologyLocationDescription(URI uRI) {
        return "Redirect to " + this.redirectURL.toString();
    }

    @Override
    public String getRepositoryDescriptor() {
        return DESCRIPTOR;
    }

    public int hashCode() {
        return this.redirectURL.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof DublinCoreDLVersionRedirectRepository;
    }
}

