/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.storage.database.DatabaseProperty;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.DatabaseRepository;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    private static final transient Logger log = Log.getLogger(DatabaseRepositoryFactoryPlugin.class);

    public Repository createRepository(OWLModel oWLModel, String string) {
        try {
            return new DatabaseRepository(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.warning("Database repository driver class not found = " + classNotFoundException);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception caught initializing the database repository", classNotFoundException);
            }
            return null;
        }
        catch (SQLException sQLException) {
            log.warning("SQL error caught initializing the database repository" + sQLException);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "SQL error caught initializing the database repository", sQLException);
            }
            return null;
        }
    }

    public boolean isSuitable(OWLModel oWLModel, String string) {
        if (string.startsWith("database:")) {
            try {
                List<String> list = DatabaseRepository.parse(string);
                Class.forName(list.get(DatabaseRepository.getDBPropertyIndex(DatabaseProperty.DRIVER_PROPERTY)));
                return list.size() > DatabaseRepository.DATABASE_FIELDS.length;
            }
            catch (Throwable throwable) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Repository descriptor = " + string);
                    log.log(Level.FINE, "Exception caught figuring out if database repository was applicable", throwable);
                }
                return false;
            }
        }
        return false;
    }
}

