/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.exception.AmalgamatedLoadException;
import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDbFactory;
import edu.stanford.smi.protege.storage.database.DatabaseProperty;
import edu.stanford.smi.protege.storage.database.DefaultDatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.IdleConnectionNarrowFrameStore;
import edu.stanford.smi.protege.storage.database.ValueCachingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.database.DatabaseFactoryUtils;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseRepository
implements Repository {
    private static final Logger log = Log.getLogger(DatabaseRepository.class);
    private Connection connection;
    private Map<DatabaseProperty, String> fieldMap = new EnumMap<DatabaseProperty, String>(DatabaseProperty.class);
    private Map<URI, String> ontologyToTable = new HashMap<URI, String>();
    private Map<String, URI> tableToOntology = new HashMap<String, URI>();
    public static final String REPOSITORY_DESCRIPTOR_PREFIX = "database:";
    public static final char SEPARATOR_CHAR = ',';
    public static final String SQL_TABLE_TYPE = "TABLE";
    public static final String SQL_VIEW_TYPE = "VIEW";
    public int SQL_GET_TABLE_TYPES_TABLE_TYPE_COL = 1;
    public int SQL_GET_TABLES_TABLENAME_COL = 3;
    public static final DatabaseProperty[] DATABASE_FIELDS = new DatabaseProperty[]{DatabaseProperty.DRIVER_PROPERTY, DatabaseProperty.URL_PROPERTY, DatabaseProperty.USERNAME_PROPERTY, DatabaseProperty.PASSWORD_PROPERTY};

    public static int getDBPropertyIndex(DatabaseProperty databaseProperty) {
        int n = 0;
        for (DatabaseProperty databaseProperty2 : DATABASE_FIELDS) {
            if (databaseProperty == databaseProperty2) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("Invalid property");
    }

    public static List<String> parse(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = REPOSITORY_DESCRIPTOR_PREFIX.length();
        while (true) {
            int n2;
            if ((n2 = string.indexOf(44, n)) < 0) {
                arrayList.add(string.substring(n));
                return arrayList;
            }
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseRepository(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        this.fieldMap.put(DatabaseProperty.DRIVER_PROPERTY, string);
        this.fieldMap.put(DatabaseProperty.URL_PROPERTY, string2);
        this.fieldMap.put(DatabaseProperty.USERNAME_PROPERTY, string3);
        this.fieldMap.put(DatabaseProperty.PASSWORD_PROPERTY, string4);
        Class.forName(this.getDriver());
        this.connect();
        try {
            this.findAllTables();
        }
        finally {
            this.disconnect();
        }
    }

    public DatabaseRepository(String string, String string2, String string3, String string4, String string5) throws SQLException, ClassNotFoundException {
        this.fieldMap.put(DatabaseProperty.DRIVER_PROPERTY, string);
        this.fieldMap.put(DatabaseProperty.URL_PROPERTY, string2);
        this.fieldMap.put(DatabaseProperty.USERNAME_PROPERTY, string3);
        this.fieldMap.put(DatabaseProperty.PASSWORD_PROPERTY, string4);
        Class.forName(this.getDriver());
        this.addTable(string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseRepository(String string) throws ClassNotFoundException, SQLException {
        List<String> list = DatabaseRepository.parse(string);
        for (DatabaseProperty databaseProperty : DATABASE_FIELDS) {
            this.fieldMap.put(databaseProperty, list.get(DatabaseRepository.getDBPropertyIndex(databaseProperty)));
        }
        Class.forName(this.getDriver());
        this.connect();
        try {
            for (int i = DATABASE_FIELDS.length; i < list.size(); ++i) {
                String string2 = list.get(i);
                if (string2 == null || string2.length() == 0) {
                    log.warning("Invalid table description in database repository. Table name is empty. Repository Description: " + string);
                    continue;
                }
                this.addTable(string2);
            }
        }
        finally {
            this.disconnect();
        }
    }

    private void findAllTables() throws SQLException {
        Object object;
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTableTypes();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (resultSet.next()) {
            object = resultSet.getString(this.SQL_GET_TABLE_TYPES_TABLE_TYPE_COL);
            if (!((String)object).equals(SQL_TABLE_TYPE) && !((String)object).equals(SQL_VIEW_TYPE)) continue;
            arrayList.add((String)object);
        }
        object = databaseMetaData.getTables(null, null, null, arrayList.toArray(new String[1]));
        while (object.next()) {
            String string = object.getString(this.SQL_GET_TABLES_TABLENAME_COL);
            this.addTable(string);
        }
        if (this.ontologyToTable.isEmpty()) {
            throw new SQLException("No tables containing ontologies found");
        }
    }

    public void connect() throws SQLException {
        this.connection = DriverManager.getConnection(this.getUrl(), this.getUser(), this.getPassword());
    }

    public void disconnect() throws SQLException {
        this.connection.close();
        this.connection = null;
    }

    public boolean addTable(String string) {
        block5: {
            String string2 = null;
            try {
                string2 = DatabaseFactoryUtils.getOntologyFromTable(DefaultDatabaseFrameDb.class, this.getDriver(), this.getUrl(), this.getUser(), this.getPassword(), string);
                if (string2 != null) {
                    this.ontologyToTable.put(new URI(string2), string);
                    this.tableToOntology.put(string, new URI(string2));
                    return true;
                }
            }
            catch (SQLException sQLException) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Exception caught looking for ontology in db table " + string, sQLException);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                if (!log.isLoggable(Level.FINE)) break block5;
                log.log(Level.FINE, "Ontology " + string2 + " found in " + string + " not in uri format.", uRISyntaxException);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TripleStore loadImportedAssertions(OWLModel oWLModel, URI uRI) throws OntologyLoadException {
        String string = this.ontologyToTable.get(uRI);
        DatabaseFrameDb databaseFrameDb = DatabaseFrameDbFactory.createDatabaseFrameDb(DefaultDatabaseFrameDb.class);
        databaseFrameDb.initialize((FrameFactory)oWLModel.getOWLJavaFactory(), this.getDriver(), this.getUrl(), this.getUser(), this.getPassword(), string, true);
        ValueCachingNarrowFrameStore valueCachingNarrowFrameStore = new ValueCachingNarrowFrameStore(databaseFrameDb);
        IdleConnectionNarrowFrameStore idleConnectionNarrowFrameStore = new IdleConnectionNarrowFrameStore(valueCachingNarrowFrameStore);
        idleConnectionNarrowFrameStore.setName(uRI.toString());
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        TripleStore tripleStore = null;
        TripleStore tripleStore2 = tripleStoreModel.getActiveTripleStore();
        try {
            tripleStore = tripleStoreModel.createActiveImportedTripleStore((NarrowFrameStore)idleConnectionNarrowFrameStore);
            ArrayList arrayList = new ArrayList();
            DatabaseFactoryUtils.readOWLOntologyFromDatabase(oWLModel, tripleStore);
            FactoryUtils.loadEncodedNamespaceFromModel(oWLModel, tripleStore, arrayList);
            FactoryUtils.addPrefixesToModelListener(oWLModel, tripleStore);
            DatabaseFactoryUtils.loadImports(oWLModel, arrayList);
            if (!arrayList.isEmpty()) {
                throw new AmalgamatedLoadException(arrayList);
            }
        }
        finally {
            tripleStoreModel.setActiveTripleStore(tripleStore2);
        }
        return tripleStore;
    }

    @Override
    public boolean contains(URI uRI) {
        return this.ontologyToTable.keySet().contains(uRI);
    }

    @Override
    public Collection<URI> getOntologies() {
        return Collections.unmodifiableCollection(this.ontologyToTable.keySet());
    }

    public String getDBTable(URI uRI) {
        return this.ontologyToTable.get(uRI);
    }

    @Override
    public String getOntologyLocationDescription(URI uRI) {
        return "Table " + this.ontologyToTable.get(uRI) + " of the database " + this.getUrl();
    }

    @Override
    public OutputStream getOutputStream(URI uRI) throws IOException {
        return null;
    }

    @Override
    public String getRepositoryDescription() {
        return "Repository for the database " + this.getUrl();
    }

    @Override
    public String getRepositoryDescriptor() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(REPOSITORY_DESCRIPTOR_PREFIX);
        for (DatabaseProperty databaseProperty : DATABASE_FIELDS) {
            stringBuffer.append(this.fieldMap.get(databaseProperty));
            stringBuffer.append(',');
        }
        for (String string : this.ontologyToTable.values()) {
            stringBuffer.append(string);
            stringBuffer.append(',');
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public boolean isWritable(URI uRI) {
        return true;
    }

    @Override
    public boolean hasOutputStream(URI uRI) {
        return false;
    }

    @Override
    public void refresh() {
    }

    public String getDriver() {
        return this.fieldMap.get(DatabaseProperty.DRIVER_PROPERTY);
    }

    public String getUrl() {
        return this.fieldMap.get(DatabaseProperty.URL_PROPERTY);
    }

    public String getUser() {
        return this.fieldMap.get(DatabaseProperty.USERNAME_PROPERTY);
    }

    public String getPassword() {
        return this.fieldMap.get(DatabaseProperty.PASSWORD_PROPERTY);
    }

    public Map<String, URI> getTableToOntologyMap() {
        return new HashMap<String, URI>(this.tableToOntology);
    }
}

