/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractStreamBasedRepositoryImpl;
import edu.stanford.smi.protegex.owl.repository.util.FileInputSource;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocalRepository
extends AbstractStreamBasedRepositoryImpl {
    private File file;
    private boolean forceReadOnly;
    private Map<URI, File> ontologies;

    public AbstractLocalRepository(File file, boolean bl) {
        this.file = file;
        this.forceReadOnly = bl;
        this.ontologies = new HashMap<URI, File>();
    }

    protected File getFile() {
        return this.file;
    }

    @Override
    public void refresh() {
        this.ontologies = new HashMap<URI, File>();
    }

    protected void putOntology(URI uRI, File file) {
        this.ontologies.put(uRI, file);
    }

    @Override
    public boolean contains(URI uRI) {
        return this.ontologies.keySet().contains(uRI);
    }

    @Override
    public Collection<URI> getOntologies() {
        return Collections.unmodifiableCollection(this.ontologies.keySet());
    }

    @Override
    public InputStream getInputStream(URI uRI) throws OntologyLoadException {
        File file = this.ontologies.get(uRI);
        if (file != null) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new OntologyLoadException((Throwable)fileNotFoundException, "Could not open file: " + file);
            }
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream(URI uRI) throws IOException {
        if (this.isWritable(uRI)) {
            File file = this.ontologies.get(uRI);
            return new FileOutputStream(file);
        }
        return null;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public String getOntologyLocationDescription(URI uRI) {
        File file = this.ontologies.get(uRI);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "";
    }

    @Override
    public String getRepositoryDescriptor() {
        try {
            return this.file.toURI().toURL().toString() + "?" + "forceReadOnly" + "=" + Boolean.toString(this.forceReadOnly);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public boolean isWritable(URI uRI) {
        if (!this.forceReadOnly) {
            File file = this.ontologies.get(uRI);
            if (file != null) {
                return file.canWrite();
            }
            return false;
        }
        return false;
    }

    public boolean isForceReadOnly() {
        return this.forceReadOnly;
    }

    public void setForceReadOnly(boolean bl) {
        this.forceReadOnly = bl;
    }

    protected URI processFile(File file) {
        URI uRI = null;
        try {
            PrintStream printStream = System.err;
            System.setErr(new PrintStream(new OutputStream(){

                public void write(int n) throws IOException {
                }
            }));
            OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(new FileInputSource(file));
            uRI = ontologyNameExtractor.getOntologyName();
            System.setErr(printStream);
        }
        catch (Exception exception) {
            Log.emptyCatchBlock((Throwable)exception);
        }
        return uRI;
    }
}

