/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.DublinCoreDLVersionRedirectRepository;
import edu.stanford.smi.protegex.owl.repository.impl.ForcedURLRetrievalRepository;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepository;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManager {
    private ArrayList<Repository> projectRepositories;
    private ArrayList<Repository> globalRepositories;
    private OWLModel model;

    public RepositoryManager(OWLModel oWLModel) {
        this.model = oWLModel;
        this.projectRepositories = new ArrayList();
        this.globalRepositories = new ArrayList();
    }

    public void addDefaultRepositories() {
        this.projectRepositories.add(new DublinCoreDLVersionRedirectRepository());
    }

    public void removeAllProjectRepositories() {
        this.projectRepositories.clear();
    }

    public List<Repository> getAllRepositories() {
        ArrayList<Repository> arrayList = new ArrayList<Repository>();
        arrayList.addAll(this.projectRepositories);
        arrayList.addAll(this.globalRepositories);
        return arrayList;
    }

    public void removeAllGlobalRepositories() {
        this.globalRepositories.clear();
    }

    public List<Repository> getProjectRepositories() {
        return Collections.unmodifiableList(this.projectRepositories);
    }

    public List<Repository> getGlobalRepositories() {
        return Collections.unmodifiableList(this.globalRepositories);
    }

    public void addProjectRepository(Repository repository) {
        this.addProjectRepository(this.projectRepositories.size(), repository);
    }

    public void addProjectRepository(int n, Repository repository) {
        if (!this.projectRepositories.contains(repository)) {
            this.projectRepositories.add(n, repository);
        }
    }

    public void addGlobalRepository(Repository repository) {
        this.addGlobalRepository(this.globalRepositories.size(), repository);
    }

    public void addGlobalRepository(int n, Repository repository) {
        if (!this.globalRepositories.contains(repository)) {
            this.globalRepositories.add(n, repository);
        }
    }

    public void moveUp(Repository repository) {
        List<Repository> list = this.selectRepositories(repository);
        int n = list.indexOf(repository);
        if (n != -1 && n > 0) {
            list.remove(n);
            list.add(n - 1, repository);
        }
    }

    public void moveDown(Repository repository) {
        List<Repository> list = this.selectRepositories(repository);
        int n = list.indexOf(repository);
        if (n != -1 && n < list.size() - 1) {
            list.remove(n);
            list.add(n + 1, repository);
        }
    }

    private List<Repository> selectRepositories(Repository repository) {
        ArrayList<Repository> arrayList = this.isGlobalRepository(repository) ? this.globalRepositories : this.projectRepositories;
        return arrayList;
    }

    public boolean isGlobalRepository(Repository repository) {
        return this.globalRepositories.contains(repository);
    }

    public void remove(Repository repository) {
        this.selectRepositories(repository).remove(repository);
    }

    public Repository getRepository(URI uRI) {
        for (Repository repository : this.projectRepositories) {
            if (!repository.contains(uRI)) continue;
            return repository;
        }
        for (Repository repository : this.globalRepositories) {
            if (!repository.contains(uRI)) continue;
            return repository;
        }
        return null;
    }

    public Repository getRepository(URI uRI, boolean bl) {
        Repository repository = this.getRepository(uRI);
        if (repository == null && bl) {
            try {
                repository = new HTTPRepository(uRI.toURL());
                if (!repository.contains(uRI)) {
                    ForcedURLRetrievalRepository forcedURLRetrievalRepository = new ForcedURLRetrievalRepository(uRI.toURL());
                    if (forcedURLRetrievalRepository.contains(uRI)) {
                        this.addProjectRepository(forcedURLRetrievalRepository);
                        return forcedURLRetrievalRepository;
                    }
                    return null;
                }
                this.addProjectRepository(repository);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return repository;
    }
}

