/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDVisibility {
    public static Set<RDFSDatatype> getDefaultDatatypes(OWLModel oWLModel) {
        HashSet<RDFSDatatype> hashSet = new HashSet<RDFSDatatype>();
        hashSet.add(oWLModel.getXSDboolean());
        hashSet.add(oWLModel.getXSDfloat());
        hashSet.add(oWLModel.getXSDint());
        hashSet.add(oWLModel.getXSDstring());
        hashSet.add(oWLModel.getXSDdate());
        hashSet.add(oWLModel.getXSDdateTime());
        hashSet.add(oWLModel.getXSDtime());
        return hashSet;
    }

    public static void updateVisibility(OWLModel oWLModel) {
        Set<RDFSDatatype> set = XSDVisibility.getDefaultDatatypes(oWLModel);
        for (RDFSDatatype rDFSDatatype : oWLModel.getRDFSDatatypes()) {
            if (!rDFSDatatype.isSystem() || set.contains(rDFSDatatype)) continue;
            Collection collection = oWLModel.getReferences(rDFSDatatype, 10);
            boolean bl = false;
            for (Reference reference : collection) {
                if (reference.getFrame().isSystem() && reference.getSlot().isSystem() && (reference.getFacet() == null || reference.getFacet().isSystem())) continue;
                bl = true;
                break;
            }
            rDFSDatatype.setVisible(bl);
        }
    }
}

