/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModelMetrics
extends OWLModelVisitorAdapter {
    private OWLModel model;
    private int owlClassCount;
    private int namedClassCount = 0;
    private int primitiveClassCount = 0;
    private int definedClassCount = 0;
    private int objectPropertyCount = 0;
    private int datatypePropertyCount = 0;
    private int annotationPropertyCount = 0;
    private int owlIndividualCount = 0;
    private int restrictionCount;
    private int allValuesFromCount;
    private int someValuesFromCount;
    private int hasValueCount;
    private int cardinalityCount;
    private int maxCardinalityCount;
    private int minCardinalityCount;
    private int unionClassCount;
    private int propertDomainCount;
    private int propertyRangeCount;
    private int complementClassCount;
    private int enumeratedClassCount;
    private HashMap propertyUsageCountMap;
    private HashMap classInstantiationCountMap;
    private HashMap siblingClassCount;
    private HashMap parentClassCount;
    private HashMap inferredParentClassCount;
    private int inversePropertyCount = 0;
    private boolean stop;

    public ModelMetrics(OWLModel oWLModel) {
        this.model = oWLModel;
        this.propertyUsageCountMap = new HashMap();
        this.classInstantiationCountMap = new HashMap();
        this.siblingClassCount = new HashMap();
        this.parentClassCount = new HashMap();
        this.inferredParentClassCount = new HashMap();
        this.stop = false;
    }

    public void calculateMetrics() {
        this.stop = false;
        for (RDFResource rDFResource : this.model.getRDFResources()) {
            if (!rDFResource.isSystem()) {
                rDFResource.accept(this);
            }
            if (!this.stop) continue;
            break;
        }
    }

    public int getNamedClassCount() {
        return this.namedClassCount;
    }

    public int getOwlClassCount() {
        return this.owlClassCount;
    }

    public int getPrimitiveClassCount() {
        return this.primitiveClassCount;
    }

    public int getDefinedClassCount() {
        return this.definedClassCount;
    }

    public int getObjectPropertyCount() {
        return this.objectPropertyCount;
    }

    public int getDatatypePropertyCount() {
        return this.datatypePropertyCount;
    }

    public int getAnnotationPropertyCount() {
        return this.annotationPropertyCount;
    }

    public int getPropertyCount() {
        return this.objectPropertyCount + this.datatypePropertyCount + this.annotationPropertyCount;
    }

    public int getOwlIndividualCount() {
        return this.owlIndividualCount;
    }

    public int getRestrictionCount() {
        return this.restrictionCount;
    }

    public int getAllValuesFromCount() {
        return this.allValuesFromCount;
    }

    public int getSomeValuesFromCount() {
        return this.someValuesFromCount;
    }

    public int getHasValueCount() {
        return this.hasValueCount;
    }

    public int getCardinalityCount() {
        return this.cardinalityCount;
    }

    public int getMaxCardinalityCount() {
        return this.maxCardinalityCount;
    }

    public int getMinCardinalityCount() {
        return this.minCardinalityCount;
    }

    public int getUnionClassCount() {
        return this.unionClassCount;
    }

    public int getPropertDomainCount() {
        return this.propertDomainCount;
    }

    public int getPropertyRangeCount() {
        return this.propertyRangeCount;
    }

    public int getComplementClassCount() {
        return this.complementClassCount;
    }

    public int getEnumeratedClassCount() {
        return this.enumeratedClassCount;
    }

    private int getMean(HashMap hashMap) {
        int n = 0;
        for (Integer n2 : hashMap.keySet()) {
            n += n2.intValue();
        }
        return (int)Math.round((double)n / (double)hashMap.size());
    }

    private int getMax(HashMap hashMap) {
        int n = 0;
        for (Integer n2 : hashMap.keySet()) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int getMode(HashMap hashMap) {
        int n = 0;
        int n2 = 0;
        for (Integer n3 : hashMap.keySet()) {
            int n4 = (Integer)hashMap.get(n3);
            if (n4 <= n) continue;
            n = n4;
            n2 = n3;
        }
        return n2;
    }

    public int getMaxSiblings() {
        return this.getMax(this.siblingClassCount);
    }

    public int getMeanSiblings() {
        return this.getMean(this.siblingClassCount);
    }

    public int getModeSiblings() {
        return this.getMode(this.siblingClassCount);
    }

    public int getMaxParents() {
        return this.getMax(this.parentClassCount);
    }

    public int getMaxInferredParents() {
        return this.getMax(this.inferredParentClassCount);
    }

    public int getMeanParents() {
        return this.getMean(this.parentClassCount);
    }

    public int getModeParents() {
        return this.getMode(this.parentClassCount);
    }

    public int getMeanInferredParents() {
        return this.getMean(this.inferredParentClassCount);
    }

    public int getModeInferredParents() {
        return this.getMode(this.inferredParentClassCount);
    }

    public int getInversePropertyCount() {
        return this.inversePropertyCount;
    }

    private void incrementPropertyUsage(RDFProperty rDFProperty) {
        this.incrementCount(rDFProperty, this.propertyUsageCountMap);
    }

    private void incrementClassInstantiation(RDFSClass rDFSClass) {
        this.incrementCount(rDFSClass, this.classInstantiationCountMap);
    }

    private void logSiblingClassCount(int n) {
        this.logCount(n, this.siblingClassCount);
    }

    private void logParentClassCount(int n) {
        this.logCount(n, this.parentClassCount);
    }

    private void logInferredParentClassCount(int n) {
        this.logCount(n, this.inferredParentClassCount);
    }

    private void logCount(int n, HashMap hashMap) {
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)hashMap.get(n2);
        if (n3 == null) {
            n3 = new Integer(0);
        }
        n3 = new Integer(n3 + 1);
        hashMap.put(n2, n3);
    }

    private void incrementCount(RDFResource rDFResource, Map map) {
        Integer n = (Integer)map.get(rDFResource);
        if (n == null) {
            n = new Integer(0);
            map.put(rDFResource, n);
        }
        map.put(rDFResource, new Integer(n + 1));
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom oWLAllValuesFrom) {
        ++this.allValuesFromCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLCardinality(OWLCardinality oWLCardinality) {
        ++this.cardinalityCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLComplementClass(OWLComplementClass oWLComplementClass) {
        ++this.complementClassCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty oWLDatatypeProperty) {
        if (oWLDatatypeProperty.isAnnotationProperty()) {
            ++this.annotationPropertyCount;
        } else {
            ++this.datatypePropertyCount;
            RDFSClass rDFSClass = oWLDatatypeProperty.getDomain(false);
            if (rDFSClass != null && !rDFSClass.equals(this.model.getOWLThingClass())) {
                ++this.propertDomainCount;
            }
            this.incrementPropertyUsage(oWLDatatypeProperty);
        }
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass oWLEnumeratedClass) {
        ++this.enumeratedClassCount;
        ++this.owlClassCount;
    }

    public void visitOWLHasValue(OWLHasValue oWLHasValue) {
        ++this.hasValueCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLIndividual(OWLIndividual oWLIndividual) {
        ++this.owlIndividualCount;
        Iterator iterator = oWLIndividual.getRDFTypes().iterator();
        while (iterator.hasNext()) {
            this.incrementClassInstantiation((RDFSClass)iterator.next());
        }
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass oWLIntersectionClass) {
        ++this.owlClassCount;
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality oWLMaxCardinality) {
        ++this.maxCardinalityCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLMinCardinality(OWLMinCardinality oWLMinCardinality) {
        ++this.minCardinalityCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLNamedClass(OWLNamedClass oWLNamedClass) {
        ++this.namedClassCount;
        ++this.owlClassCount;
        Collection collection = oWLNamedClass.getNamedSuperclasses();
        if (collection.size() > 2) {
            collection.remove(this.model.getOWLThingClass());
        }
        this.logParentClassCount(collection.size());
        this.logInferredParentClassCount(oWLNamedClass.getInferredSuperclasses().size());
        int n = oWLNamedClass.getNamedSubclasses().size();
        if (n > 0) {
            this.logSiblingClassCount(n);
        }
        if (oWLNamedClass.getEquivalentClasses().size() > 0) {
            ++this.definedClassCount;
        } else {
            ++this.primitiveClassCount;
        }
    }

    public void visitOWLObjectProperty(OWLObjectProperty oWLObjectProperty) {
        if (oWLObjectProperty.isAnnotationProperty()) {
            ++this.annotationPropertyCount;
        } else {
            RDFResource rDFResource;
            ++this.objectPropertyCount;
            RDFSClass rDFSClass = oWLObjectProperty.getDomain(false);
            if (rDFSClass != null && !rDFSClass.equals(this.model.getOWLThingClass())) {
                ++this.propertDomainCount;
            }
            if ((rDFResource = oWLObjectProperty.getRange(false)) != null && !rDFResource.equals(this.model.getOWLThingClass())) {
                ++this.propertyRangeCount;
            }
            this.incrementPropertyUsage(oWLObjectProperty);
            if (oWLObjectProperty.getInverseProperty() != null) {
                ++this.inversePropertyCount;
            }
        }
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom oWLSomeValuesFrom) {
        ++this.someValuesFromCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLUnionClass(OWLUnionClass oWLUnionClass) {
        ++this.unionClassCount;
        ++this.owlClassCount;
    }

    public void stopCalculating() {
        this.stop = true;
    }
}

