/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.menu.OWLMenuProjectPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public class ImportHelper {
    private OWLModel owlModel;
    private Collection<URI> ontologyURIs;
    private Collection<InputStream> ontologyStreams;

    public ImportHelper(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.ontologyURIs = new ArrayList<URI>();
        this.ontologyStreams = new ArrayList<InputStream>();
    }

    public void addImport(URI uRI) {
        this.ontologyURIs.add(uRI);
    }

    public void addImport(InputStream inputStream) {
        this.ontologyStreams.add(inputStream);
    }

    public void importOntologies() throws OntologyLoadException {
        this.importOntologies(true);
    }

    public void importOntologies(boolean bl) throws OntologyLoadException {
        URI uRI3;
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (this.ontologyStreams.isEmpty() && this.ontologyURIs.isEmpty()) {
            return;
        }
        for (InputStream iterator : this.ontologyStreams) {
            uRI3 = this.loadImportedAssertions(iterator);
            try {
                iterator.close();
            }
            catch (IOException iOException) {
                Log.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
            }
            if (uRI3 == null) continue;
            arrayList.add(uRI3);
        }
        for (URI uRI2 : this.ontologyURIs) {
            if (this.owlModel.getAllImports().contains(uRI2.toString()) || arrayList.contains(uRI2) || (uRI3 = ((AbstractOWLModel)this.owlModel).loadImportedAssertions(uRI2)) == null) continue;
            arrayList.add(uRI3);
        }
        ProtegeOWLParser.doFinalPostProcessing(this.owlModel);
        OWLOntology oWLOntology = this.owlModel.getTripleStoreModel().getActiveTripleStore().getOWLOntology();
        for (URI uRI3 : arrayList) {
            oWLOntology.addImports(uRI3);
        }
        if (arrayList.size() > 0) {
            this.owlModel.getTripleStoreModel().updateEditableResourceState();
            if (OWLUtil.runsWithGUI(this.owlModel)) {
                OWLMenuProjectPlugin.makeHiddenClsesWithSubclassesVisible(this.owlModel);
                if (bl) {
                    ProtegeUI.reloadUI(this.owlModel);
                }
            }
        }
    }

    private URI loadImportedAssertions(InputStream inputStream) throws OntologyLoadException {
        ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(this.owlModel);
        protegeOWLParser.setImporting(true);
        TripleStore tripleStore = null;
        TripleStore tripleStore2 = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        try {
            InMemoryFrameDb inMemoryFrameDb = new InMemoryFrameDb("**temp_name**");
            tripleStore = this.owlModel.getTripleStoreModel().createActiveImportedTripleStore((NarrowFrameStore)inMemoryFrameDb);
            protegeOWLParser.run(inputStream, null);
            String string = tripleStore.getName();
            URI uRI = new URI(string);
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new OntologyLoadException((Throwable)uRISyntaxException, "Invalid URI: " + tripleStore.getName());
        }
        finally {
            this.owlModel.getTripleStoreModel().setActiveTripleStore(tripleStore2);
        }
    }
}

