/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class DLExpressivityChecker
extends OWLModelVisitorAdapter {
    private OWLModel owlModel;
    private Set constructors;
    public static final String FL0 = "FL0";
    public static final String FL_MINUS = "FL-";
    public static final String AL = "AL";
    public static final String C = "C";
    public static final String TRAN_ROLES = "Tran";
    public static final String E = "E";
    public static final String U = "U";
    public static final String I = "I";
    public static final String O = "O";
    public static final String N = "N";
    public static final String Q = "Q";
    public static final String F = "F";
    public static final String H = "H";
    public static final String DATATYPE = "(D)";
    public static final String S = "S";

    public DLExpressivityChecker(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.constructors = new TreeSet();
    }

    public void check() {
        this.constructors = new TreeSet();
        this.constructors.add(FL0);
        for (RDFResource rDFResource : this.owlModel.getRDFResources()) {
            if (rDFResource.isSystem()) continue;
            rDFResource.accept(this);
        }
        this.tidy();
    }

    public String getDLName() {
        Collection collection = this.getSortedName();
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next() + " ";
        }
        return string.trim();
    }

    public Collection getDL() {
        return this.getSortedName();
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom oWLAllValuesFrom) {
        this.constructors.add(FL0);
    }

    public void visitOWLCardinality(OWLCardinality oWLCardinality) {
        this.processCardinality(oWLCardinality);
    }

    public void visitOWLComplementClass(OWLComplementClass oWLComplementClass) {
        this.constructors.add(AL);
        RDFSClass rDFSClass = oWLComplementClass.getComplement();
        if (rDFSClass instanceof OWLNamedClass) {
            if (!this.isAtomic((OWLNamedClass)rDFSClass)) {
                this.constructors.add(C);
            } else {
                this.constructors.add(C);
            }
        }
    }

    public void visitOWLDataRange(OWLDataRange oWLDataRange) {
        this.constructors.add(DATATYPE);
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty oWLDatatypeProperty) {
        this.constructors.add(DATATYPE);
        if (oWLDatatypeProperty.isFunctional()) {
            this.constructors.add(F);
        }
        if (oWLDatatypeProperty.getSuperproperties(false).size() > 0) {
            this.constructors.add(H);
        }
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass oWLEnumeratedClass) {
        this.constructors.add(AL);
        this.constructors.add(O);
    }

    public void visitOWLHasValue(OWLHasValue oWLHasValue) {
        this.constructors.add(AL);
        this.constructors.add(E);
        this.constructors.add(O);
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass oWLIntersectionClass) {
        this.constructors.add(FL0);
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality oWLMaxCardinality) {
        this.processCardinality(oWLMaxCardinality);
    }

    public void visitOWLMinCardinality(OWLMinCardinality oWLMinCardinality) {
        this.processCardinality(oWLMinCardinality);
    }

    private void processCardinality(OWLCardinalityBase oWLCardinalityBase) {
        this.constructors.add(AL);
        if (!oWLCardinalityBase.getQualifier().equals(this.owlModel.getOWLThingClass())) {
            this.constructors.add(Q);
        } else {
            this.constructors.add(N);
        }
    }

    public void visitOWLNamedClass(OWLNamedClass oWLNamedClass) {
        this.constructors.add(FL0);
        Collection collection = oWLNamedClass.getDisjointClasses();
        if (collection.size() > 0) {
            this.constructors.add(AL);
            for (RDFSClass rDFSClass : collection) {
                if (rDFSClass instanceof OWLNamedClass) {
                    if (this.isAtomic((OWLNamedClass)rDFSClass)) continue;
                    this.constructors.add(C);
                    break;
                }
                this.constructors.add(C);
                break;
            }
        }
    }

    public void visitOWLObjectProperty(OWLObjectProperty oWLObjectProperty) {
        this.constructors.add(AL);
        if (oWLObjectProperty.isFunctional()) {
            this.constructors.add(F);
        }
        if (oWLObjectProperty.getSuperproperties(false).size() > 0) {
            this.constructors.add(H);
        }
        if (oWLObjectProperty.getInverseProperty() != null) {
            this.constructors.add(I);
        }
        if (oWLObjectProperty.isSymmetric()) {
            this.constructors.add(I);
        }
        if (oWLObjectProperty.isTransitive()) {
            this.constructors.add(TRAN_ROLES);
        }
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom oWLSomeValuesFrom) {
        if (oWLSomeValuesFrom.getFiller().equals(this.owlModel.getOWLThingClass())) {
            this.constructors.add(FL_MINUS);
        } else {
            this.constructors.add(E);
            this.constructors.add(AL);
        }
    }

    public void visitOWLUnionClass(OWLUnionClass oWLUnionClass) {
        this.constructors.add(AL);
        this.constructors.add(U);
    }

    private Collection getSortedName() {
        TreeSet treeSet = new TreeSet(new LangFeatureComparator());
        treeSet.addAll(this.constructors);
        return treeSet;
    }

    public String toString() {
        String string = "";
        Iterator iterator = this.constructors.iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next() + " ";
        }
        return string.trim();
    }

    private boolean isAtomic(OWLNamedClass oWLNamedClass) {
        Collection collection = oWLNamedClass.getSuperclasses(false);
        collection.remove(this.owlModel.getOWLThingClass());
        if (collection.size() > 0) {
            return false;
        }
        return oWLNamedClass.getDisjointClasses().size() == 0;
    }

    private void tidy() {
        if (this.constructors.contains(FL_MINUS)) {
            this.constructors.remove(FL0);
        }
        if (this.constructors.contains(AL)) {
            this.constructors.remove(FL_MINUS);
            this.constructors.remove(FL0);
        }
        if (this.constructors.contains(E) && this.constructors.contains(U)) {
            this.constructors.add(C);
            this.constructors.remove(E);
            this.constructors.remove(U);
        } else if (this.constructors.contains(C)) {
            this.constructors.remove(E);
            this.constructors.remove(U);
        }
        if (this.constructors.contains(N)) {
            this.constructors.remove(F);
        }
        if (this.constructors.contains(Q)) {
            this.constructors.remove(N);
        }
        if (this.constructors.contains(AL) && this.constructors.contains(C) && this.constructors.contains(TRAN_ROLES)) {
            this.constructors.remove(AL);
            this.constructors.remove(C);
            this.constructors.remove(TRAN_ROLES);
            this.constructors.add(S);
        }
    }

    private class LangFeatureComparator
    implements Comparator {
        private List ORDER = Arrays.asList("AL", "C", "U", "E", "S", "H", "O", "I", "F", "N", "Q", "(D)", "Tran");

        private LangFeatureComparator() {
        }

        public int compare(Object object, Object object2) {
            return this.ORDER.indexOf(object) - this.ORDER.indexOf(object2);
        }
    }
}

