/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.TripleStoreImpl;
import edu.stanford.smi.protegex.owl.util.OWLFrameStoreUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleStoreModelImpl
implements TripleStoreModel {
    public static final String SUPPRESS_DUPLICATE_PROPERTY_VALUES = "suppress.duplicate.owl.values";
    protected MergingNarrowFrameStore mnfs;
    private Slot nameSlot;
    private OWLModel owlModel;
    private List<TripleStore> allTripleStores = new ArrayList<TripleStore>();
    private Map<NarrowFrameStore, TripleStore> tripleStoreMap = new HashMap<NarrowFrameStore, TripleStore>();
    private TripleStore topTripleStore;

    public TripleStoreModelImpl(OWLModel oWLModel) {
        this.nameSlot = oWLModel.getSystemFrames().getNameSlot();
        this.mnfs = MergingNarrowFrameStore.get((KnowledgeBase)oWLModel);
        this.owlModel = oWLModel;
        this.initTripleStores();
    }

    @Override
    public TripleStore createActiveImportedTripleStore(NarrowFrameStore narrowFrameStore) {
        String string = this.getActiveTripleStore().getNarrowFrameStore().getName();
        this.mnfs.addActiveChildFrameStore(narrowFrameStore, string);
        TripleStoreImpl tripleStoreImpl = new TripleStoreImpl(this.owlModel, narrowFrameStore, this);
        this.allTripleStores.add(tripleStoreImpl);
        this.tripleStoreMap.put(narrowFrameStore, tripleStoreImpl);
        this.updateRemoveFrameStores();
        return tripleStoreImpl;
    }

    @Override
    public void deleteTripleStore(TripleStore tripleStore) {
        this.allTripleStores.remove(tripleStore);
        this.tripleStoreMap.remove(tripleStore.getNarrowFrameStore());
    }

    public static void ensureActiveTripleStore(RDFResource rDFResource) {
        TripleStoreUtil.ensureActiveTripleStore(rDFResource);
    }

    @Override
    public TripleStore getTripleStoreByDefaultNamespace(String string) {
        for (TripleStore tripleStore : this.allTripleStores) {
            if (!string.equals(tripleStore.getDefaultNamespace())) continue;
            return tripleStore;
        }
        return null;
    }

    private void initTripleStores() {
        this.allTripleStores.clear();
        this.tripleStoreMap.clear();
        for (NarrowFrameStore narrowFrameStore : this.mnfs.getAvailableFrameStores()) {
            TripleStoreImpl tripleStoreImpl = new TripleStoreImpl(this.owlModel, narrowFrameStore, this);
            this.allTripleStores.add(tripleStoreImpl);
            this.tripleStoreMap.put(narrowFrameStore, tripleStoreImpl);
        }
        this.updateRemoveFrameStores();
    }

    private void updateRemoveFrameStores() {
        Collection collection = this.mnfs.getAvailableFrameStores();
        this.mnfs.setRemoveFrameStores(collection);
        this.owlModel.resetJenaModel();
    }

    @Override
    public TripleStore getActiveTripleStore() {
        NarrowFrameStore narrowFrameStore = this.mnfs.getActiveFrameStore();
        return this.tripleStoreMap.get(narrowFrameStore);
    }

    @Override
    public TripleStore getHomeTripleStore(RDFResource rDFResource) {
        for (TripleStore tripleStore : this.allTripleStores) {
            if (tripleStore.getNarrowFrameStore().getValuesCount((Frame)rDFResource, this.nameSlot, null, false) <= 0) continue;
            return tripleStore;
        }
        return null;
    }

    @Override
    public TripleStore getHomeTripleStore(Instance instance, Slot slot, Object object) {
        Iterator<TripleStore> iterator = this.owlModel.getTripleStoreModel().listUserTripleStores();
        while (iterator.hasNext()) {
            TripleStore tripleStore = iterator.next();
            NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
            List list = narrowFrameStore.getValues((Frame)instance, slot, null, false);
            if (!list.contains(object)) continue;
            return tripleStore;
        }
        return null;
    }

    @Override
    public Collection getPropertyValues(RDFResource rDFResource, RDFProperty rDFProperty) {
        List list = this.mnfs.getValues((Frame)rDFResource, (Slot)rDFProperty, null, false);
        return OWLFrameStoreUtils.convertValueListToRDFLiterals(this.owlModel, list);
    }

    @Override
    public Collection getSlotValues(Instance instance, Slot slot) {
        return this.mnfs.getValues((Frame)instance, slot, null, false);
    }

    @Override
    public TripleStore getTripleStore(String string) {
        if (string == null) {
            return this.getActiveTripleStore();
        }
        for (TripleStore tripleStore : this.allTripleStores) {
            if (!string.equals(tripleStore.getName())) continue;
            return tripleStore;
        }
        return null;
    }

    @Override
    public TripleStore getSystemTripleStore() {
        return this.allTripleStores.get(0);
    }

    @Override
    public List<TripleStore> getTripleStores() {
        return new ArrayList<TripleStore>(this.allTripleStores);
    }

    @Override
    public TripleStore getTopTripleStore() {
        return this.topTripleStore;
    }

    @Override
    public void setTopTripleStore(TripleStore tripleStore) {
        this.topTripleStore = tripleStore;
        this.setViewActiveOnly(false);
        this.mnfs.setSuppressDuplicates(ApplicationProperties.getBooleanProperty((String)SUPPRESS_DUPLICATE_PROPERTY_VALUES, (boolean)true));
    }

    @Override
    public boolean isActiveTriple(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return this.getActiveTripleStore().contains(rDFResource, rDFProperty, object);
    }

    @Override
    public boolean isEditableTriple(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        object = DefaultRDFSLiteral.getPlainValueIfPossible(object);
        Iterator<TripleStore> iterator = this.listUserTripleStores();
        while (iterator.hasNext()) {
            TripleStore tripleStore = iterator.next();
            if (!tripleStore.contains(rDFResource, rDFProperty, object)) continue;
            return this.isEditableTripleStore(tripleStore);
        }
        return false;
    }

    @Override
    public boolean isEditableTripleStore(TripleStore tripleStore) {
        if (tripleStore.equals(this.getSystemTripleStore())) {
            return false;
        }
        if (tripleStore.equals(this.getTopTripleStore())) {
            return true;
        }
        try {
            URI uRI = new URI(tripleStore.getName());
            return this.owlModel.getRepositoryManager().getRepository(uRI).isWritable(uRI);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Iterator<Triple> listTriplesWithSubject(RDFResource rDFResource) {
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        for (TripleStore tripleStore : this.getTripleStores()) {
            Iterator<Triple> iterator = tripleStore.listTriplesWithSubject(rDFResource);
            while (iterator.hasNext()) {
                Triple triple = iterator.next();
                arrayList.add(triple);
            }
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<RDFResource> listSubjects(RDFProperty rDFProperty) {
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        for (TripleStore tripleStore : this.getTripleStores()) {
            Iterator<RDFResource> iterator = tripleStore.listSubjects(rDFProperty);
            while (iterator.hasNext()) {
                Frame frame = (Frame)iterator.next();
                if (!(frame instanceof RDFResource)) continue;
                hashSet.add((RDFResource)frame);
            }
        }
        return hashSet.iterator();
    }

    @Override
    public Iterator<TripleStore> listUserTripleStores() {
        Iterator<TripleStore> iterator = this.getTripleStores().iterator();
        iterator.next();
        if (this.allTripleStores.size() > 1 && this.allTripleStores.get(1).getName() == null) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public void replaceJavaObject(RDFResource rDFResource) {
        this.mnfs.replaceFrame((Frame)rDFResource);
    }

    @Override
    public void setActiveTripleStore(TripleStore tripleStore) {
        if (this.mnfs.getActiveFrameStore() != tripleStore.getNarrowFrameStore()) {
            this.mnfs.setActiveFrameStore(tripleStore.getNarrowFrameStore());
        }
    }

    @Override
    public void setHomeTripleStore(RDFResource rDFResource, TripleStore tripleStore) {
        TripleStore tripleStore2 = this.getHomeTripleStore(rDFResource);
        if (tripleStore2 != tripleStore) {
            List list = this.mnfs.getValues((Frame)rDFResource, this.nameSlot, null, false);
            String string = (String)list.get(0);
            tripleStore2.getNarrowFrameStore().removeValue((Frame)rDFResource, this.nameSlot, null, false, (Object)string);
            tripleStore.getNarrowFrameStore().addValues((Frame)rDFResource, this.nameSlot, null, false, Collections.singleton(string));
        }
    }

    @Override
    public void updateEditableResourceState() {
        TripleStoreUtil.updateFrameInclusion(this.mnfs, this.nameSlot);
    }

    @Override
    public void dispose() {
        for (TripleStore tripleStore : this.allTripleStores) {
            tripleStore.dispose();
        }
        this.allTripleStores.clear();
        this.tripleStoreMap.clear();
        this.allTripleStores = null;
        this.tripleStoreMap = null;
    }

    @Override
    public void setViewActiveOnly(boolean bl) {
        this.mnfs.setQueryAllFrameStores(false);
        if (bl) {
            this.mnfs.setTopFrameStore(null);
        } else {
            this.mnfs.setTopFrameStore(this.getTopTripleStore().getNarrowFrameStore().getName());
        }
    }

    public String toString() {
        return "TripleStoreModel(" + this.getTopTripleStore().getOWLOntology().getBrowserText() + ")";
    }
}

