/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Record;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.OWLNamespaceManager;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.swrl.SWRLSystemFrames;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleStoreImpl
implements TripleStore {
    private static final transient Logger log = Log.getLogger(TripleStoreImpl.class);
    private NamespaceManager namespaceManager;
    protected NarrowFrameStore narrowFrameStore;
    protected Slot nameSlot;
    protected OWLModel owlModel;
    protected TripleStoreModel tripleStoreModel;
    protected String originalXMLBase;
    private Collection<String> ioAddresses = new ArrayList<String>();
    private String name;

    public TripleStoreImpl(OWLModel oWLModel, NarrowFrameStore narrowFrameStore, TripleStoreModel tripleStoreModel) {
        this(oWLModel, narrowFrameStore, tripleStoreModel, new OWLNamespaceManager(), null);
    }

    public TripleStoreImpl(OWLModel oWLModel, NarrowFrameStore narrowFrameStore, TripleStoreModel tripleStoreModel, NamespaceManager namespaceManager, String string) {
        this.narrowFrameStore = narrowFrameStore;
        this.owlModel = oWLModel;
        this.tripleStoreModel = tripleStoreModel;
        this.namespaceManager = namespaceManager;
        this.name = string;
        OWLModel oWLModel2 = oWLModel;
        this.nameSlot = oWLModel2.getSystemFrames().getNameSlot();
    }

    @Override
    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public boolean equals(Object object) {
        if (object instanceof TripleStoreImpl) {
            return this.narrowFrameStore.getName().equals(((TripleStoreImpl)object).narrowFrameStore.getName());
        }
        return false;
    }

    @Override
    public Iterator<Triple> listTriples() {
        HashSet<Slot> hashSet = new HashSet<Slot>();
        SWRLSystemFrames sWRLSystemFrames = this.owlModel.getSystemFrames();
        hashSet.add(sWRLSystemFrames.getOwlOntologyPrefixesProperty());
        hashSet.add(sWRLSystemFrames.getOwlOntologyPointerProperty());
        hashSet.add(sWRLSystemFrames.getDirectInstancesSlot());
        hashSet.add(sWRLSystemFrames.getDirectTypesSlot());
        hashSet.add(sWRLSystemFrames.getProtegeClassificationStatusProperty());
        hashSet.add(sWRLSystemFrames.getProtegeInferredSubclassesProperty());
        hashSet.add(sWRLSystemFrames.getProtegeInferredSuperclassesProperty());
        hashSet.add(sWRLSystemFrames.getProtegeInferredTypeProperty());
        ArrayList<DefaultTriple> arrayList = new ArrayList<DefaultTriple>();
        for (Record record : ((InMemoryFrameDb)this.narrowFrameStore).getRecords()) {
            Frame frame = record.getFrame();
            if (!(frame instanceof RDFResource)) continue;
            Slot slot = record.getSlot();
            if (log.isLoggable(Level.FINE)) {
                log.fine("listTriples -- " + frame.getName() + " . " + slot.getName());
            }
            if (!(slot instanceof RDFProperty) || record.getFacet() != null || record.isTemplate() || hashSet.contains(slot)) continue;
            for (Object object : record.getValues()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("\tObject = " + object);
                }
                if (object instanceof String && DefaultRDFSLiteral.isRawValue((String)object)) {
                    object = new DefaultRDFSLiteral(this.owlModel, (String)object);
                }
                DefaultTriple defaultTriple = new DefaultTriple((RDFResource)frame, (RDFProperty)slot, object);
                arrayList.add(defaultTriple);
            }
        }
        return arrayList.iterator();
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public void add(Triple triple) {
        this.add(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    public void add(final RDFResource rDFResource, final RDFProperty rDFProperty, final Object object) {
        this.doChangesOnThisTripleStore(new Runnable(){

            public void run() {
                rDFResource.addPropertyValue(rDFProperty, object);
            }
        });
    }

    public boolean addValue(final Instance instance, final Slot slot, final Object object) {
        Collection collection = this.getValues(instance, slot);
        if (!collection.contains(object)) {
            this.doChangesOnThisTripleStore(new Runnable(){

                public void run() {
                    instance.addOwnSlotValue(slot, object);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Triple triple) {
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    public boolean contains(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        Collection collection = this.getValues(rDFResource, rDFProperty);
        if (collection == null) {
            return false;
        }
        if (object instanceof RDFSLiteral) {
            OWLModel oWLModel = rDFResource.getOWLModel();
            for (Object e : collection) {
                try {
                    RDFSLiteral rDFSLiteral = oWLModel.asRDFSLiteral(e);
                    if (!rDFSLiteral.equals(object)) continue;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.emptyCatchBlock((Throwable)illegalArgumentException);
                }
            }
            return false;
        }
        return collection.contains(object);
    }

    @Override
    public String getDefaultNamespace() {
        return this.getNamespaceForPrefix("");
    }

    @Override
    public RDFResource getHomeResource(String string) {
        Set set = this.narrowFrameStore.getFrames(this.nameSlot, null, false, (Object)string);
        if (set.isEmpty()) {
            return null;
        }
        return (RDFResource)set.iterator().next();
    }

    @Override
    public OWLOntology getOWLOntology() {
        String string = this.getName();
        if (string != null) {
            return (OWLOntology)this.owlModel.getFrame(string);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespaceForPrefix(String string) {
        return this.getNamespaceManager().getNamespaceForPrefix(string);
    }

    @Override
    public NarrowFrameStore getNarrowFrameStore() {
        return this.narrowFrameStore;
    }

    public Collection getSlotValues(Instance instance, Slot slot) {
        return this.tripleStoreModel.getSlotValues(instance, slot);
    }

    protected Collection getValues(Instance instance, Slot slot) {
        return this.narrowFrameStore.getValues((Frame)instance, slot, null, false);
    }

    @Override
    public String getPrefix(String string) {
        return this.getNamespaceManager().getPrefix(string);
    }

    @Override
    public Collection<String> getPrefixes() {
        return this.getNamespaceManager().getPrefixes();
    }

    protected Collection<Reference> getReferences(Object object) {
        return this.narrowFrameStore.getReferences(object);
    }

    @Override
    public Iterator<RDFResource> listHomeResources() {
        Set set = this.narrowFrameStore.getFramesWithAnyValue(this.nameSlot, null, false);
        Collection<RDFResource> collection = AbstractOWLModel.getRDFResources(this.owlModel, set);
        return collection.iterator();
    }

    @Override
    public Iterator listObjects(RDFResource rDFResource, RDFProperty rDFProperty) {
        return new ArrayList(this.getValues(rDFResource, rDFProperty)).iterator();
    }

    public Iterator listSubjects(RDFProperty rDFProperty) {
        Set set = this.narrowFrameStore.getFramesWithAnyValue((Slot)rDFProperty, null, false);
        return set.iterator();
    }

    @Override
    public Iterator listSubjects(RDFProperty rDFProperty, Object object) {
        if (object instanceof DefaultRDFSLiteral && (object = DefaultRDFSLiteral.getPlainValueIfPossible(object)) instanceof DefaultRDFSLiteral) {
            object = ((DefaultRDFSLiteral)object).getRawValue();
        }
        return this.narrowFrameStore.getFrames((Slot)rDFProperty, null, false, object).iterator();
    }

    @Override
    public Iterator<Triple> listTriplesWithObject(RDFObject rDFObject) {
        ArrayList<DefaultTriple> arrayList;
        Cls cls = this.owlModel.getCls(RDFNames.Cls.PROPERTY);
        OWLJavaFactory oWLJavaFactory = this.owlModel.getOWLJavaFactory();
        Object object = rDFObject;
        if (rDFObject instanceof DefaultRDFSLiteral) {
            arrayList = ((DefaultRDFSLiteral)rDFObject).getPlainValue();
            object = arrayList == null ? ((DefaultRDFSLiteral)rDFObject).getRawValue() : arrayList;
        }
        arrayList = new ArrayList<DefaultTriple>();
        Collection<Reference> collection = this.getReferences(object);
        for (Reference reference : collection) {
            Reference reference2 = reference;
            if (!(reference2.getFrame() instanceof RDFResource) || !reference2.getSlot().hasType(cls) || Model.SlotID.DIRECT_INSTANCES.equals((Object)reference2.getSlot().getFrameID())) continue;
            RDFProperty rDFProperty = (RDFProperty)oWLJavaFactory.createSlot(reference2.getSlot().getFrameID(), reference2.getSlot().getDirectTypes());
            DefaultTriple defaultTriple = new DefaultTriple((RDFResource)reference2.getFrame(), rDFProperty, rDFObject);
            arrayList.add(defaultTriple);
        }
        return arrayList.iterator();
    }

    public Iterator listTriplesWithSubject(RDFResource rDFResource) {
        ArrayList<DefaultTriple> arrayList = new ArrayList<DefaultTriple>();
        Iterator iterator = rDFResource.getOWLModel().listRDFProperties();
        while (iterator.hasNext()) {
            RDFProperty rDFProperty = (RDFProperty)iterator.next();
            Iterator iterator2 = this.listObjects(rDFResource, rDFProperty);
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                DefaultTriple defaultTriple = new DefaultTriple(rDFResource, rDFProperty, e);
                arrayList.add(defaultTriple);
            }
        }
        return arrayList.iterator();
    }

    @Override
    public Set<RDFProperty> getUserDefinedProperties() {
        HashSet<RDFSNamedClass> hashSet = new HashSet<RDFSNamedClass>(this.owlModel.getRDFPropertyClass().getSubclasses(true));
        hashSet.add(this.owlModel.getRDFPropertyClass());
        HashSet<RDFProperty> hashSet2 = new HashSet<RDFProperty>();
        for (Object e : hashSet) {
            if (!(e instanceof RDFSClass)) continue;
            hashSet2.addAll(this.getUserDefinedDirectInstancesOf((RDFSClass)e, RDFProperty.class));
        }
        return hashSet2;
    }

    @Override
    public Set<RDFSNamedClass> getUserDefinedClasses() {
        HashSet<RDFSNamedClass> hashSet = new HashSet<RDFSNamedClass>(this.owlModel.getRDFSNamedClassClass().getSubclasses(true));
        hashSet.add(this.owlModel.getRDFSNamedClassClass());
        HashSet<RDFSNamedClass> hashSet2 = new HashSet<RDFSNamedClass>();
        for (Object e : hashSet) {
            if (!(e instanceof RDFSClass)) continue;
            hashSet2.addAll(this.getUserDefinedDirectInstancesOf((RDFSClass)e, RDFSNamedClass.class));
        }
        return hashSet2;
    }

    @Override
    public <X extends RDFResource> Set<X> getUserDefinedDirectInstancesOf(RDFSClass rDFSClass, Class<? extends X> clazz) {
        List list = this.getNarrowFrameStore().getValues((Frame)rDFSClass, this.owlModel.getSystemFrames().getDirectInstancesSlot(), null, false);
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        for (Object e : list) {
            RDFResource rDFResource;
            if (!clazz.isInstance(e) || (rDFResource = (RDFResource)clazz.cast(e)).isSystem()) continue;
            hashSet.add(rDFResource);
        }
        return hashSet;
    }

    @Override
    public <X extends RDFResource> Set<X> getUserDefinedInstancesOf(RDFSClass rDFSClass, Class<? extends X> clazz) {
        HashSet<X> hashSet = new HashSet<X>(this.getUserDefinedDirectInstancesOf(rDFSClass, clazz));
        for (RDFSClass rDFSClass2 : rDFSClass.getSubclasses(true)) {
            if (rDFSClass2.isSystem()) continue;
            hashSet.addAll(this.getUserDefinedInstancesOf(rDFSClass2, clazz));
        }
        return hashSet;
    }

    @Override
    public void remove(Triple triple) {
        this.remove(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    public void remove(final RDFResource rDFResource, final RDFProperty rDFProperty, final Object object) {
        this.doChangesOnThisTripleStore(new Runnable(){

            public void run() {
                rDFResource.removePropertyValue(rDFProperty, object);
            }
        });
    }

    @Override
    public void setName(String string) {
        this.name = string;
        if (this.name != null) {
            this.getNarrowFrameStore().setName(string);
        }
    }

    @Override
    public void removePrefix(String string) {
        this.namespaceManager.removePrefix(string);
    }

    @Override
    public void setDefaultNamespace(String string) {
        this.setPrefix(string, "");
    }

    @Override
    public void setDefaultNamespace(URI uRI) {
        this.setDefaultNamespace(uRI.toString());
    }

    @Override
    public void setPrefix(String string, String string2) {
        this.getNamespaceManager().setPrefix(string, string2);
    }

    @Override
    public void setPrefix(URI uRI, String string) {
        this.setPrefix(uRI.toString(), string);
    }

    @Override
    public void sortPropertyValues(RDFResource rDFResource, RDFProperty rDFProperty, Comparator comparator) {
        TripleStoreUtil.sortSlotValues(this.getNarrowFrameStore(), rDFResource, rDFProperty, comparator);
    }

    @Override
    public String getOriginalXMLBase() {
        return this.originalXMLBase;
    }

    @Override
    public void setOriginalXMLBase(String string) {
        this.originalXMLBase = string;
    }

    public String toString() {
        return "TripleStore(" + this.getName() + ")";
    }

    @Override
    public void dump(Level level) {
        if (log.isLoggable(level)) {
            log.log(level, "Triples in " + this.getName());
            Iterator<Triple> iterator = this.listTriples();
            while (iterator.hasNext()) {
                log.log(level, " - " + iterator.next());
            }
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void addIOAddress(String string) {
        if (!this.ioAddresses.contains(string)) {
            this.ioAddresses.add(string);
        }
    }

    @Override
    public Collection<String> getIOAddresses() {
        return Collections.unmodifiableCollection(this.ioAddresses);
    }

    @Override
    public void removeIOAddress(String string) {
        this.ioAddresses.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangesOnThisTripleStore(Runnable runnable) {
        TripleStore tripleStore = this.tripleStoreModel.getActiveTripleStore();
        try {
            this.tripleStoreModel.setActiveTripleStore(this);
            runnable.run();
        }
        finally {
            this.tripleStoreModel.setActiveTripleStore(tripleStore);
        }
    }
}

