/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.query;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.query.QueryResults;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SPARQLQueryResults
implements QueryResults {
    private OWLModel owlModel;
    private Query query;
    private ResultSet results;

    public SPARQLQueryResults(OWLModel oWLModel, Query query, ResultSet resultSet) {
        this.owlModel = oWLModel;
        this.query = query;
        this.results = resultSet;
    }

    public static SPARQLQueryResults create(OWLModel oWLModel, String string) throws Exception {
        Model model = oWLModel.getJenaModel();
        Query query = QueryFactory.create((String)string);
        QueryExecution queryExecution = QueryExecutionFactory.create((Query)query, (Model)model);
        ResultSet resultSet = queryExecution.execSelect();
        return new SPARQLQueryResults(oWLModel, query, resultSet);
    }

    public static String createPrefixDeclarations(OWLModel oWLModel) {
        String string = "";
        String string2 = oWLModel.getNamespaceManager().getDefaultNamespace();
        if (string2 != null) {
            string = string2.endsWith("#") ? string + "BASE <" + string2.substring(0, string2.length() - 1) + ">\n" : string + "BASE <" + string2 + ">\n";
            string = string + "PREFIX :   <" + string2 + ">\n";
        }
        for (String string3 : oWLModel.getNamespaceManager().getPrefixes()) {
            String string4 = oWLModel.getNamespaceManager().getNamespaceForPrefix(string3);
            string = string + "PREFIX " + string3 + ": <" + string4 + ">\n";
        }
        return string;
    }

    public List getVariables() {
        return this.query.getResultVars();
    }

    public boolean hasNext() {
        return this.results.hasNext();
    }

    public Map next() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List list = this.query.getResultVars();
        QuerySolution querySolution = this.results.nextSolution();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Object object3;
            String string = (String)list.get(i);
            RDFNode rDFNode = querySolution.get(string);
            if (rDFNode == null) continue;
            if (rDFNode instanceof Literal) {
                object3 = (Literal)rDFNode;
                object2 = this.owlModel.getRDFSDatatypeByURI(object3.getDatatypeURI());
                object = object3.getLexicalForm();
                RDFSLiteral rDFSLiteral = this.owlModel.createRDFSLiteral((String)object, (RDFSDatatype)object2);
                hashMap.put(string, rDFSLiteral);
                continue;
            }
            object3 = rDFNode.toString();
            object2 = null;
            object2 = this.owlModel.isAnonymousResourceName((String)object3) ? object3 : ((AbstractOWLModel)this.owlModel).getFrameNameForURI((String)object3, false);
            if (object2 != null) {
                object = this.owlModel.getRDFResource((String)object2);
                if (object != null) {
                    hashMap.put(string, object);
                    continue;
                }
                hashMap.put(string, this.owlModel.createRDFSLiteral(object3));
                continue;
            }
            hashMap.put(string, this.owlModel.createRDFSLiteral(object3));
        }
        return hashMap;
    }
}

