/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.util.OWLFrameStoreUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLUtil {
    public static void addIsDefinedBy(Instance instance, Instance instance2) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        instance.addOwnSlotValue((Slot)oWLModel.getRDFSIsDefinedByProperty(), (Object)instance2);
    }

    public static void addLabel(RDFResource rDFResource, String string, String string2) {
        Object object = null;
        object = string2 != null && string2.trim().length() > 0 ? rDFResource.getOWLModel().createRDFSLiteralOrString(string, string2.trim()) : string;
        RDFProperty rDFProperty = rDFResource.getOWLModel().getRDFSLabelProperty();
        if (!rDFResource.getPropertyValues(rDFProperty).contains(object)) {
            rDFResource.addPropertyValue(rDFProperty, object);
        }
    }

    public static void addSameAs(Instance instance, Instance instance2) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        instance.addOwnSlotValue((Slot)oWLModel.getOWLSameAsProperty(), (Object)instance2);
    }

    public static void addVersionInfo(Instance instance, String string) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        instance.addOwnSlotValue((Slot)oWLModel.getOWLVersionInfoProperty(), (Object)string);
    }

    public static RDFUntypedResource assignUniqueURI(RDFUntypedResource rDFUntypedResource) {
        OWLModel oWLModel = rDFUntypedResource.getOWLModel();
        String string = "http://protege.stanford.edu/";
        String string2 = "";
        int n = 1;
        while (oWLModel.getRDFUntypedResource(string + n + string2, false) != null) {
            ++n;
        }
        return (RDFUntypedResource)rDFUntypedResource.rename(string + n + string2);
    }

    @Deprecated
    public static boolean confirmSaveAndReload() {
        return OWLUtil.confirmSaveAndReload(null);
    }

    public static boolean confirmSaveAndReload(Project project) {
        return ProtegeUI.getModalDialogFactory().showConfirmDialog((OWLModel)project.getKnowledgeBase(), "This change will not take effect until you save and\nreload your project.  Do you want to do this now?", "Confirm Reload");
    }

    public static void copyAnnotations(Instance instance, Instance instance2) {
        for (Slot slot : instance.getKnowledgeBase().getSlots()) {
            List list;
            if (!(slot instanceof OWLProperty) || !((OWLProperty)slot).isAnnotationProperty() || (list = instance.getDirectOwnSlotValues(slot)).size() <= 0) continue;
            instance2.setOwnSlotValues(slot, (Collection)list);
        }
    }

    public static void convertEquivalentClsIntoSuperClses(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
        if (rDFSClass2 instanceof OWLIntersectionClass) {
            OWLIntersectionClass oWLIntersectionClass = (OWLIntersectionClass)rDFSClass2;
            ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
            Iterator<RDFSClass> iterator = oWLIntersectionClass.getOperands().iterator();
            while (iterator.hasNext()) {
                RDFSClass rDFSClass3;
                RDFSClass rDFSClass4 = rDFSClass3 = iterator.next();
                RDFSClass rDFSClass5 = rDFSClass4.createClone();
                arrayList.add(rDFSClass5);
            }
            oWLIntersectionClass.delete();
            for (RDFSClass rDFSClass3 : arrayList) {
                rDFSClass.addSuperclass(rDFSClass3);
            }
        } else {
            rDFSClass2.removeSuperclass(rDFSClass);
        }
    }

    public static void convertSuperClsIntoEquivalentCls(OWLNamedClass oWLNamedClass, RDFSClass rDFSClass) {
        RDFSClass rDFSClass2 = oWLNamedClass.getDefinition();
        OWLUtil.convertSuperClsIntoEquivalentCls(oWLNamedClass, rDFSClass, rDFSClass2);
    }

    public static void convertSuperClsIntoEquivalentCls(OWLNamedClass oWLNamedClass, RDFSClass rDFSClass, RDFSClass rDFSClass2) {
        if (rDFSClass2 == null) {
            rDFSClass.addSuperclass(oWLNamedClass);
        } else {
            RDFSClass rDFSClass3;
            RDFSClass rDFSClass4 = rDFSClass.createClone();
            ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
            OWLModel oWLModel = oWLNamedClass.getOWLModel();
            if (rDFSClass2 instanceof OWLIntersectionClass) {
                rDFSClass3 = (OWLIntersectionClass)rDFSClass2;
                Iterator<RDFSClass> iterator = rDFSClass3.getOperands().iterator();
                while (iterator.hasNext()) {
                    RDFSClass rDFSClass5;
                    RDFSClass rDFSClass6 = rDFSClass5 = iterator.next();
                    RDFSClass rDFSClass7 = rDFSClass6.createClone();
                    arrayList.add(rDFSClass7);
                }
            } else {
                rDFSClass3 = rDFSClass2.createClone();
                arrayList.add(rDFSClass3);
            }
            arrayList.add(rDFSClass4);
            rDFSClass3 = oWLModel.createOWLIntersectionClass(arrayList);
            oWLNamedClass.addEquivalentClass(rDFSClass3);
            oWLNamedClass.removeSuperclass(rDFSClass2);
            oWLNamedClass.removeSuperclass(rDFSClass);
        }
    }

    @Deprecated
    public static Cls createClone(Cls cls) {
        String string = cls.getBrowserText();
        OWLModel oWLModel = (OWLModel)cls.getKnowledgeBase();
        RDFSClass rDFSClass = OWLUtil.createClone(oWLModel, string);
        OWLUtil.copyAnnotations((Instance)cls, rDFSClass);
        return rDFSClass;
    }

    @Deprecated
    public static RDFSClass createClone(OWLModel oWLModel, String string) {
        OWLClassParser oWLClassParser = oWLModel.getOWLClassParser();
        try {
            return oWLClassParser.parseClass(oWLModel, string);
        }
        catch (Exception exception) {
            System.err.println("Error in OWLUtil.createClone (" + string + ")");
            exception.printStackTrace();
            return null;
        }
    }

    public static void ensureSubclassesDisjoint(OWLNamedClass oWLNamedClass) {
        List list = OWLUtil.getPotentiallyDisjointSubclasses(oWLNamedClass);
        for (OWLNamedClass oWLNamedClass2 : list) {
            if (oWLNamedClass2.isSystem()) continue;
            Collection collection = oWLNamedClass2.getDisjointClasses();
            for (RDFSNamedClass rDFSNamedClass : list) {
                if (oWLNamedClass2.equals(rDFSNamedClass) || collection.contains(rDFSNamedClass)) continue;
                oWLNamedClass2.addDisjointClass(rDFSNamedClass);
            }
        }
    }

    public static boolean equalsStructurally(Collection collection, Collection collection2) {
        if (collection.size() == collection2.size()) {
            for (RDFObject rDFObject : collection) {
                boolean bl = false;
                for (RDFObject rDFObject2 : collection2) {
                    if (!rDFObject.equalsStructurally(rDFObject2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Collection getDocumentation(Instance instance) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        return instance.getOwnSlotValues((Slot)oWLModel.getRDFSCommentProperty());
    }

    public static Collection getInferredDirectTypes(RDFResource rDFResource) {
        RDFProperty rDFProperty = rDFResource.getOWLModel().getRDFProperty(ProtegeNames.Slot.INFERRED_TYPE);
        return rDFResource.getPropertyValues(rDFProperty);
    }

    public static Collection getIsDefinedBy(Instance instance) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        return instance.getOwnSlotValues((Slot)oWLModel.getRDFSIsDefinedByProperty());
    }

    public static Collection getLabels(RDFResource rDFResource) {
        return rDFResource.getPropertyValues(rDFResource.getOWLModel().getRDFSLabelProperty());
    }

    public static Collection<List<Cls>> getPathsToRoot(Cls cls) {
        ArrayList<List<Cls>> arrayList = new ArrayList<List<Cls>>();
        return OWLUtil.getPathToRoot(cls, new LinkedList<Cls>(), arrayList);
    }

    private static Collection<List<Cls>> getPathToRoot(Cls cls, LinkedList<Cls> linkedList, Collection<List<Cls>> collection) {
        linkedList.add(0, cls);
        Iterator iterator = cls.getDirectSuperclasses().iterator();
        Cls cls2 = cls.getKnowledgeBase().getRootCls();
        while (iterator.hasNext()) {
            Cls cls3 = (Cls)iterator.next();
            if (!cls.isVisible()) continue;
            ArrayList<Cls> arrayList = new ArrayList<Cls>(linkedList);
            OWLUtil.getPathToRoot(cls3, linkedList, collection);
            if (linkedList.getFirst().equals(cls2)) {
                collection.add(linkedList);
                continue;
            }
            linkedList.clear();
            linkedList.addAll(arrayList);
        }
        return collection;
    }

    public static List getPotentiallyDisjointSubclasses(OWLNamedClass oWLNamedClass) {
        ArrayList<RDFSNamedClass> arrayList = new ArrayList<RDFSNamedClass>();
        for (RDFSNamedClass rDFSNamedClass : oWLNamedClass.getNamedSubclasses()) {
            if (!(rDFSNamedClass instanceof OWLNamedClass) || ((OWLNamedClass)rDFSNamedClass).getDefinition() != null || !rDFSNamedClass.isVisible()) continue;
            arrayList.add(rDFSNamedClass);
        }
        return arrayList;
    }

    public static Set getReferringAnonymousClses(RDFResource rDFResource) {
        Slot slot = rDFResource.getKnowledgeBase().getSlot(":DIRECT-SUBCLASSES");
        RDFProperty rDFProperty = rDFResource.getOWLModel().getRDFFirstProperty();
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (Reference reference : rDFResource.getReferences()) {
            if (reference.getFrame() instanceof OWLAnonymousClass) {
                if (slot.equals(reference.getSlot())) continue;
                hashSet.add(reference.getFrame());
                continue;
            }
            if (!(reference.getFrame() instanceof RDFList) || !rDFProperty.equals(reference.getSlot())) continue;
            RDFList rDFList = (RDFList)reference.getFrame();
            RDFList rDFList2 = rDFList.getStart();
            OWLUtil.getReferringLogicalClasses(rDFList2, hashSet);
        }
        return hashSet;
    }

    public static void getReferringLogicalClasses(RDFList rDFList, Set set) {
        OWLModel oWLModel = rDFList.getOWLModel();
        Collection collection = oWLModel.getReferences(rDFList, 1000);
        for (Reference reference : collection) {
            if (!(reference.getFrame() instanceof OWLNAryLogicalClass) && !(reference.getFrame() instanceof OWLEnumeratedClass)) continue;
            set.add(reference.getFrame());
        }
    }

    public static Collection getSameAs(Instance instance) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        return instance.getOwnSlotValues((Slot)oWLModel.getOWLSameAsProperty());
    }

    public static Collection getSelectableNamedClses(OWLModel oWLModel) {
        Collection collection = oWLModel.getUserDefinedRDFSNamedClasses();
        collection.add(oWLModel.getOWLThingClass());
        if (oWLModel.getOWLNamedClassClass().isVisible()) {
            collection.add(oWLModel.getOWLNamedClassClass());
        }
        if (oWLModel.getRDFPropertyClass().isVisible()) {
            collection.add(oWLModel.getOWLDatatypePropertyClass());
            collection.add(oWLModel.getOWLObjectPropertyClass());
        }
        return collection;
    }

    public static Collection getVersionInfo(Instance instance) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        return instance.getOwnSlotValues((Slot)oWLModel.getOWLVersionInfoProperty());
    }

    public static boolean hasDirectRestriction(Cls cls, Slot slot, Cls cls2) {
        for (Cls cls3 : cls.getDirectSuperclasses()) {
            OWLRestriction oWLRestriction;
            Cls cls4 = cls3;
            if (!cls4.getDirectType().equals(cls2) || !(oWLRestriction = (OWLRestriction)cls4).getOnProperty().equals(slot)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOWLDLProfile(OWLModel oWLModel) {
        return ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.OWL_DL) && !OWLUtil.hasOWLFullProfile(oWLModel);
    }

    public static boolean hasOWLFullProfile(OWLModel oWLModel) {
        return ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.OWL_Full);
    }

    public static boolean hasRDFProfile(OWLModel oWLModel) {
        return ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.RDF_but_not_OWL);
    }

    public static boolean isInconsistent(Cls cls) {
        Slot slot = ((AbstractOWLModel)cls.getKnowledgeBase()).getSlot(ProtegeNames.Slot.INFERRED_SUPERCLASSES);
        List list = cls.getDirectOwnSlotValues(slot);
        return list.contains(((AbstractOWLModel)cls.getKnowledgeBase()).getOWLNothing());
    }

    public static void printStackTrace() {
        try {
            throw new RuntimeException("Debugging purposes only");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void removeIsDefinedBy(Instance instance, Instance instance2) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        instance.removeOwnSlotValue((Slot)oWLModel.getRDFSIsDefinedByProperty(), (Object)instance2);
    }

    public static void removeLabel(RDFResource rDFResource, String string, String string2) {
        Object object = null;
        object = string2 != null && string2.trim().length() > 0 ? rDFResource.getOWLModel().createRDFSLiteralOrString(string, string2.trim()) : string;
        rDFResource.removePropertyValue(rDFResource.getOWLModel().getRDFSLabelProperty(), object);
    }

    public static void removeSameAs(Instance instance, Instance instance2) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        instance.removeOwnSlotValue((Slot)oWLModel.getOWLSameAsProperty(), (Object)instance2);
    }

    public static void removeSubclassesDisjoint(OWLNamedClass oWLNamedClass) {
        Object object22;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object22 : oWLNamedClass.getNamedSubclasses()) {
            if (!(object22 instanceof OWLNamedClass) || ((OWLNamedClass)object22).getDefinition() != null || !object22.isVisible()) continue;
            arrayList.add(object22);
        }
        object22 = oWLNamedClass.getOWLModel().getTripleStoreModel();
        RDFProperty rDFProperty = oWLNamedClass.getOWLModel().getOWLDisjointWithProperty();
        for (OWLNamedClass oWLNamedClass2 : arrayList) {
            if (!oWLNamedClass2.isEditable()) continue;
            Collection collection = oWLNamedClass2.getDisjointClasses();
            for (OWLNamedClass oWLNamedClass3 : arrayList) {
                if (oWLNamedClass2.equals(oWLNamedClass3) || !collection.contains(oWLNamedClass3) || !object22.isEditableTriple(oWLNamedClass2, rDFProperty, oWLNamedClass3)) continue;
                oWLNamedClass2.removeDisjointClass(oWLNamedClass3);
            }
        }
    }

    public static void removeVersionInfo(Instance instance, String string) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        instance.removeOwnSlotValue((Slot)oWLModel.getOWLVersionInfoProperty(), (Object)string);
    }

    public static void resetComputedSuperclasses(OWLModel oWLModel) {
        OWLUtil.resetComputedSuperclasses(oWLModel, oWLModel.getUserDefinedOWLNamedClasses());
    }

    public static void resetComputedSuperclasses(OWLModel oWLModel, Collection collection) {
        AbstractOWLModel abstractOWLModel = (AbstractOWLModel)oWLModel;
        RDFProperty rDFProperty = abstractOWLModel.getProtegeInferredSubclassesProperty();
        RDFProperty rDFProperty2 = abstractOWLModel.getProtegeInferredSuperclassesProperty();
        for (OWLNamedClass oWLNamedClass : collection) {
            oWLNamedClass.setOwnSlotValues(rDFProperty, Collections.EMPTY_LIST);
            oWLNamedClass.setOwnSlotValues(rDFProperty2, Collections.EMPTY_LIST);
        }
        oWLModel.getOWLThingClass().setOwnSlotValues(rDFProperty, Collections.EMPTY_LIST);
        oWLModel.getOWLNothing().setOwnSlotValues(rDFProperty, Collections.EMPTY_LIST);
    }

    public static boolean saveAndReloadProject() {
        ProjectManager projectManager = ProjectManager.getProjectManager();
        if (projectManager.saveProjectRequest()) {
            URI uRI = projectManager.getCurrentProject().getProjectURI();
            if (projectManager.closeProjectRequest()) {
                projectManager.loadProject(uRI);
                return true;
            }
        }
        return false;
    }

    public static void setDocumentation(Instance instance, Collection collection) {
        OWLModel oWLModel = (OWLModel)instance.getKnowledgeBase();
        instance.setOwnSlotValues((Slot)oWLModel.getRDFSCommentProperty(), collection);
    }

    public static void setConsistentClassificationStatus(OWLNamedClass oWLNamedClass) {
        if (oWLNamedClass.isMetaclass()) {
            oWLNamedClass.setClassificationStatus(1);
        } else {
            Collection collection = oWLNamedClass.getNamedSuperclasses();
            Collection collection2 = oWLNamedClass.getInferredSuperclasses();
            ArrayList arrayList = new ArrayList(collection2);
            arrayList.removeAll(collection);
            int n = arrayList.size() == 0 ? 1 : 3;
            oWLNamedClass.setClassificationStatus(n);
        }
    }

    public static void sortSubclasses(Cls cls) {
        if (cls.getDirectSubclassCount() > 1) {
            ArrayList arrayList = new ArrayList(cls.getDirectSubclasses());
            ArrayList arrayList2 = new ArrayList(arrayList);
            Collections.sort(arrayList2, new FrameComparator(){

                public int compare(Frame frame, Frame frame2) {
                    if (frame instanceof RDFSNamedClass && frame2 instanceof RDFSNamedClass) {
                        return ((RDFSNamedClass)frame).getBrowserText().compareTo(((RDFSNamedClass)frame2).getBrowserText());
                    }
                    if (frame instanceof RDFSNamedClass) {
                        return 1;
                    }
                    if (frame2 instanceof RDFSNamedClass) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (int i = 0; i < arrayList2.size() - 1; ++i) {
                Cls cls2 = (Cls)arrayList2.get(i);
                Cls cls3 = (Cls)arrayList2.get(i + 1);
                cls.moveDirectSubclass(cls3, cls2);
            }
        }
    }

    public static void addProtegeType(RDFResource rDFResource, RDFSClass rDFSClass) {
        rDFResource.getOWLModel().addDirectType(rDFResource, rDFSClass);
    }

    public static RDFSClass getDirectRDFType(RDFResource rDFResource) {
        return (RDFSClass)rDFResource.getOWLModel().getDirectType(rDFResource);
    }

    public static Collection getDirectRDFTypes(RDFResource rDFResource) {
        return rDFResource.getOWLModel().getDirectTypes(rDFResource);
    }

    public static boolean hasProtegeType(RDFResource rDFResource, RDFSClass rDFSClass) {
        return rDFResource.getOWLModel().hasDirectType(rDFResource, rDFSClass);
    }

    public static boolean hasProtegeType(RDFResource rDFResource, RDFSClass rDFSClass, boolean bl) {
        if (bl) {
            return rDFResource.getOWLModel().hasType(rDFResource, rDFSClass);
        }
        return rDFResource.getOWLModel().hasDirectType(rDFResource, rDFSClass);
    }

    public static void removeProtegeType(RDFResource rDFResource, RDFSClass rDFSClass) {
        rDFResource.getOWLModel().removeDirectType(rDFResource, rDFSClass);
    }

    public static void setProtegeType(RDFResource rDFResource, RDFSClass rDFSClass) {
        rDFResource.getOWLModel().setDirectType(rDFResource, rDFSClass);
    }

    public static void setProtegeTypes(RDFResource rDFResource, Collection collection) {
        rDFResource.getOWLModel().setDirectTypes(rDFResource, collection);
    }

    public static void addDifferentFrom(RDFResource rDFResource, RDFResource rDFResource2) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        oWLModel.addOwnSlotValue((Frame)rDFResource, oWLModel.getOWLDifferentFromProperty(), rDFResource2);
    }

    public static void removeDifferentFrom(RDFResource rDFResource, RDFResource rDFResource2) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        oWLModel.removeOwnSlotValue((Frame)rDFResource, oWLModel.getOWLDifferentFromProperty(), rDFResource2);
    }

    public static void addComment(RDFResource rDFResource, String string) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        oWLModel.addOwnSlotValue((Frame)rDFResource, oWLModel.getRDFSCommentProperty(), string);
    }

    public static void removeComment(RDFResource rDFResource, String string) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        oWLModel.removeOwnSlotValue((Frame)rDFResource, oWLModel.getRDFSCommentProperty(), string);
    }

    public static void addPropertyValue(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        oWLModel.addOwnSlotValue((Frame)rDFResource, rDFProperty, object);
    }

    public static Collection getComments(RDFResource rDFResource) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        return rDFResource.getPropertyValues(oWLModel.getRDFSCommentProperty());
    }

    public static void setComment(RDFResource rDFResource, String string) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        rDFResource.setPropertyValues(oWLModel.getRDFSCommentProperty(), string == null ? Collections.EMPTY_LIST : Collections.singleton(string));
    }

    public static void setComments(RDFResource rDFResource, Collection collection) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        rDFResource.setPropertyValues(oWLModel.getRDFSCommentProperty(), collection);
    }

    public static void setInferredTypes(RDFResource rDFResource, Collection collection) {
        RDFProperty rDFProperty = rDFResource.getOWLModel().getRDFProperty(ProtegeNames.Slot.INFERRED_TYPE);
        rDFResource.setPropertyValues(rDFProperty, collection);
    }

    public static Collection getDifferentFrom(RDFResource rDFResource) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        return rDFResource.getPropertyValues(oWLModel.getRDFProperty(OWLNames.Slot.DIFFERENT_FROM));
    }

    public static Object getPropertyValue(RDFResource rDFResource, RDFProperty rDFProperty, boolean bl) {
        Collection collection = OWLUtil.getPropertyValues(rDFResource, rDFProperty, bl);
        return collection.isEmpty() ? null : collection.iterator().next();
    }

    public static int getPropertyValueCount(RDFResource rDFResource, RDFProperty rDFProperty) {
        return rDFResource.getOWLModel().getDirectOwnSlotValues((Frame)rDFResource, rDFProperty).size();
    }

    public static Collection getPropertyValues(RDFResource rDFResource, RDFProperty rDFProperty, boolean bl) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        Collection collection = bl ? oWLModel.getOwnSlotValues((Frame)rDFResource, rDFProperty) : oWLModel.getDirectOwnSlotValues((Frame)rDFResource, rDFProperty);
        return OWLFrameStoreUtils.convertValueListToRDFLiterals(oWLModel, collection);
    }

    public static Iterator listPropertyValues(RDFResource rDFResource, RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.getPropertyValues(rDFResource, rDFProperty, bl).iterator();
    }

    public static void removePropertyValue(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        if (object instanceof RDFSLiteral) {
            object = ((DefaultRDFSLiteral)object).getRawValue();
        }
        oWLModel.removeOwnSlotValue((Frame)rDFResource, rDFProperty, object);
    }

    public static void setPropertyValue(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        oWLModel.setOwnSlotValues((Frame)rDFResource, rDFProperty, object == null ? Collections.EMPTY_LIST : Collections.singleton(object));
    }

    public static void setPropertyValues(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        oWLModel.setOwnSlotValues((Frame)rDFResource, rDFProperty, collection);
    }

    public static boolean isSystem(Frame frame) {
        Slot slot;
        MergingNarrowFrameStore mergingNarrowFrameStore = MergingNarrowFrameStore.get((KnowledgeBase)frame.getKnowledgeBase());
        NarrowFrameStore narrowFrameStore = mergingNarrowFrameStore.getSystemFrameStore();
        return narrowFrameStore.getValuesCount(frame, slot = frame.getKnowledgeBase().getSlot(":DIRECT-TYPE"), null, false) > 0;
    }

    public static Collection getPropertyValueLiterals(RDFResource rDFResource, RDFProperty rDFProperty) {
        return ((AbstractOWLModel)rDFResource.getOWLModel()).getPropertyValueLiterals(rDFResource, rDFProperty);
    }

    public static RDFSLiteral getPropertyValueLiteral(RDFResource rDFResource, RDFProperty rDFProperty) {
        Object object = OWLUtil.getPropertyValue(rDFResource, rDFProperty, false);
        if (object != null) {
            if (object instanceof RDFSLiteral) {
                return (RDFSLiteral)object;
            }
            return rDFResource.getOWLModel().createRDFSLiteral(object);
        }
        return null;
    }

    public static Collection getRDFProperties(RDFResource rDFResource) {
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        OWLModel oWLModel = rDFResource.getOWLModel();
        ArrayList arrayList2 = new ArrayList(oWLModel.getRDFProperties());
        if (!(rDFResource instanceof RDFProperty)) {
            arrayList2.remove(oWLModel.getRDFSSubPropertyOfProperty());
        }
        for (RDFProperty rDFProperty : arrayList2) {
            if (rDFResource.getPropertyValueCount(rDFProperty) <= 0) continue;
            arrayList.add(rDFProperty);
        }
        return arrayList;
    }

    public static void addResourceListener(RDFResource rDFResource, ResourceListener resourceListener) {
        if (!(resourceListener instanceof ResourceAdapter)) {
            throw new IllegalArgumentException("Listener must be a ResourceAdapter");
        }
        rDFResource.addFrameListener(resourceListener);
    }

    public static void removeResourceListener(RDFResource rDFResource, ResourceListener resourceListener) {
        if (!(resourceListener instanceof ResourceAdapter)) {
            throw new IllegalArgumentException("Listener must be a ResourceAdapter");
        }
        rDFResource.removeFrameListener(resourceListener);
    }

    public static boolean hasPropertyValue(RDFResource rDFResource, RDFProperty rDFProperty, Object object, boolean bl) {
        return rDFResource.getPropertyValues(rDFProperty, bl).contains(object);
    }

    public static void addPropertyValueListener(RDFResource rDFResource, PropertyValueListener propertyValueListener) {
        if (!(propertyValueListener instanceof PropertyValueAdapter)) {
            throw new IllegalArgumentException("Listener must be a PropertyValueAdapter");
        }
        rDFResource.addFrameListener(propertyValueListener);
    }

    public static void removePropertyValueListener(RDFResource rDFResource, PropertyValueListener propertyValueListener) {
        rDFResource.removeFrameListener(propertyValueListener);
    }

    public static Collection getPossibleRDFProperties(RDFResource rDFResource) {
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        for (RDFSClass rDFSClass : rDFResource.getProtegeTypes()) {
            Collection collection = rDFSClass.getUnionDomainProperties(true);
            hashSet.addAll(collection);
            for (RDFProperty rDFProperty : collection) {
                for (RDFProperty rDFProperty2 : rDFProperty.getSubproperties(true)) {
                    if (rDFProperty2.getDomain(false) != null) continue;
                    hashSet.add(rDFProperty2);
                }
            }
        }
        return hashSet;
    }

    public static RDFResource as(RDFResource rDFResource, Class clazz) {
        return rDFResource.getOWLModel().getOWLJavaFactory().as(rDFResource, clazz);
    }

    public static boolean canAs(RDFResource rDFResource, Class clazz) {
        return rDFResource.getOWLModel().getOWLJavaFactory().canAs(rDFResource, clazz);
    }

    public static Collection getPropertyValuesAs(RDFResource rDFResource, RDFProperty rDFProperty, Class clazz) {
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        for (Object e : rDFResource.getPropertyValues(rDFProperty)) {
            if (e instanceof RDFResource) {
                arrayList.add(((RDFResource)e).as(clazz));
                continue;
            }
            arrayList.add((RDFResource)e);
        }
        return arrayList;
    }

    public static RDFResource getPropertyValueAs(RDFResource rDFResource, RDFProperty rDFProperty, Class clazz) {
        RDFResource rDFResource2 = (RDFResource)rDFResource.getPropertyValue(rDFProperty);
        if (rDFResource2 != null) {
            return rDFResource2.as(clazz);
        }
        return null;
    }

    public static Iterator listPropertyValuesAs(RDFResource rDFResource, RDFProperty rDFProperty, Class clazz) {
        return OWLUtil.getPropertyValuesAs(rDFResource, rDFProperty, clazz).iterator();
    }

    public static boolean hasPropertyValue(RDFResource rDFResource, RDFProperty rDFProperty) {
        return rDFResource.getPropertyValueCount(rDFProperty) > 0;
    }

    public static boolean hasPropertyValue(RDFResource rDFResource, RDFProperty rDFProperty, boolean bl) {
        if (bl) {
            return rDFResource.getPropertyValues(rDFProperty, bl).size() > 0;
        }
        return OWLUtil.hasPropertyValue(rDFResource, rDFProperty);
    }

    public static RDFSClass getRDFType(RDFResource rDFResource) {
        return (RDFSClass)rDFResource.getPropertyValue(rDFResource.getOWLModel().getRDFTypeProperty());
    }

    public static Collection getRDFTypes(RDFResource rDFResource) {
        return rDFResource.getPropertyValues(rDFResource.getOWLModel().getRDFTypeProperty());
    }

    public static void addRDFType(RDFResource rDFResource, RDFSClass rDFSClass) {
        OWLUtil.addProtegeType(rDFResource, rDFSClass);
    }

    public static void removeRDFType(RDFResource rDFResource, RDFSClass rDFSClass) {
        OWLUtil.removeProtegeType(rDFResource, rDFSClass);
    }

    public static boolean hasRDFType(RDFResource rDFResource, RDFSClass rDFSClass) {
        return rDFResource.getRDFTypes().contains(rDFSClass);
    }

    public static boolean hasRDFType(RDFResource rDFResource, RDFSClass rDFSClass, boolean bl) {
        if (bl) {
            return OWLUtil.hasProtegeType(rDFResource, rDFSClass, bl);
        }
        return OWLUtil.hasRDFType(rDFResource, rDFSClass);
    }

    public static void sortSubclasses(OWLModel oWLModel) {
        for (OWLNamedClass oWLNamedClass : oWLModel.getUserDefinedOWLNamedClasses()) {
            OWLUtil.sortSubclasses(oWLNamedClass);
        }
        OWLUtil.sortSubclasses(oWLModel.getOWLThingClass());
    }

    public static void setRDFType(RDFResource rDFResource, RDFSClass rDFSClass) {
        OWLUtil.setProtegeType(rDFResource, rDFSClass);
    }

    public static void setRDFTypes(RDFResource rDFResource, Collection collection) {
        OWLUtil.setProtegeTypes(rDFResource, collection);
    }

    public static Collection getHasValuesOnTypes(RDFResource rDFResource, RDFProperty rDFProperty) {
        HashSet hashSet = new HashSet();
        for (RDFSClass rDFSClass : rDFResource.getRDFTypes()) {
            if (!(rDFSClass instanceof OWLNamedClass)) continue;
            Collection collection = ((OWLNamedClass)rDFSClass).getHasValues(rDFProperty);
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    public static boolean containsAnonymousClass(Collection collection) {
        for (Cls cls : collection) {
            if (!(cls instanceof OWLAnonymousClass)) continue;
            return true;
        }
        return false;
    }

    public static List removeInvisibleResources(Iterator iterator) {
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        while (iterator.hasNext()) {
            RDFResource rDFResource = (RDFResource)iterator.next();
            if (!rDFResource.isVisible()) continue;
            arrayList.add(rDFResource);
        }
        return arrayList;
    }

    public static boolean isValidPropertyValue(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return rDFResource.getOWLModel().isValidPropertyValue(rDFResource, rDFProperty, object);
    }

    public static RDFResource getAllValuesFromOnTypes(RDFResource rDFResource, RDFProperty rDFProperty) {
        Iterator iterator = rDFResource.listRDFTypes();
        while (iterator.hasNext()) {
            RDFResource rDFResource2;
            RDFSClass rDFSClass = (RDFSClass)iterator.next();
            if (!(rDFSClass instanceof OWLNamedClass) || (rDFResource2 = ((OWLNamedClass)rDFSClass).getAllValuesFrom(rDFProperty)) == null) continue;
            return rDFResource2;
        }
        return rDFProperty.getRange();
    }

    public static OWLOntology getActiveOntology(OWLModel oWLModel) {
        Object var1_1 = null;
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
        return tripleStore.getOWLOntology();
    }

    public static void setActiveOntology(OWLModel oWLModel, OWLOntology oWLOntology) {
        if (oWLOntology != null && !oWLOntology.equals(OWLUtil.getActiveOntology(oWLModel))) {
            TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
            TripleStore tripleStore = tripleStoreModel.getHomeTripleStore(oWLOntology);
            TripleStoreUtil.switchTripleStore(oWLModel, tripleStore);
        }
    }

    public static URI getOWLFileURI(OWLModel oWLModel) {
        try {
            Project project = oWLModel.getProject();
            String string = JenaKnowledgeBaseFactory.getOWLFilePath(project.getSources());
            if (string.startsWith("http://")) {
                return new URI(string);
            }
            URI uRI = project.getProjectURI();
            if (uRI == null) {
                return new URI(string);
            }
            URI uRI2 = project.getProjectDirectoryURI();
            URI uRI3 = URIUtilities.relativize((URI)uRI2, (URI)new URI(string));
            URI uRI4 = uRI.resolve(uRI3);
            return uRI4;
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return null;
        }
    }

    public static boolean runsWithGUI(OWLModel oWLModel) {
        Project project = oWLModel.getProject();
        if (project == null) {
            return false;
        }
        JComponent jComponent = ProjectManager.getProjectManager().getMainPanel();
        return jComponent != null;
    }

    public static OWLOntology renameOntology(OWLModel oWLModel, OWLOntology oWLOntology, String string) {
        String string2 = oWLOntology.getName();
        OWLOntology oWLOntology2 = (OWLOntology)oWLModel.rename((Frame)oWLOntology, string);
        OWLUtil.synchronizeTripleStoreAfterOntologyRename(oWLModel, string2, oWLOntology2);
        return oWLOntology2;
    }

    public static void synchronizeTripleStoreAfterOntologyRename(OWLModel oWLModel, String string, OWLOntology oWLOntology) {
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getTripleStore(string);
        if (tripleStore == null) {
            Log.getLogger().severe("Error at ontology rename. Could not find triplestore " + string);
            return;
        }
        String string2 = oWLOntology.getName();
        tripleStore.setName(string2);
        tripleStore.setOriginalXMLBase(string2);
        if (tripleStore.equals(tripleStoreModel.getTopTripleStore())) {
            oWLModel.resetOntologyCache();
        }
    }

    public static String getInternalFullName(OWLModel oWLModel, String string) {
        return OWLUtil.getInternalFullName(oWLModel, string, oWLModel.isExpandShortNameInMethods());
    }

    public static String getInternalFullName(OWLModel oWLModel, String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (oWLModel.isAnonymousResourceName(string)) {
            return string;
        }
        if (bl && !OWLUtil.isAbsoluteURI(oWLModel, string)) {
            string = NamespaceUtil.getFullName(oWLModel, string);
        }
        return string;
    }

    protected static boolean isAbsoluteURI(OWLModel oWLModel, String string) {
        if (!string.contains(":")) {
            return false;
        }
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (uRI == null || !uRI.isAbsolute()) {
            return false;
        }
        if (uRI.isOpaque()) {
            String string2 = uRI.getScheme();
            return oWLModel.getNamespaceManager().getNamespaceForPrefix(string2) == null;
        }
        return true;
    }
}

