/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.MaximumCardinalityConstraint;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.XSDNames;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSDatatype;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLSystemFrames
extends SystemFrames {
    private static final transient Logger log = Log.getLogger(OWLSystemFrames.class);
    protected OWLModel owlModel;
    private OWLNamedClass owlThingClass;
    private RDFSNamedClass owlClassMetaCls;
    private OWLNamedClass rdfsNamedClassClass;
    private OWLNamedClass owlNamedClassClass;
    private RDFSNamedClass owlDeprecatedClassClass;
    private OWLNamedClass anonymousClassMetaCls;
    private RDFSNamedClass owlEnumeratedClassClass;
    private RDFSNamedClass owlRestrictionClass;
    private RDFSNamedClass owlAllValuesFromClass;
    private RDFSNamedClass owlHasValueClass;
    private RDFSNamedClass owlMaxCardinalityClass;
    private RDFSNamedClass owlMinCardinalityClass;
    private RDFSNamedClass owlCardinalityClass;
    private RDFSNamedClass owlSomeValuesFromClass;
    private RDFSNamedClass owlLogicalClassClass;
    private RDFSNamedClass owlComplementClassClass;
    private RDFSNamedClass owlIntersectionClassClass;
    private RDFSNamedClass owlUnionClassClass;
    private OWLNamedClass rdfPropertyClass;
    private OWLNamedClass owlDatatypePropertyClass;
    private OWLNamedClass owlObjectPropertyClass;
    private OWLNamedClass owlInverseFunctionalPropertyClass;
    private OWLNamedClass owlSymmetricPropertyClass;
    private OWLNamedClass owlTransitivePropertyClass;
    private OWLNamedClass owlAnnotationPropertyClass;
    private OWLNamedClass owlFunctionalPropertyClass;
    private RDFSNamedClass owlDeprecatedPropertyClass;
    private RDFSNamedClass rdfsDatatypeClass;
    private OWLNamedClass owlOntologyClass;
    private OWLNamedClass owlNothingClass;
    private RDFSNamedClass rdfListClass;
    private RDFSNamedClass owlAllDifferentClass;
    private RDFSNamedClass rdfsContainerClass;
    private RDFSNamedClass rdfAltClass;
    private RDFSNamedClass rdfBagClass;
    private RDFSNamedClass rdfSeqClass;
    private RDFSNamedClass rdfStatementClass;
    private RDFSNamedClass owlDataRangeClass;
    private RDFSNamedClass anonymousRootCls;
    private RDFSNamedClass rdfExternalResourceClass;
    private RDFSNamedClass rdfExternalClassClass;
    private RDFSNamedClass rdfExternalPropertyClass;
    private RDFSNamedClass owlOntologyPointerClass;
    private OWLNamedClass directedBinaryRelation;
    private OWLNamedClass palConstraintCls;
    private RDFProperty owlAllValuesFromProperty;
    private RDFProperty owlBackwardCompatibleWithProperty;
    private RDFProperty owlCardinalityProperty;
    private RDFProperty owlComplementOfProperty;
    private RDFProperty owlDifferentFromProperty;
    private RDFProperty owlDisjointWithProperty;
    private RDFProperty owlDistinctMembersProperty;
    private RDFProperty owlEquivalentClassProperty;
    private RDFProperty owlEquivalentPropertyProperty;
    private RDFProperty owlHasValueProperty;
    private RDFProperty owlImportsProperty;
    private RDFProperty owlIncompatibleWithProperty;
    private RDFProperty owlIntersectionOfProperty;
    private RDFProperty owlInverseOfProperty;
    private RDFProperty owlMaxCardinalityProperty;
    private RDFProperty owlMinCardinalityProperty;
    private RDFProperty owlOneOfProperty;
    private RDFProperty owlOnPropertyProperty;
    private RDFProperty owlPriorVersionProperty;
    private RDFProperty owlSameAsProperty;
    private RDFProperty owlSomeValuesFromProperty;
    private RDFProperty owlUnionOfProperty;
    private RDFProperty owlValuesFromProperty;
    private OWLDatatypeProperty owlVersionInfoProperty;
    private RDFProperty protegeClassificationStatusProperty;
    private RDFProperty protegeInferredSubclassesProperty;
    private RDFProperty protegeInferredSuperclassesProperty;
    private RDFProperty protegeInferredTypeProperty;
    private RDFProperty rdfFirstProperty;
    private RDFProperty rdfObjectProperty;
    private RDFProperty rdfPredicateProperty;
    private RDFProperty rdfRestProperty;
    private RDFProperty rdfSubjectProperty;
    private RDFProperty rdfTypeProperty;
    private RDFProperty rdfValueProperty;
    private OWLDatatypeProperty rdfsCommentProperty;
    private RDFProperty rdfsDomainProperty;
    private RDFProperty rdfsIsDefinedByProperty;
    private RDFProperty rdfsLabelProperty;
    private RDFProperty rdfsMemberProperty;
    private RDFProperty rdfsRangeProperty;
    private RDFProperty rdfsSeeAlsoProperty;
    private RDFProperty rdfsSubClassOfProperty;
    private RDFProperty rdfsSubPropertyOf;
    private RDFProperty owlOntologyPrefixesProperty;
    private RDFProperty owlResourceURIProperty;
    private RDFProperty owlOntologyPointerProperty;
    private OWLObjectProperty toSlot;
    private OWLObjectProperty fromSlot;
    private OWLObjectProperty slotConstraints;
    private OWLDatatypeProperty palStatementSlot;
    private OWLDatatypeProperty palDescriptionSlot;
    private OWLDatatypeProperty palNameSlot;
    private OWLDatatypeProperty palRangeSlot;
    private RDFList rdfNil;
    private Set<RDFSDatatype> rdfDatatypes = new HashSet<RDFSDatatype>();
    private Set<RDFSDatatype> floatDatatypes = new HashSet<RDFSDatatype>();
    private Set<RDFSDatatype> integerDatatypes = new HashSet<RDFSDatatype>();

    public OWLSystemFrames(OWLModel oWLModel) {
        super((KnowledgeBase)oWLModel);
        this.owlModel = oWLModel;
        this.createOWLMetaModel();
    }

    protected OWLNamedClass createOWLNamedClass(String string) {
        FrameID frameID = new FrameID(string);
        DefaultOWLNamedClass defaultOWLNamedClass = new DefaultOWLNamedClass(this.owlModel, frameID);
        this.addFrame(frameID, (Frame)defaultOWLNamedClass);
        return defaultOWLNamedClass;
    }

    protected RDFSNamedClass createRDFSNamedClass(String string) {
        FrameID frameID = new FrameID(string);
        DefaultRDFSNamedClass defaultRDFSNamedClass = new DefaultRDFSNamedClass(this.owlModel, frameID);
        this.addFrame(frameID, (Frame)defaultRDFSNamedClass);
        return defaultRDFSNamedClass;
    }

    protected RDFProperty createRDFProperty(String string) {
        FrameID frameID = new FrameID(string);
        DefaultRDFProperty defaultRDFProperty = new DefaultRDFProperty(this.owlModel, frameID);
        this.addFrame(frameID, (Frame)defaultRDFProperty);
        return defaultRDFProperty;
    }

    protected OWLDatatypeProperty createOWLDatatypeProperty(String string) {
        FrameID frameID = new FrameID(string);
        DefaultOWLDatatypeProperty defaultOWLDatatypeProperty = new DefaultOWLDatatypeProperty(this.owlModel, frameID);
        this.addFrame(frameID, (Frame)defaultOWLDatatypeProperty);
        return defaultOWLDatatypeProperty;
    }

    protected OWLObjectProperty createOWLObjectProperty(String string) {
        FrameID frameID = new FrameID(string);
        DefaultOWLObjectProperty defaultOWLObjectProperty = new DefaultOWLObjectProperty(this.owlModel, frameID);
        this.addFrame(frameID, (Frame)defaultOWLObjectProperty);
        return defaultOWLObjectProperty;
    }

    protected RDFSDatatype createRDFSDatatype(String string) {
        FrameID frameID = new FrameID(string);
        DefaultRDFSDatatype defaultRDFSDatatype = new DefaultRDFSDatatype(this.owlModel, frameID);
        this.addFrame(frameID, (Frame)defaultRDFSDatatype);
        this.rdfDatatypes.add(defaultRDFSDatatype);
        return defaultRDFSDatatype;
    }

    private void createOWLMetaModel() {
        this.createOWLClses();
        this.createOWLSlots();
        this.createOWLInstances();
        this.removeUnusedProtegeFrames();
    }

    private void createOWLClses() {
        this.owlThingClass = this.createOWLNamedClass(OWLNames.Cls.THING);
        this.owlClassMetaCls = this.createRDFSNamedClass(OWLNames.Cls.OWL_CLASS);
        this.rdfsNamedClassClass = this.createOWLNamedClass("http://www.w3.org/2000/01/rdf-schema#Class");
        this.owlNamedClassClass = this.createOWLNamedClass(OWLNames.Cls.NAMED_CLASS);
        this.owlDeprecatedClassClass = this.createRDFSNamedClass(OWLNames.Cls.DEPRECATED_CLASS);
        this.anonymousClassMetaCls = this.createOWLNamedClass(OWLNames.Cls.ANONYMOUS_CLASS);
        this.owlEnumeratedClassClass = this.createRDFSNamedClass(OWLNames.Cls.ENUMERATED_CLASS);
        this.owlRestrictionClass = this.createRDFSNamedClass(OWLNames.Cls.RESTRICTION);
        this.owlAllValuesFromClass = this.createRDFSNamedClass(OWLNames.Cls.ALL_VALUES_FROM_RESTRICTION);
        this.owlHasValueClass = this.createRDFSNamedClass(OWLNames.Cls.HAS_VALUE_RESTRICTION);
        this.owlMaxCardinalityClass = this.createRDFSNamedClass(OWLNames.Cls.MAX_CARDINALITY_RESTRICTION);
        this.owlMinCardinalityClass = this.createRDFSNamedClass(OWLNames.Cls.MIN_CARDINALITY_RESTRICTION);
        this.owlCardinalityClass = this.createRDFSNamedClass(OWLNames.Cls.CARDINALITY_RESTRICTION);
        this.owlSomeValuesFromClass = this.createRDFSNamedClass(OWLNames.Cls.SOME_VALUES_FROM_RESTRICTION);
        this.owlLogicalClassClass = this.createRDFSNamedClass(OWLNames.Cls.LOGICAL_CLASS);
        this.owlComplementClassClass = this.createRDFSNamedClass(OWLNames.Cls.COMPLEMENT_CLASS);
        this.owlIntersectionClassClass = this.createRDFSNamedClass(OWLNames.Cls.INTERSECTION_CLASS);
        this.owlUnionClassClass = this.createRDFSNamedClass(OWLNames.Cls.UNION_CLASS);
        this.rdfPropertyClass = this.createOWLNamedClass(RDFNames.Cls.PROPERTY);
        this.owlDatatypePropertyClass = this.createOWLNamedClass(OWLNames.Cls.DATATYPE_PROPERTY);
        this.owlObjectPropertyClass = this.createOWLNamedClass(OWLNames.Cls.OBJECT_PROPERTY);
        this.owlInverseFunctionalPropertyClass = this.createOWLNamedClass(OWLNames.Cls.INVERSE_FUNCTIONAL_PROPERTY);
        this.owlSymmetricPropertyClass = this.createOWLNamedClass(OWLNames.Cls.SYMMETRIC_PROPERTY);
        this.owlTransitivePropertyClass = this.createOWLNamedClass(OWLNames.Cls.TRANSITIVE_PROPERTY);
        this.owlAnnotationPropertyClass = this.createOWLNamedClass(OWLNames.Cls.ANNOTATION_PROPERTY);
        this.owlFunctionalPropertyClass = this.createOWLNamedClass(OWLNames.Cls.FUNCTIONAL_PROPERTY);
        this.owlDeprecatedPropertyClass = this.createRDFSNamedClass(OWLNames.Cls.DEPRECATED_PROPERTY);
        this.rdfsDatatypeClass = this.createRDFSNamedClass("http://www.w3.org/2000/01/rdf-schema#Datatype");
        this.owlOntologyClass = this.createOWLNamedClass(OWLNames.Cls.ONTOLOGY);
        this.owlNothingClass = this.createOWLNamedClass(OWLNames.Cls.NOTHING);
        this.rdfListClass = this.createRDFSNamedClass(RDFNames.Cls.LIST);
        this.owlAllDifferentClass = this.createRDFSNamedClass(OWLNames.Cls.ALL_DIFFERENT);
        this.rdfsContainerClass = this.createRDFSNamedClass("http://www.w3.org/2000/01/rdf-schema#Container");
        this.rdfAltClass = this.createRDFSNamedClass(RDFNames.Cls.ALT);
        this.rdfBagClass = this.createRDFSNamedClass(RDFNames.Cls.BAG);
        this.rdfSeqClass = this.createRDFSNamedClass(RDFNames.Cls.SEQ);
        this.rdfStatementClass = this.createRDFSNamedClass(RDFNames.Cls.STATEMENT);
        this.owlDataRangeClass = this.createRDFSNamedClass(OWLNames.Cls.DATA_RANGE);
        this.anonymousRootCls = this.createRDFSNamedClass(OWLNames.Cls.ANONYMOUS_ROOT);
        this.rdfExternalResourceClass = this.createRDFSNamedClass(RDFNames.Cls.EXTERNAL_RESOURCE);
        this.rdfExternalClassClass = this.createRDFSNamedClass(RDFNames.Cls.EXTERNAL_CLASS);
        this.rdfExternalPropertyClass = this.createRDFSNamedClass(RDFNames.Cls.EXTERNAL_PROPERTY);
        this.owlOntologyPointerClass = this.createRDFSNamedClass(OWLNames.Cls.OWL_ONTOLOGY_POINTER_CLASS);
        this.directedBinaryRelation = this.createOWLNamedClass(ProtegeNames.Cls.DIRECTED_BINARY_RELATION);
        this.palConstraintCls = this.createOWLNamedClass(ProtegeNames.Cls.PAL_CONSTRAINT);
    }

    private void createOWLSlots() {
        this.owlAllValuesFromProperty = this.createRDFProperty(OWLNames.Slot.ALL_VALUES_FROM);
        this.owlBackwardCompatibleWithProperty = this.createRDFProperty(OWLNames.Slot.BACKWARD_COMPATIBLE_WITH);
        this.owlCardinalityProperty = this.createRDFProperty(OWLNames.Slot.CARDINALITY);
        this.owlComplementOfProperty = this.createRDFProperty(OWLNames.Slot.COMPLEMENT_OF);
        this.owlDifferentFromProperty = this.createRDFProperty(OWLNames.Slot.DIFFERENT_FROM);
        this.owlDisjointWithProperty = this.createRDFProperty(OWLNames.Slot.DISJOINT_WITH);
        this.owlDistinctMembersProperty = this.createRDFProperty(OWLNames.Slot.DISTINCT_MEMBERS);
        this.owlEquivalentClassProperty = this.createRDFProperty(OWLNames.Slot.EQUIVALENT_CLASS);
        this.owlEquivalentPropertyProperty = this.createRDFProperty(OWLNames.Slot.EQUIVALENT_PROPERTY);
        this.owlHasValueProperty = this.createRDFProperty(OWLNames.Slot.HAS_VALUE);
        this.owlImportsProperty = this.createRDFProperty(OWLNames.Slot.IMPORTS);
        this.owlIncompatibleWithProperty = this.createRDFProperty(OWLNames.Slot.INCOMPATIBLE_WITH);
        this.owlIntersectionOfProperty = this.createRDFProperty(OWLNames.Slot.INTERSECTION_OF);
        this.owlInverseOfProperty = this.createRDFProperty(OWLNames.Slot.INVERSE_OF);
        this.owlMaxCardinalityProperty = this.createRDFProperty(OWLNames.Slot.MAX_CARDINALITY);
        this.owlMinCardinalityProperty = this.createRDFProperty(OWLNames.Slot.MIN_CARDINALITY);
        this.owlOneOfProperty = this.createRDFProperty(OWLNames.Slot.ONE_OF);
        this.owlOnPropertyProperty = this.createRDFProperty(OWLNames.Slot.ON_PROPERTY);
        this.owlPriorVersionProperty = this.createRDFProperty(OWLNames.Slot.PRIOR_VERSION);
        this.owlSameAsProperty = this.createRDFProperty(OWLNames.Slot.SAME_AS);
        this.owlSomeValuesFromProperty = this.createRDFProperty(OWLNames.Slot.SOME_VALUES_FROM);
        this.owlUnionOfProperty = this.createRDFProperty(OWLNames.Slot.UNION_OF);
        this.owlValuesFromProperty = this.createRDFProperty(OWLNames.Slot.VALUES_FROM);
        this.owlVersionInfoProperty = this.createOWLDatatypeProperty(OWLNames.Slot.VERSION_INFO);
        this.protegeClassificationStatusProperty = this.createRDFProperty(ProtegeNames.Slot.CLASSIFICATION_STATUS);
        this.protegeInferredSubclassesProperty = this.createRDFProperty(ProtegeNames.Slot.INFERRED_SUBCLASSES);
        this.protegeInferredSuperclassesProperty = this.createRDFProperty(ProtegeNames.Slot.INFERRED_SUPERCLASSES);
        this.protegeInferredTypeProperty = this.createRDFProperty(ProtegeNames.Slot.INFERRED_TYPE);
        this.rdfFirstProperty = this.createRDFProperty(RDFNames.Slot.FIRST);
        this.rdfObjectProperty = this.createRDFProperty(RDFNames.Slot.OBJECT);
        this.rdfPredicateProperty = this.createRDFProperty(RDFNames.Slot.PREDICATE);
        this.rdfRestProperty = this.createRDFProperty(RDFNames.Slot.REST);
        this.rdfSubjectProperty = this.createRDFProperty(RDFNames.Slot.SUBJECT);
        this.rdfTypeProperty = this.createRDFProperty(RDFNames.Slot.TYPE);
        this.rdfValueProperty = this.createRDFProperty(RDFNames.Slot.VALUE);
        this.rdfsCommentProperty = this.createOWLDatatypeProperty("http://www.w3.org/2000/01/rdf-schema#comment");
        this.rdfsDomainProperty = this.createRDFProperty("http://www.w3.org/2000/01/rdf-schema#domain");
        this.rdfsIsDefinedByProperty = this.createRDFProperty("http://www.w3.org/2000/01/rdf-schema#isDefinedBy");
        this.rdfsLabelProperty = this.createRDFProperty("http://www.w3.org/2000/01/rdf-schema#label");
        this.rdfsMemberProperty = this.createRDFProperty("http://www.w3.org/2000/01/rdf-schema#member");
        this.rdfsRangeProperty = this.createRDFProperty("http://www.w3.org/2000/01/rdf-schema#range");
        this.rdfsSeeAlsoProperty = this.createRDFProperty("http://www.w3.org/2000/01/rdf-schema#seeAlso");
        this.rdfsSubClassOfProperty = this.createRDFProperty("http://www.w3.org/2000/01/rdf-schema#subClassOf");
        this.rdfsSubPropertyOf = this.createRDFProperty("http://www.w3.org/2000/01/rdf-schema#subPropertyOf");
        this.owlOntologyPrefixesProperty = this.createRDFProperty(OWLNames.Slot.ONTOLOGY_PREFIXES);
        this.owlResourceURIProperty = this.createRDFProperty(OWLNames.Slot.RESOURCE_URI);
        this.owlOntologyPointerProperty = this.createRDFProperty(OWLNames.Slot.OWL_ONTOLOGY_POINTER_PROPERTY);
        this.fromSlot = this.createOWLObjectProperty(ProtegeNames.Slot.FROM);
        this.toSlot = this.createOWLObjectProperty(ProtegeNames.Slot.TO);
        this.slotConstraints = this.createOWLObjectProperty(ProtegeNames.Slot.CONSTRAINTS);
        this.palStatementSlot = this.createOWLDatatypeProperty(ProtegeNames.Slot.PAL_STATEMENT);
        this.palDescriptionSlot = this.createOWLDatatypeProperty(ProtegeNames.Slot.PAL_DESCRIPTION);
        this.palNameSlot = this.createOWLDatatypeProperty(ProtegeNames.Slot.PAL_NAME);
        this.palRangeSlot = this.createOWLDatatypeProperty(ProtegeNames.Slot.PAL_RANGE);
    }

    private void createOWLInstances() {
        FrameID frameID = new FrameID(RDFNames.Instance.NIL);
        this.rdfNil = new DefaultRDFList(this.owlModel, frameID);
        this.addFrame(frameID, (Frame)this.rdfNil);
        this.createRDFSDatatypes();
    }

    private void createRDFSDatatypes() {
        this.createRDFSDatatype("http://www.w3.org/2000/01/rdf-schema#Literal");
        this.createRDFSDatatype(RDFNames.XML_LITERAL);
        TypeMapper typeMapper = TypeMapper.getInstance();
        Iterator iterator = typeMapper.listTypes();
        while (iterator.hasNext()) {
            RDFDatatype rDFDatatype = (RDFDatatype)iterator.next();
            String string = rDFDatatype.getURI();
            if (!string.startsWith("http://www.w3.org/2001/XMLSchema")) continue;
            String string2 = string.toString();
            this.createRDFSDatatype(string2);
        }
        this.fillDatatypeSet(XMLSchemaDatatypes.floatTypes, this.floatDatatypes);
        this.fillDatatypeSet(XMLSchemaDatatypes.integerTypes, this.integerDatatypes);
    }

    private void fillDatatypeSet(XSDDatatype[] xSDDatatypeArray, Set<RDFSDatatype> set) {
        for (int i = 0; i < xSDDatatypeArray.length; ++i) {
            XSDDatatype xSDDatatype = xSDDatatypeArray[i];
            String string = xSDDatatype.getURI();
            set.add((RDFSDatatype)this.getFrame(new FrameID(string)));
        }
    }

    private void removeUnusedProtegeFrames() {
        this.removeFrame(super.getRootCls().getFrameID());
        this.removeFrame(super.getDirectSuperslotsSlot().getFrameID());
        this.removeFrame(super.getInverseSlotSlot().getFrameID());
    }

    public OWLNamedClass getRootCls() {
        return this.owlThingClass;
    }

    public RDFProperty getDirectSuperslotsSlot() {
        return this.rdfsSubPropertyOf;
    }

    public RDFProperty getInverseSlotSlot() {
        return this.owlInverseOfProperty;
    }

    public OWLNamedClass getDirectedBinaryRelationCls() {
        return this.directedBinaryRelation;
    }

    public OWLNamedClass getPalConstraintCls() {
        return this.palConstraintCls;
    }

    public OWLObjectProperty getFromSlot() {
        return this.fromSlot;
    }

    public OWLObjectProperty getToSlot() {
        return this.toSlot;
    }

    public OWLObjectProperty getConstraintsSlot() {
        return this.slotConstraints;
    }

    public OWLObjectProperty getSlotConstraintsSlot() {
        return this.slotConstraints;
    }

    public OWLDatatypeProperty getPalStatementSlot() {
        return this.palStatementSlot;
    }

    public OWLDatatypeProperty getPalDescriptionSlot() {
        return this.palDescriptionSlot;
    }

    public OWLDatatypeProperty getPalNameSlot() {
        return this.palNameSlot;
    }

    public OWLDatatypeProperty getPalRangeSlot() {
        return this.palRangeSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemFrames(FrameStore frameStore) {
        long l = System.currentTimeMillis();
        FrameFactory frameFactory = this.owlModel.getFrameFactory();
        try {
            this.owlModel.setFrameFactory(new NonSwizzlingFactory());
            super.addSystemFrames(frameStore);
            OWLSystemFramesAssertions oWLSystemFramesAssertions = new OWLSystemFramesAssertions(frameStore);
            oWLSystemFramesAssertions.addClassHierarchy();
            oWLSystemFramesAssertions.addInstances();
            oWLSystemFramesAssertions.addClassAssertions();
            oWLSystemFramesAssertions.addSlotAssertions();
        }
        finally {
            this.owlModel.setFrameFactory(frameFactory);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading OWL System Frames took " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    public RDFSDatatype getXsdBoolean() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.BOOLEAN));
    }

    public RDFSDatatype getXsdDouble() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.DOUBLE));
    }

    public RDFSDatatype getXsdFloat() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.FLOAT));
    }

    public RDFSDatatype getXsdLong() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.LONG));
    }

    public RDFSDatatype getXsdInt() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.INT));
    }

    public RDFSDatatype getXsdShort() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.SHORT));
    }

    public RDFSDatatype getXsdByte() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.BYTE));
    }

    public RDFSDatatype getXsdString() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.STRING));
    }

    public RDFSDatatype getXsdBase64Binary() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.BASE_64_BINARY));
    }

    public RDFSDatatype getXsdDate() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.DATE));
    }

    public RDFSDatatype getXsdTime() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.TIME));
    }

    public RDFSDatatype getXsdDateTime() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.DATE_TIME));
    }

    public RDFSDatatype getXsdDuration() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.DURATION));
    }

    public RDFSDatatype getXsdAnyURI() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.ANY_URI));
    }

    public RDFSDatatype getXsdDecimal() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.DECIMAL));
    }

    public RDFSDatatype getXsdInteger() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.INTEGER));
    }

    public RDFSDatatype getXsdNonNegativeInteger() {
        return (RDFSDatatype)this.getFrame(new FrameID(XSDNames.NON_NEGATIVE_INTEGER));
    }

    public RDFSDatatype getXmlLiteralType() {
        return (RDFSDatatype)this.getFrame(new FrameID(RDFNames.XML_LITERAL));
    }

    public OWLNamedClass getOwlThingClass() {
        return this.owlThingClass;
    }

    public RDFSNamedClass getOwlClassMetaCls() {
        return this.owlClassMetaCls;
    }

    public OWLNamedClass getRdfsNamedClassClass() {
        return this.rdfsNamedClassClass;
    }

    public OWLNamedClass getOwlNamedClassClass() {
        return this.owlNamedClassClass;
    }

    public RDFSNamedClass getOwlDeprecatedClassClass() {
        return this.owlDeprecatedClassClass;
    }

    public OWLNamedClass getAnonymousClassMetaCls() {
        return this.anonymousClassMetaCls;
    }

    public RDFSNamedClass getOwlEnumeratedClassClass() {
        return this.owlEnumeratedClassClass;
    }

    public RDFSNamedClass getOwlRestrictionClass() {
        return this.owlRestrictionClass;
    }

    public RDFSNamedClass getOwlAllValuesFromClass() {
        return this.owlAllValuesFromClass;
    }

    public RDFSNamedClass getOwlHasValueClass() {
        return this.owlHasValueClass;
    }

    public RDFSNamedClass getOwlMaxCardinalityClass() {
        return this.owlMaxCardinalityClass;
    }

    public RDFSNamedClass getOwlMinCardinalityClass() {
        return this.owlMinCardinalityClass;
    }

    public RDFSNamedClass getOwlCardinalityClass() {
        return this.owlCardinalityClass;
    }

    public RDFSNamedClass getOwlSomeValuesFromClass() {
        return this.owlSomeValuesFromClass;
    }

    public RDFSNamedClass getOwlLogicalClassClass() {
        return this.owlLogicalClassClass;
    }

    public RDFSNamedClass getOwlComplementClassClass() {
        return this.owlComplementClassClass;
    }

    public RDFSNamedClass getOwlIntersectionClassClass() {
        return this.owlIntersectionClassClass;
    }

    public RDFSNamedClass getOwlUnionClassClass() {
        return this.owlUnionClassClass;
    }

    public OWLNamedClass getRdfPropertyClass() {
        return this.rdfPropertyClass;
    }

    public OWLNamedClass getOwlDatatypePropertyClass() {
        return this.owlDatatypePropertyClass;
    }

    public OWLNamedClass getOwlObjectPropertyClass() {
        return this.owlObjectPropertyClass;
    }

    public OWLNamedClass getOwlInverseFunctionalPropertyClass() {
        return this.owlInverseFunctionalPropertyClass;
    }

    public OWLNamedClass getOwlSymmetricPropertyClass() {
        return this.owlSymmetricPropertyClass;
    }

    public OWLNamedClass getOwlTransitivePropertyClass() {
        return this.owlTransitivePropertyClass;
    }

    public OWLNamedClass getOwlAnnotationPropertyClass() {
        return this.owlAnnotationPropertyClass;
    }

    public OWLNamedClass getOwlFunctionalPropertyClass() {
        return this.owlFunctionalPropertyClass;
    }

    public RDFSNamedClass getOwlDeprecatedPropertyClass() {
        return this.owlDeprecatedPropertyClass;
    }

    public RDFSNamedClass getRdfsDatatypeClass() {
        return this.rdfsDatatypeClass;
    }

    public OWLNamedClass getOwlOntologyClass() {
        return this.owlOntologyClass;
    }

    public OWLNamedClass getOwlNothingClass() {
        return this.owlNothingClass;
    }

    public RDFSNamedClass getRdfListClass() {
        return this.rdfListClass;
    }

    public RDFSNamedClass getOwlAllDifferentClass() {
        return this.owlAllDifferentClass;
    }

    public RDFSNamedClass getRdfsLiteralClass() {
        return new DefaultRDFSNamedClass(this.owlModel, new FrameID("http://www.w3.org/2000/01/rdf-schema#Literal"));
    }

    public RDFSNamedClass getRdfsContainerClass() {
        return this.rdfsContainerClass;
    }

    public RDFSNamedClass getRdfAltClass() {
        return this.rdfAltClass;
    }

    public RDFSNamedClass getRdfBagClass() {
        return this.rdfBagClass;
    }

    public RDFSNamedClass getRdfSeqClass() {
        return this.rdfSeqClass;
    }

    public RDFSNamedClass getRdfStatementClass() {
        return this.rdfStatementClass;
    }

    public RDFSNamedClass getOwlDataRangeClass() {
        return this.owlDataRangeClass;
    }

    public RDFSNamedClass getAnonymousRootCls() {
        return this.anonymousRootCls;
    }

    public RDFSNamedClass getRdfExternalResourceClass() {
        return this.rdfExternalResourceClass;
    }

    public RDFSNamedClass getRdfExternalClassClass() {
        return this.rdfExternalClassClass;
    }

    public RDFSNamedClass getRdfExternalPropertyClass() {
        return this.rdfExternalPropertyClass;
    }

    public RDFSNamedClass getOwlOntologyPointerClass() {
        return this.owlOntologyPointerClass;
    }

    public RDFProperty getOwlAllValuesFromProperty() {
        return this.owlAllValuesFromProperty;
    }

    public RDFProperty getOwlBackwardCompatibleWithProperty() {
        return this.owlBackwardCompatibleWithProperty;
    }

    public RDFProperty getOwlCardinalityProperty() {
        return this.owlCardinalityProperty;
    }

    public RDFProperty getOwlComplementOfProperty() {
        return this.owlComplementOfProperty;
    }

    public RDFProperty getOwlDifferentFromProperty() {
        return this.owlDifferentFromProperty;
    }

    public RDFProperty getOwlDisjointWithProperty() {
        return this.owlDisjointWithProperty;
    }

    public RDFProperty getOwlDistinctMembersProperty() {
        return this.owlDistinctMembersProperty;
    }

    public RDFProperty getOwlEquivalentClassProperty() {
        return this.owlEquivalentClassProperty;
    }

    public RDFProperty getOwlEquivalentPropertyProperty() {
        return this.owlEquivalentPropertyProperty;
    }

    public RDFProperty getOwlHasValueProperty() {
        return this.owlHasValueProperty;
    }

    public RDFProperty getOwlImportsProperty() {
        return this.owlImportsProperty;
    }

    public RDFProperty getOwlIncompatibleWithProperty() {
        return this.owlIncompatibleWithProperty;
    }

    public RDFProperty getOwlIntersectionOfProperty() {
        return this.owlIntersectionOfProperty;
    }

    public RDFProperty getOwlInverseOfProperty() {
        return this.owlInverseOfProperty;
    }

    public RDFProperty getOwlMaxCardinalityProperty() {
        return this.owlMaxCardinalityProperty;
    }

    public RDFProperty getOwlMinCardinalityProperty() {
        return this.owlMinCardinalityProperty;
    }

    public RDFProperty getOwlOneOfProperty() {
        return this.owlOneOfProperty;
    }

    public RDFProperty getOwlOnPropertyProperty() {
        return this.owlOnPropertyProperty;
    }

    public RDFProperty getOwlPriorVersionProperty() {
        return this.owlPriorVersionProperty;
    }

    public RDFProperty getOwlSameAsProperty() {
        return this.owlSameAsProperty;
    }

    public RDFProperty getOwlSomeValuesFromProperty() {
        return this.owlSomeValuesFromProperty;
    }

    public RDFProperty getOwlUnionOfProperty() {
        return this.owlUnionOfProperty;
    }

    public RDFProperty getOwlValuesFromProperty() {
        return this.owlValuesFromProperty;
    }

    public RDFProperty getOwlVersionInfoProperty() {
        return this.owlVersionInfoProperty;
    }

    public RDFProperty getProtegeClassificationStatusProperty() {
        return this.protegeClassificationStatusProperty;
    }

    public RDFProperty getProtegeInferredSubclassesProperty() {
        return this.protegeInferredSubclassesProperty;
    }

    public RDFProperty getProtegeInferredSuperclassesProperty() {
        return this.protegeInferredSuperclassesProperty;
    }

    public RDFProperty getProtegeInferredTypeProperty() {
        return this.protegeInferredTypeProperty;
    }

    public RDFProperty getRdfFirstProperty() {
        return this.rdfFirstProperty;
    }

    public RDFProperty getRdfObjectProperty() {
        return this.rdfObjectProperty;
    }

    public RDFProperty getRdfPredicateProperty() {
        return this.rdfPredicateProperty;
    }

    public RDFProperty getRdfRestProperty() {
        return this.rdfRestProperty;
    }

    public RDFProperty getRdfSubjectProperty() {
        return this.rdfSubjectProperty;
    }

    public RDFProperty getRdfTypeProperty() {
        return this.rdfTypeProperty;
    }

    public RDFProperty getRdfValueProperty() {
        return this.rdfValueProperty;
    }

    public OWLDatatypeProperty getRdfsCommentProperty() {
        return this.rdfsCommentProperty;
    }

    public RDFProperty getRdfsDomainProperty() {
        return this.rdfsDomainProperty;
    }

    public RDFProperty getRdfsIsDefinedByProperty() {
        return this.rdfsIsDefinedByProperty;
    }

    public RDFProperty getRdfsLabelProperty() {
        return this.rdfsLabelProperty;
    }

    public RDFProperty getRdfsMemberProperty() {
        return this.rdfsMemberProperty;
    }

    public RDFProperty getRdfsRangeProperty() {
        return this.rdfsRangeProperty;
    }

    public RDFProperty getRdfsSeeAlsoProperty() {
        return this.rdfsSeeAlsoProperty;
    }

    public RDFProperty getRdfsSubClassOfProperty() {
        return this.rdfsSubClassOfProperty;
    }

    public RDFProperty getRdfsSubPropertyOf() {
        return this.rdfsSubPropertyOf;
    }

    public RDFProperty getOwlOntologyPrefixesProperty() {
        return this.owlOntologyPrefixesProperty;
    }

    public RDFProperty getOwlResourceURIProperty() {
        return this.owlResourceURIProperty;
    }

    public RDFProperty getOwlOntologyPointerProperty() {
        return this.owlOntologyPointerProperty;
    }

    public RDFList getRdfNil() {
        return this.rdfNil;
    }

    public Set<RDFSDatatype> getRdfDatatypes() {
        return this.rdfDatatypes;
    }

    public Set<RDFSDatatype> getFloatDatatypes() {
        return this.floatDatatypes;
    }

    public Set<RDFSDatatype> getIntegerDatatypes() {
        return this.integerDatatypes;
    }

    private class NonSwizzlingFactory
    implements FrameFactory {
        private NonSwizzlingFactory() {
        }

        public void addJavaPackage(String string) {
        }

        public Cls createCls(FrameID frameID, Collection collection) {
            return (Cls)OWLSystemFrames.this.getFrame(frameID);
        }

        public Facet createFacet(FrameID frameID, Collection collection) {
            return (Facet)OWLSystemFrames.this.getFrame(frameID);
        }

        public Frame createFrameFromClassId(int n, FrameID frameID) {
            return OWLSystemFrames.this.getFrame(frameID);
        }

        public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection) {
            return (SimpleInstance)OWLSystemFrames.this.getFrame(frameID);
        }

        public Slot createSlot(FrameID frameID, Collection collection) {
            return (Slot)OWLSystemFrames.this.getFrame(frameID);
        }

        public Collection getClsJavaClassIds() {
            throw new UnsupportedOperationException();
        }

        public Collection getFacetJavaClassIds() {
            throw new UnsupportedOperationException();
        }

        public int getJavaClassId(Frame frame) {
            throw new UnsupportedOperationException();
        }

        public Collection getSimpleInstanceJavaClassIds() {
            throw new UnsupportedOperationException();
        }

        public Collection getSlotJavaClassIds() {
            throw new UnsupportedOperationException();
        }

        public boolean isCorrectJavaImplementationClass(FrameID frameID, Collection collection, Class clazz) {
            return true;
        }

        public void removeJavaPackage(String string) {
            throw new UnsupportedOperationException();
        }

        public Frame rename(Frame frame, String string) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SystemFramesAsserter {
        protected FrameStore fs;
        protected Collection<Cls> annotationObjectPropertyTypes = new HashSet<Cls>();
        protected Collection<Cls> annotationDatatypePropertyTypes = new HashSet<Cls>();
        protected Collection<Cls> functionalDatatypePropertyTypes = new HashSet<Cls>();

        public SystemFramesAsserter(FrameStore frameStore) {
            this.fs = frameStore;
            this.annotationObjectPropertyTypes.add(OWLSystemFrames.this.owlAnnotationPropertyClass);
            this.annotationObjectPropertyTypes.add(OWLSystemFrames.this.owlObjectPropertyClass);
            this.annotationDatatypePropertyTypes.add(OWLSystemFrames.this.owlAnnotationPropertyClass);
            this.annotationDatatypePropertyTypes.add(OWLSystemFrames.this.owlDatatypePropertyClass);
            this.functionalDatatypePropertyTypes.add(OWLSystemFrames.this.owlDatatypePropertyClass);
            this.functionalDatatypePropertyTypes.add(OWLSystemFrames.this.owlFunctionalPropertyClass);
        }

        protected Cls assertTypeAndSubclasses(Cls cls, Cls cls2, Cls[] clsArray) {
            this.assertTypeAndName((Instance)cls, cls2);
            for (Cls cls3 : clsArray) {
                this.fs.addDirectSuperclass(cls3, cls);
            }
            return cls;
        }

        protected void assertFunctional(Slot slot) {
            this.fs.setDirectOwnSlotValues((Frame)slot, OWLSystemFrames.this.getMaximumCardinalitySlot(), MaximumCardinalityConstraint.getValues((boolean)false));
        }

        protected void assertTypeAndName(Instance instance, Cls cls) {
            this.assertTypeAndName((Frame)instance, Collections.singleton(cls));
        }

        protected void assertValueType(Slot slot, ValueType valueType) {
            this.fs.setDirectOwnSlotValues((Frame)slot, OWLSystemFrames.this.getValueTypeSlot(), ValueTypeConstraint.getValues((ValueType)valueType));
        }

        protected void assertTypeAndName(Frame frame, Collection<Cls> collection) {
            OWLSystemFrames.this.assertTypeAndName(this.fs, frame, collection);
            this.fs.setDirectOwnSlotValues(frame, (Slot)OWLSystemFrames.this.getRdfTypeProperty(), collection);
        }

        protected void assertDomain(Slot slot) {
            this.assertDomains(slot, new Cls[0]);
        }

        protected void assertDomain(Slot slot, Cls cls) {
            this.assertDomains(slot, new Cls[]{cls});
        }

        protected void assertDomains(Slot slot, Cls[] clsArray) {
            if (clsArray.length == 0) {
                this.fs.addDirectTemplateSlot((Cls)OWLSystemFrames.this.getOwlThingClass(), slot);
                return;
            }
            for (Cls cls : clsArray) {
                this.fs.addDirectTemplateSlot(cls, slot);
            }
            if (clsArray.length == 1) {
                this.fs.setDirectOwnSlotValues((Frame)slot, (Slot)OWLSystemFrames.this.getRdfsDomainProperty(), Collections.singleton(clsArray[0]));
            }
        }

        protected void assertRange(Slot slot, Cls cls) {
            this.fs.setDirectOwnSlotValues((Frame)slot, (Slot)OWLSystemFrames.this.getRdfsRangeProperty(), Collections.singleton(cls));
            this.fs.setDirectOwnSlotValues((Frame)slot, OWLSystemFrames.this.getValueTypeSlot(), (Collection)ValueTypeConstraint.getValues((ValueType)ValueType.INSTANCE, Collections.singleton(cls)));
        }
    }

    protected class OWLSystemFramesAssertions
    extends SystemFramesAsserter {
        private RDFSDatatype xsdInt;
        private RDFSDatatype xsdNonNegativeInteger;
        private RDFSDatatype xsdString;

        public OWLSystemFramesAssertions(FrameStore frameStore) {
            super(frameStore);
            this.xsdInt = (RDFSDatatype)OWLSystemFrames.this.getFrame(new FrameID(XSDNames.INT));
            this.xsdNonNegativeInteger = (RDFSDatatype)OWLSystemFrames.this.getFrame(new FrameID(XSDNames.NON_NEGATIVE_INTEGER));
            this.xsdString = (RDFSDatatype)OWLSystemFrames.this.getFrame(new FrameID(XSDNames.STRING));
        }

        public void addClassHierarchy() {
            this.fs.addDirectSuperclass((Cls)OWLSystemFrames.this.owlClassMetaCls, OWLSystemFrames.this.getStandardClsMetaCls());
            this.assertTypeAndSubclasses(OWLSystemFrames.this.owlClassMetaCls, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[]{this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfsNamedClassClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[]{this.assertTypeAndSubclasses(OWLSystemFrames.this.owlNamedClassClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlDeprecatedClassClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfExternalClassClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0])}), this.assertTypeAndSubclasses(OWLSystemFrames.this.anonymousClassMetaCls, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[]{this.assertTypeAndSubclasses(OWLSystemFrames.this.owlEnumeratedClassClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlRestrictionClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[]{this.assertTypeAndSubclasses(OWLSystemFrames.this.owlAllValuesFromClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlHasValueClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlMaxCardinalityClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlMinCardinalityClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlCardinalityClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlSomeValuesFromClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0])}), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlLogicalClassClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[]{this.assertTypeAndSubclasses(OWLSystemFrames.this.owlComplementClassClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlIntersectionClassClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlUnionClassClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0])})})});
            this.fs.addDirectSuperclass((Cls)OWLSystemFrames.this.rdfPropertyClass, OWLSystemFrames.this.getStandardSlotMetaCls());
            this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfPropertyClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[]{this.assertTypeAndSubclasses(OWLSystemFrames.this.owlDatatypePropertyClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlObjectPropertyClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[]{this.assertTypeAndSubclasses(OWLSystemFrames.this.owlInverseFunctionalPropertyClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlSymmetricPropertyClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlTransitivePropertyClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[0])}), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlAnnotationPropertyClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlFunctionalPropertyClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlDeprecatedPropertyClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfExternalPropertyClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0])});
            this.assertTypeAndSubclasses(OWLSystemFrames.this.owlThingClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[]{OWLSystemFrames.this.rdfsNamedClassClass, OWLSystemFrames.this.rdfPropertyClass, OWLSystemFrames.this.directedBinaryRelation, OWLSystemFrames.this.palConstraintCls, this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfsDatatypeClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlOntologyClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlNothingClass, OWLSystemFrames.this.owlNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfListClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlAllDifferentClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfsContainerClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[]{this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfAltClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfBagClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfSeqClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0])}), this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfStatementClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlDataRangeClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.anonymousRootCls, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.rdfExternalResourceClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), this.assertTypeAndSubclasses(OWLSystemFrames.this.owlOntologyPointerClass, OWLSystemFrames.this.rdfsNamedClassClass, new Cls[0]), OWLSystemFrames.this.getDirectedBinaryRelationCls()});
        }

        private void addClassAssertions() {
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.owlClassMetaCls, OWLSystemFrames.this.getRoleSlot(), Collections.singleton("Concrete"));
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.owlClassMetaCls, OWLSystemFrames.this.getRoleSlot(), Collections.singleton("Abstract"));
            this.fs.setDirectTemplateFacetValues((Cls)OWLSystemFrames.this.owlDatatypePropertyClass, (Slot)OWLSystemFrames.this.owlEquivalentPropertyProperty, OWLSystemFrames.this.getValueTypeFacet(), Collections.singleton(OWLSystemFrames.this.owlDatatypePropertyClass));
            this.fs.setDirectTemplateFacetValues((Cls)OWLSystemFrames.this.owlObjectPropertyClass, (Slot)OWLSystemFrames.this.owlEquivalentPropertyProperty, OWLSystemFrames.this.getValueTypeFacet(), (Collection)ValueTypeConstraint.getValues((ValueType)ValueType.INSTANCE, Collections.singleton(OWLSystemFrames.this.owlObjectPropertyClass)));
            this.assertTypeAndName(OWLSystemFrames.this.getDirectedBinaryRelationCls(), OWLSystemFrames.this.owlNamedClassClass);
            this.assertTypeAndName(OWLSystemFrames.this.getPalConstraintCls(), OWLSystemFrames.this.owlNamedClassClass);
        }

        private void addSlotAssertions() {
            this.assertTypeAndName(OWLSystemFrames.this.owlAllValuesFromProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlAllValuesFromProperty, OWLSystemFrames.this.owlAllValuesFromClass);
            this.assertRange(OWLSystemFrames.this.owlAllValuesFromProperty, OWLSystemFrames.this.rdfsNamedClassClass);
            this.assertTypeAndName((Frame)OWLSystemFrames.this.owlBackwardCompatibleWithProperty, this.annotationObjectPropertyTypes);
            this.assertDomain(OWLSystemFrames.this.owlBackwardCompatibleWithProperty, OWLSystemFrames.this.owlOntologyClass);
            this.assertRange(OWLSystemFrames.this.owlBackwardCompatibleWithProperty, OWLSystemFrames.this.owlOntologyClass);
            this.assertValueType(OWLSystemFrames.this.owlBackwardCompatibleWithProperty, ValueType.INSTANCE);
            this.assertTypeAndName(OWLSystemFrames.this.owlCardinalityProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertFunctional(OWLSystemFrames.this.owlCardinalityProperty);
            this.assertDomain(OWLSystemFrames.this.owlCardinalityProperty, OWLSystemFrames.this.owlCardinalityClass);
            this.assertValueType(OWLSystemFrames.this.owlCardinalityProperty, ValueType.INTEGER);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.owlCardinalityProperty, (Slot)OWLSystemFrames.this.rdfsRangeProperty, Collections.singleton(this.xsdNonNegativeInteger));
            this.assertTypeAndName(OWLSystemFrames.this.owlComplementOfProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlComplementOfProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertRange(OWLSystemFrames.this.owlComplementOfProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertTypeAndName(OWLSystemFrames.this.owlDifferentFromProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlDifferentFromProperty);
            this.assertRange(OWLSystemFrames.this.owlDifferentFromProperty, OWLSystemFrames.this.owlThingClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlDisjointWithProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlDisjointWithProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertRange(OWLSystemFrames.this.owlDisjointWithProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertTypeAndName(OWLSystemFrames.this.owlDistinctMembersProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlDistinctMembersProperty, OWLSystemFrames.this.owlAllDifferentClass);
            this.assertRange(OWLSystemFrames.this.owlDistinctMembersProperty, OWLSystemFrames.this.rdfListClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlEquivalentClassProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlEquivalentClassProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertRange(OWLSystemFrames.this.owlDistinctMembersProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertTypeAndName(OWLSystemFrames.this.owlEquivalentPropertyProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlEquivalentPropertyProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertRange(OWLSystemFrames.this.owlEquivalentPropertyProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlHasValueProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlHasValueProperty, OWLSystemFrames.this.owlHasValueClass);
            this.assertFunctional(OWLSystemFrames.this.owlHasValueProperty);
            this.assertTypeAndName(OWLSystemFrames.this.owlImportsProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlImportsProperty, OWLSystemFrames.this.owlOntologyClass);
            this.assertRange(OWLSystemFrames.this.owlImportsProperty, OWLSystemFrames.this.owlOntologyClass);
            this.assertTypeAndName((Frame)OWLSystemFrames.this.owlIncompatibleWithProperty, this.annotationObjectPropertyTypes);
            this.assertDomain(OWLSystemFrames.this.owlIncompatibleWithProperty, OWLSystemFrames.this.owlOntologyClass);
            this.assertRange(OWLSystemFrames.this.owlIncompatibleWithProperty, OWLSystemFrames.this.owlOntologyClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlIntersectionOfProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlIntersectionOfProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertRange(OWLSystemFrames.this.owlIntersectionOfProperty, OWLSystemFrames.this.rdfListClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlInverseOfProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlInverseOfProperty, OWLSystemFrames.this.owlObjectPropertyClass);
            this.assertRange(OWLSystemFrames.this.owlInverseOfProperty, OWLSystemFrames.this.owlObjectPropertyClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlMaxCardinalityProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlMaxCardinalityProperty, OWLSystemFrames.this.owlMaxCardinalityClass);
            this.assertValueType(OWLSystemFrames.this.owlMaxCardinalityProperty, ValueType.INTEGER);
            this.assertFunctional(OWLSystemFrames.this.owlMaxCardinalityProperty);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.owlMaxCardinalityProperty, (Slot)OWLSystemFrames.this.rdfsRangeProperty, Collections.singleton(this.xsdNonNegativeInteger));
            this.assertTypeAndName(OWLSystemFrames.this.owlMinCardinalityProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlMinCardinalityProperty, OWLSystemFrames.this.owlMinCardinalityClass);
            this.assertValueType(OWLSystemFrames.this.owlMinCardinalityProperty, ValueType.INTEGER);
            this.assertFunctional(OWLSystemFrames.this.owlMinCardinalityProperty);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.owlMinCardinalityProperty, (Slot)OWLSystemFrames.this.rdfsRangeProperty, Collections.singleton(this.xsdNonNegativeInteger));
            this.assertTypeAndName(OWLSystemFrames.this.owlOneOfProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomains(OWLSystemFrames.this.owlOneOfProperty, new Cls[]{OWLSystemFrames.this.owlEnumeratedClassClass, OWLSystemFrames.this.owlDataRangeClass});
            this.assertRange(OWLSystemFrames.this.owlOneOfProperty, OWLSystemFrames.this.rdfListClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlOnPropertyProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlOnPropertyProperty, OWLSystemFrames.this.owlRestrictionClass);
            this.assertRange(OWLSystemFrames.this.owlOnPropertyProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertTypeAndName((Frame)OWLSystemFrames.this.owlPriorVersionProperty, this.annotationObjectPropertyTypes);
            this.assertDomain(OWLSystemFrames.this.owlPriorVersionProperty, OWLSystemFrames.this.owlOntologyClass);
            this.assertRange(OWLSystemFrames.this.owlPriorVersionProperty, OWLSystemFrames.this.owlOntologyClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlSameAsProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlSameAsProperty);
            this.assertRange(OWLSystemFrames.this.owlSameAsProperty, OWLSystemFrames.this.owlThingClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlSomeValuesFromProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlSomeValuesFromProperty, OWLSystemFrames.this.owlSomeValuesFromClass);
            this.assertRange(OWLSystemFrames.this.owlSomeValuesFromProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertTypeAndName(OWLSystemFrames.this.owlUnionOfProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlUnionOfProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertRange(OWLSystemFrames.this.owlUnionOfProperty, OWLSystemFrames.this.rdfListClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlValuesFromProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomains(OWLSystemFrames.this.owlValuesFromProperty, new Cls[]{OWLSystemFrames.this.owlMaxCardinalityClass, OWLSystemFrames.this.owlMinCardinalityClass, OWLSystemFrames.this.owlCardinalityClass});
            this.assertRange(OWLSystemFrames.this.owlValuesFromProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertFunctional(OWLSystemFrames.this.owlValuesFromProperty);
            this.assertTypeAndName((Frame)OWLSystemFrames.this.owlVersionInfoProperty, this.annotationDatatypePropertyTypes);
            this.assertDomain(OWLSystemFrames.this.owlVersionInfoProperty);
            this.assertValueType(OWLSystemFrames.this.owlVersionInfoProperty, ValueType.STRING);
            this.assertTypeAndName(OWLSystemFrames.this.protegeClassificationStatusProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.protegeClassificationStatusProperty, OWLSystemFrames.this.rdfsNamedClassClass);
            this.assertFunctional(OWLSystemFrames.this.protegeClassificationStatusProperty);
            this.assertValueType(OWLSystemFrames.this.owlVersionInfoProperty, ValueType.BOOLEAN);
            this.assertTypeAndName(OWLSystemFrames.this.protegeInferredSubclassesProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.protegeInferredSubclassesProperty, OWLSystemFrames.this.rdfsNamedClassClass);
            this.assertRange(OWLSystemFrames.this.protegeInferredSubclassesProperty, OWLSystemFrames.this.getStandardClsMetaCls());
            this.assertTypeAndName(OWLSystemFrames.this.protegeInferredSuperclassesProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.protegeInferredSuperclassesProperty, OWLSystemFrames.this.rdfsNamedClassClass);
            this.assertRange(OWLSystemFrames.this.protegeInferredSuperclassesProperty, OWLSystemFrames.this.getStandardClsMetaCls());
            this.assertTypeAndName(OWLSystemFrames.this.protegeInferredTypeProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.protegeInferredTypeProperty, OWLSystemFrames.this.rdfsNamedClassClass);
            this.assertRange(OWLSystemFrames.this.protegeInferredTypeProperty, OWLSystemFrames.this.getStandardClsMetaCls());
            this.assertTypeAndName(OWLSystemFrames.this.rdfFirstProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfFirstProperty, OWLSystemFrames.this.rdfListClass);
            this.assertFunctional(OWLSystemFrames.this.rdfFirstProperty);
            this.assertTypeAndName(OWLSystemFrames.this.rdfObjectProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfObjectProperty, OWLSystemFrames.this.rdfStatementClass);
            this.assertValueType(OWLSystemFrames.this.rdfObjectProperty, ValueType.INSTANCE);
            this.assertTypeAndName(OWLSystemFrames.this.rdfPredicateProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfPredicateProperty, OWLSystemFrames.this.rdfStatementClass);
            this.assertValueType(OWLSystemFrames.this.rdfPredicateProperty, ValueType.INSTANCE);
            this.assertTypeAndName(OWLSystemFrames.this.rdfRestProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertFunctional(OWLSystemFrames.this.rdfRestProperty);
            this.assertDomain(OWLSystemFrames.this.rdfRestProperty, OWLSystemFrames.this.rdfListClass);
            this.assertRange(OWLSystemFrames.this.rdfRestProperty, OWLSystemFrames.this.rdfListClass);
            this.assertTypeAndName(OWLSystemFrames.this.rdfSubjectProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfSubjectProperty, OWLSystemFrames.this.rdfStatementClass);
            this.assertValueType(OWLSystemFrames.this.rdfSubjectProperty, ValueType.INSTANCE);
            this.assertTypeAndName(OWLSystemFrames.this.rdfTypeProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfTypeProperty);
            this.assertValueType(OWLSystemFrames.this.rdfTypeProperty, ValueType.CLS);
            this.assertTypeAndName(OWLSystemFrames.this.rdfValueProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfValueProperty);
            this.assertTypeAndName((Frame)OWLSystemFrames.this.rdfsCommentProperty, this.annotationDatatypePropertyTypes);
            this.assertDomain(OWLSystemFrames.this.rdfsCommentProperty);
            this.assertValueType(OWLSystemFrames.this.rdfsCommentProperty, ValueType.STRING);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.rdfsCommentProperty, (Slot)OWLSystemFrames.this.rdfsRangeProperty, Collections.singleton(this.xsdString));
            this.assertTypeAndName(OWLSystemFrames.this.rdfsDomainProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfsDomainProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertRange(OWLSystemFrames.this.rdfsDomainProperty, OWLSystemFrames.this.owlClassMetaCls);
            this.assertValueType(OWLSystemFrames.this.rdfsDomainProperty, ValueType.INSTANCE);
            this.assertTypeAndName((Frame)OWLSystemFrames.this.rdfsIsDefinedByProperty, this.annotationObjectPropertyTypes);
            this.assertDomain(OWLSystemFrames.this.rdfsIsDefinedByProperty);
            this.assertTypeAndName((Frame)OWLSystemFrames.this.rdfsLabelProperty, this.annotationObjectPropertyTypes);
            this.assertDomain(OWLSystemFrames.this.rdfsLabelProperty);
            this.assertValueType(OWLSystemFrames.this.rdfsLabelProperty, ValueType.STRING);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.rdfsLabelProperty, (Slot)OWLSystemFrames.this.rdfsRangeProperty, Collections.singleton(this.xsdString));
            this.assertTypeAndName(OWLSystemFrames.this.rdfsMemberProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfsMemberProperty);
            this.assertValueType(OWLSystemFrames.this.rdfsMemberProperty, ValueType.INSTANCE);
            this.assertTypeAndName(OWLSystemFrames.this.rdfsRangeProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfsRangeProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertRange(OWLSystemFrames.this.rdfsRangeProperty, OWLSystemFrames.this.rdfsNamedClassClass);
            this.assertTypeAndName((Frame)OWLSystemFrames.this.rdfsSeeAlsoProperty, this.annotationObjectPropertyTypes);
            this.assertDomain(OWLSystemFrames.this.rdfsSeeAlsoProperty);
            this.assertTypeAndName(OWLSystemFrames.this.rdfsSubClassOfProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfsSubClassOfProperty, OWLSystemFrames.this.rdfsNamedClassClass);
            this.assertRange(OWLSystemFrames.this.rdfsSubClassOfProperty, OWLSystemFrames.this.rdfsNamedClassClass);
            this.assertTypeAndName(OWLSystemFrames.this.rdfsSubPropertyOf, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.rdfsSubPropertyOf, OWLSystemFrames.this.rdfPropertyClass);
            this.assertRange(OWLSystemFrames.this.rdfsSubPropertyOf, OWLSystemFrames.this.rdfPropertyClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlOntologyPrefixesProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlOntologyPrefixesProperty, OWLSystemFrames.this.owlOntologyClass);
            this.assertValueType(OWLSystemFrames.this.owlOntologyPrefixesProperty, ValueType.STRING);
            this.assertFunctional(OWLSystemFrames.this.owlOntologyPrefixesProperty);
            this.assertTypeAndName(OWLSystemFrames.this.owlOntologyPointerProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlOntologyPointerProperty, OWLSystemFrames.this.owlOntologyPointerClass);
            this.assertFunctional(OWLSystemFrames.this.owlOntologyPointerProperty);
            this.assertRange(OWLSystemFrames.this.owlOntologyPointerProperty, OWLSystemFrames.this.owlOntologyClass);
            this.assertTypeAndName(OWLSystemFrames.this.owlResourceURIProperty, OWLSystemFrames.this.rdfPropertyClass);
            this.assertDomain(OWLSystemFrames.this.owlResourceURIProperty, OWLSystemFrames.this.rdfExternalResourceClass);
            this.assertTypeAndName(OWLSystemFrames.this.getFromSlot(), OWLSystemFrames.this.owlObjectPropertyClass);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.getFromSlot(), (Slot)OWLSystemFrames.this.getRdfsDomainProperty(), Collections.singleton(OWLSystemFrames.this.getDirectedBinaryRelationCls()));
            this.assertTypeAndName(OWLSystemFrames.this.getToSlot(), OWLSystemFrames.this.owlObjectPropertyClass);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.getToSlot(), (Slot)OWLSystemFrames.this.getRdfsDomainProperty(), Collections.singleton(OWLSystemFrames.this.getDirectedBinaryRelationCls()));
            this.assertTypeAndName(OWLSystemFrames.this.getSlotConstraintsSlot(), OWLSystemFrames.this.owlObjectPropertyClass);
            this.assertDomain(OWLSystemFrames.this.getSlotConstraintsSlot(), OWLSystemFrames.this.owlThingClass);
            this.assertTypeAndName(OWLSystemFrames.this.getPalStatementSlot(), OWLSystemFrames.this.owlDatatypePropertyClass);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.getPalStatementSlot(), (Slot)OWLSystemFrames.this.getRdfsDomainProperty(), Collections.singleton(OWLSystemFrames.this.getPalConstraintCls()));
            this.assertValueType(OWLSystemFrames.this.getPalStatementSlot(), ValueType.STRING);
            this.assertTypeAndName(OWLSystemFrames.this.getPalDescriptionSlot(), OWLSystemFrames.this.owlDatatypePropertyClass);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.getPalDescriptionSlot(), (Slot)OWLSystemFrames.this.getRdfsDomainProperty(), Collections.singleton(OWLSystemFrames.this.getPalConstraintCls()));
            this.assertValueType(OWLSystemFrames.this.getPalDescriptionSlot(), ValueType.STRING);
            this.assertTypeAndName(OWLSystemFrames.this.getPalNameSlot(), OWLSystemFrames.this.owlDatatypePropertyClass);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.getPalNameSlot(), (Slot)OWLSystemFrames.this.getRdfsDomainProperty(), Collections.singleton(OWLSystemFrames.this.getPalConstraintCls()));
            this.assertValueType(OWLSystemFrames.this.getPalNameSlot(), ValueType.STRING);
            this.assertTypeAndName(OWLSystemFrames.this.getPalRangeSlot(), OWLSystemFrames.this.owlObjectPropertyClass);
            this.fs.setDirectOwnSlotValues((Frame)OWLSystemFrames.this.getPalRangeSlot(), (Slot)OWLSystemFrames.this.getRdfsDomainProperty(), Collections.singleton(OWLSystemFrames.this.getPalConstraintCls()));
            this.assertValueType(OWLSystemFrames.this.getPalRangeSlot(), ValueType.STRING);
        }

        private void addInstances() {
            this.assertTypeAndName(OWLSystemFrames.this.rdfNil, OWLSystemFrames.this.rdfListClass);
            for (RDFSDatatype rDFSDatatype : OWLSystemFrames.this.rdfDatatypes) {
                this.assertTypeAndName(rDFSDatatype, OWLSystemFrames.this.rdfsDatatypeClass);
            }
        }
    }
}

