/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.impl.AbstractNamespaceManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLNamespaceManager
extends AbstractNamespaceManager {
    private static final long serialVersionUID = -7101015781624857363L;
    private static final transient Logger log = Log.getLogger(OWLNamespaceManager.class);
    private HashMap<String, String> prefix2namespaceMap = new HashMap();
    private HashMap<String, String> namespace2prefixMap = new HashMap();
    private Collection<String> unmodifiablePrefixes = new HashSet<String>();

    public OWLNamespaceManager() {
        this.setPrefix("http://www.w3.org/2002/07/owl#", "owl");
        this.setModifiable("owl", false);
        this.setPrefix("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.setModifiable("rdf", false);
        this.setPrefix("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        this.setModifiable("rdfs", false);
        this.setPrefix("http://www.w3.org/2001/XMLSchema#", "xsd");
        this.setModifiable("xsd", false);
        this.setPrefix("http://www.owl-ontologies.com/2005/08/07/xsp.owl#", "xsp");
        this.setModifiable("xsp", false);
        this.setPrefix(ProtegeNames.PROTEGE_OWL_NAMESPACE, ProtegeNames.PROTEGE_PREFIX);
        this.setPrefix("http://www.w3.org/2003/11/swrl#", "swrl");
        this.setModifiable("swrl", false);
        this.setPrefix("http://www.w3.org/2003/11/swrlb#", "swrlb");
        this.setModifiable("swrlb", false);
    }

    @Override
    public boolean isModifiable(String string) {
        return !this.unmodifiablePrefixes.contains(string);
    }

    @Override
    public void setModifiable(String string, boolean bl) {
        if (bl) {
            this.unmodifiablePrefixes.remove(string);
        } else {
            this.unmodifiablePrefixes.add(string);
        }
    }

    @Override
    public String getNamespaceForPrefix(String string) {
        return this.prefix2namespaceMap.get(string);
    }

    @Override
    public String getPrefix(String string) {
        return this.namespace2prefixMap.get(string);
    }

    @Override
    public Collection<String> getPrefixes() {
        return this.prefix2namespaceMap.keySet();
    }

    @Override
    public void removePrefix(String string) {
        String string2 = this.prefix2namespaceMap.get(string);
        if (string2 != null) {
            this.removePrefixMappingSimple(string2, string);
            this.tellNamespaceChanged(string, string2, null);
            this.tellPrefixChanged(string2, string, null);
        }
    }

    @Override
    public void setPrefix(String string, String string2) {
        String string3 = this.prefix2namespaceMap.get(string2);
        String string4 = this.namespace2prefixMap.get(string);
        if (string3 != null && string.equals(string3)) {
            return;
        }
        if (this.unmodifiablePrefixes.contains(string2)) {
            log.warning("Trying to set namespace to an unmodifiable prefix: " + string2 + " -> " + string);
            return;
        }
        if (this.unmodifiablePrefixes.contains(string4)) {
            log.warning("Trying to remove an unmodifiable prefix mapping: " + string4 + " -> " + string);
            return;
        }
        if (string4 != null) {
            this.removePrefixMappingSimple(string, string4);
            this.tellNamespaceChanged(string4, string, null);
        }
        if (string3 != null) {
            this.removePrefixMappingSimple(string3, string2);
            this.tellPrefixChanged(string3, string2, null);
        }
        this.addPrefixMappingSimple(string, string2);
        this.tellPrefixChanged(string, string4, string2);
        this.tellNamespaceChanged(string2, string3, string);
    }

    public void removePrefixMappingSimple(String string, String string2) {
        this.prefix2namespaceMap.remove(string2);
        this.namespace2prefixMap.remove(string);
    }

    private void addPrefixMappingSimple(String string, String string2) {
        this.prefix2namespaceMap.put(string2, string);
        this.namespace2prefixMap.put(string, string2);
    }
}

