/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SetMultiMap;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.AbstractNamespaceManager;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportingOwlNamespaceManager
extends AbstractNamespaceManager {
    private static final long serialVersionUID = -5443609678477899634L;
    private static final transient Logger log = Log.getLogger(ImportingOwlNamespaceManager.class);
    private OWLModel owlModel;
    private boolean needsRebuild = true;
    private HashMap<String, String> prefix2namespaceMap = new HashMap();
    private HashMap<String, String> namespace2prefixMap = new HashMap();
    private Collection<String> unmodifiablePrefixes;

    public ImportingOwlNamespaceManager(OWLModel oWLModel) {
        this.owlModel = oWLModel;
    }

    @Override
    public void addImport(TripleStore tripleStore) {
        this.needsRebuild = true;
        super.addImport(tripleStore);
    }

    private void checkDb() {
        Iterator<Object> iterator2;
        Object object;
        String string2;
        Object object2;
        if (!this.needsRebuild) {
            return;
        }
        TripleStore tripleStore = this.owlModel.getTripleStoreModel().getTopTripleStore();
        this.prefix2namespaceMap = new HashMap();
        this.namespace2prefixMap = new HashMap();
        SetMultiMap setMultiMap = new SetMultiMap();
        SetMultiMap setMultiMap2 = new SetMultiMap();
        for (TripleStore object32 : this.owlModel.getTripleStoreModel().getTripleStores()) {
            object2 = object32.getNamespaceManager();
            for (String string2 : object2.getPrefixes()) {
                if (object32 != tripleStore && string2.equals("")) continue;
                object = object2.getNamespaceForPrefix(string2);
                setMultiMap.addValue((Object)string2, object);
                setMultiMap2.addValue(object, (Object)string2);
            }
        }
        NamespaceManager namespaceManager = tripleStore.getNamespaceManager();
        Collection<String> collection = namespaceManager.getPrefixes();
        for (Iterator<Object> iterator2 : collection) {
            string2 = namespaceManager.getNamespaceForPrefix((String)((Object)iterator2));
            this.prefix2namespaceMap.put((String)((Object)iterator2), string2);
            this.namespace2prefixMap.put(string2, (String)((Object)iterator2));
        }
        object2 = setMultiMap.getKeys();
        object2.removeAll(collection);
        iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            String string3;
            Collection collection2;
            string2 = (String)iterator2.next();
            object = setMultiMap.getValues((Object)string2);
            if (object == null || object.size() != 1 || (collection2 = setMultiMap2.getValues((Object)(string3 = (String)object.iterator().next()))).size() != 1) continue;
            this.prefix2namespaceMap.put(string2, string3);
            this.namespace2prefixMap.put(string3, string2);
        }
        this.unmodifiablePrefixes = new HashSet<String>();
        for (String string2 : namespaceManager.getPrefixes()) {
            if (namespaceManager.isModifiable(string2)) continue;
            this.unmodifiablePrefixes.add(string2);
        }
        this.needsRebuild = false;
    }

    private void tellDiffs(Map<String, String> map, Map<String, String> map2) {
        this.tellPrefixDiffs(map, map2);
        this.tellNamespaceDiffs(map, map2);
    }

    private void tellPrefixDiffs(Map<String, String> map, Map<String, String> map2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(map.keySet());
        hashSet.addAll(this.prefix2namespaceMap.keySet());
        for (String string : hashSet) {
            String string2 = map.get(string);
            String string3 = this.prefix2namespaceMap.get(string);
            if (string2 == null && string3 == null || string2 != null && string2.equals(string3)) continue;
            this.tellNamespaceChanged(string, string2, string3);
        }
    }

    private void tellNamespaceDiffs(Map<String, String> map, Map<String, String> map2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(map2.keySet());
        hashSet.addAll(this.namespace2prefixMap.keySet());
        for (String string : hashSet) {
            String string2 = map2.get(string);
            String string3 = this.namespace2prefixMap.get(string);
            if (string2 == null && string3 == null || string2 != null && string2.equals(string3)) continue;
            this.tellPrefixChanged(string, string2, string3);
        }
    }

    @Override
    public boolean isModifiable(String string) {
        this.checkDb();
        return !this.unmodifiablePrefixes.contains(string);
    }

    @Override
    public void setModifiable(String string, boolean bl) {
        this.checkDb();
        this.owlModel.getTripleStoreModel().getTopTripleStore().getNamespaceManager().setModifiable(string, bl);
    }

    @Override
    public String getNamespaceForPrefix(String string) {
        this.checkDb();
        return this.prefix2namespaceMap.get(string);
    }

    @Override
    public String getPrefix(String string) {
        this.checkDb();
        return this.namespace2prefixMap.get(string);
    }

    @Override
    public Collection<String> getPrefixes() {
        this.checkDb();
        return this.prefix2namespaceMap.keySet();
    }

    @Override
    public void removePrefix(String string) {
        this.checkDb();
        HashMap<String, String> hashMap = this.prefix2namespaceMap;
        HashMap<String, String> hashMap2 = this.namespace2prefixMap;
        this.needsRebuild = true;
        this.owlModel.getTripleStoreModel().getTopTripleStore().getNamespaceManager().removePrefix(string);
        this.checkDb();
        this.tellDiffs(hashMap, hashMap2);
    }

    @Override
    public void setPrefix(String string, String string2) {
        this.checkDb();
        HashMap<String, String> hashMap = this.prefix2namespaceMap;
        HashMap<String, String> hashMap2 = this.namespace2prefixMap;
        this.needsRebuild = true;
        this.owlModel.getTripleStoreModel().getTopTripleStore().getNamespaceManager().setPrefix(string, string2);
        this.checkDb();
        this.tellDiffs(hashMap, hashMap2);
    }
}

