/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import java.util.Collection;
import java.util.HashSet;

public class GetExpressionRootForAnonymousClassJob
extends ProtegeJob {
    private static final long serialVersionUID = 6042855610878771146L;
    private OWLAnonymousClass anonClass;

    public GetExpressionRootForAnonymousClassJob(KnowledgeBase knowledgeBase, OWLAnonymousClass oWLAnonymousClass) {
        super(knowledgeBase);
        this.anonClass = oWLAnonymousClass;
    }

    public Object run() throws ProtegeException {
        RDFProperty rDFProperty = ((OWLModel)this.getKnowledgeBase()).getRDFFirstProperty();
        Collection collection = this.anonClass.getReferences();
        for (Reference reference : collection) {
            RDFResource rDFResource;
            if (reference.getFrame() instanceof OWLAnonymousClass) {
                rDFResource = (OWLAnonymousClass)reference.getFrame();
                return rDFResource.getExpressionRoot();
            }
            if (!(reference.getFrame() instanceof RDFList) || !rDFProperty.equals(reference.getSlot())) continue;
            rDFResource = (RDFList)reference.getFrame();
            RDFList rDFList = rDFResource.getStart();
            HashSet hashSet = new HashSet();
            OWLUtil.getReferringLogicalClasses(rDFList, hashSet);
            if (hashSet.size() <= 0) continue;
            OWLAnonymousClass oWLAnonymousClass = (OWLAnonymousClass)hashSet.iterator().next();
            return oWLAnonymousClass.getExpressionRoot();
        }
        return this.anonClass;
    }

    public void localize(KnowledgeBase knowledgeBase) {
        super.localize(knowledgeBase);
        LocalizeUtils.localize((Object)this.anonClass, (KnowledgeBase)knowledgeBase);
    }
}

