/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DefaultRDFSLiteral
implements RDFSLiteral {
    public static final String DATATYPE_PREFIX = "~@";
    public static final String LANGUAGE_PREFIX = "~#";
    public static final char SEPARATOR = ' ';
    private OWLModel owlModel;
    private String rawValue;
    private String language;

    public DefaultRDFSLiteral(OWLModel oWLModel, String string) {
        this.owlModel = oWLModel;
        this.rawValue = string;
        this.language = this.getLanguageFromRawValue();
    }

    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitRDFSLiteral(this);
    }

    public int compareTo(RDFSLiteral rDFSLiteral) {
        RDFSDatatype rDFSDatatype;
        RDFSDatatype rDFSDatatype2 = this.getDatatype();
        if (rDFSDatatype2.equals(rDFSDatatype = rDFSLiteral.getDatatype())) {
            if (this.owlModel.getIntegerDatatypes().contains(rDFSDatatype2)) {
                int n = this.getInt();
                int n2 = rDFSLiteral.getInt();
                return new Integer(n).compareTo(new Integer(n2));
            }
            if (this.owlModel.getFloatDatatypes().contains(rDFSDatatype2)) {
                double d = this.getDouble();
                double d2 = rDFSLiteral.getDouble();
                return new Double(d).compareTo(new Double(d2));
            }
        }
        return this.rawValue.compareTo(rDFSLiteral.getRawValue());
    }

    public static RDFSLiteral create(OWLModel oWLModel, Object object) {
        RDFSDatatype rDFSDatatype = null;
        if (object instanceof Boolean) {
            rDFSDatatype = oWLModel.getXSDboolean();
        } else if (object instanceof Long) {
            rDFSDatatype = oWLModel.getXSDlong();
        } else if (object instanceof Integer) {
            rDFSDatatype = oWLModel.getXSDint();
        } else if (object instanceof Short) {
            rDFSDatatype = oWLModel.getXSDshort();
        } else if (object instanceof Byte) {
            rDFSDatatype = oWLModel.getXSDbyte();
        } else if (object instanceof Double) {
            rDFSDatatype = oWLModel.getXSDdouble();
        } else if (object instanceof Float) {
            rDFSDatatype = oWLModel.getXSDfloat();
        } else if (object instanceof String) {
            if (DefaultRDFSLiteral.isRawValue((String)object)) {
                return new DefaultRDFSLiteral(oWLModel, (String)object);
            }
            rDFSDatatype = oWLModel.getXSDstring();
        } else if (object instanceof byte[]) {
            rDFSDatatype = oWLModel.getXSDbase64Binary();
            object = XSDDatatype.XSDbase64Binary.unparse(object);
        } else if (object instanceof BigDecimal) {
            rDFSDatatype = oWLModel.getXSDdecimal();
        } else if (object instanceof BigInteger) {
            rDFSDatatype = oWLModel.getXSDinteger();
        } else {
            throw new IllegalArgumentException("Value type " + object.getClass() + " of value \"" + object + "\" cannot be mapped into default RDFSDatatype.");
        }
        return new DefaultRDFSLiteral(oWLModel, DefaultRDFSLiteral.getRawValue(String.valueOf(object), rDFSDatatype));
    }

    public static RDFSLiteral create(OWLModel oWLModel, String string, RDFSDatatype rDFSDatatype) {
        return new DefaultRDFSLiteral(oWLModel, DefaultRDFSLiteral.getRawValue(string, rDFSDatatype));
    }

    public static RDFSLiteral create(OWLModel oWLModel, String string, String string2) {
        return new DefaultRDFSLiteral(oWLModel, DefaultRDFSLiteral.getRawValue(string, string2));
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultRDFSLiteral) {
            return this.rawValue.equals(((DefaultRDFSLiteral)object).rawValue);
        }
        return false;
    }

    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof RDFSLiteral) {
            return ((RDFSLiteral)rDFObject).equals(this);
        }
        return false;
    }

    public boolean getBoolean() {
        String string = this.getString();
        return Boolean.valueOf(string);
    }

    public String getBrowserText() {
        return this.toString();
    }

    public byte[] getBytes() {
        return (byte[])XSDDatatype.XSDbase64Binary.parse(this.getString());
    }

    public RDFSDatatype getDatatype() {
        if (this.rawValue.startsWith(LANGUAGE_PREFIX)) {
            return this.owlModel.getXSDstring();
        }
        int n = this.rawValue.indexOf(32);
        if (n == -1) {
            return this.owlModel.getXSDstring();
        }
        String string = this.rawValue.substring(2, n);
        RDFSDatatype rDFSDatatype = this.owlModel.getRDFSDatatypeByName(string);
        return rDFSDatatype;
    }

    public double getDouble() {
        return Double.parseDouble(this.getString().trim());
    }

    public float getFloat() {
        return Float.parseFloat(this.getString().trim());
    }

    public int getInt() {
        return Integer.parseInt(this.getString().trim());
    }

    public String getLanguage() {
        return this.language;
    }

    protected String getLanguageFromRawValue() {
        String string = null;
        if (this.rawValue.startsWith(LANGUAGE_PREFIX)) {
            int n = this.rawValue.indexOf(32);
            string = n > 0 ? this.rawValue.substring(2, n) : this.rawValue.substring(2);
        }
        return string;
    }

    public long getLong() {
        return Long.parseLong(this.getString());
    }

    public short getShort() {
        return Short.parseShort(this.getString());
    }

    public Object getPlainValue() {
        String string = this.getLanguage();
        if (string != null) {
            if (string.length() == 0) {
                return this.getString();
            }
            return null;
        }
        RDFSDatatype rDFSDatatype = this.getDatatype();
        if (this.owlModel.getXSDstring().equals(rDFSDatatype)) {
            if (this.getLanguage() == null) {
                return this.getString();
            }
        } else {
            if (this.owlModel.getXSDint().equals(rDFSDatatype)) {
                try {
                    return Integer.valueOf(this.getString().trim());
                }
                catch (Exception exception) {
                    return new Integer(0);
                }
            }
            if (this.owlModel.getXSDfloat().equals(rDFSDatatype)) {
                try {
                    return Float.valueOf(this.getString().trim());
                }
                catch (Exception exception) {
                    return new Float(0.0f);
                }
            }
            if (this.owlModel.getXSDboolean().equals(rDFSDatatype)) {
                try {
                    return Boolean.valueOf(this.getString());
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        }
        return null;
    }

    public static Object getPlainValueIfPossible(Object object) {
        RDFSLiteral rDFSLiteral;
        Object object2;
        if (object instanceof RDFSLiteral && (object2 = (rDFSLiteral = (RDFSLiteral)object).getPlainValue()) != null) {
            return object2;
        }
        return object;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getString() {
        if (this.rawValue.startsWith(LANGUAGE_PREFIX) || this.rawValue.startsWith(DATATYPE_PREFIX)) {
            return this.rawValue.substring(this.rawValue.indexOf(32) + 1);
        }
        return this.rawValue;
    }

    public static final String getRawValue(String string, RDFSDatatype rDFSDatatype) {
        if (rDFSDatatype.equals(rDFSDatatype.getOWLModel().getXSDboolean()) && "1".equals(string)) {
            string = Boolean.TRUE.toString();
        }
        if (!rDFSDatatype.isSystem() && rDFSDatatype.isAnonymous()) {
            rDFSDatatype = rDFSDatatype.getBaseDatatype();
        }
        return DATATYPE_PREFIX + rDFSDatatype.getName() + ' ' + string;
    }

    public static final String getRawValue(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return LANGUAGE_PREFIX + string2 + ' ' + string;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }

    public static final boolean isRawValue(String string) {
        return string.startsWith(LANGUAGE_PREFIX) || string.startsWith(DATATYPE_PREFIX);
    }

    public String toString() {
        return this.getString();
    }
}

