/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.XSPNames;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;

public class DefaultRDFSDatatype
extends DefaultRDFIndividual
implements RDFSDatatype {
    public DefaultRDFSDatatype(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultRDFSDatatype() {
    }

    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitRDFDatatype(this);
    }

    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof RDFSDatatype) {
            RDFSDatatype rDFSDatatype = (RDFSDatatype)rDFObject;
            return rDFSDatatype.getURI() == this.getURI() && rDFSDatatype.getMaxExclusive().equalsStructurally(this.getMaxExclusive()) && rDFSDatatype.getMinExclusive().equalsStructurally(this.getMinExclusive()) && rDFSDatatype.getMaxInclusive().equalsStructurally(this.getMaxInclusive()) && rDFSDatatype.getMinInclusive().equalsStructurally(this.getMinInclusive());
        }
        return false;
    }

    public RDFSDatatype getBaseDatatype() {
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.getOWLModel(), 0);
        if (rDFProperty != null) {
            return (RDFSDatatype)this.getPropertyValue(rDFProperty);
        }
        return null;
    }

    public String getBrowserText() {
        Object object;
        if (this.isAnonymous() && (object = this.getBaseDatatype()) != null) {
            String string = object.getBrowserText();
            String string2 = "[";
            String string3 = "]";
            RDFSLiteral rDFSLiteral = this.getMinInclusive();
            RDFSLiteral rDFSLiteral2 = this.getMaxInclusive();
            if (rDFSLiteral == null && (rDFSLiteral = this.getMinExclusive()) != null) {
                string2 = "(";
                if (rDFSLiteral2 == null) {
                    string3 = ")";
                }
            }
            if (rDFSLiteral2 == null && (rDFSLiteral2 = this.getMaxExclusive()) != null) {
                string3 = ")";
            }
            if (rDFSLiteral2 != null || rDFSLiteral != null) {
                string = string + string2;
                string = rDFSLiteral != null ? string + rDFSLiteral.toString() : string + "..";
                string = string + ",";
                string = rDFSLiteral2 != null ? string + rDFSLiteral2.toString() : string + "..";
                return string + string3;
            }
            return "variant of " + object.getBrowserText();
        }
        object = super.getBrowserText();
        if (((String)object).startsWith("xsd:")) {
            return ((String)object).substring("xsd:".length());
        }
        return object;
    }

    public Object getDefaultValue() {
        if (this.equals(this.getOWLModel().getXSDboolean())) {
            return Boolean.FALSE;
        }
        if (this.equals(this.getOWLModel().getXSDint())) {
            return new Integer(0);
        }
        if (this.equals(this.getOWLModel().getXSDfloat())) {
            return new Float(0.0f);
        }
        if (this.equals(this.getOWLModel().getXSDstring())) {
            return "";
        }
        String string = "";
        if (this.isNumericDatatype()) {
            string = "0";
        }
        return this.getOWLModel().createRDFSLiteral(string, this);
    }

    public Icon getIcon() {
        return this.isEditable() ? OWLIcons.getImageIcon("RDFSDatatype") : OWLIcons.getReadOnlyIndividualIcon(OWLIcons.getImageIcon("RDFSDatatype"));
    }

    private int getIntPropertyValue(String string) {
        Object object;
        RDFProperty rDFProperty = this.getOWLModel().getRDFProperty(string);
        if (rDFProperty != null && (object = this.getPropertyValue(rDFProperty)) instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public int getLength() {
        return this.getIntPropertyValue(XSPNames.getName(this.getOWLModel(), 2));
    }

    public RDFSLiteral getMaxExclusive() {
        return this.getPropertyValueLiteral(XSPNames.getName(this.getOWLModel(), 5));
    }

    public RDFSLiteral getMaxInclusive() {
        return this.getPropertyValueLiteral(XSPNames.getName(this.getOWLModel(), 6));
    }

    public int getMaxLength() {
        return this.getIntPropertyValue(XSPNames.getName(this.getOWLModel(), 8));
    }

    public RDFSLiteral getMinExclusive() {
        return this.getPropertyValueLiteral(XSPNames.getName(this.getOWLModel(), 3));
    }

    public RDFSLiteral getMinInclusive() {
        return this.getPropertyValueLiteral(XSPNames.getName(this.getOWLModel(), 4));
    }

    public int getMinLength() {
        return this.getIntPropertyValue(XSPNames.getName(this.getOWLModel(), 7));
    }

    public String getPattern() {
        Object object;
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.getOWLModel(), 9);
        if (rDFProperty != null && (object = this.getPropertyValue(rDFProperty)) != null) {
            return object.toString();
        }
        return null;
    }

    private RDFSLiteral getPropertyValueLiteral(String string) {
        RDFProperty rDFProperty = this.getOWLModel().getRDFProperty(string);
        if (rDFProperty != null) {
            return this.getPropertyValueLiteral(rDFProperty);
        }
        return null;
    }

    public boolean isNumericDatatype() {
        String string = this.getURI();
        RDFSDatatype rDFSDatatype = this.getBaseDatatype();
        if (rDFSDatatype != null) {
            string = rDFSDatatype.getURI();
        }
        return XMLSchemaDatatypes.isNumericDatatype(string);
    }

    public boolean isValidValue(RDFSLiteral rDFSLiteral) {
        RDFSDatatype rDFSDatatype = this;
        RDFSDatatype rDFSDatatype2 = this.getBaseDatatype();
        if (rDFSDatatype2 != null) {
            rDFSDatatype = rDFSDatatype2;
        }
        if (!rDFSLiteral.getDatatype().equals(rDFSDatatype)) {
            return false;
        }
        if (this.getOWLModel().getXSDstring().equals(rDFSDatatype)) {
            return this.isValidValueString(rDFSLiteral);
        }
        return this.isValidValueNumeric(rDFSLiteral);
    }

    private boolean isValidValueNumeric(RDFSLiteral rDFSLiteral) {
        RDFSLiteral rDFSLiteral2 = this.getMinInclusive();
        if (rDFSLiteral2 != null && rDFSLiteral.compareTo(rDFSLiteral2) < 0) {
            return false;
        }
        RDFSLiteral rDFSLiteral3 = this.getMinExclusive();
        if (rDFSLiteral3 != null && rDFSLiteral.compareTo(rDFSLiteral3) <= 0) {
            return false;
        }
        RDFSLiteral rDFSLiteral4 = this.getMaxInclusive();
        if (rDFSLiteral4 != null && rDFSLiteral.compareTo(rDFSLiteral4) > 0) {
            return false;
        }
        RDFSLiteral rDFSLiteral5 = this.getMaxExclusive();
        return rDFSLiteral5 == null || rDFSLiteral.compareTo(rDFSLiteral5) < 0;
    }

    private boolean isValidValueString(RDFSLiteral rDFSLiteral) {
        Pattern pattern;
        Matcher matcher;
        String string = rDFSLiteral.toString();
        int n = string.length();
        int n2 = this.getLength();
        if (n2 >= 0 && n2 != n) {
            return false;
        }
        int n3 = this.getMinLength();
        if (n3 >= 0 && n < n3) {
            return false;
        }
        int n4 = this.getMaxLength();
        if (n4 >= 0 && n > n4) {
            return false;
        }
        String string2 = this.getPattern();
        return string2 == null || (matcher = (pattern = Pattern.compile(string2)).matcher(string)).matches();
    }

    public static Map parse(OWLModel oWLModel, String string) {
        HashMap<RDFProperty, RDFObject> hashMap = new HashMap<RDFProperty, RDFObject>();
        if (oWLModel.isProtegeMetaOntologyImported()) {
            String string2;
            RDFSDatatype rDFSDatatype;
            int n;
            for (n = 3; n < string.length() && string.charAt(n) != '(' && string.charAt(n) != '['; ++n) {
            }
            if (n < string.length() && (rDFSDatatype = oWLModel.getRDFSDatatypeByName(string2 = string.substring(0, n).trim())) != null) {
                int n2;
                int n3;
                RDFProperty rDFProperty = XSPNames.getRDFProperty(oWLModel, 0);
                hashMap.put(rDFProperty, rDFSDatatype);
                RDFProperty rDFProperty2 = null;
                rDFProperty2 = string.charAt(n) == '(' ? XSPNames.getRDFProperty(oWLModel, 3) : XSPNames.getRDFProperty(oWLModel, 4);
                String string3 = string.substring(n + 1).trim();
                for (n3 = 0; n3 < string3.length() && (Character.isDigit(string3.charAt(n3)) || string3.charAt(n3) == '.'); ++n3) {
                }
                String string4 = string3.substring(0, n3);
                if (string4.length() > 0 && Character.isDigit(string4.charAt(0))) {
                    RDFSLiteral rDFSLiteral = oWLModel.createRDFSLiteral(string4, rDFSDatatype);
                    hashMap.put(rDFProperty2, rDFSLiteral);
                }
                for (n2 = n3; n2 < string3.length() && !Character.isDigit(string3.charAt(n2)); ++n2) {
                }
                if (n2 < string3.length()) {
                    String string5;
                    int n4;
                    string3 = string3.substring(n2);
                    for (n4 = 0; n4 < string3.length() && (Character.isDigit(string3.charAt(n4)) || string3.charAt(n4) == '.'); ++n4) {
                    }
                    RDFProperty rDFProperty3 = XSPNames.getRDFProperty(oWLModel, 6);
                    if (string3.endsWith(")")) {
                        rDFProperty3 = XSPNames.getRDFProperty(oWLModel, 5);
                    }
                    if ((string5 = string3.substring(0, n4)).length() > 0 && Character.isDigit(string5.charAt(0))) {
                        RDFSLiteral rDFSLiteral = oWLModel.createRDFSLiteral(string5, rDFSDatatype);
                        hashMap.put(rDFProperty3, rDFSLiteral);
                    }
                }
                if (hashMap.size() == 1) {
                    return new HashMap();
                }
            }
        }
        return hashMap;
    }
}

