/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRDFProperty
extends DefaultSlot
implements RDFProperty {
    private static final long serialVersionUID = 8950825871351060966L;

    public DefaultRDFProperty(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultRDFProperty() {
    }

    @Override
    public void addPropertyListener(PropertyListener propertyListener) {
        if (!(propertyListener instanceof PropertyAdapter)) {
            throw new IllegalArgumentException("Listener must be subclass of PropertyAdapter");
        }
        this.addSlotListener(propertyListener);
    }

    @Override
    public void addSuperproperty(RDFProperty rDFProperty) {
        this.getKnowledgeBase().addDirectSuperslot((Slot)this, (Slot)rDFProperty);
    }

    @Override
    public void addEquivalentProperty(RDFProperty rDFProperty) {
        RDFProperty rDFProperty2 = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.addOwnSlotValue(rDFProperty2, rDFProperty);
    }

    @Override
    public void addUnionDomainClass(RDFSClass rDFSClass) {
        Collection collection = this.getDirectDomain();
        if (collection.isEmpty() || collection.size() == 1 && collection.contains(this.getOWLModel().getOWLThingClass())) {
            this.setDomain(rDFSClass);
        } else {
            OWLUnionClass oWLUnionClass = this.getOWLModel().createOWLUnionClass(collection);
            oWLUnionClass.addOperand(rDFSClass);
            this.setDomain(oWLUnionClass);
        }
    }

    @Override
    public boolean equalsStructurally(RDFObject rDFObject) {
        return this.equals(rDFObject);
    }

    public ImageIcon getBaseImageIcon() {
        return OWLIcons.getImageIcon("RDFProperty");
    }

    @Override
    public RDFSClass getDomain(boolean bl) {
        Collection collection = this.getDomains(bl);
        if (collection.isEmpty()) {
            return null;
        }
        return (RDFSClass)collection.iterator().next();
    }

    @Override
    public Collection getDomains(boolean bl) {
        if (bl) {
            List list = this.getDirectOwnSlotValues(this.getOWLModel().getRDFSDomainProperty());
            if (list.isEmpty()) {
                ArrayList arrayList = new ArrayList();
                for (RDFProperty rDFProperty : this.getSuperproperties(false)) {
                    Collection collection = rDFProperty.getDomains(true);
                    arrayList.addAll(collection);
                }
                return arrayList;
            }
            return list;
        }
        return this.getDirectOwnSlotValues(this.getOWLModel().getRDFSDomainProperty());
    }

    @Override
    public Collection getEquivalentProperties() {
        RDFProperty rDFProperty = this.getOWLModel().getOWLEquivalentPropertyProperty();
        return this.getOwnSlotValues(rDFProperty);
    }

    @Override
    public RDFProperty getFirstSuperproperty() {
        return (RDFProperty)this.getPropertyValue(this.getOWLModel().getRDFSSubPropertyOfProperty());
    }

    @Override
    public Icon getInheritedIcon() {
        return OWLIcons.getImageIcon("RDFPropertyInherited");
    }

    @Override
    public Icon getIcon() {
        if (this.isUntyped()) {
            return this.isEditable() ? OWLIcons.getExternalResourceIcon() : OWLIcons.getReadOnlyClsIcon(OWLIcons.getExternalResourceIcon());
        }
        return this.isEditable() ? this.getBaseImageIcon() : OWLIcons.getReadOnlyPropertyIcon(OWLIcons.getImageIcon("RDFProperty"));
    }

    protected boolean isUntyped() {
        return this.hasDirectType(((AbstractOWLModel)this.getOWLModel()).getRDFExternalPropertyClass());
    }

    @Override
    public String getIconName() {
        return "RDFProperty";
    }

    @Override
    public RDFProperty getInverseProperty() {
        return (RDFProperty)this.getKnowledgeBase().getInverseSlot((Slot)this);
    }

    @Override
    public RDFResource getRange() {
        return this.getRange(false);
    }

    @Override
    public RDFResource getRange(boolean bl) {
        Object object = this.getPropertyValue(this.getOWLModel().getRDFSRangeProperty());
        if (object instanceof RDFResource) {
            return (RDFResource)object;
        }
        if (object == null && bl) {
            for (RDFProperty rDFProperty : this.getSuperproperties(false)) {
                RDFResource rDFResource = rDFProperty.getRange(true);
                if (rDFResource == null) continue;
                return rDFResource;
            }
        }
        return null;
    }

    @Override
    public RDFSDatatype getRangeDatatype() {
        RDFResource rDFResource = this.getRange();
        if (rDFResource instanceof RDFSDatatype) {
            return (RDFSDatatype)rDFResource;
        }
        if (rDFResource instanceof OWLDataRange) {
            return ((OWLDataRange)rDFResource).getRDFDatatype();
        }
        return null;
    }

    @Override
    public Collection getRanges(boolean bl) {
        Collection collection = this.getPropertyValues(this.getOWLModel().getRDFSRangeProperty());
        if (collection.isEmpty() && bl) {
            for (RDFProperty rDFProperty : this.getSuperproperties(false)) {
                collection = rDFProperty.getRanges(true);
                if (collection == null) continue;
                return collection;
            }
        }
        return collection;
    }

    @Override
    public Collection getSubproperties(boolean bl) {
        if (bl) {
            return this.getKnowledgeBase().getSubslots((Slot)this);
        }
        return this.getKnowledgeBase().getDirectSubslots((Slot)this);
    }

    @Override
    public int getSubpropertyCount() {
        return this.getKnowledgeBase().getDirectSubslotCount((Slot)this);
    }

    @Override
    public Collection getSuperproperties(boolean bl) {
        if (bl) {
            return this.getKnowledgeBase().getSuperslots((Slot)this);
        }
        return this.getKnowledgeBase().getDirectSuperslots((Slot)this);
    }

    @Override
    public int getSuperpropertyCount() {
        return this.getKnowledgeBase().getDirectSuperslotCount((Slot)this);
    }

    @Override
    public Collection getUnionDomain() {
        return this.getKnowledgeBase().getDirectDomain((Slot)this);
    }

    @Override
    public Collection getUnionDomain(boolean bl) {
        Collection<OWLNamedClass> collection = this.getKnowledgeBase().getDirectDomain((Slot)this);
        OWLNamedClass oWLNamedClass = this.getOWLModel().getOWLThingClass();
        if (collection == null || collection.isEmpty()) {
            collection = Collections.singleton(oWLNamedClass);
        }
        if (bl) {
            Set<OWLNamedClass> set = collection;
            for (Object e : this.getSuperproperties(true)) {
                if (!(e instanceof RDFProperty)) continue;
                RDFProperty rDFProperty = (RDFProperty)e;
                Collection collection2 = this.getKnowledgeBase().getDirectDomain((Slot)rDFProperty);
                if (collection2 == null || collection2.isEmpty() || collection2.size() == 1 && collection2.contains(oWLNamedClass)) continue;
                if (collection.size() == 1 && collection.contains(oWLNamedClass)) {
                    collection = collection2;
                    continue;
                }
                if (collection.containsAll(collection2)) {
                    collection = collection2;
                    continue;
                }
                if (collection2.containsAll(collection)) continue;
                collection = set;
                break;
            }
        }
        return collection;
    }

    @Override
    public Collection getUnionRangeClasses() {
        return AbstractOWLModel.getRDFResources(this.getOWLModel(), this.getKnowledgeBase().getAllowedClses((Slot)this));
    }

    @Override
    public boolean hasDatatypeRange() {
        RDFResource rDFResource = this.getRange(true);
        return rDFResource instanceof RDFSDatatype || rDFResource instanceof OWLDataRange;
    }

    @Override
    public boolean hasObjectRange() {
        RDFResource rDFResource = this.getRange(true);
        return rDFResource instanceof RDFSClass;
    }

    @Override
    public boolean hasRange(boolean bl) {
        Collection collection = this.getRanges(bl);
        return !collection.isEmpty();
    }

    @Override
    public boolean isSubpropertyOf(RDFProperty rDFProperty, boolean bl) {
        if (bl) {
            return this.getKnowledgeBase().hasSuperslot((Slot)this, (Slot)rDFProperty);
        }
        return this.getKnowledgeBase().hasDirectSuperslot((Slot)this, (Slot)rDFProperty);
    }

    @Override
    public boolean isAnnotationProperty() {
        return this.hasProtegeType(this.getOWLModel().getOWLAnnotationPropertyClass());
    }

    @Override
    public boolean isPureAnnotationProperty() {
        return this.isAnnotationProperty() && !(this instanceof OWLDatatypeProperty) && !(this instanceof OWLObjectProperty);
    }

    @Override
    public boolean isDomainDefined() {
        Slot slot = this.getOWLModel().getSystemFrames().getDirectDomainSlot();
        List list = this.getDirectOwnSlotValues(slot);
        if (list.size() > 1) {
            return true;
        }
        if (list.size() == 1 && !list.contains(this.getOWLModel().getRootCls())) {
            return true;
        }
        if (list.size() == 1) {
            RDFProperty rDFProperty = this.getOWLModel().getRDFSDomainProperty();
            list = this.getDirectOwnSlotValues(rDFProperty);
            return !list.isEmpty();
        }
        return false;
    }

    @Override
    public boolean isDomainDefined(boolean bl) {
        if (!bl) {
            return this.isDomainDefined();
        }
        return this.isDomainDefined(new HashSet<RDFProperty>());
    }

    private boolean isDomainDefined(Set<RDFProperty> set) {
        set.add(this);
        if (this.isDomainDefined()) {
            return true;
        }
        for (Slot slot : this.getDirectSuperslots()) {
            if (set.contains(slot) || !(slot instanceof DefaultRDFProperty) || !((DefaultRDFProperty)slot).isDomainDefined(set)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFunctional() {
        if (this.hasProtegeType(this.getOWLModel().getOWLFunctionalPropertyClass())) {
            return true;
        }
        for (RDFProperty rDFProperty : this.getSuperproperties(false)) {
            if (!rDFProperty.isFunctional()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRangeDefined() {
        return this.getDirectOwnSlotValue(this.getKnowledgeBase().getSlot(":SLOT-VALUE-TYPE")) != null;
    }

    @Override
    public boolean isReadOnly() {
        RDFProperty rDFProperty = ((OWLModel)this.getKnowledgeBase()).getProtegeReadOnlyProperty();
        Object object = this.getDirectOwnSlotValue(rDFProperty);
        return Boolean.TRUE.equals(object) || object != null && object instanceof String && ((String)object).toLowerCase().equals("true");
    }

    @Override
    public void removeEquivalentProperty(OWLProperty oWLProperty) {
        RDFProperty rDFProperty = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.removeOwnSlotValue(rDFProperty, oWLProperty);
    }

    @Override
    public void removePropertyListener(PropertyListener propertyListener) {
        if (!(propertyListener instanceof PropertyAdapter)) {
            throw new IllegalArgumentException("Listener must be subclass of PropertyAdapter");
        }
        this.removeSlotListener(propertyListener);
    }

    @Override
    public void removeSuperproperty(RDFProperty rDFProperty) {
        this.getKnowledgeBase().removeDirectSuperslot((Slot)this, (Slot)rDFProperty);
    }

    @Override
    public void removeUnionDomainClass(RDFSClass rDFSClass) {
        ArrayList arrayList = new ArrayList(this.getDirectDomain());
        arrayList.remove(rDFSClass);
        if (arrayList.isEmpty()) {
            OWLNamedClass oWLNamedClass = rDFSClass.getOWLModel().getOWLThingClass();
            if (rDFSClass != oWLNamedClass && this.getSuperpropertyCount() == 0) {
                this.setDomain(oWLNamedClass);
            } else {
                this.setDomain(null);
            }
        } else if (arrayList.size() == 1) {
            this.setDomain((RDFSClass)arrayList.iterator().next());
        } else {
            OWLUnionClass oWLUnionClass = this.getOWLModel().createOWLUnionClass(arrayList);
            this.setDomain(oWLUnionClass);
        }
    }

    @Override
    public void setDomainDefined(boolean bl) {
        if (bl != this.isDomainDefined()) {
            if (!bl) {
                this.setDomain(null);
            } else if (this.getSuperpropertyCount() > 0) {
                this.setDomain(null);
            } else {
                this.setDomain(this.getOWLModel().getOWLThingClass());
            }
        }
    }

    @Override
    public void setEquivalentProperties(Collection collection) {
        RDFProperty rDFProperty = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.setOwnSlotValues(rDFProperty, collection);
    }

    @Override
    public void setFunctional(boolean bl) {
        this.updateRDFType(bl, this.getOWLModel().getOWLFunctionalPropertyClass());
    }

    @Override
    public void setInverseProperty(RDFProperty rDFProperty) {
        this.getKnowledgeBase().setInverseSlot((Slot)this, (Slot)rDFProperty);
    }

    @Override
    public void setRange(RDFResource rDFResource) {
        this.setPropertyValue(this.getOWLModel().getRDFSRangeProperty(), rDFResource);
    }

    @Override
    public void setRanges(Collection collection) {
        this.setPropertyValues(this.getOWLModel().getRDFSRangeProperty(), collection);
    }

    public void setRDFTypeOfSubproperties(RDFSNamedClass rDFSNamedClass) {
        this.getKnowledgeBase().setDirectTypeOfSubslots((Slot)this, (Cls)rDFSNamedClass);
    }

    @Override
    public void setUnionRangeClasses(Collection collection) {
        RDFResource rDFResource = null;
        if (collection.size() == 1) {
            rDFResource = (RDFResource)collection.iterator().next();
        } else if (collection.size() > 1) {
            rDFResource = this.getOWLModel().createOWLUnionClass(collection);
        }
        this.setRange(rDFResource);
    }

    protected void updateRDFType(boolean bl, RDFSClass rDFSClass) {
        if (this.hasProtegeType(rDFSClass) != bl) {
            if (bl) {
                this.addProtegeType(rDFSClass);
            } else {
                this.removeProtegeType(rDFSClass);
            }
        }
    }

    @Override
    public void addComment(String string) {
        OWLUtil.addComment(this, string);
    }

    @Override
    public void addDifferentFrom(RDFResource rDFResource) {
        OWLUtil.addDifferentFrom(this, rDFResource);
    }

    @Override
    public void addIsDefinedBy(RDFResource rDFResource) {
        OWLUtil.addIsDefinedBy(this, rDFResource);
    }

    @Override
    public void addLabel(String string, String string2) {
        OWLUtil.addLabel(this, string, string2);
    }

    @Override
    public void addPropertyValue(RDFProperty rDFProperty, Object object) {
        OWLUtil.addPropertyValue(this, rDFProperty, object);
    }

    @Override
    public void addPropertyValueListener(PropertyValueListener propertyValueListener) {
        OWLUtil.addPropertyValueListener(this, propertyValueListener);
    }

    @Override
    public void addProtegeType(RDFSClass rDFSClass) {
        OWLUtil.addProtegeType(this, rDFSClass);
    }

    @Override
    public void addRDFType(RDFSClass rDFSClass) {
        OWLUtil.addRDFType(this, rDFSClass);
    }

    @Override
    public void addResourceListener(ResourceListener resourceListener) {
        OWLUtil.addResourceListener(this, resourceListener);
    }

    @Override
    public void addSameAs(RDFResource rDFResource) {
        OWLUtil.addSameAs(this, rDFResource);
    }

    @Override
    public void addVersionInfo(String string) {
        OWLUtil.addVersionInfo(this, string);
    }

    @Override
    public RDFResource as(Class clazz) {
        return OWLUtil.as(this, clazz);
    }

    @Override
    public boolean canAs(Class clazz) {
        return OWLUtil.canAs(this, clazz);
    }

    @Override
    public RDFResource getAllValuesFromOnTypes(RDFProperty rDFProperty) {
        return OWLUtil.getAllValuesFromOnTypes(this, rDFProperty);
    }

    @Override
    public Collection getComments() {
        return OWLUtil.getComments(this);
    }

    @Override
    public Collection getDifferentFrom() {
        return OWLUtil.getDifferentFrom(this);
    }

    @Override
    public Collection getHasValuesOnTypes(RDFProperty rDFProperty) {
        return OWLUtil.getHasValuesOnTypes(this, rDFProperty);
    }

    @Override
    public Class getIconLocation() {
        return OWLIcons.class;
    }

    @Override
    public RDFSClass getProtegeType() {
        return OWLUtil.getDirectRDFType(this);
    }

    @Override
    public Collection getProtegeTypes() {
        return OWLUtil.getDirectRDFTypes(this);
    }

    @Override
    public Collection getDocumentation() {
        return OWLUtil.getComments(this);
    }

    @Override
    public Collection getInferredTypes() {
        return OWLUtil.getInferredDirectTypes(this);
    }

    @Override
    public Collection getIsDefinedBy() {
        return OWLUtil.getIsDefinedBy(this);
    }

    @Override
    public Collection getLabels() {
        return OWLUtil.getLabels(this);
    }

    @Override
    public String getLocalName() {
        return NamespaceUtil.getLocalName(this.getName());
    }

    @Override
    public String getPrefixedName() {
        return NamespaceUtil.getPrefixedName(this.getOWLModel(), this.getName());
    }

    @Override
    public String getNamespace() {
        return NamespaceUtil.getNameSpace(this.getName());
    }

    @Override
    public String getNamespacePrefix() {
        return NamespaceUtil.getPrefixForResourceName(this.getOWLModel(), this.getName());
    }

    @Override
    public OWLModel getOWLModel() {
        return (OWLModel)this.getKnowledgeBase();
    }

    @Override
    public Collection getPossibleRDFProperties() {
        return OWLUtil.getPossibleRDFProperties(this);
    }

    @Override
    public Object getPropertyValue(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValue(this, rDFProperty, false);
    }

    @Override
    public RDFResource getPropertyValueAs(RDFProperty rDFProperty, Class clazz) {
        return OWLUtil.getPropertyValueAs(this, rDFProperty, clazz);
    }

    @Override
    public Object getPropertyValue(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.getPropertyValue(this, rDFProperty, bl);
    }

    @Override
    public int getPropertyValueCount(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValueCount(this, rDFProperty);
    }

    @Override
    public RDFSLiteral getPropertyValueLiteral(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValueLiteral(this, rDFProperty);
    }

    @Override
    public Collection getPropertyValueLiterals(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValueLiterals(this, rDFProperty);
    }

    @Override
    public Collection getPropertyValues(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValues(this, rDFProperty, false);
    }

    @Override
    public Collection getPropertyValuesAs(RDFProperty rDFProperty, Class clazz) {
        return OWLUtil.getPropertyValuesAs(this, rDFProperty, clazz);
    }

    @Override
    public Collection getPropertyValues(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.getPropertyValues(this, rDFProperty, bl);
    }

    @Override
    public Collection getRDFProperties() {
        return OWLUtil.getRDFProperties(this);
    }

    @Override
    public RDFSClass getRDFType() {
        return OWLUtil.getRDFType(this);
    }

    @Override
    public Collection getRDFTypes() {
        return OWLUtil.getRDFTypes(this);
    }

    @Override
    public Set getReferringAnonymousClasses() {
        return OWLUtil.getReferringAnonymousClses(this);
    }

    @Override
    public Collection getSameAs() {
        return OWLUtil.getSameAs(this);
    }

    @Override
    public String getURI() {
        return this.getName();
    }

    @Override
    public Collection getVersionInfo() {
        return OWLUtil.getVersionInfo(this);
    }

    @Override
    public boolean hasPropertyValue(RDFProperty rDFProperty) {
        return OWLUtil.hasPropertyValue(this, rDFProperty);
    }

    @Override
    public boolean hasPropertyValue(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.hasPropertyValue(this, rDFProperty, bl);
    }

    @Override
    public boolean hasPropertyValue(RDFProperty rDFProperty, Object object) {
        return this.hasPropertyValue(rDFProperty, object, false);
    }

    @Override
    public boolean hasPropertyValue(RDFProperty rDFProperty, Object object, boolean bl) {
        return OWLUtil.hasPropertyValue(this, rDFProperty, object, bl);
    }

    @Override
    public boolean hasProtegeType(RDFSClass rDFSClass) {
        return OWLUtil.hasProtegeType(this, rDFSClass);
    }

    @Override
    public boolean hasProtegeType(RDFSClass rDFSClass, boolean bl) {
        return OWLUtil.hasProtegeType(this, rDFSClass, bl);
    }

    @Override
    public boolean hasRDFType(RDFSClass rDFSClass) {
        return OWLUtil.hasRDFType(this, rDFSClass);
    }

    @Override
    public boolean hasRDFType(RDFSClass rDFSClass, boolean bl) {
        return OWLUtil.hasRDFType(this, rDFSClass, bl);
    }

    @Override
    public boolean isAnonymous() {
        return this.getOWLModel().isAnonymousResourceName(this.getName());
    }

    @Override
    public boolean isValidPropertyValue(RDFProperty rDFProperty, Object object) {
        return OWLUtil.isValidPropertyValue(this, rDFProperty, object);
    }

    @Override
    public Iterator listPropertyValues(RDFProperty rDFProperty) {
        return OWLUtil.listPropertyValues(this, rDFProperty, false);
    }

    @Override
    public Iterator listPropertyValuesAs(RDFProperty rDFProperty, Class clazz) {
        return OWLUtil.listPropertyValuesAs(this, rDFProperty, clazz);
    }

    @Override
    public Iterator listPropertyValues(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.listPropertyValues(this, rDFProperty, bl);
    }

    @Override
    public Iterator listRDFTypes() {
        return this.getRDFTypes().iterator();
    }

    @Override
    public void removeComment(String string) {
        OWLUtil.removeComment(this, string);
    }

    @Override
    public void removeDifferentFrom(RDFResource rDFResource) {
        OWLUtil.removeDifferentFrom(this, rDFResource);
    }

    @Override
    public void removeIsDefinedBy(RDFResource rDFResource) {
        OWLUtil.removeIsDefinedBy(this, rDFResource);
    }

    @Override
    public void removeLabel(String string, String string2) {
        OWLUtil.removeLabel(this, string, string2);
    }

    @Override
    public void removePropertyValue(RDFProperty rDFProperty, Object object) {
        OWLUtil.removePropertyValue(this, rDFProperty, object);
    }

    @Override
    public void removePropertyValueListener(PropertyValueListener propertyValueListener) {
        OWLUtil.removePropertyValueListener(this, propertyValueListener);
    }

    @Override
    public void removeProtegeType(RDFSClass rDFSClass) {
        OWLUtil.removeProtegeType(this, rDFSClass);
    }

    @Override
    public void removeRDFType(RDFSClass rDFSClass) {
        OWLUtil.removeRDFType(this, rDFSClass);
    }

    @Override
    public void removeResourceListener(ResourceListener resourceListener) {
        OWLUtil.removeResourceListener(this, resourceListener);
    }

    @Override
    public void removeSameAs(RDFResource rDFResource) {
        OWLUtil.removeSameAs(this, rDFResource);
    }

    @Override
    public void removeVersionInfo(String string) {
        OWLUtil.removeVersionInfo(this, string);
    }

    @Override
    public void setComment(String string) {
        OWLUtil.setComment(this, string);
    }

    @Override
    public void setComments(Collection collection) {
        OWLUtil.setComments(this, collection);
    }

    @Override
    public void setDomain(RDFSClass rDFSClass) {
        if (rDFSClass == null) {
            this.setDomains(Collections.EMPTY_LIST);
        } else {
            this.setDomains(Collections.singleton(rDFSClass));
        }
    }

    @Override
    public void setDomains(Collection collection) {
        this.setDirectOwnSlotValues(this.getOWLModel().getRDFSDomainProperty(), collection);
    }

    @Override
    public void setInferredTypes(Collection collection) {
        OWLUtil.setInferredTypes(this, collection);
    }

    @Override
    public void setDocumentation(String string) {
        OWLUtil.setComment(this, string);
    }

    @Override
    public void setPropertyValue(RDFProperty rDFProperty, Object object) {
        OWLUtil.setPropertyValue(this, rDFProperty, object);
    }

    @Override
    public void setPropertyValues(RDFProperty rDFProperty, Collection collection) {
        OWLUtil.setPropertyValues(this, rDFProperty, collection);
    }

    @Override
    public void setProtegeType(RDFSClass rDFSClass) {
        OWLUtil.setProtegeType(this, rDFSClass);
    }

    @Override
    public void setProtegeTypes(Collection collection) {
        OWLUtil.setProtegeTypes(this, collection);
    }

    @Override
    public void setRDFType(RDFSClass rDFSClass) {
        OWLUtil.setRDFType(this, rDFSClass);
    }

    @Override
    public void setRDFTypes(Collection collection) {
        OWLUtil.setRDFTypes(this, collection);
    }

    @Override
    public boolean isDeprecated() {
        RDFSNamedClass rDFSNamedClass = this.getOWLModel().getRDFSNamedClass(OWLNames.Cls.DEPRECATED_PROPERTY);
        return this.getProtegeTypes().contains(rDFSNamedClass);
    }

    @Override
    public void setDeprecated(boolean bl) {
        if (this.isDeprecated() != bl) {
            RDFSNamedClass rDFSNamedClass = this.getOWLModel().getRDFSNamedClass(OWLNames.Cls.DEPRECATED_PROPERTY);
            if (bl) {
                this.addProtegeType(rDFSNamedClass);
            } else {
                this.removeProtegeType(rDFSNamedClass);
            }
        }
    }

    @Override
    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitRDFProperty(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSimpleName());
        stringBuffer.append("(");
        stringBuffer.append(this.getName());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

