/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOWLOntology
extends DefaultRDFIndividual
implements OWLOntology {
    private static final Logger log = Log.getLogger(DefaultOWLOntology.class);

    public DefaultOWLOntology(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultOWLOntology() {
    }

    @Override
    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitOWLOntology(this);
    }

    @Override
    public void addBackwardCompatibleWith(String string) {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.BACKWARD_COMPATIBLE_WITH);
        this.addOwnSlotValue(slot, string);
    }

    @Override
    public void addImports(String string) {
        Object object = this.getKnowledgeBase().getFrame(string);
        if (object == null) {
            object = this.getOWLModel().createRDFUntypedResource(string);
        }
        if (object != null && (object instanceof RDFExternalResource || object instanceof RDFUntypedResource || object instanceof OWLOntology)) {
            this.addImportsHelper(object);
        } else {
            log.warning("could not add import " + string + "to the import tree.");
        }
    }

    @Override
    public void addImports(URI uRI) {
        this.addImports(uRI.toString());
    }

    @Override
    public void addImports(RDFExternalResource rDFExternalResource) {
        this.addImportsHelper(rDFExternalResource);
    }

    @Override
    public void addImports(RDFUntypedResource rDFUntypedResource) {
        this.addImportsHelper(rDFUntypedResource);
    }

    @Override
    public void addImports(OWLOntology oWLOntology) {
        this.addImportsHelper(oWLOntology);
    }

    private void addImportsHelper(Object object) {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.IMPORTS);
        this.addOwnSlotValue(slot, object);
    }

    @Override
    public void addIncompatibleWith(String string) {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.INCOMPATIBLE_WITH);
        this.addOwnSlotValue(slot, string);
    }

    @Override
    public void addPriorVersion(String string) {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.PRIOR_VERSION);
        this.addOwnSlotValue(slot, string);
    }

    @Override
    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof OWLOntology) {
            OWLOntology oWLOntology = (OWLOntology)rDFObject;
            return this.getURI().equals(oWLOntology.getURI());
        }
        return false;
    }

    @Override
    public Collection getBackwardCompatibleWith() {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.BACKWARD_COMPATIBLE_WITH);
        return this.getOwnSlotValues(slot);
    }

    @Override
    public String getBrowserText() {
        String string = this.getOntologyURI();
        if (string == null) {
            return "DefaultOntology";
        }
        return "Ontology(" + string + ")";
    }

    @Override
    public Icon getIcon() {
        Icon icon = OWLIcons.getImageIcon("OWLOntology");
        if (!this.isAssociatedTriplestoreEditable() || !this.isActive()) {
            icon = OWLIcons.getReadOnlyIcon(icon, "RDFIndividualFrame");
        }
        return icon;
    }

    @Override
    public Collection<String> getImports() {
        Collection collection = this.getImportResources();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : collection) {
            if (!(e instanceof RDFResource)) continue;
            arrayList.add(((RDFResource)e).getURI());
        }
        return arrayList;
    }

    @Override
    public Collection getImportResources() {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.IMPORTS);
        return this.getOwnSlotValues(slot);
    }

    @Override
    public Collection getIncompatibleWith() {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.INCOMPATIBLE_WITH);
        return this.getOwnSlotValues(slot);
    }

    @Override
    public String getOntologyURI() {
        return this.getURI();
    }

    @Override
    public Collection getPriorVersions() {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.PRIOR_VERSION);
        return this.getOwnSlotValues(slot);
    }

    @Override
    public void removeBackwardCompatibleWith(String string) {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.BACKWARD_COMPATIBLE_WITH);
        this.removeOwnSlotValue(slot, string);
    }

    @Override
    public void removeImports(String string) {
        Object var2_2 = null;
        Collection collection = this.getImportResources();
        for (Object e : collection) {
            String string2 = ((RDFResource)e).getURI();
            if (!string2.equals(string)) continue;
            var2_2 = e;
            break;
        }
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.IMPORTS);
        this.removeOwnSlotValue(slot, var2_2);
    }

    @Override
    public void removeIncompatibleWith(String string) {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.INCOMPATIBLE_WITH);
        this.removeOwnSlotValue(slot, string);
    }

    @Override
    public void removePriorVersion(String string) {
        Slot slot = this.getKnowledgeBase().getSlot(OWLNames.Slot.PRIOR_VERSION);
        this.removeOwnSlotValue(slot, string);
    }

    public boolean isAssociatedTriplestoreEditable() {
        boolean bl = false;
        OWLModel oWLModel = this.getOWLModel();
        TripleStore tripleStore = oWLModel.getTripleStoreModel().getTopTripleStore();
        if (this.equals(tripleStore.getOWLOntology())) {
            bl = true;
        } else {
            RepositoryManager repositoryManager = oWLModel.getRepositoryManager();
            URI uRI = null;
            try {
                uRI = new URI(this.getURI());
                Repository repository = repositoryManager.getRepository(uRI);
                if (repository != null) {
                    bl = repository.isWritable(uRI);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return bl;
    }

    private boolean isActive() {
        TripleStore tripleStore = this.getOWLModel().getTripleStoreModel().getActiveTripleStore();
        return this.equals(tripleStore.getOWLOntology());
    }

    @Override
    public String toString() {
        return "OWLOntology(" + this.getName() + ")";
    }
}

