/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLRestriction;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import java.util.Set;

public class DefaultOWLHasValue
extends AbstractOWLRestriction
implements OWLHasValue {
    public static final char OPERATOR = '\u220b';

    public DefaultOWLHasValue(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultOWLHasValue() {
    }

    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitOWLHasValue(this);
    }

    public void checkFillerText(String string) throws Exception {
        DefaultOWLHasValue.checkFillerText(string, this.getOnProperty());
    }

    public static void checkFillerText(String string, RDFProperty rDFProperty) throws OWLClassParseException {
        if (rDFProperty != null && !(rDFProperty instanceof OWLDatatypeProperty)) {
            OWLModel oWLModel = rDFProperty.getOWLModel();
            OWLClassParser oWLClassParser = oWLModel.getOWLClassDisplay().getParser();
            oWLClassParser.checkHasValueFiller(oWLModel, string);
        }
    }

    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof OWLHasValue) {
            OWLHasValue oWLHasValue = (OWLHasValue)rDFObject;
            RDFObject rDFObject2 = oWLHasValue.getHasValue() instanceof RDFResource ? (RDFResource)oWLHasValue.getHasValue() : oWLHasValue.getOWLModel().asRDFSLiteral(oWLHasValue.getHasValue());
            RDFObject rDFObject3 = this.getHasValue() instanceof RDFResource ? (RDFResource)this.getHasValue() : oWLHasValue.getOWLModel().asRDFSLiteral(this.getHasValue());
            return this.getOnProperty().equalsStructurally(oWLHasValue.getOnProperty()) && rDFObject3.equalsStructurally(rDFObject2);
        }
        return false;
    }

    public RDFProperty getFillerProperty() {
        return this.getOWLModel().getRDFProperty(OWLNames.Slot.HAS_VALUE);
    }

    public String getFillerText() {
        Object object = this.getHasValue();
        if (object == null) {
            return "";
        }
        if (object instanceof RDFResource) {
            return ((RDFResource)object).getBrowserText();
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        return object.toString();
    }

    public Object getHasValue() {
        return this.getPropertyValue(this.getFillerProperty());
    }

    public String getIconName() {
        return "OWLHasValue";
    }

    public void getNestedNamedClasses(Set set) {
        if (this.getHasValue() instanceof RDFSClass) {
            ((RDFSClass)this.getHasValue()).getNestedNamedClasses(set);
        }
    }

    public char getOperator() {
        return '\u220b';
    }

    public void setFillerText(String string) throws Exception {
        OWLModel oWLModel = this.getOWLModel();
        OWLClassParser oWLClassParser = oWLModel.getOWLClassDisplay().getParser();
        if (this.getOnProperty() instanceof OWLDatatypeProperty) {
            Object object = string;
            try {
                object = oWLClassParser.parseHasValueFiller(oWLModel, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setHasValue(object);
        } else {
            Object object = oWLClassParser.parseHasValueFiller(oWLModel, string);
            this.setHasValue(object);
        }
    }

    public void setHasValue(Object object) {
        if (object instanceof Double) {
            object = new Float((Double)object);
        }
        if (object instanceof Long) {
            object = new Integer(((Long)object).intValue());
        }
        this.setDirectOwnSlotValue(this.getFillerProperty(), object);
    }
}

