/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLLogicalClass;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import java.util.Collection;
import java.util.Collections;

public class DefaultOWLComplementClass
extends AbstractOWLLogicalClass
implements OWLComplementClass {
    public static final char OPERATOR = '\u00ac';

    public DefaultOWLComplementClass(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultOWLComplementClass() {
    }

    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitOWLComplementClass(this);
    }

    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof OWLComplementClass) {
            return this.getComplement().equalsStructurally(((OWLComplementClass)rDFObject).getComplement());
        }
        return false;
    }

    public RDFSClass getComplement() {
        return (RDFSClass)this.getPropertyValue(this.getOperandsProperty());
    }

    public String getIconName() {
        return "OWLComplementClass";
    }

    public Collection getOperands() {
        RDFSClass rDFSClass = this.getComplement();
        if (rDFSClass == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singleton(rDFSClass);
    }

    public RDFProperty getOperandsProperty() {
        return this.getOWLModel().getRDFProperty(OWLNames.Slot.COMPLEMENT_OF);
    }

    public char getOperatorSymbol() {
        return '\u00ac';
    }

    public String getNestedBrowserText() {
        return this.getBrowserText();
    }

    public void setComplement(RDFSClass rDFSClass) {
        this.setOwnSlotValue(this.getOperandsProperty(), rDFSClass);
    }

    public void setOperands(Collection collection) {
        if (collection != null && collection.size() > 1) {
            throw new IllegalArgumentException("Only one complement class allowed.");
        }
        this.setPropertyValues(this.getOperandsProperty(), collection);
    }
}

