/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIndividual;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultOWLAllDifferent
extends DefaultOWLIndividual
implements OWLAllDifferent {
    public DefaultOWLAllDifferent(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultOWLAllDifferent() {
    }

    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitOWLAllDifferent(this);
    }

    public void addDistinctMember(RDFResource rDFResource) {
        RDFProperty rDFProperty = this.getOWLModel().getRDFProperty(OWLNames.Slot.DISTINCT_MEMBERS);
        RDFList rDFList = (RDFList)this.getPropertyValue(rDFProperty);
        if (rDFList == null) {
            RDFList rDFList2 = this.getOWLModel().createRDFList();
            rDFList2.setFirst(rDFResource);
            rDFList2.setRest(this.getOWLModel().getRDFNil());
            this.setPropertyValue(rDFProperty, rDFList2);
        } else {
            rDFList.append(rDFResource);
        }
    }

    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof OWLAllDifferent) {
            OWLAllDifferent oWLAllDifferent = (OWLAllDifferent)rDFObject;
            return OWLUtil.equalsStructurally(this.getDistinctMembers(), oWLAllDifferent.getDistinctMembers());
        }
        return false;
    }

    public String getBrowserText() {
        String string = "AllDifferent {";
        Iterator iterator = this.listDistinctMembers();
        while (iterator.hasNext() && string.length() < 80) {
            RDFResource rDFResource = (RDFResource)iterator.next();
            string = string + rDFResource.getBrowserText();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        if (iterator.hasNext()) {
            string = string + "...";
        }
        string = string + "}";
        return string;
    }

    public Collection getDistinctMembers() {
        RDFProperty rDFProperty = this.getOWLModel().getRDFProperty(OWLNames.Slot.DISTINCT_MEMBERS);
        RDFList rDFList = (RDFList)this.getPropertyValue(rDFProperty);
        if (rDFList == null) {
            return Collections.EMPTY_LIST;
        }
        return rDFList.getValues();
    }

    public Iterator listDistinctMembers() {
        return this.getDistinctMembers().iterator();
    }

    public Set getReferringAnonymousClasses() {
        return Collections.EMPTY_SET;
    }

    public void removeDistinctMember(RDFResource rDFResource) {
        RDFProperty rDFProperty = this.getOWLModel().getRDFProperty(OWLNames.Slot.DISTINCT_MEMBERS);
        DefaultRDFList.removeListValue(this, rDFProperty, rDFResource);
    }

    public void setDistinctMembers(List list) {
        for (RDFResource rDFResource : this.getDistinctMembers()) {
            this.removeDistinctMember(rDFResource);
        }
        for (RDFResource rDFResource : list) {
            this.addDistinctMember(rDFResource);
        }
    }
}

