/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLSomeValuesFrom;

public abstract class AbstractOWLRestriction
extends AbstractOWLAnonymousClass
implements OWLRestriction {
    public AbstractOWLRestriction(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    AbstractOWLRestriction() {
    }

    public static void checkExpression(String string, RDFProperty rDFProperty, RDFProperty rDFProperty2) throws OWLClassParseException {
        if (rDFProperty == null) {
            throw new OWLClassParseException("Please select a property.");
        }
        if (string.trim().length() == 0) {
            throw new OWLClassParseException("Please enter a filler.");
        }
        if (rDFProperty2.getName().equals(OWLNames.Slot.HAS_VALUE)) {
            DefaultOWLHasValue.checkFillerText(string, rDFProperty);
        } else if (rDFProperty2.getName().equals(OWLNames.Slot.ALL_VALUES_FROM)) {
            DefaultOWLAllValuesFrom.checkFillerText(string, rDFProperty, rDFProperty2.getOWLModel());
        } else if (rDFProperty2.getName().equals(OWLNames.Slot.SOME_VALUES_FROM)) {
            DefaultOWLSomeValuesFrom.checkFillerText(string, rDFProperty);
        } else {
            AbstractOWLCardinalityBase.checkFillerText(string, rDFProperty);
        }
    }

    protected String getBrowserTextFiller() {
        return this.isDefined() ? this.getFillerText() : "?";
    }

    protected String getBrowserTextPropertyName() {
        RDFProperty rDFProperty = this.getOnProperty();
        if (rDFProperty == null) {
            return "<property>";
        }
        return rDFProperty.getBrowserText();
    }

    public String getNestedBrowserText() {
        return "(" + this.getBrowserText() + ")";
    }

    public RDFProperty getOnProperty() {
        RDFProperty rDFProperty = this.getOWLModel().getRDFProperty(OWLNames.Slot.ON_PROPERTY);
        return (RDFProperty)this.getDirectOwnSlotValue(rDFProperty);
    }

    public boolean isDefined() {
        return this.getOnProperty() != null && this.isFillerDefined();
    }

    protected boolean isFillerDefined() {
        return this.getDirectOwnSlotValue(this.getFillerProperty()) != null;
    }

    public void setOnProperty(RDFProperty rDFProperty) {
        RDFProperty rDFProperty2 = this.getOWLModel().getRDFProperty(OWLNames.Slot.ON_PROPERTY);
        this.setDirectOwnSlotValue(rDFProperty2, rDFProperty);
    }
}

