/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractOWLProperty
extends DefaultRDFProperty
implements OWLProperty {
    public AbstractOWLProperty(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    AbstractOWLProperty() {
    }

    public ImageIcon getBaseImageIcon() {
        return OWLIcons.getImageIcon(this.getIconName());
    }

    public Icon getIcon() {
        String string = this.getIconName();
        if (this.isEditable()) {
            return OWLIcons.getImageIcon(string);
        }
        if (this.isAnnotationProperty()) {
            return OWLIcons.getReadOnlyAnnotationPropertyIcon(OWLIcons.getImageIcon(string));
        }
        return OWLIcons.getReadOnlyPropertyIcon(OWLIcons.getImageIcon(string));
    }

    public String getIconName() {
        String string;
        String string2 = string = this.isObjectProperty() ? "OWLObjectProperty" : "OWLDatatypeProperty";
        if (this.isAnnotationProperty()) {
            string = "Annotation" + string;
        }
        return string;
    }

    public boolean isInverseFunctional() {
        RDFSNamedClass rDFSNamedClass = this.getOWLModel().getRDFSNamedClass(OWLNames.Cls.INVERSE_FUNCTIONAL_PROPERTY);
        if (this.hasProtegeType(rDFSNamedClass)) {
            return true;
        }
        for (RDFProperty rDFProperty : this.getSuperproperties(false)) {
            if (!(rDFProperty instanceof OWLProperty) || !((OWLProperty)rDFProperty).isInverseFunctional()) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectProperty() {
        return this.getKnowledgeBase().getSlot(this.getName()) instanceof OWLObjectProperty;
    }

    public void setAnnotationProperty(boolean bl) {
        this.updateRDFType(bl, (RDFSClass)this.getKnowledgeBase().getCls(OWLNames.Cls.ANNOTATION_PROPERTY));
    }

    public void setEquivalentProperties(Collection collection) {
        RDFProperty rDFProperty = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.setOwnSlotValues(rDFProperty, collection);
    }

    public void setInverseFunctional(boolean bl) {
        RDFSNamedClass rDFSNamedClass = this.getOWLModel().getRDFSNamedClass(OWLNames.Cls.INVERSE_FUNCTIONAL_PROPERTY);
        this.updateRDFType(bl, rDFSNamedClass);
    }
}

