/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLLogicalClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOWLNAryLogicalClass
extends AbstractOWLLogicalClass
implements OWLNAryLogicalClass {
    protected AbstractOWLNAryLogicalClass(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    protected AbstractOWLNAryLogicalClass() {
    }

    @Override
    public void addOperand(RDFSClass rDFSClass) {
        RDFList rDFList = (RDFList)this.getPropertyValue(this.getOperandsProperty());
        if (rDFList == null || this.getOWLModel().getRDFNil().equals(rDFList)) {
            rDFList = this.getOWLModel().createRDFList();
            this.setOwnSlotValue(this.getOperandsProperty(), rDFList);
        }
        rDFList.append(rDFSClass);
    }

    @Override
    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof AbstractOWLNAryLogicalClass) {
            AbstractOWLNAryLogicalClass abstractOWLNAryLogicalClass = (AbstractOWLNAryLogicalClass)rDFObject;
            if (this.getOperatorSymbol() == abstractOWLNAryLogicalClass.getOperatorSymbol()) {
                return OWLUtil.equalsStructurally(this.getOperands(), abstractOWLNAryLogicalClass.getOperands());
            }
        }
        return false;
    }

    @Override
    public Collection<RDFSNamedClass> getNamedOperands() {
        HashSet<RDFSNamedClass> hashSet = new HashSet<RDFSNamedClass>();
        for (RDFSClass rDFSClass : this.getOperands()) {
            if (!(rDFSClass instanceof RDFSNamedClass)) continue;
            hashSet.add((RDFSNamedClass)rDFSClass);
        }
        return hashSet;
    }

    @Override
    public String getNestedBrowserText() {
        return "(" + this.getBrowserText() + ")";
    }

    @Override
    public Collection<RDFSClass> getOperands() {
        Collection collection = null;
        try {
            collection = (Collection)new GetOperandsJob(this.getOWLModel(), this, this.getOperandsProperty()).execute();
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.WARNING, "Could not get operands for " + this, throwable);
        }
        return collection == null ? Collections.emptyList() : collection;
    }

    @Override
    public boolean hasOperandWithBrowserText(String string) {
        for (RDFSClass rDFSClass : this.getOperands()) {
            if (!string.equals(rDFSClass.getBrowserText())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSameOperands(OWLNAryLogicalClass oWLNAryLogicalClass) {
        HashSet<String> hashSet = new HashSet<String>();
        for (RDFSClass object : this.getOperands()) {
            hashSet.add(object.getBrowserText());
        }
        HashSet hashSet2 = new HashSet();
        for (RDFSClass rDFSClass : oWLNAryLogicalClass.getOperands()) {
            hashSet2.add(rDFSClass.getBrowserText());
        }
        if (hashSet.size() == hashSet2.size()) {
            hashSet.removeAll(hashSet2);
            return hashSet.isEmpty();
        }
        return false;
    }

    @Override
    public Iterator listOperands() {
        return this.getOperands().iterator();
    }

    @Override
    public void removeOperand(RDFSClass rDFSClass) {
        DefaultRDFList.removeListValue(this, this.getOperandsProperty(), rDFSClass);
    }

    private static class GetOperandsJob
    extends ProtegeJob {
        private OWLClass owlClass;
        private RDFProperty operandsProp;

        public GetOperandsJob(KnowledgeBase knowledgeBase, OWLNAryLogicalClass oWLNAryLogicalClass, RDFProperty rDFProperty) {
            super(knowledgeBase);
            this.owlClass = oWLNAryLogicalClass;
            this.operandsProp = rDFProperty;
        }

        public Object run() throws ProtegeException {
            RDFList rDFList = (RDFList)this.owlClass.getPropertyValue(this.operandsProp);
            if (rDFList == null) {
                return Collections.emptyList();
            }
            return rDFList.getValues();
        }

        public void localize(KnowledgeBase knowledgeBase) {
            super.localize(knowledgeBase);
            LocalizeUtils.localize((Object)this.owlClass, (KnowledgeBase)knowledgeBase);
            LocalizeUtils.localize((Object)this.operandsProp, (KnowledgeBase)knowledgeBase);
        }
    }
}

