/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import com.hp.hpl.jena.rdf.model.Model;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.FrameNameValidator;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.server.framestore.background.ServerCacheStateMachine;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.widget.WidgetMapper;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.graph.JenaModelFactory;
import edu.stanford.smi.protegex.owl.jena.parser.GlobalParserCache;
import edu.stanford.smi.protegex.owl.jena.parser.OWLImportsCache;
import edu.stanford.smi.protegex.owl.jena.parser.UnresolvedImportHandler;
import edu.stanford.smi.protegex.owl.jena.writersettings.JenaWriterSettings;
import edu.stanford.smi.protegex.owl.jena.writersettings.WriterSettings;
import edu.stanford.smi.protegex.owl.model.DefaultTaskManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.TaskManager;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplayFactory;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.model.factory.AlreadyImportedException;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.framestore.FacetUpdateFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStoreManager;
import edu.stanford.smi.protegex.owl.model.framestore.TypeUpdateFrameStore;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.ImportingOwlNamespaceManager;
import edu.stanford.smi.protegex.owl.model.impl.NoopProgressDisplay;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.project.DefaultOWLProject;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.model.project.SettingsMap;
import edu.stanford.smi.protegex.owl.model.query.QueryResults;
import edu.stanford.smi.protegex.owl.model.query.SPARQLQueryResults;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTuple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.TripleStoreModelImpl;
import edu.stanford.smi.protegex.owl.model.validator.DefaultPropertyValueValidator;
import edu.stanford.smi.protegex.owl.model.validator.PropertyValueValidator;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import edu.stanford.smi.protegex.owl.server.OwlStateMachine;
import edu.stanford.smi.protegex.owl.server.triplestore.ClientTripleStoreModel;
import edu.stanford.smi.protegex.owl.swrl.SWRLSystemFrames;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestLibrary;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.RenderingPanel;
import edu.stanford.smi.protegex.owl.ui.repository.UnresolvedImportUIHandler;
import edu.stanford.smi.protegex.owl.ui.widget.OWLFormWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import edu.stanford.smi.protegex.owl.util.OWLBrowserSlotPattern;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.ProtegeWriterSettings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOWLModel
extends DefaultKnowledgeBase
implements OWLModel {
    private static transient Logger log = Log.getLogger(AbstractOWLModel.class);
    public static final String OWL_MODEL_INIT_DEFAULTS_AT_CREATION = "owlmodel.init.defaults";
    public static final String OWL_MODEL_EXPAND_SHORT_NAME_IN_METHODS = "owlmodel.expand.short.name.in.methods";
    public static final String OWL_MODEL_IMPORT_NAMESPACES = "owlmodel.import.namespaces";
    private static final String SEARCH_SYNONYMS_KEY = "OWL-SEARCH-SYNONYMS-SLOTS";
    private static final String SEARCH_SYNONYMS_SEPARATOR = ",";
    private static final String DEFAULT_ANNOT_PROP_IN_VIEW_KEY = "OWL-DEFAULT-ANNOT-PROP-IN-VIEW";
    public static final String DEFAULT_TODO_PREFIX = "TODO";
    public static final String[] DEFAULT_USED_LANGUAGES = new String[]{"de", "en", "es", "fr", "it", "nl", "pt", "ru"};
    public static final String ANONYMOUS_BASE = "@";
    public static final String UNIQUE_SESSION_ID = UUID.randomUUID().toString().replace("-", "_");
    public static final String DEFAULT_ANNOTATION_PROPERTY_NAME = "annotationProperty";
    public static final String DEFAULT_CLASS_NAME = "Class";
    public static final String DEFAULT_DATATYPE_PROPERTY_NAME = "datatypeProperty";
    public static final String DEFAULT_INDIVIDUAL_NAME = "Individual";
    public static final String DEFAULT_OBJECT_PROPERTY_NAME = "objectProperty";
    public static final String DEFAULT_PROPERTY_NAME = "property";
    private static final String VALID_SYMBOLS = "-.";
    private static final String AUTO_REPAIR_ENABLED = "TestAutoRepairEnabled";
    private static final String TEST_LIST_NAME = "DisabledTest";
    private static final String TESTGROUP_LIST_NAME = "DisabledTestGroups";
    private boolean loadDefaults = false;
    private boolean expandShortNameInMethods = true;
    private boolean importNamespaces = true;
    private static UnresolvedImportHandler unresolvedImportHandler = new UnresolvedImportUIHandler();
    private Model jenaModel;
    private OWLClassDisplay owlClassRenderer = OWLClassDisplayFactory.getDefaultDisplay();
    private OWLProject owlProject;
    private PropertyValueValidator propertyValueValidator = new DefaultPropertyValueValidator();
    private Set<Cls> defaultAnonymousTypes = new HashSet<Cls>();
    private RDFSDatatypeFactory rdfsDatatypeFactory = new DefaultRDFSDatatypeFactory(this);
    private TaskManager taskManager;
    private GlobalParserCache globalParserCache;
    private RepositoryManager repositoryManager;
    private Collection<MessageError> parserErrors = new ArrayList<MessageError>();
    private OWLOntology topOWLOntology;
    private Slot protegeSubclassesDisjointProperty;
    private TripleStoreModel tripleStoreModel;
    private String defaultLanguage;
    private boolean defaultLanguageInitialized = false;
    private FrameListener defaultLanguageListener;
    private static int anonCount = 1;
    private ImportingOwlNamespaceManager importingNamespaceManager;
    private int lastGen = 1;

    public AbstractOWLModel(KnowledgeBaseFactory knowledgeBaseFactory) {
        super(knowledgeBaseFactory);
        this.setFrameFactory((FrameFactory)new SWRLJavaFactory((OWLModel)this));
        this.initializeLoadDefaults();
        this.initializeExpandShortNamesInMethods();
        this.intializeImportOwlNamespaces();
        this.initialize();
    }

    protected void initializeLoadDefaults() {
        this.loadDefaults = ApplicationProperties.getBooleanProperty((String)OWL_MODEL_INIT_DEFAULTS_AT_CREATION, (boolean)false);
    }

    protected void initializeExpandShortNamesInMethods() {
        this.expandShortNameInMethods = ApplicationProperties.getBooleanProperty((String)OWL_MODEL_EXPAND_SHORT_NAME_IN_METHODS, (boolean)true);
    }

    protected void intializeImportOwlNamespaces() {
        this.importNamespaces = ApplicationProperties.getBooleanProperty((String)OWL_MODEL_IMPORT_NAMESPACES, (boolean)true);
    }

    public void initialize() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Phase 2 initialization of OWL Model starts");
        }
        boolean bl = this.setGenerateEventsEnabled(false);
        this.setGenerateDeletingFrameEventsEnabled(true);
        this.setDefaultClsMetaCls(this.getOWLNamedClassClass());
        this.setDefaultSlotMetaCls(this.getOWLDatatypePropertyClass());
        this.setFrameNameValidator(new FrameNameValidator(){

            public String getErrorMessage(String string, Frame frame) {
                if (frame instanceof RDFUntypedResource) {
                    return "The name \"" + string + "\" is not a valid URI.";
                }
                String string2 = AbstractOWLModel.this.getValidNamespaceFrameName(string);
                return "The name \"" + string + "\" is not a valid OWL identifier.\n" + "You might want to use \"" + string2 + "\" instead.";
            }

            public boolean isValid(String string, Frame frame) {
                if (frame != null && !frame.isEditable()) {
                    return true;
                }
                if (frame instanceof RDFUntypedResource) {
                    if (string.equals(string.trim()) && string.length() > 4) {
                        try {
                            new URI(string);
                            return true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                NamespaceManager namespaceManager = AbstractOWLModel.this.getNamespaceManager();
                return AbstractOWLModel.isValidOWLFrameName(namespaceManager, string);
            }
        });
        this.defaultAnonymousTypes.add(this.getRDFListClass());
        this.defaultAnonymousTypes.add(this.getOWLAllValuesFromClass());
        this.defaultAnonymousTypes.add(this.getOWLSomeValuesFromClass());
        this.defaultAnonymousTypes.add(this.getOWLHasValueClass());
        this.defaultAnonymousTypes.add(this.getOWLMinCardinalityClass());
        this.defaultAnonymousTypes.add(this.getOWLMaxCardinalityClass());
        this.defaultAnonymousTypes.add(this.getOWLCardinalityClass());
        this.defaultAnonymousTypes.add(this.getOWLComplementClassClass());
        this.defaultAnonymousTypes.add(this.getOWLIntersectionClassClass());
        this.defaultAnonymousTypes.add(this.getOWLUnionClassClass());
        this.defaultAnonymousTypes.add(this.getOWLEnumeratedClassClass());
        this.defaultAnonymousTypes.add(this.getOWLAllDifferentClass());
        this.defaultAnonymousTypes.add(this.getOWLDataRangeClass());
        this.taskManager = new DefaultTaskManager();
        this.taskManager.setProgressDisplay(new NoopProgressDisplay());
        this.setGenerateEventsEnabled(bl);
    }

    @Deprecated
    protected void initializeDefaultAnnotationView() {
        try {
            Collection collection = this.getDefaultAnnotationPropertiesInView();
            if (collection == null || collection.size() == 0) {
                this.setDefaultAnnotationPropertiesInView(CollectionUtilities.createCollection((Object)this.getRDFSCommentProperty()));
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Error at initializing the default annotation view configuration (it's not bad)", exception);
        }
    }

    public URI loadImportedAssertions(URI uRI) throws OntologyLoadException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("=======================================================");
                log.fine("Processing import " + uRI);
            }
            TripleStoreModel tripleStoreModel = this.getTripleStoreModel();
            for (TripleStore object2 : tripleStoreModel.getTripleStores()) {
                if (!object2.getIOAddresses().contains(uRI.toString())) continue;
                log.info(uRI.toString() + " already imported as triple store " + object2.getName());
                return new URI(object2.getName());
            }
            TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
            Repository repository = this.getRepository(tripleStore, uRI);
            if (repository != null) {
                log.info("Importing " + uRI + " from location: " + repository.getOntologyLocationDescription(uRI));
                TripleStore tripleStore2 = repository.loadImportedAssertions(this, uRI);
                tripleStore2.addIOAddress(uRI.toString());
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Import Processing of " + uRI + " done");
                    log.fine("=======================================================");
                }
                this.getNamespaceManager().addImport(tripleStore2);
                return new URI(tripleStore2.getName());
            }
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new OntologyLoadException((Throwable)uRISyntaxException, uRISyntaxException.getMessage());
        }
    }

    private Repository getRepository(TripleStore tripleStore, URI uRI) {
        RepositoryManager repositoryManager = this.getRepositoryManager();
        Repository repository = repositoryManager.getRepository(uRI, true);
        if (repository == null && (repository = unresolvedImportHandler.handleUnresolvableImport(this, tripleStore, uRI)) != null) {
            repositoryManager.addProjectRepository(0, repository);
        }
        return repository;
    }

    public Collection<MessageError> getParserErrors() {
        return this.parserErrors;
    }

    public void addParserError(MessageError messageError) {
        this.parserErrors.add(messageError);
    }

    @Override
    public void addClassListener(ClassListener classListener) {
        if (!(classListener instanceof ClassAdapter)) {
            throw new IllegalArgumentException("Listener must be a ClassAdapter");
        }
        this.addClsListener(classListener);
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
        if (!(modelListener instanceof ModelAdapter)) {
            throw new IllegalArgumentException("Listener must be a ModelAdapter");
        }
        this.addKnowledgeBaseListener(modelListener);
    }

    @Override
    public void addPropertyListener(PropertyListener propertyListener) {
        if (!(propertyListener instanceof PropertyAdapter)) {
            throw new IllegalArgumentException("Listener must be a PropertyAdapter");
        }
        this.addSlotListener(propertyListener);
    }

    @Override
    public void addPropertyValueListener(PropertyValueListener propertyValueListener) {
        if (!(propertyValueListener instanceof PropertyValueAdapter)) {
            throw new IllegalArgumentException("Listener must be a PropertyValueAdapter");
        }
        this.addFrameListener(propertyValueListener);
    }

    @Override
    public void addResourceListener(ResourceListener resourceListener) {
        if (!(resourceListener instanceof ResourceAdapter)) {
            throw new IllegalArgumentException("Listener must be a ResourceAdapter");
        }
        this.addFrameListener(resourceListener);
    }

    protected SWRLJavaFactory createFrameFactory() {
        return new SWRLJavaFactory((OWLModel)this);
    }

    protected SWRLSystemFrames createSystemFrames() {
        return new SWRLSystemFrames(this);
    }

    @Override
    public synchronized SWRLSystemFrames getSystemFrames() {
        return (SWRLSystemFrames)super.getSystemFrames();
    }

    @Override
    public TaskManager getTaskManager() {
        if (this.taskManager == null) {
            this.taskManager = new DefaultTaskManager();
        }
        return this.taskManager;
    }

    @Override
    public void removeClassListener(ClassListener classListener) {
        this.removeClsListener(classListener);
    }

    @Override
    public void removeModelListener(ModelListener modelListener) {
        this.removeKnowledgeBaseListener(modelListener);
    }

    @Override
    public void removePropertyListener(PropertyListener propertyListener) {
        this.removeSlotListener(propertyListener);
    }

    @Override
    public void removePropertyValueListener(PropertyValueListener propertyValueListener) {
        this.removeFrameListener(propertyValueListener);
    }

    @Override
    public void removeResourceListener(ResourceListener resourceListener) {
        this.removeFrameListener(resourceListener);
    }

    @Override
    public void setOWLClassDisplay(OWLClassDisplay oWLClassDisplay) {
        assert (oWLClassDisplay != null);
        this.owlClassRenderer = oWLClassDisplay;
    }

    @Override
    public OWLJavaFactory getOWLJavaFactory() {
        return (OWLJavaFactory)super.getFrameFactory();
    }

    @Override
    public void setOWLJavaFactory(OWLJavaFactory oWLJavaFactory) {
        super.setFrameFactory((FrameFactory)oWLJavaFactory);
    }

    @Override
    public void setOWLProject(OWLProject oWLProject) {
        this.owlProject = oWLProject;
    }

    @Override
    public PropertyValueValidator getPropertyValueValidator() {
        return this.propertyValueValidator;
    }

    @Override
    public boolean isValidPropertyValue(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        if (this.getPropertyValueValidator() == null) {
            return true;
        }
        return this.getPropertyValueValidator().isValidPropertyValue(rDFResource, rDFProperty, object);
    }

    @Override
    public void setPropertyValueValidator(PropertyValueValidator propertyValueValidator) {
        this.propertyValueValidator = propertyValueValidator;
    }

    public void copyFacetValuesIntoNamedClses() {
        FacetUpdateFrameStore facetUpdateFrameStore = this.getFrameStoreManager().getFacetUpdateFrameStore();
        if (FrameStoreManager.isEnabled((FrameStore)facetUpdateFrameStore)) {
            facetUpdateFrameStore.copyFacetValuesIntoNamedClses();
        }
    }

    public void copyFacetValuesIntoProperties() {
        TypeUpdateFrameStore typeUpdateFrameStore = this.getFrameStoreManager().getTypeUpdateFrameStore();
        if (FrameStoreManager.isEnabled((FrameStore)typeUpdateFrameStore)) {
            typeUpdateFrameStore.updateFacetValues(this);
        }
    }

    @Override
    public String createNewResourceName(String string) {
        TripleStore tripleStore = this.getTripleStoreModel().getActiveTripleStore();
        String string2 = tripleStore.getDefaultNamespace();
        if (string2 == null) {
            string2 = tripleStore.getName() + "#";
        }
        return this.getUniqueFrameName(string2 + string);
    }

    @Override
    public OWLAllDifferent createOWLAllDifferent() {
        return (OWLAllDifferent)this.createInstance(null, this.getOWLAllDifferentClass());
    }

    @Override
    public OWLAllValuesFrom createOWLAllValuesFrom() {
        Collection collection = CollectionUtilities.createCollection((Object)this.getAnonymousRootCls());
        return (OWLAllValuesFrom)this.createCls(null, collection, this.getOWLAllValuesFromClass(), false);
    }

    @Override
    public OWLAllValuesFrom createOWLAllValuesFrom(RDFProperty rDFProperty, RDFResource rDFResource) {
        OWLAllValuesFrom oWLAllValuesFrom = this.createOWLAllValuesFrom();
        oWLAllValuesFrom.setOnProperty(rDFProperty);
        oWLAllValuesFrom.setFiller(rDFResource);
        return oWLAllValuesFrom;
    }

    @Override
    public OWLAllValuesFrom createOWLAllValuesFrom(RDFProperty rDFProperty, RDFSLiteral[] rDFSLiteralArray) {
        OWLAllValuesFrom oWLAllValuesFrom = this.createOWLAllValuesFrom();
        oWLAllValuesFrom.setOnProperty(rDFProperty);
        OWLDataRange oWLDataRange = this.createOWLDataRange(rDFSLiteralArray);
        oWLAllValuesFrom.setFiller(oWLDataRange);
        return oWLAllValuesFrom;
    }

    @Override
    public RDFProperty createAnnotationProperty(String string) {
        if (string == null) {
            string = this.createUniqueNewFrameName(DEFAULT_ANNOTATION_PROPERTY_NAME);
        }
        RDFProperty rDFProperty = this.createRDFProperty(string);
        rDFProperty.setProtegeType(this.getOWLAnnotationPropertyClass());
        return rDFProperty;
    }

    @Override
    public OWLDatatypeProperty createAnnotationOWLDatatypeProperty(String string) {
        OWLDatatypeProperty oWLDatatypeProperty = this.createOWLDatatypeProperty(string);
        oWLDatatypeProperty.setAllowsMultipleValues(true);
        oWLDatatypeProperty.addDirectType(this.getOWLAnnotationPropertyClass());
        return oWLDatatypeProperty;
    }

    @Override
    public OWLObjectProperty createAnnotationOWLObjectProperty(String string) {
        OWLObjectProperty oWLObjectProperty = this.createOWLObjectProperty(string);
        oWLObjectProperty.setAllowsMultipleValues(true);
        oWLObjectProperty.addDirectType(this.getOWLAnnotationPropertyClass());
        return oWLObjectProperty;
    }

    @Override
    public OWLCardinality createOWLCardinality() {
        Collection collection = CollectionUtilities.createCollection((Object)this.getAnonymousRootCls());
        return (OWLCardinality)this.createCls(null, collection, this.getOWLCardinalityClass(), false);
    }

    @Override
    public OWLCardinality createOWLCardinality(RDFProperty rDFProperty, int n) {
        OWLCardinality oWLCardinality = this.createOWLCardinality();
        oWLCardinality.setOnProperty(rDFProperty);
        oWLCardinality.setCardinality(n);
        return oWLCardinality;
    }

    @Override
    public OWLCardinality createOWLCardinality(RDFProperty rDFProperty, int n, RDFSClass rDFSClass) {
        OWLCardinality oWLCardinality = this.createOWLCardinality(rDFProperty, n);
        oWLCardinality.setValuesFrom(rDFSClass);
        return oWLCardinality;
    }

    @Override
    public synchronized Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        if (frameID == null || frameID.getName() == null) {
            frameID = this.isDefaultAnonymousType(collection2) ? new FrameID(this.getNextAnonymousResourceName()) : new FrameID(this.createUniqueNewFrameName(DEFAULT_CLASS_NAME));
        }
        return super.createCls(frameID, collection, collection2, bl);
    }

    @Override
    public OWLComplementClass createOWLComplementClass() {
        Collection collection = CollectionUtilities.createCollection((Object)this.getAnonymousRootCls());
        return (OWLComplementClass)this.createCls(null, collection, this.getOWLComplementClassClass(), false);
    }

    @Override
    public OWLComplementClass createOWLComplementClass(RDFSClass rDFSClass) {
        OWLComplementClass oWLComplementClass = this.createOWLComplementClass();
        oWLComplementClass.setComplement(rDFSClass);
        return oWLComplementClass;
    }

    @Override
    public OWLDataRange createOWLDataRange() {
        return (OWLDataRange)this.getOWLDataRangeClass().createAnonymousInstance();
    }

    @Override
    public OWLDataRange createOWLDataRange(RDFSLiteral[] rDFSLiteralArray) {
        OWLDataRange oWLDataRange = this.createOWLDataRange();
        RDFList rDFList = this.createRDFList(Arrays.asList(rDFSLiteralArray).iterator());
        oWLDataRange.setPropertyValue(this.getOWLOneOfProperty(), rDFList);
        return oWLDataRange;
    }

    @Override
    public OWLDatatypeProperty createOWLDatatypeProperty(String string) {
        return this.createOWLDatatypeProperty(string, this.getOWLDatatypePropertyClass());
    }

    @Override
    public OWLDatatypeProperty createOWLDatatypeProperty(String string, OWLNamedClass oWLNamedClass) {
        if (string == null) {
            string = this.createUniqueNewFrameName(DEFAULT_DATATYPE_PROPERTY_NAME);
        }
        String string2 = OWLUtil.getInternalFullName(this, string);
        OWLDatatypeProperty oWLDatatypeProperty = (OWLDatatypeProperty)this.createSlot(string2, oWLNamedClass, this.loadDefaults);
        oWLDatatypeProperty.setAllowsMultipleValues(true);
        oWLDatatypeProperty.setValueType(ValueType.ANY);
        return oWLDatatypeProperty;
    }

    @Override
    public OWLDatatypeProperty createOWLDatatypeProperty(String string, RDFSDatatype rDFSDatatype) {
        OWLDatatypeProperty oWLDatatypeProperty = this.createOWLDatatypeProperty(string);
        oWLDatatypeProperty.setAllowsMultipleValues(true);
        oWLDatatypeProperty.setRange(rDFSDatatype);
        return oWLDatatypeProperty;
    }

    @Override
    public OWLDatatypeProperty createOWLDatatypeProperty(String string, RDFSLiteral[] rDFSLiteralArray) {
        OWLDatatypeProperty oWLDatatypeProperty = this.createOWLDatatypeProperty(string);
        OWLDataRange oWLDataRange = this.createOWLDataRange(rDFSLiteralArray);
        oWLDatatypeProperty.setRange(oWLDataRange);
        return oWLDatatypeProperty;
    }

    protected FrameStoreManager createFrameStoreManager() {
        return new OWLFrameStoreManager(this);
    }

    @Override
    public OWLFrameStoreManager getFrameStoreManager() {
        return (OWLFrameStoreManager)super.getFrameStoreManager();
    }

    @Override
    public OWLEnumeratedClass createOWLEnumeratedClass() {
        Collection collection = CollectionUtilities.createCollection((Object)this.getAnonymousRootCls());
        return (OWLEnumeratedClass)this.createCls(null, collection, this.getOWLEnumeratedClassClass(), false);
    }

    @Override
    public OWLEnumeratedClass createOWLEnumeratedClass(Collection collection) {
        OWLEnumeratedClass oWLEnumeratedClass = this.createOWLEnumeratedClass();
        oWLEnumeratedClass.setOneOf(collection);
        return oWLEnumeratedClass;
    }

    @Override
    @Deprecated
    public RDFExternalResource createRDFExternalResource(String string) {
        throw new RuntimeException("The class RDFExternalResource has been replaced with RDFUntypedResource");
    }

    @Override
    public OWLHasValue createOWLHasValue() {
        Collection collection = CollectionUtilities.createCollection((Object)this.getAnonymousRootCls());
        return (OWLHasValue)this.createCls(null, collection, this.getOWLHasValueClass(), false);
    }

    @Override
    public OWLHasValue createOWLHasValue(RDFProperty rDFProperty, Object object) {
        OWLHasValue oWLHasValue = this.createOWLHasValue();
        oWLHasValue.setOnProperty(rDFProperty);
        oWLHasValue.setHasValue(object);
        return oWLHasValue;
    }

    @Override
    public synchronized Instance createInstance(String string, Cls cls) {
        return this.createInstance(new FrameID(string), CollectionUtilities.createCollection((Object)cls), this.loadDefaults);
    }

    public synchronized Instance createInstance(String string, Collection collection) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        return this.createInstance(new FrameID(string2), collection, this.loadDefaults);
    }

    @Override
    public synchronized Instance createInstance(FrameID frameID, Collection collection, boolean bl) {
        if (frameID == null || frameID.getName() == null) {
            if (this.isDefaultAnonymousType(collection)) {
                frameID = new FrameID(this.getNextAnonymousResourceName());
            } else {
                Cls cls = (Cls)collection.iterator().next();
                if (cls instanceof RDFSNamedClass) {
                    frameID = new FrameID(this.createNewResourceName(((RDFSClass)cls).getLocalName()));
                }
            }
        }
        return super.createInstance(frameID, collection, bl);
    }

    @Override
    public OWLIntersectionClass createOWLIntersectionClass() {
        Collection collection = CollectionUtilities.createCollection((Object)this.getAnonymousRootCls());
        return (OWLIntersectionClass)this.createCls(null, collection, this.getOWLIntersectionClassClass(), false);
    }

    @Override
    public OWLIntersectionClass createOWLIntersectionClass(Collection collection) {
        OWLIntersectionClass oWLIntersectionClass = this.createOWLIntersectionClass();
        for (RDFSClass rDFSClass : collection) {
            oWLIntersectionClass.addOperand(rDFSClass);
        }
        return oWLIntersectionClass;
    }

    @Override
    public RDFList createRDFList() {
        return (RDFList)this.getRDFListClass().createDirectInstance(null);
    }

    @Override
    public RDFList createRDFList(Iterator iterator) {
        return this.createListInstance(iterator, this.getRDFListClass());
    }

    @Override
    public RDFSClass createRDFSClassFromExpression(String string) {
        try {
            OWLClassParser oWLClassParser = this.getOWLClassDisplay().getParser();
            return oWLClassParser.parseClass(this, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public RDFSDatatype createRDFSDatatype(String string) {
        return (RDFSDatatype)this.getRDFSDatatypeClass().createDirectInstance(string);
    }

    private RDFList createListInstance(Iterator iterator, Cls cls) {
        RDFList rDFList;
        if (!iterator.hasNext()) {
            return this.getRDFNil();
        }
        RDFList rDFList2 = rDFList = (RDFList)cls.createDirectInstance(null);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            rDFList2.setFirst(e);
            if (!iterator.hasNext()) continue;
            RDFList rDFList3 = (RDFList)cls.createDirectInstance(null);
            rDFList2.setRest(rDFList3);
            rDFList2 = rDFList3;
        }
        rDFList2.setRest(this.getRDFNil());
        return rDFList;
    }

    @Override
    public OWLMaxCardinality createOWLMaxCardinality() {
        Set<RDFSNamedClass> set = Collections.singleton(this.getAnonymousRootCls());
        return (OWLMaxCardinality)this.createCls(null, set, this.getOWLMaxCardinalityClass(), false);
    }

    @Override
    public OWLMaxCardinality createOWLMaxCardinality(RDFProperty rDFProperty, int n) {
        OWLMaxCardinality oWLMaxCardinality = this.createOWLMaxCardinality();
        oWLMaxCardinality.setOnProperty(rDFProperty);
        oWLMaxCardinality.setCardinality(n);
        return oWLMaxCardinality;
    }

    @Override
    public OWLMaxCardinality createOWLMaxCardinality(RDFProperty rDFProperty, int n, RDFSClass rDFSClass) {
        OWLMaxCardinality oWLMaxCardinality = this.createOWLMaxCardinality(rDFProperty, n);
        oWLMaxCardinality.setValuesFrom(rDFSClass);
        return oWLMaxCardinality;
    }

    @Override
    public OWLMinCardinality createOWLMinCardinality() {
        Set<RDFSNamedClass> set = Collections.singleton(this.getAnonymousRootCls());
        return (OWLMinCardinality)this.createCls(null, set, this.getOWLMinCardinalityClass(), false);
    }

    @Override
    public OWLMinCardinality createOWLMinCardinality(RDFProperty rDFProperty, int n) {
        OWLMinCardinality oWLMinCardinality = this.createOWLMinCardinality();
        oWLMinCardinality.setOnProperty(rDFProperty);
        oWLMinCardinality.setCardinality(n);
        return oWLMinCardinality;
    }

    @Override
    public OWLMinCardinality createOWLMinCardinality(RDFProperty rDFProperty, int n, RDFSClass rDFSClass) {
        OWLMinCardinality oWLMinCardinality = this.createOWLMinCardinality(rDFProperty, n);
        oWLMinCardinality.setValuesFrom(rDFSClass);
        return oWLMinCardinality;
    }

    @Override
    public OWLNamedClass createOWLNamedClass(String string) {
        return this.createOWLNamedClass(string, this.loadDefaults);
    }

    @Override
    public OWLNamedClass createOWLNamedClass(String string, boolean bl) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        return (OWLNamedClass)this.createCls(string2, this.getRootClses(), this.getOWLNamedClassClass(), bl);
    }

    @Override
    public OWLNamedClass createOWLNamedClass(String string, OWLNamedClass oWLNamedClass) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        return (OWLNamedClass)this.createCls(string2, this.getRootClses(), oWLNamedClass, this.loadDefaults);
    }

    @Override
    public OWLNamedClass createOWLNamedSubclass(String string, OWLNamedClass oWLNamedClass) {
        OWLNamedClass oWLNamedClass2 = this.createOWLNamedClass(string);
        if (!oWLNamedClass.equals(this.getOWLThingClass())) {
            oWLNamedClass2.addSuperclass(oWLNamedClass);
            oWLNamedClass2.removeSuperclass(this.getOWLThingClass());
        }
        return oWLNamedClass2;
    }

    @Override
    public OWLObjectProperty createOWLObjectProperty(String string) {
        return this.createOWLObjectProperty(string, this.getOWLObjectPropertyClass());
    }

    @Override
    public OWLObjectProperty createOWLObjectProperty(String string, OWLNamedClass oWLNamedClass) {
        if (string == null) {
            string = this.createUniqueNewFrameName(DEFAULT_OBJECT_PROPERTY_NAME);
        }
        String string2 = OWLUtil.getInternalFullName(this, string);
        OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)this.createSlot(string2, oWLNamedClass, this.loadDefaults);
        oWLObjectProperty.setAllowsMultipleValues(true);
        oWLObjectProperty.setValueType(ValueType.INSTANCE);
        return oWLObjectProperty;
    }

    @Override
    public OWLObjectProperty createOWLObjectProperty(String string, Collection collection) {
        OWLObjectProperty oWLObjectProperty = this.createOWLObjectProperty(string);
        oWLObjectProperty.setUnionRangeClasses(collection);
        return oWLObjectProperty;
    }

    @Override
    public OWLOntology createOWLOntology(String string) throws AlreadyImportedException {
        if (this.getDefaultOWLOntology() == null) {
            FactoryUtils.addOntologyToTripleStore(this, this.tripleStoreModel.getTopTripleStore(), string);
        } else {
            OWLUtil.renameOntology(this, this.getDefaultOWLOntology(), string);
        }
        return this.getDefaultOWLOntology();
    }

    @Override
    @Deprecated
    public OWLOntology createOWLOntology(String string, String string2) throws AlreadyImportedException {
        return this.createOWLOntology(string2);
    }

    @Override
    public RDFSNamedClass createRDFSNamedClass(String string) {
        return this.createRDFSNamedClass(string, true);
    }

    @Override
    public RDFSNamedClass createRDFSNamedClass(String string, boolean bl) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        return (RDFSNamedClass)this.createCls(string2, this.getRootClses(), this.getRDFSNamedClassClass(), bl);
    }

    @Override
    public RDFSNamedClass createRDFSNamedClass(String string, Collection collection, RDFSClass rDFSClass) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        return (RDFSNamedClass)this.createCls(string2, collection, rDFSClass);
    }

    @Override
    public RDFSNamedClass createRDFSNamedSubclass(String string, RDFSNamedClass rDFSNamedClass) {
        RDFSNamedClass rDFSNamedClass2 = this.createRDFSNamedClass(string);
        if (!rDFSNamedClass.equals(this.getOWLThingClass())) {
            rDFSNamedClass2.addSuperclass(rDFSNamedClass);
            rDFSNamedClass2.removeSuperclass(this.getOWLThingClass());
        }
        return rDFSNamedClass2;
    }

    @Override
    public RDFUntypedResource createRDFUntypedResource(String string) {
        Instance instance = this.getRDFExternalResourceClass().createDirectInstance(string);
        return (RDFUntypedResource)instance;
    }

    @Override
    public RDFProperty createRDFProperty(String string) {
        if (string == null) {
            string = this.createUniqueNewFrameName(DEFAULT_PROPERTY_NAME);
        }
        String string2 = OWLUtil.getInternalFullName(this, string);
        RDFProperty rDFProperty = (RDFProperty)this.createSlot(string2, this.getRDFPropertyClass(), this.loadDefaults);
        rDFProperty.setValueType(ValueType.ANY);
        rDFProperty.setAllowsMultipleValues(true);
        return rDFProperty;
    }

    @Override
    public Triple createTriple(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return new DefaultTriple(rDFResource, rDFProperty, object);
    }

    @Override
    public Set<String> getAllImports() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object e : this.getOWLOntologies()) {
            OWLOntology oWLOntology = (OWLOntology)e;
            for (String string : oWLOntology.getImports()) {
                if (string instanceof RDFResource) {
                    hashSet.add(((RDFResource)((Object)string)).getURI());
                    continue;
                }
                if (!(string instanceof String)) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    @Override
    public RDFSNamedClass createSubclass(String string, RDFSNamedClass rDFSNamedClass) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        return (RDFSNamedClass)this.createCls(string2, Collections.singleton(rDFSNamedClass));
    }

    @Override
    public RDFSNamedClass createSubclass(String string, Collection collection) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        return (RDFSNamedClass)this.createCls(string2, collection);
    }

    @Override
    public OWLSomeValuesFrom createOWLSomeValuesFrom() {
        Collection collection = CollectionUtilities.createCollection((Object)this.getAnonymousRootCls());
        return (OWLSomeValuesFrom)this.createCls(null, collection, this.getOWLSomeValuesFromClass(), false);
    }

    @Override
    public OWLSomeValuesFrom createOWLSomeValuesFrom(RDFProperty rDFProperty, RDFResource rDFResource) {
        OWLSomeValuesFrom oWLSomeValuesFrom = this.createOWLSomeValuesFrom();
        oWLSomeValuesFrom.setOnProperty(rDFProperty);
        oWLSomeValuesFrom.setFiller(rDFResource);
        return oWLSomeValuesFrom;
    }

    @Override
    public OWLSomeValuesFrom createOWLSomeValuesFrom(RDFProperty rDFProperty, RDFSLiteral[] rDFSLiteralArray) {
        OWLSomeValuesFrom oWLSomeValuesFrom = this.createOWLSomeValuesFrom();
        oWLSomeValuesFrom.setOnProperty(rDFProperty);
        OWLDataRange oWLDataRange = this.createOWLDataRange(rDFSLiteralArray);
        oWLSomeValuesFrom.setFiller(oWLDataRange);
        return oWLSomeValuesFrom;
    }

    @Override
    public RDFProperty createSubproperty(String string, RDFProperty rDFProperty) {
        ArrayList arrayList = new ArrayList(rDFProperty.getProtegeTypes());
        Cls cls = (Cls)CollectionUtilities.getFirstItem(arrayList);
        String string2 = OWLUtil.getInternalFullName(this, string);
        Slot slot = this.createSlot(string2, cls, Collections.singleton(rDFProperty), true);
        arrayList.remove(cls);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Cls cls2;
            Cls cls3 = cls2 = (Cls)iterator.next();
            slot.addDirectType(cls3);
        }
        return (RDFProperty)slot;
    }

    public boolean endTransaction() {
        return this.commitTransaction();
    }

    @Override
    public QueryResults executeSPARQLQuery(String string) throws Exception {
        String string2 = SPARQLQueryResults.createPrefixDeclarations(this) + string;
        return SPARQLQueryResults.create(this, string2);
    }

    @Override
    public OWLUnionClass createOWLUnionClass() {
        Collection collection = CollectionUtilities.createCollection((Object)this.getAnonymousRootCls());
        return (OWLUnionClass)this.createCls(null, collection, this.getOWLUnionClassClass(), false);
    }

    @Override
    public OWLUnionClass createOWLUnionClass(Collection collection) {
        OWLUnionClass oWLUnionClass = this.createOWLUnionClass();
        for (Cls cls : collection) {
            if (cls instanceof RDFSClass) {
                oWLUnionClass.addOperand((RDFSClass)cls);
                continue;
            }
            Log.getLogger().warning(cls + " is not an RDFSClass. It will not be added to the OWLUnionClass.");
        }
        return oWLUnionClass;
    }

    @Override
    public RDFSLiteral createRDFSLiteral(Object object) {
        return DefaultRDFSLiteral.create(this, object);
    }

    @Override
    public RDFSLiteral createRDFSLiteral(String string, RDFSDatatype rDFSDatatype) {
        return DefaultRDFSLiteral.create((OWLModel)this, string, rDFSDatatype);
    }

    @Override
    public RDFSLiteral createRDFSLiteral(String string, String string2) {
        return DefaultRDFSLiteral.create((OWLModel)this, string, string2);
    }

    @Override
    public Object createRDFSLiteralOrString(String string, String string2) {
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            return this.createRDFSLiteral(string, string2);
        }
        return string;
    }

    public static void deleteAllFrames(OWLModel oWLModel) {
        Object object3;
        Object object22;
        OWLModel oWLModel2 = oWLModel;
        for (Object object22 : oWLModel2.getInstances()) {
            object3 = object22;
            if (object3 instanceof Cls || !object3.isEditable() && !object3.isIncluded() || object3.isSystem()) continue;
            oWLModel2.deleteFrame((Frame)object3);
        }
        ArrayList arrayList = new ArrayList();
        for (Object object3 : oWLModel.getUserDefinedOWLNamedClasses()) {
            if (!object3.isEditable() && !object3.isIncluded() || object3.isSystem() || !object3.isMetaCls()) continue;
            arrayList.add(object3);
        }
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            object3 = (Cls)object22.next();
            for (Instance instance : object3.getInstances()) {
                Frame frame = (Frame)instance;
                oWLModel2.deleteFrame(frame);
            }
        }
        for (Object object3 : oWLModel.getUserDefinedOWLNamedClasses()) {
            if (object3.getDirectType() == null || !object3.isEditable() && !object3.isIncluded() || object3.isSystem()) continue;
            oWLModel2.deleteFrame((Frame)object3);
        }
    }

    @Override
    public void deleteCls(Cls cls) {
        this.getHeadFrameStore().deleteCls(cls);
        cls.markDeleted(true);
    }

    @Override
    public Collection getOWLAllDifferents() {
        RDFSNamedClass rDFSNamedClass = this.getOWLAllDifferentClass();
        return rDFSNamedClass.getDirectInstances();
    }

    @Override
    public Collection<RDFProperty> getOWLAnnotationProperties() {
        return this.getOWLAnnotationPropertyClass().getInstances(true);
    }

    @Override
    public synchronized String getBrowserText(Instance instance) {
        Cls cls;
        if (!(instance instanceof RDFResource)) {
            return super.getBrowserText(instance);
        }
        if (instance.isDeleted()) {
            return "<deleted>";
        }
        if (instance instanceof OWLAnonymousClass) {
            return instance.getBrowserText();
        }
        if (this.getProject() == null) {
            return this.getName((Frame)instance);
        }
        Cls cls2 = cls = instance instanceof RDFResource ? OWLUI.getOneNamedDirectTypeWithBrowserPattern((RDFResource)instance) : instance.getDirectType();
        if (cls == null) {
            return this.getMissingTypeString(instance);
        }
        OWLBrowserSlotPattern oWLBrowserSlotPattern = null;
        try {
            oWLBrowserSlotPattern = (OWLBrowserSlotPattern)this.getProject().getBrowserSlotPattern(cls);
        }
        catch (ClassCastException classCastException) {
            try {
                oWLBrowserSlotPattern = OWLUI.fixBrowserSlotPattern(this.getProject(), cls);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Error at getting browser slot pattern for " + instance, exception);
            }
        }
        catch (Exception exception) {
            oWLBrowserSlotPattern = null;
            Log.getLogger().log(Level.WARNING, "Unknown error at getting the browser slot for: " + cls, exception);
        }
        if (oWLBrowserSlotPattern == null) {
            return this.getDisplaySlotNotSetString(instance);
        }
        String string = oWLBrowserSlotPattern.getBrowserText(instance);
        if (string == null) {
            string = this.getDisplaySlotPatternValueNotSetString(instance, oWLBrowserSlotPattern);
        }
        return string;
    }

    protected String getDisplaySlotPatternValueNotSetString(Instance instance, BrowserSlotPattern browserSlotPattern) {
        return NamespaceUtil.getPrefixedName(this, instance.getName());
    }

    protected String getDisplaySlotNotSetString(Instance instance) {
        return NamespaceUtil.getPrefixedName(this, instance.getName());
    }

    @Override
    public Collection getChangedInferredClasses() {
        return this.getClsesWithClassificationStatus(3);
    }

    @Override
    public Set<RDFSNamedClass> getCommonSuperclasses(Collection<RDFSNamedClass> collection) {
        Collection collection2;
        Object object;
        HashSet<RDFSNamedClass> hashSet = new HashSet<RDFSNamedClass>();
        boolean bl = true;
        for (RDFSNamedClass object22 : collection) {
            if (bl) {
                object = object22.getSuperclasses(true);
                collection2 = object.iterator();
                while (collection2.hasNext()) {
                    Object e = collection2.next();
                    if (!(e instanceof RDFSNamedClass)) continue;
                    hashSet.add((RDFSNamedClass)e);
                }
                bl = false;
                continue;
            }
            hashSet.retainAll(object22.getSuperclasses(true));
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (RDFSNamedClass)iterator.next();
            if (!hashSet.contains(object)) continue;
            collection2 = object.getSuperclasses(true);
            if (collection2.contains(object)) {
                collection2 = new HashSet(collection2);
                collection2.remove(object);
            }
            hashSet.removeAll(collection2);
        }
        return hashSet;
    }

    @Override
    public RDFSNamedClass getCommonSuperclass(Collection<RDFSNamedClass> collection) {
        return this.getCommonSuperclasses(collection).iterator().next();
    }

    private Collection getClsesWithClassificationStatus(int n) {
        RDFProperty rDFProperty = this.getProtegeClassificationStatusProperty();
        Collection collection = this.getFramesWithValue(rDFProperty, null, false, new Integer(n));
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame : collection) {
            if (!(frame instanceof OWLNamedClass)) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }

    @Override
    public OWLDatatypeProperty getOWLDatatypeProperty(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        return (OWLDatatypeProperty)this.getSlot(string2);
    }

    @Override
    public String getDefaultLanguage() {
        String string;
        Object object;
        OWLOntology oWLOntology;
        String string2 = ApplicationProperties.getString((String)RenderingPanel.DEFAULT_LANGUATE_PROPERTY);
        if (string2 != null) {
            return string2;
        }
        if (this.defaultLanguageInitialized) {
            return this.defaultLanguage;
        }
        this.defaultLanguage = null;
        RDFProperty rDFProperty = this.getDefaultLanguageProperty();
        if (rDFProperty != null && (oWLOntology = this.getDefaultOWLOntology()) != null && (object = oWLOntology.getPropertyValue(rDFProperty)) instanceof String && (string = (String)object) != null && string.length() > 0) {
            this.defaultLanguage = string;
        }
        this.defaultLanguageInitialized = true;
        return this.defaultLanguage;
    }

    public RDFProperty getDefaultLanguageProperty() {
        return this.getRDFProperty(ProtegeNames.getDefaultLanguageSlotName());
    }

    @Override
    public void resetOntologyCache() {
        this.detachDefaultLanguageListener();
        this.topOWLOntology = null;
    }

    @Override
    public OWLOntology getDefaultOWLOntology() {
        if (this.topOWLOntology == null) {
            this.topOWLOntology = this.getTripleStoreModel().getTopTripleStore().getOWLOntology();
            this.attachDefaultLanguageListener();
        }
        return this.topOWLOntology;
    }

    protected void attachDefaultLanguageListener() {
        if (this.topOWLOntology == null) {
            return;
        }
        this.defaultLanguageListener = this.createDefaultLanguageListener();
        this.topOWLOntology.addFrameListener(this.defaultLanguageListener);
    }

    protected void detachDefaultLanguageListener() {
        if (this.topOWLOntology == null) {
            return;
        }
        try {
            this.topOWLOntology.removeFrameListener(this.defaultLanguageListener);
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.WARNING, "Error in dispose of OWL Model: Could not detach default language listener", throwable);
        }
        this.defaultLanguage = null;
        this.defaultLanguageInitialized = false;
    }

    @Override
    public Collection getDomainlessProperties() {
        return this.getRootCls().getDirectTemplateSlots();
    }

    @Override
    public OWLProject getOWLProject() {
        if (this.owlProject == null) {
            this.owlProject = new DefaultOWLProject(this.getProject());
        }
        return this.owlProject;
    }

    @Override
    public RepositoryManager getRepositoryManager() {
        if (this.repositoryManager == null) {
            this.repositoryManager = new RepositoryManager(this);
            RepositoryFileManager repositoryFileManager = new RepositoryFileManager(this);
            repositoryFileManager.loadGlobalRepositories();
        }
        return this.repositoryManager;
    }

    @Override
    @Deprecated
    public RDFExternalResource getRDFExternalResource(String string) {
        return (RDFExternalResource)((Object)this.getRDFResource(string));
    }

    @Override
    public Collection getInconsistentClasses() {
        return this.getOWLNothing().getInferredSubclasses();
    }

    @Override
    public Model getJenaModel() {
        if (this.jenaModel == null) {
            this.jenaModel = JenaModelFactory.createModel(this);
        }
        return this.jenaModel;
    }

    @Override
    public OWLClassParser getOWLClassParser() {
        return this.getOWLClassDisplay().getParser();
    }

    public GlobalParserCache getGlobalParserCache() {
        if (this.globalParserCache == null) {
            this.globalParserCache = new GlobalParserCache(this);
        }
        return this.globalParserCache;
    }

    @Override
    public OWLClassDisplay getOWLClassDisplay() {
        return this.owlClassRenderer;
    }

    @Override
    public int getRDFResourceCount() {
        return this.getFrameCount() - 62;
    }

    @Override
    public Collection getRDFResources() {
        Collection collection = this.getFrames();
        return AbstractOWLModel.getRDFResources(this, collection);
    }

    @Override
    public Collection getRDFResourcesWithPropertyValue(RDFProperty rDFProperty, Object object) {
        Collection collection = this.getFramesWithValue(rDFProperty, null, false, object);
        return AbstractOWLModel.getRDFResources(this, collection);
    }

    public static Collection<RDFResource> getRDFResources(KnowledgeBase knowledgeBase, Collection<? extends Frame> collection) {
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        for (Frame frame : collection) {
            if (!(frame instanceof RDFResource)) continue;
            arrayList.add((RDFResource)frame);
        }
        AbstractOWLModel.removeProtegeSystemResources(knowledgeBase, arrayList);
        return arrayList;
    }

    @Override
    public RDFUntypedResource getRDFUntypedResource(String string, boolean bl) {
        RDFUntypedResource rDFUntypedResource = (RDFUntypedResource)this.getFrame(string);
        if (bl && rDFUntypedResource == null) {
            rDFUntypedResource = this.createRDFUntypedResource(string);
        }
        return rDFUntypedResource;
    }

    @Override
    public Collection<RDFResource> getResourceNameMatches(String string, int n) {
        Collection collection = this.getFrameNameMatches(string, n);
        return AbstractOWLModel.getRDFResources(this, collection);
    }

    @Override
    public OWLNamedClass getOWLNamedClass(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        return (OWLNamedClass)this.getCls(string2);
    }

    @Override
    public Collection getMatchingResources(RDFProperty rDFProperty, String string, int n) {
        Collection collection = this.getMatchingFrames(rDFProperty, null, false, string, n);
        return AbstractOWLModel.getRDFResources(this, collection);
    }

    @Override
    public String getNextAnonymousResourceName() {
        return AbstractOWLModel.getNextAnonymousResourceNameStatic();
    }

    public static String getNextAnonymousResourceNameStatic() {
        StringBuffer stringBuffer = new StringBuffer(ANONYMOUS_BASE);
        stringBuffer.append(anonCount++);
        stringBuffer.append('_');
        stringBuffer.append(UNIQUE_SESSION_ID);
        return stringBuffer.toString();
    }

    @Override
    public Collection getRDFProperties() {
        return AbstractOWLModel.getRDFResources(this, this.getSlots());
    }

    @Override
    public RDFResource getRDFResource(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        Frame frame = this.getFrame(string2);
        return frame instanceof RDFResource ? (RDFResource)frame : null;
    }

    @Override
    public RDFResource getRDFResourceAs(String string, Class clazz) {
        RDFResource rDFResource = this.getRDFResource(string);
        if (rDFResource != null) {
            return rDFResource.as(clazz);
        }
        return null;
    }

    @Override
    public OWLIndividual getOWLIndividual(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        return (OWLIndividual)this.getFrame(string2);
    }

    @Override
    public Collection getOWLRestrictionsOnProperty(RDFProperty rDFProperty) {
        return this.getFramesWithValue(this.getOWLOnPropertyProperty(), null, false, rDFProperty);
    }

    @Override
    public Collection getSearchSynonymProperties() {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        String string = this.getOWLProject().getSettingsMap().getString(SEARCH_SYNONYMS_KEY);
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(SEARCH_SYNONYMS_SEPARATOR)) {
                Frame frame = this.getFrame(string2);
                if (!(frame instanceof Slot)) continue;
                hashSet.add(frame);
            }
        }
        return hashSet;
    }

    public Collection getDefaultAnnotationPropertiesInView() {
        HashSet<Object> hashSet = new HashSet<Object>();
        String string = this.getOWLProject().getSettingsMap().getString(DEFAULT_ANNOT_PROP_IN_VIEW_KEY);
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(SEARCH_SYNONYMS_SEPARATOR)) {
                Frame frame = this.getFrame(string2);
                if (!(frame instanceof Slot)) continue;
                hashSet.add(frame);
            }
        } else {
            hashSet.add(this.getRDFSCommentProperty());
        }
        return hashSet;
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        return (OWLObjectProperty)this.getSlot(string2);
    }

    @Override
    public Collection getOWLOntologies() {
        return this.getOWLOntologyClass().getInstances();
    }

    @Override
    public OWLOntology getOWLOntologyByURI(String string) {
        OWLOntology oWLOntology = null;
        try {
            URI uRI = new URI(string);
            oWLOntology = (OWLOntology)this.getOWLOntologyByURI(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
        return oWLOntology;
    }

    @Override
    public RDFResource getOWLOntologyByURI(URI uRI) {
        return this.getRDFResource(uRI.toString());
    }

    @Override
    public Collection getOWLOntologyProperties() {
        return Arrays.asList(this.getOWLBackwardCompatibleWithProperty(), this.getOWLIncompatibleWithProperty(), this.getOWLPriorVersionProperty());
    }

    @Deprecated
    public Collection getOWLClasses() {
        return this.getRDFSClasses();
    }

    @Override
    public OWLFrameStore getOWLFrameStore() {
        return this.getFrameStoreManager().getOWLFrameStore();
    }

    @Override
    public Collection getOWLIndividuals() {
        return this.getOWLIndividuals(false);
    }

    @Override
    public Collection getOWLIndividuals(boolean bl) {
        Collection<RDFIndividual> collection = this.getRDFIndividuals(this.listOWLNamedClasses(), bl);
        Iterator<RDFIndividual> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isSystem()) continue;
            iterator.remove();
        }
        Iterator<OWLAnonymousClass> iterator2 = this.listOWLAnonymousClasses();
        while (iterator2.hasNext()) {
            OWLAnonymousClass oWLAnonymousClass = iterator2.next();
            Collection collection2 = oWLAnonymousClass.getInstances(false);
            for (Instance instance : collection2) {
                if (!(instance instanceof RDFIndividual) || instance.isSystem()) continue;
                collection.add((RDFIndividual)instance);
            }
        }
        return collection;
    }

    @Override
    public OWLProperty getOWLProperty(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        return (OWLProperty)this.getSlot(string2);
    }

    @Override
    public Collection getOWLSystemResources() {
        ArrayList<Frame> arrayList = new ArrayList<Frame>(Arrays.asList(this.getOWLSystemFramesArray()));
        arrayList.addAll(this.getRDFSDatatypeClass().getDirectInstances());
        return arrayList;
    }

    protected Frame[] getOWLSystemFramesArray() {
        Collection collection = this.getSystemFrames().getFrames();
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (Frame frame : collection) {
            if (!(frame instanceof RDFResource)) continue;
            hashSet.add(frame);
        }
        return hashSet.toArray(new Frame[hashSet.size()]);
    }

    @Override
    public RDFProperty getProtegeAllowedParentProperty() {
        return this.getRDFProperty(ProtegeNames.PROTEGE_OWL_NAMESPACE + "allowedParent");
    }

    @Override
    public ValueType getOWLValueType(String string) {
        return XMLSchemaDatatypes.getValueType(string);
    }

    @Override
    public RDFIndividual getRDFIndividual(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        return (RDFIndividual)this.getFrame(string2);
    }

    @Override
    public Collection<RDFIndividual> getRDFIndividuals() {
        return this.getRDFIndividuals(false);
    }

    @Override
    public Collection<RDFIndividual> getRDFIndividuals(boolean bl) {
        return this.getRDFIndividuals(this.listRDFSNamedClasses(), bl);
    }

    private Collection<RDFIndividual> getRDFIndividuals(Iterator iterator, boolean bl) {
        HashSet<RDFIndividual> hashSet = new HashSet<RDFIndividual>();
        while (iterator.hasNext()) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)iterator.next();
            if (!rDFSNamedClass.isVisible() && bl) continue;
            Collection collection = rDFSNamedClass.getInstances(false);
            for (Instance instance : collection) {
                if (!(instance instanceof RDFIndividual) || instance instanceof OWLOntology || instance instanceof RDFList || instance instanceof OWLAllDifferent || instance.isSystem()) continue;
                hashSet.add((RDFIndividual)instance);
            }
        }
        return hashSet;
    }

    @Override
    public RDFSNamedClass getRDFSNamedClass(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        return (RDFSNamedClass)this.getCls(string2);
    }

    @Override
    public RDFProperty getRDFProperty(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        return (RDFProperty)this.getSlot(string2);
    }

    @Override
    public RDFProperty getProtegeReadOnlyProperty() {
        return new DefaultOWLDatatypeProperty(this, new FrameID(ProtegeNames.getReadOnlySlotName()));
    }

    @Override
    public RDFSDatatype getRDFSDatatypeByName(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        return this.getRDFSDatatypeByURI(string2);
    }

    @Override
    public RDFSDatatype getRDFSDatatypeByURI(String string) {
        return string == null ? null : (RDFSDatatype)this.getFrame(string);
    }

    @Override
    public RDFSDatatype getRDFSDatatypeOfValue(Object object) {
        if (object instanceof RDFSLiteral) {
            return ((RDFSLiteral)object).getDatatype();
        }
        return DefaultRDFSLiteral.create(this, object).getDatatype();
    }

    @Override
    public Collection<RDFSDatatype> getRDFSDatatypes() {
        ArrayList<RDFSDatatype> arrayList = new ArrayList<RDFSDatatype>();
        for (RDFSDatatype rDFSDatatype : this.getRDFSDatatypeClass().getDirectInstances()) {
            if (rDFSDatatype.isAnonymous()) continue;
            arrayList.add(rDFSDatatype);
        }
        return arrayList;
    }

    @Override
    public RDFSNamedClass[] getOWLRestrictionMetaclasses() {
        return new RDFSNamedClass[]{this.getOWLAllValuesFromClass(), this.getOWLSomeValuesFromClass(), this.getOWLHasValueClass(), this.getOWLCardinalityClass(), this.getOWLMinCardinalityClass(), this.getOWLMaxCardinalityClass()};
    }

    @Override
    public RDFProperty[] getSystemAnnotationProperties() {
        return new RDFProperty[]{this.getRDFSSeeAlsoProperty(), this.getRDFSIsDefinedByProperty(), this.getRDFSLabelProperty(), this.getOWLVersionInfoProperty(), this.getOWLBackwardCompatibleWithProperty(), this.getOWLIncompatibleWithProperty(), this.getOWLPriorVersionProperty(), this.getRDFSCommentProperty()};
    }

    @Override
    public String getTodoAnnotationPrefix() {
        String string;
        OWLOntology oWLOntology;
        RDFProperty rDFProperty = this.getRDFProperty(ProtegeNames.getTodoPrefixSlotName());
        if (rDFProperty != null && (oWLOntology = this.getDefaultOWLOntology()) != null && (string = (String)oWLOntology.getPropertyValue(rDFProperty)) != null) {
            return string;
        }
        return DEFAULT_TODO_PREFIX;
    }

    @Override
    public OWLDatatypeProperty getTodoAnnotationProperty() {
        Object object;
        OWLOntology oWLOntology;
        RDFProperty rDFProperty = this.getRDFProperty(ProtegeNames.getTodoPropertySlotName());
        if (rDFProperty != null && (oWLOntology = this.getDefaultOWLOntology()) != null && (object = oWLOntology.getPropertyValue(rDFProperty)) instanceof OWLDatatypeProperty) {
            return (OWLDatatypeProperty)object;
        }
        return (OWLDatatypeProperty)this.getOWLVersionInfoProperty();
    }

    @Override
    public TripleStoreModel getTripleStoreModel() {
        if (this.tripleStoreModel == null) {
            this.tripleStoreModel = new TripleStoreModelImpl(this);
        }
        return this.tripleStoreModel;
    }

    @Override
    public String[] getUsedLanguages() {
        Collection collection;
        OWLOntology oWLOntology;
        RDFProperty rDFProperty = this.getRDFProperty(ProtegeNames.getUsedLanguagesSlotName());
        if (rDFProperty != null && (oWLOntology = this.getDefaultOWLOntology()) != null && (collection = oWLOntology.getPropertyValues(rDFProperty)).size() > 0) {
            return collection.toArray(new String[0]);
        }
        return DEFAULT_USED_LANGUAGES;
    }

    @Override
    public Collection getUserDefinedOWLNamedClasses() {
        return this.getUserDefinedInstances(this.getOWLNamedClassClass());
    }

    @Override
    public Collection getUserDefinedRDFIndividuals(boolean bl) {
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        for (RDFResource rDFResource : this.getRDFIndividuals(bl)) {
            if (rDFResource.isSystem()) continue;
            arrayList.add(rDFResource);
        }
        return arrayList;
    }

    private Collection getUserDefinedInstances(Cls cls) {
        Collection collection = cls.getInstances();
        return this.getUserDefinedInstances(collection);
    }

    private Collection getUserDefinedInstances(Collection collection) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame : collection) {
            if (frame.isSystem()) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }

    @Override
    public Collection getUserDefinedOWLProperties() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getOWLDatatypePropertyClass().getInstances());
        arrayList.addAll(this.getOWLObjectPropertyClass().getInstances());
        return this.getUserDefinedInstances(arrayList);
    }

    @Override
    public Collection getUserDefinedOWLObjectProperties() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getOWLObjectPropertyClass().getInstances());
        return this.getUserDefinedInstances(arrayList);
    }

    @Override
    public Collection getUserDefinedOWLDatatypeProperties() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getOWLDatatypePropertyClass().getInstances());
        return this.getUserDefinedInstances(arrayList);
    }

    @Override
    public Collection getUserDefinedRDFProperties() {
        return this.getUserDefinedInstances(this.getRDFPropertyClass());
    }

    @Override
    public Collection getUserDefinedRDFSNamedClasses() {
        return this.getUserDefinedInstances(this.getRDFSNamedClassClass());
    }

    @Override
    public String getValueTypeURI(ValueType valueType) {
        return XMLSchemaDatatypes.getValueTypeURI(valueType);
    }

    @Override
    public Collection getVisibleUserDefinedOWLProperties() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getOWLDatatypePropertyClass().getInstances());
        arrayList.addAll(this.getOWLObjectPropertyClass().getInstances());
        return this.getVisibleUserDefinedInstances(arrayList);
    }

    private Collection getVisibleUserDefinedInstances(Cls cls) {
        Collection collection = cls.getInstances();
        return this.getVisibleUserDefinedInstances(collection);
    }

    private Collection getVisibleUserDefinedInstances(Collection collection) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame : collection) {
            if (frame.isSystem() || !frame.isVisible()) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }

    @Override
    public Collection getVisibleUserDefinedRDFProperties() {
        return this.getVisibleUserDefinedInstances(this.getRDFPropertyClass());
    }

    @Override
    public RDFSLiteral asRDFSLiteral(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RDFSLiteral) {
            return (RDFSLiteral)object;
        }
        return this.createRDFSLiteral(object);
    }

    @Override
    public RDFObject asRDFObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RDFExternalResource) {
            return null;
        }
        if (object instanceof RDFResource) {
            return (RDFObject)object;
        }
        return this.createRDFSLiteral(object);
    }

    @Override
    public List asRDFSLiterals(Collection collection) {
        LinkedList<RDFSLiteral> linkedList = new LinkedList<RDFSLiteral>();
        for (Object e : collection) {
            linkedList.add(this.asRDFSLiteral(e));
        }
        return linkedList;
    }

    @Override
    @Deprecated
    public boolean isAnonymousResource(RDFResource rDFResource) {
        return rDFResource.isAnonymous();
    }

    @Override
    public boolean isAnonymousResourceName(String string) {
        return string.length() > 0 && string.charAt(0) == '@';
    }

    public boolean isDefaultAnonymousType(Cls cls) {
        return this.defaultAnonymousTypes.contains(cls);
    }

    public boolean isDefaultAnonymousType(Collection collection) {
        for (Cls cls : collection) {
            if (!this.isDefaultAnonymousType(cls)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean isOWLSystemFrame(Frame frame) {
        return this.getOWLSystemResources().contains(frame);
    }

    @Override
    public boolean isProtegeMetaOntologyImported() {
        String string = ProtegeNames.getSubclassesDisjointSlotName();
        return this.getSlot(string) != null;
    }

    public boolean isTrueInstance(Instance instance) {
        return !(instance instanceof Slot) && !(instance instanceof Cls) && !(instance instanceof Facet) && !(instance instanceof OWLAllDifferent) && !(instance instanceof RDFList) && !(instance instanceof OWLOntology);
    }

    @Override
    public Iterator<OWLAnonymousClass> listOWLAnonymousClasses() {
        ArrayList<OWLAnonymousClass> arrayList = new ArrayList<OWLAnonymousClass>();
        for (Instance instance : this.getCls(OWLNames.Cls.ANONYMOUS_CLASS).getInstances()) {
            if (!(instance instanceof OWLAnonymousClass)) continue;
            arrayList.add((OWLAnonymousClass)instance);
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator listOWLNamedClasses() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.getOWLNamedClassClass().getInstances(true)) {
            if (!(e instanceof OWLNamedClass)) continue;
            arrayList.add(e);
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator listRDFProperties() {
        return this.getRDFProperties().iterator();
    }

    @Override
    public Iterator listRDFSNamedClasses() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.getRDFSNamedClassClass().getInstances(true)) {
            if (!(e instanceof RDFSNamedClass)) continue;
            arrayList.add(e);
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator listReferences(Object object, int n) {
        if (object instanceof DefaultRDFSLiteral) {
            object = ((DefaultRDFSLiteral)object).getRawValue();
        }
        Iterator iterator = this.getReferences(object, n).iterator();
        ArrayList<DefaultTuple> arrayList = new ArrayList<DefaultTuple>();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            if (!(reference.getFrame() instanceof RDFResource) || !(reference.getSlot() instanceof RDFProperty)) continue;
            arrayList.add(new DefaultTuple((RDFResource)reference.getFrame(), (RDFProperty)reference.getSlot()));
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator listSubjects(RDFProperty rDFProperty) {
        return this.getHeadFrameStore().getFramesWithAnyDirectOwnSlotValue((Slot)rDFProperty).iterator();
    }

    @Override
    public synchronized Instance setDirectType(Instance instance, Cls cls) {
        if (instance instanceof OWLProperty && cls != null) {
            this.deleteRestrictionsDependingOnPropertyType((OWLProperty)instance, cls);
        }
        if (instance instanceof OWLNamedClass && cls.equals(this.getRDFSNamedClassClass())) {
            this.deleteAnonymousSuperclasses((OWLNamedClass)instance);
        }
        return super.setDirectType(instance, cls);
    }

    private void deleteAnonymousSuperclasses(OWLNamedClass oWLNamedClass) {
        Collection collection = oWLNamedClass.getNamedSuperclasses();
        for (Cls cls : new ArrayList(oWLNamedClass.getSuperclasses(false))) {
            if (!(cls instanceof OWLAnonymousClass)) continue;
            cls.delete();
        }
        for (RDFSClass rDFSClass : collection) {
            if (oWLNamedClass.isSubclassOf(rDFSClass)) continue;
            oWLNamedClass.addSuperclass(rDFSClass);
        }
    }

    private void deleteRestrictionsDependingOnPropertyType(OWLProperty oWLProperty, Cls cls) {
        OWLNamedClass oWLNamedClass = null;
        oWLNamedClass = oWLProperty instanceof OWLDatatypeProperty ? this.getOWLDatatypePropertyClass() : this.getOWLObjectPropertyClass();
        if (!cls.hasSuperclass((Cls)oWLNamedClass)) {
            this.getOWLFrameStore().deleteQuantifierRestrictions(oWLProperty);
        }
    }

    public void setLoadDefaults(boolean bl) {
        this.loadDefaults = bl;
    }

    @Override
    public void setProject(Project project) {
        super.setProject(project);
        project.setPrettyPrintSlotWidgetLabels(false);
        Slot slot = this.getSlot(":NAME");
        this.getRootCls().setDirectBrowserSlotPattern((BrowserSlotPattern)new OWLBrowserSlotPattern(slot));
        project.setDefaultClsWidgetClassName(OWLFormWidget.class.getName());
        project.setWidgetMapper((WidgetMapper)new OWLWidgetMapper(this));
        this.getProtegeClassificationStatusProperty().setVisible(false);
        this.getProtegeInferredSuperclassesProperty().setVisible(false);
        this.getProtegeInferredSubclassesProperty().setVisible(false);
        this.getOWLOntologyClass().setVisible(false);
    }

    protected FrameListener createDefaultLanguageListener() {
        return new FrameAdapter(){

            public void ownSlotValueChanged(FrameEvent frameEvent) {
                Slot slot = frameEvent.getSlot();
                if (slot.equals(AbstractOWLModel.this.getDefaultLanguageProperty())) {
                    AbstractOWLModel.this.defaultLanguageInitialized = false;
                    AbstractOWLModel.this.defaultLanguage = AbstractOWLModel.this.getDefaultLanguage();
                }
            }
        };
    }

    @Override
    public void setSearchSynonymProperties(Collection collection) {
        if (collection.isEmpty()) {
            this.getOWLProject().getSettingsMap().setString(SEARCH_SYNONYMS_KEY, null);
        } else {
            String string = "";
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Slot slot = (Slot)iterator.next();
                string = string + slot.getName();
                if (!iterator.hasNext()) continue;
                string = string + SEARCH_SYNONYMS_SEPARATOR;
            }
            this.getOWLProject().getSettingsMap().setString(SEARCH_SYNONYMS_KEY, string);
        }
    }

    public void setDefaultAnnotationPropertiesInView(Collection collection) {
        if (collection.isEmpty()) {
            this.getOWLProject().getSettingsMap().setString(DEFAULT_ANNOT_PROP_IN_VIEW_KEY, null);
        } else {
            String string = "";
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Slot slot = (Slot)iterator.next();
                string = string + slot.getName();
                if (!iterator.hasNext()) continue;
                string = string + SEARCH_SYNONYMS_SEPARATOR;
            }
            this.getOWLProject().getSettingsMap().setString(DEFAULT_ANNOT_PROP_IN_VIEW_KEY, string);
        }
    }

    @Override
    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public RDFResource getRDFResourceByBrowserText(String string) {
        for (Instance instance : this.getInstances()) {
            Instance instance2 = instance;
            if (!(instance2 instanceof RDFResource) || !instance2.getBrowserText().equals(string)) continue;
            return (RDFResource)this.getInstance(instance2.getName());
        }
        return null;
    }

    @Override
    public RDFResource getRDFResourceByNameOrBrowserText(String string) {
        String string2 = OWLUtil.getInternalFullName(this, string);
        if (string2 == null) {
            return null;
        }
        Instance instance = this.getInstance(string2);
        if (instance instanceof RDFResource) {
            return (RDFResource)instance;
        }
        instance = this.getRDFResourceByBrowserText(string);
        if (instance instanceof RDFResource) {
            return (RDFResource)instance;
        }
        return null;
    }

    @Override
    public int getRDFSClassCount() {
        return this.getRDFSNamedClassClass().getInstanceCount() - 3;
    }

    @Override
    public Collection getRDFSClasses() {
        ArrayList arrayList = new ArrayList(this.getOWLClassMetaCls().getInstances());
        AbstractOWLModel.removeProtegeSystemResources(this, arrayList);
        return arrayList;
    }

    @Override
    public RDFSDatatypeFactory getRDFSDatatypeFactory() {
        return this.rdfsDatatypeFactory;
    }

    private static void removeProtegeSystemResources(KnowledgeBase knowledgeBase, Collection collection) {
        if (collection.size() > 0 && knowledgeBase instanceof OWLModel) {
            OWLModel oWLModel = (OWLModel)knowledgeBase;
            collection.remove(oWLModel.getSystemFrames().getOwlOntologyPrefixesProperty());
            collection.remove(oWLModel.getSystemFrames().getOwlOntologyPointerClass());
            collection.remove(oWLModel.getSystemFrames().getOwlOntologyPointerProperty());
            collection.remove(oWLModel.getSystemFrames().getOwlResourceURIProperty());
            collection.remove(oWLModel.getSystemFrames().getAnonymousRootCls());
            collection.remove(oWLModel.getSystemFrames().getOwlClassMetaCls());
        }
    }

    @Override
    public Collection getResourcesWithPrefix(String string) {
        Collection collection = new ArrayList();
        String string2 = this.getNamespaceManager().getNamespaceForPrefix(string);
        if (string2 == null) {
            return collection;
        }
        collection = this.getMatchingFrames(this.getNameSlot(), null, false, string2 + "*", -1);
        return AbstractOWLModel.getRDFResources(this, collection);
    }

    @Override
    public List getVisibleResources(Iterator iterator) {
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        while (iterator.hasNext()) {
            RDFResource rDFResource = (RDFResource)iterator.next();
            if (!rDFResource.isVisible()) continue;
            arrayList.add(rDFResource);
        }
        return arrayList;
    }

    @Override
    public synchronized boolean isSlotMetaCls(Cls cls) {
        return this.getRDFPropertyClass().equals(cls) || this.hasSuperclass(cls, this.getRootSlotMetaCls());
    }

    @Override
    public void resetJenaModel() {
        if (this.jenaModel != null) {
            this.jenaModel.close();
        }
        this.jenaModel = null;
    }

    public Collection getPropertyValueLiterals(RDFResource rDFResource, RDFProperty rDFProperty) {
        ArrayList arrayList = new ArrayList(OWLUtil.getPropertyValues(rDFResource, rDFProperty, false));
        if (!arrayList.isEmpty()) {
            return this.getValueLiterals(arrayList);
        }
        return arrayList;
    }

    public List getValueLiterals(List list) {
        ArrayList arrayList = new ArrayList();
        for (Object e : list) {
            if (e instanceof RDFSLiteral) {
                arrayList.add(e);
                continue;
            }
            arrayList.add(this.createRDFSLiteral(e));
        }
        return arrayList;
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        int n = collection.size();
        if (n > 0) {
            for (Object e : collection) {
                if (!(e instanceof RDFSLiteral)) continue;
                collection = AbstractOWLModel.convertRDFSLiteralsToInternalFormat(collection);
                break;
            }
        }
        super.setDirectOwnSlotValues(frame, slot, collection);
    }

    public static List convertRDFSLiteralsToInternalFormat(Collection collection) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object e : collection) {
            linkedList.add(AbstractOWLModel.convertRDFSLiteralToInternalFormat(e));
        }
        return linkedList;
    }

    public static Object convertRDFSLiteralToInternalFormat(Object object) {
        if (object instanceof RDFSLiteral) {
            DefaultRDFSLiteral defaultRDFSLiteral = (DefaultRDFSLiteral)object;
            Object object2 = defaultRDFSLiteral.getPlainValue();
            if (object2 != null) {
                return object2;
            }
            return defaultRDFSLiteral.getRawValue();
        }
        return object;
    }

    @Override
    public void addOWLTest(OWLTest oWLTest) {
        this.getOWLTestsSettingsMap().remove(oWLTest.getClass().getName());
    }

    @Override
    public OWLTest[] getOWLTests() {
        Class[] classArray = OWLTestLibrary.getOWLTestClasses();
        ArrayList<OWLTest> arrayList = new ArrayList<OWLTest>();
        HashSet hashSet = new HashSet();
        Iterator iterator = this.getOWLTestsSettingsMap().listKeys();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        for (Class clazz : classArray) {
            if (hashSet.contains(clazz.getName())) continue;
            arrayList.add(OWLTestLibrary.getOWLTest(clazz));
        }
        return arrayList.toArray(new OWLTest[0]);
    }

    private SettingsMap getOWLTestGroupsSettingsMap() {
        return this.getOWLProject().getSettingsMap().getSettingsMap(TESTGROUP_LIST_NAME);
    }

    private SettingsMap getOWLTestsSettingsMap() {
        return this.getOWLProject().getSettingsMap().getSettingsMap(TEST_LIST_NAME);
    }

    @Override
    public boolean isAutoRepairEnabled() {
        return !Boolean.FALSE.equals(this.getOWLProject().getSettingsMap().getBoolean(AUTO_REPAIR_ENABLED));
    }

    @Override
    public boolean isOWLTestGroupEnabled(String string) {
        return this.getOWLTestGroupsSettingsMap().getBoolean(string) == null;
    }

    @Override
    public void removeOWLTest(OWLTest oWLTest) {
        String string = oWLTest.getClass().getName();
        this.getOWLTestsSettingsMap().setBoolean(string, true);
    }

    @Override
    public void setAutoRepairEnabled(boolean bl) {
        this.getOWLProject().getSettingsMap().setBoolean(AUTO_REPAIR_ENABLED, (Boolean)bl);
    }

    @Override
    public void setOWLTestGroupEnabled(String string, boolean bl) {
        if (bl) {
            Class[] classArray;
            this.getOWLTestGroupsSettingsMap().remove(string);
            for (Class clazz : classArray = OWLTestLibrary.getOWLTestClasses()) {
                OWLTest oWLTest = OWLTestLibrary.getOWLTest(clazz);
                if (!string.equals(oWLTest.getGroup())) continue;
                this.addOWLTest(oWLTest);
            }
        } else {
            OWLTest[] oWLTestArray;
            this.getOWLTestGroupsSettingsMap().setBoolean(string, true);
            for (OWLTest oWLTest : oWLTestArray = this.getOWLTests()) {
                if (!string.equals(oWLTest.getGroup())) continue;
                this.removeOWLTest(oWLTest);
            }
        }
    }

    public ServerCacheStateMachine getCacheMachine() {
        return new OwlStateMachine(this.getHeadFrameStore(), this);
    }

    public void setCacheMachine(ServerCacheStateMachine serverCacheStateMachine) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    protected void adjustForClient() {
        super.adjustForClient();
        OWLFrameStoreManager oWLFrameStoreManager = this.getFrameStoreManager();
        oWLFrameStoreManager.setOwlFrameStoresEnabled(false);
        this.tripleStoreModel = new ClientTripleStoreModel(this);
    }

    @Override
    public boolean isValidResourceName(String string, RDFResource rDFResource) {
        return this.isValidFrameName(string, (Frame)rDFResource);
    }

    public String createUniqueNewFrameName(String string) {
        return this.createNewResourceName(string);
    }

    @Override
    public String getResourceNameForURI(String string) {
        return string;
    }

    public boolean isValidOWLFrameName(String string) {
        return AbstractOWLModel.isValidOWLFrameName(this.getNamespaceManager(), string);
    }

    public static boolean isValidOWLFrameName(NamespaceManager namespaceManager, String string) {
        return URIUtilities.isValidURI((String)string);
    }

    public String getValidNamespaceFrameName(String string) {
        return AbstractOWLModel.getValidOWLFrameName(this, string);
    }

    public static String getValidOWLFrameName(AbstractOWLModel abstractOWLModel, String string) {
        int n;
        Assert.assertNotNull((Object)string);
        String string2 = string;
        if (string2.startsWith(":")) {
            string2 = "_" + string2.substring(1);
        }
        int n2 = string2.indexOf(58) + 1;
        for (n = 0; n < string2.length(); ++n) {
            char c;
            if (n == n2 - 1 || Character.isJavaIdentifierPart(c = string2.charAt(n)) || VALID_SYMBOLS.indexOf(c) >= 0) continue;
            string2 = string2.replace(c, '_');
        }
        if (string2.length() == n2) {
            string2 = "_" + string2;
        } else if (!Character.isJavaIdentifierStart(string2.charAt(n2))) {
            n = n2 == 0 ? n2 : n2 - 1;
            string2 = string2.substring(0, n) + "_" + string2.substring(n2);
        }
        if (!string2.equals(string)) {
            string = abstractOWLModel != null && abstractOWLModel.getFrame(string2) != null ? abstractOWLModel.getUniqueFrameName(string2) : string2;
        }
        return string;
    }

    @Override
    public String getLocalNameForURI(String string) {
        return NamespaceUtil.getLocalName(string);
    }

    @Override
    public NamespaceManager getNamespaceManager() {
        if (this.importNamespaces) {
            if (this.importingNamespaceManager == null) {
                this.importingNamespaceManager = new ImportingOwlNamespaceManager(this);
            }
            return this.importingNamespaceManager;
        }
        this.importingNamespaceManager = null;
        return this.tripleStoreModel.getActiveTripleStore().getNamespaceManager();
    }

    @Override
    public String getNamespaceForURI(String string) {
        return NamespaceUtil.getNameSpace(string);
    }

    @Override
    public String getPrefixForResourceName(String string) {
        return NamespaceUtil.getPrefixForResourceName(this, OWLUtil.getInternalFullName(this, string));
    }

    @Override
    public String getUniqueFrameName(String string) {
        String string2 = string;
        int n = this.lastGen;
        while (this.getFrame(string = string2 + "_" + n++) != null) {
        }
        this.lastGen = n;
        return string;
    }

    @Override
    public String getURIForResourceName(String string) {
        return OWLUtil.getInternalFullName(this, string);
    }

    @Override
    @Deprecated
    public String getNamespaceForResourceName(String string) {
        return this.getNamespaceForURI(string);
    }

    @Deprecated
    public String getFrameNameForURI(String string, boolean bl) {
        return string;
    }

    @Override
    @Deprecated
    public String getLocalNameForResourceName(String string) {
        return this.getLocalNameForURI(string);
    }

    @Override
    public RDFSNamedClass getRDFUntypedResourcesClass() {
        return this.getRDFExternalResourceClass();
    }

    public OWLNamedClass getOWLDatatypePropertyMetaClassCls() {
        return this.getOWLDatatypePropertyClass();
    }

    public OWLNamedClass getOWLObjectPropertyMetaClassCls() {
        return this.getOWLObjectPropertyClass();
    }

    public RDFSNamedClass getOWLAllDifferentClassCls() {
        return this.getOWLAllDifferentClass();
    }

    public OWLNamedClass getOWLNamedClassMetaClassCls() {
        return this.getOWLNamedClassClass();
    }

    public OWLNamedClass getOWLOntologyCls() {
        return this.getOWLOntologyClass();
    }

    public RDFSNamedClass getRDFListCls() {
        return this.getRDFListClass();
    }

    public OWLNamedClass getRDFSClassMetaClassCls() {
        return this.getRDFSNamedClassClass();
    }

    @Override
    public OWLNamedClass getOWLNothing() {
        return this.getOWLNothingClass();
    }

    @Override
    public RDFSNamedClass getOWLSomeValuesFromRestrictionClass() {
        return this.getOWLSomeValuesFromClass();
    }

    @Override
    public RDFProperty getRDFSSubPropertyOfProperty() {
        return this.getRDFSSubPropertyOf();
    }

    @Override
    public OWLNamedClass getOWLThingClass() {
        return this.getSystemFrames().getOwlThingClass();
    }

    public RDFSNamedClass getOWLClassMetaCls() {
        return this.getSystemFrames().getOwlClassMetaCls();
    }

    @Override
    public OWLNamedClass getRDFSNamedClassClass() {
        return this.getSystemFrames().getRdfsNamedClassClass();
    }

    @Override
    public OWLNamedClass getOWLNamedClassClass() {
        return this.getSystemFrames().getOwlNamedClassClass();
    }

    @Override
    public RDFSNamedClass getOWLDeprecatedClassClass() {
        return this.getSystemFrames().getOwlDeprecatedClassClass();
    }

    public OWLNamedClass getAnonymousClassMetaCls() {
        return this.getSystemFrames().getAnonymousClassMetaCls();
    }

    public RDFSNamedClass getOWLEnumeratedClassClass() {
        return this.getSystemFrames().getOwlEnumeratedClassClass();
    }

    public RDFSNamedClass getOWLRestrictionClass() {
        return this.getSystemFrames().getOwlRestrictionClass();
    }

    public RDFSNamedClass getOWLAllValuesFromClass() {
        return this.getSystemFrames().getOwlAllValuesFromClass();
    }

    public RDFSNamedClass getOWLHasValueClass() {
        return this.getSystemFrames().getOwlHasValueClass();
    }

    public RDFSNamedClass getOWLMaxCardinalityClass() {
        return this.getSystemFrames().getOwlMaxCardinalityClass();
    }

    public RDFSNamedClass getOWLMinCardinalityClass() {
        return this.getSystemFrames().getOwlMinCardinalityClass();
    }

    public RDFSNamedClass getOWLCardinalityClass() {
        return this.getSystemFrames().getOwlCardinalityClass();
    }

    public RDFSNamedClass getOWLSomeValuesFromClass() {
        return this.getSystemFrames().getOwlSomeValuesFromClass();
    }

    public RDFSNamedClass getOWLLogicalClassClass() {
        return this.getSystemFrames().getOwlLogicalClassClass();
    }

    public RDFSNamedClass getOWLComplementClassClass() {
        return this.getSystemFrames().getOwlComplementClassClass();
    }

    public RDFSNamedClass getOWLIntersectionClassClass() {
        return this.getSystemFrames().getOwlIntersectionClassClass();
    }

    public RDFSNamedClass getOWLUnionClassClass() {
        return this.getSystemFrames().getOwlUnionClassClass();
    }

    @Override
    public OWLNamedClass getRDFPropertyClass() {
        return this.getSystemFrames().getRdfPropertyClass();
    }

    @Override
    public OWLNamedClass getOWLDatatypePropertyClass() {
        return this.getSystemFrames().getOwlDatatypePropertyClass();
    }

    @Override
    public OWLNamedClass getOWLObjectPropertyClass() {
        return this.getSystemFrames().getOwlObjectPropertyClass();
    }

    @Override
    public OWLNamedClass getOWLInverseFunctionalPropertyClass() {
        return this.getSystemFrames().getOwlInverseFunctionalPropertyClass();
    }

    public OWLNamedClass getOWLSymmetricPropertyClass() {
        return this.getSystemFrames().getOwlSymmetricPropertyClass();
    }

    public OWLNamedClass getOWLTransitivePropertyClass() {
        return this.getSystemFrames().getOwlTransitivePropertyClass();
    }

    @Override
    public OWLNamedClass getOWLAnnotationPropertyClass() {
        return this.getSystemFrames().getOwlAnnotationPropertyClass();
    }

    @Override
    public OWLNamedClass getOWLFunctionalPropertyClass() {
        return this.getSystemFrames().getOwlFunctionalPropertyClass();
    }

    public RDFSNamedClass getOWLDeprecatedPropertyClass() {
        return this.getSystemFrames().getOwlDeprecatedPropertyClass();
    }

    public RDFSNamedClass getRDFSDatatypeClass() {
        return this.getSystemFrames().getRdfsDatatypeClass();
    }

    @Override
    public OWLNamedClass getOWLOntologyClass() {
        return this.getSystemFrames().getOwlOntologyClass();
    }

    public OWLNamedClass getOWLNothingClass() {
        return this.getSystemFrames().getOwlNothingClass();
    }

    @Override
    public RDFSNamedClass getRDFListClass() {
        return this.getSystemFrames().getRdfListClass();
    }

    @Override
    public RDFSNamedClass getOWLAllDifferentClass() {
        return this.getSystemFrames().getOwlAllDifferentClass();
    }

    public RDFSNamedClass getRDFSLiteralClass() {
        return this.getSystemFrames().getRdfsLiteralClass();
    }

    public RDFSNamedClass getRDFSContainerClass() {
        return this.getSystemFrames().getRdfsContainerClass();
    }

    public RDFSNamedClass getRDFAltClass() {
        return this.getSystemFrames().getRdfAltClass();
    }

    public RDFSNamedClass getRDFBagClass() {
        return this.getSystemFrames().getRdfBagClass();
    }

    public RDFSNamedClass getRDFSeqClass() {
        return this.getSystemFrames().getRdfSeqClass();
    }

    public RDFSNamedClass getRDFStatementClass() {
        return this.getSystemFrames().getRdfStatementClass();
    }

    @Override
    public RDFSNamedClass getOWLDataRangeClass() {
        return this.getSystemFrames().getOwlDataRangeClass();
    }

    @Override
    public RDFSNamedClass getAnonymousRootCls() {
        return this.getSystemFrames().getAnonymousRootCls();
    }

    @Override
    public RDFSNamedClass getRDFExternalResourceClass() {
        return this.getSystemFrames().getRdfExternalResourceClass();
    }

    public RDFSNamedClass getRDFExternalClassClass() {
        return this.getSystemFrames().getRdfExternalClassClass();
    }

    public RDFSNamedClass getRDFExternalPropertyClass() {
        return this.getSystemFrames().getRdfExternalPropertyClass();
    }

    public RDFSNamedClass getTopOWLOntologyClass() {
        return this.getSystemFrames().getOwlOntologyPointerClass();
    }

    public RDFProperty getOWLAllValuesFromProperty() {
        return this.getSystemFrames().getOwlAllValuesFromProperty();
    }

    public RDFProperty getOWLBackwardCompatibleWithProperty() {
        return this.getSystemFrames().getOwlBackwardCompatibleWithProperty();
    }

    @Override
    public RDFProperty getOWLCardinalityProperty() {
        return this.getSystemFrames().getOwlCardinalityProperty();
    }

    public RDFProperty getOWLComplementOfProperty() {
        return this.getSystemFrames().getOwlComplementOfProperty();
    }

    @Override
    public RDFProperty getOWLDifferentFromProperty() {
        return this.getSystemFrames().getOwlDifferentFromProperty();
    }

    @Override
    public RDFProperty getOWLDisjointWithProperty() {
        return this.getSystemFrames().getOwlDisjointWithProperty();
    }

    public RDFProperty getOWLDistinctMembersProperty() {
        return this.getSystemFrames().getOwlDistinctMembersProperty();
    }

    @Override
    public RDFProperty getOWLEquivalentClassProperty() {
        return this.getSystemFrames().getOwlEquivalentClassProperty();
    }

    @Override
    public RDFProperty getOWLEquivalentPropertyProperty() {
        return this.getSystemFrames().getOwlEquivalentPropertyProperty();
    }

    public RDFProperty getOWLHasValueProperty() {
        return this.getSystemFrames().getOwlHasValueProperty();
    }

    public RDFProperty getOWLImportsProperty() {
        return this.getSystemFrames().getOwlImportsProperty();
    }

    public RDFProperty getOWLIncompatibleWithProperty() {
        return this.getSystemFrames().getOwlIncompatibleWithProperty();
    }

    @Override
    public RDFProperty getOWLIntersectionOfProperty() {
        return this.getSystemFrames().getOwlIntersectionOfProperty();
    }

    @Override
    public RDFProperty getOWLInverseOfProperty() {
        return this.getSystemFrames().getOwlInverseOfProperty();
    }

    @Override
    public RDFProperty getOWLMaxCardinalityProperty() {
        return this.getSystemFrames().getOwlMaxCardinalityProperty();
    }

    @Override
    public RDFProperty getOWLMinCardinalityProperty() {
        return this.getSystemFrames().getOwlMinCardinalityProperty();
    }

    @Override
    public RDFProperty getOWLOneOfProperty() {
        return this.getSystemFrames().getOwlOneOfProperty();
    }

    public RDFProperty getOWLOnPropertyProperty() {
        return this.getSystemFrames().getOwlOnPropertyProperty();
    }

    public RDFProperty getOWLPriorVersionProperty() {
        return this.getSystemFrames().getOwlPriorVersionProperty();
    }

    @Override
    public RDFProperty getOWLSameAsProperty() {
        return this.getSystemFrames().getOwlSameAsProperty();
    }

    public RDFProperty getOWLSomeValuesFromProperty() {
        return this.getSystemFrames().getOwlSomeValuesFromProperty();
    }

    @Override
    public RDFProperty getOWLUnionOfProperty() {
        return this.getSystemFrames().getOwlUnionOfProperty();
    }

    @Override
    public RDFProperty getOWLValuesFromProperty() {
        return this.getSystemFrames().getOwlValuesFromProperty();
    }

    @Override
    public RDFProperty getOWLVersionInfoProperty() {
        return this.getSystemFrames().getOwlVersionInfoProperty();
    }

    @Override
    public RDFProperty getProtegeClassificationStatusProperty() {
        return this.getSystemFrames().getProtegeClassificationStatusProperty();
    }

    @Override
    public RDFProperty getProtegeInferredSubclassesProperty() {
        return this.getSystemFrames().getProtegeInferredSubclassesProperty();
    }

    @Override
    public RDFProperty getProtegeInferredSuperclassesProperty() {
        return this.getSystemFrames().getProtegeInferredSuperclassesProperty();
    }

    public RDFProperty getProtegeInferredTypeProperty() {
        return this.getSystemFrames().getProtegeInferredTypeProperty();
    }

    @Override
    public RDFProperty getRDFFirstProperty() {
        return this.getSystemFrames().getRdfFirstProperty();
    }

    public RDFProperty getRDFObjectProperty() {
        return this.getSystemFrames().getRdfObjectProperty();
    }

    public RDFProperty getRDFPredicateProperty() {
        return this.getSystemFrames().getRdfPredicateProperty();
    }

    @Override
    public RDFProperty getRDFRestProperty() {
        return this.getSystemFrames().getRdfRestProperty();
    }

    public RDFProperty getRDFSubjectProperty() {
        return this.getSystemFrames().getRdfSubjectProperty();
    }

    @Override
    public RDFProperty getRDFTypeProperty() {
        return this.getSystemFrames().getRdfTypeProperty();
    }

    public RDFProperty getRDFValueProperty() {
        return this.getSystemFrames().getRdfValueProperty();
    }

    @Override
    public OWLDatatypeProperty getRDFSCommentProperty() {
        return this.getSystemFrames().getRdfsCommentProperty();
    }

    @Override
    public RDFProperty getRDFSDomainProperty() {
        return this.getSystemFrames().getRdfsDomainProperty();
    }

    @Override
    public RDFProperty getRDFSIsDefinedByProperty() {
        return this.getSystemFrames().getRdfsIsDefinedByProperty();
    }

    @Override
    public RDFProperty getRDFSLabelProperty() {
        return this.getSystemFrames().getRdfsLabelProperty();
    }

    public RDFProperty getRDFSMemberProperty() {
        return this.getSystemFrames().getRdfsMemberProperty();
    }

    @Override
    public RDFProperty getRDFSRangeProperty() {
        return this.getSystemFrames().getRdfsRangeProperty();
    }

    public RDFProperty getRDFSSeeAlsoProperty() {
        return this.getSystemFrames().getRdfsSeeAlsoProperty();
    }

    @Override
    public RDFProperty getRDFSSubClassOfProperty() {
        return this.getSystemFrames().getRdfsSubClassOfProperty();
    }

    public RDFProperty getRDFSSubPropertyOf() {
        return this.getSystemFrames().getRdfsSubPropertyOf();
    }

    public RDFProperty getOWLOntologyPrefixesProperty() {
        return this.getSystemFrames().getOwlOntologyPrefixesProperty();
    }

    public RDFProperty getOWLResourceURIProperty() {
        return this.getSystemFrames().getOwlResourceURIProperty();
    }

    public RDFProperty getTopOWLOntologyURISlot() {
        return this.getSystemFrames().getOwlOntologyPointerProperty();
    }

    @Override
    public RDFList getRDFNil() {
        return this.getSystemFrames().getRdfNil();
    }

    public Set<RDFSDatatype> getRDFDatatypes() {
        return this.getSystemFrames().getRdfDatatypes();
    }

    @Override
    public Set<RDFSDatatype> getFloatDatatypes() {
        return this.getSystemFrames().getFloatDatatypes();
    }

    @Override
    public Set<RDFSDatatype> getIntegerDatatypes() {
        return this.getSystemFrames().getIntegerDatatypes();
    }

    @Override
    public RDFSDatatype getXSDboolean() {
        return this.getSystemFrames().getXsdBoolean();
    }

    @Override
    public RDFSDatatype getXSDdouble() {
        return this.getSystemFrames().getXsdDouble();
    }

    @Override
    public RDFSDatatype getXSDfloat() {
        return this.getSystemFrames().getXsdFloat();
    }

    @Override
    public RDFSDatatype getXSDlong() {
        return this.getSystemFrames().getXsdLong();
    }

    @Override
    public RDFSDatatype getXSDint() {
        return this.getSystemFrames().getXsdInt();
    }

    @Override
    public RDFSDatatype getXSDNonNegativeInteger() {
        return this.getSystemFrames().getXsdNonNegativeInteger();
    }

    @Override
    public RDFSDatatype getXSDshort() {
        return this.getSystemFrames().getXsdShort();
    }

    @Override
    public RDFSDatatype getXSDbyte() {
        return this.getSystemFrames().getXsdByte();
    }

    @Override
    public RDFSDatatype getXSDstring() {
        return this.getSystemFrames().getXsdString();
    }

    @Override
    public RDFSDatatype getXSDbase64Binary() {
        return this.getSystemFrames().getXsdBase64Binary();
    }

    @Override
    public RDFSDatatype getXSDdate() {
        return this.getSystemFrames().getXsdDate();
    }

    @Override
    public RDFSDatatype getXSDtime() {
        return this.getSystemFrames().getXsdTime();
    }

    @Override
    public RDFSDatatype getXSDdateTime() {
        return this.getSystemFrames().getXsdDateTime();
    }

    @Override
    public RDFSDatatype getXSDduration() {
        return this.getSystemFrames().getXsdDuration();
    }

    @Override
    public RDFSDatatype getXSDanyURI() {
        return this.getSystemFrames().getXsdAnyURI();
    }

    @Override
    public RDFSDatatype getXSDdecimal() {
        return this.getSystemFrames().getXsdDecimal();
    }

    @Override
    public RDFSDatatype getXSDinteger() {
        return this.getSystemFrames().getXsdInteger();
    }

    @Override
    public RDFSDatatype getRDFXMLLiteralType() {
        return this.getSystemFrames().getXmlLiteralType();
    }

    @Override
    public boolean isExpandShortNameInMethods() {
        return this.expandShortNameInMethods;
    }

    @Override
    public void setExpandShortNameInMethods(boolean bl) {
        this.expandShortNameInMethods = bl;
    }

    @Override
    public RDFProperty getProtegeSubclassesDisjointProperty() {
        if (this.protegeSubclassesDisjointProperty == null) {
            this.protegeSubclassesDisjointProperty = this.getSlot(ProtegeNames.getSubclassesDisjointSlotName());
        }
        return (RDFProperty)this.protegeSubclassesDisjointProperty;
    }

    @Override
    public WriterSettings getWriterSettings() {
        String string = this.getOWLProject().getSettingsMap().getString(JenaOWLModel.WRITER_SETTINGS_PROPERTY);
        if ("protege".equals(string)) {
            return new ProtegeWriterSettings(this);
        }
        return new JenaWriterSettings(this);
    }

    @Override
    public void setWriterSettings(WriterSettings writerSettings) {
        if (writerSettings instanceof ProtegeWriterSettings) {
            this.getOWLProject().getSettingsMap().setString(JenaOWLModel.WRITER_SETTINGS_PROPERTY, "protege");
        } else {
            this.getOWLProject().getSettingsMap().remove(JenaOWLModel.WRITER_SETTINGS_PROPERTY);
        }
    }

    public synchronized void dispose() {
        this.detachDefaultLanguageListener();
        super.dispose();
        if (this.jenaModel != null) {
            this.jenaModel.close();
            this.jenaModel = null;
        }
        this.owlProject = null;
        if (this.globalParserCache != null) {
            this.globalParserCache.dispose();
            this.globalParserCache = null;
        }
        OWLImportsCache.dispose();
        if (this.tripleStoreModel != null) {
            this.tripleStoreModel.dispose();
            this.tripleStoreModel = null;
        }
        ReasonerManager.getInstance().disposeReasoner(this);
        this.repositoryManager = null;
        this.taskManager = null;
    }
}

