/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerListener;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractNamespaceManager
implements NamespaceManager,
Serializable,
Localizable {
    private static final transient Logger log = Log.getLogger(AbstractNamespaceManager.class);
    private transient Collection<NamespaceManagerListener> listeners = new HashSet<NamespaceManagerListener>();
    public static final String DEFAULT_PREFIX_START = "p";
    public static final String DEFAULT_NAMESPACE_PREFIX = "";
    private int last_prefix_index = 0;

    public String getNextAvailablePrefixName() {
        ++this.last_prefix_index;
        String string = DEFAULT_PREFIX_START + this.last_prefix_index;
        while (this.getNamespaceForPrefix(string) != null) {
            ++this.last_prefix_index;
            string = DEFAULT_PREFIX_START + this.last_prefix_index;
        }
        return string;
    }

    public static boolean isValidPrefix(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '-') continue;
            return false;
        }
        return true;
    }

    public String getDefaultNamespace() {
        return this.getNamespaceForPrefix(DEFAULT_NAMESPACE_PREFIX);
    }

    public void setDefaultNamespace(String string) {
        this.setPrefix(string, DEFAULT_NAMESPACE_PREFIX);
    }

    public void setDefaultNamespace(URI uRI) {
        this.setDefaultNamespace(uRI.toString());
    }

    public void setPrefix(URI uRI, String string) {
        this.setPrefix(uRI.toString(), string);
    }

    public void addImport(TripleStore tripleStore) {
        String string = tripleStore.getNamespaceManager().getDefaultNamespace();
        if (string == null || this.getPrefix(string) != null) {
            return;
        }
        this.setPrefix(string, this.getNextAvailablePrefixName());
    }

    public void addNamespaceManagerListener(NamespaceManagerListener namespaceManagerListener) {
        this.listeners.add(namespaceManagerListener);
    }

    public void removeNamespaceManagerListener(NamespaceManagerListener namespaceManagerListener) {
        this.listeners.remove(namespaceManagerListener);
    }

    protected void tellNamespaceChanged(String string, String string2, String string3) {
        if (string == null || string2 == string3 || string2 != null && string2.equals(string3)) {
            return;
        }
        if (string2 == null) {
            for (NamespaceManagerListener namespaceManagerListener : this.listeners) {
                try {
                    namespaceManagerListener.prefixAdded(string);
                }
                catch (Throwable throwable) {
                    this.handleNamespaceListenerError(namespaceManagerListener, throwable);
                }
            }
        }
        if (string3 == null) {
            for (NamespaceManagerListener namespaceManagerListener : this.listeners) {
                try {
                    namespaceManagerListener.prefixRemoved(string);
                }
                catch (Throwable throwable) {
                    this.handleNamespaceListenerError(namespaceManagerListener, throwable);
                }
            }
        }
        for (NamespaceManagerListener namespaceManagerListener : this.listeners) {
            try {
                namespaceManagerListener.namespaceChanged(string, string2, string3);
            }
            catch (Throwable throwable) {
                this.handleNamespaceListenerError(namespaceManagerListener, throwable);
            }
        }
        if (DEFAULT_NAMESPACE_PREFIX.equals(string)) {
            for (NamespaceManagerListener namespaceManagerListener : this.listeners) {
                try {
                    namespaceManagerListener.defaultNamespaceChanged(string2, string3);
                }
                catch (Throwable throwable) {
                    this.handleNamespaceListenerError(namespaceManagerListener, throwable);
                }
            }
        }
    }

    protected void tellPrefixChanged(String string, String string2, String string3) {
        if (string == null || string2 == string3 || string2 != null && string2.equals(string3)) {
            return;
        }
        for (NamespaceManagerListener namespaceManagerListener : this.listeners) {
            try {
                namespaceManagerListener.prefixChanged(string, string2, string3);
            }
            catch (Throwable throwable) {
                this.handleNamespaceListenerError(namespaceManagerListener, throwable);
            }
        }
    }

    private void handleNamespaceListenerError(NamespaceManagerListener namespaceManagerListener, Throwable throwable) {
        log.warning("Exception thrown by  namespace listener (" + namespaceManagerListener + "): " + throwable);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Exception caught", throwable);
        }
    }

    public void localize(KnowledgeBase knowledgeBase) {
        this.listeners = new HashSet<NamespaceManagerListener>();
    }
}

