/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.updater;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.updater.AbstractRestrictionUpdater;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HasValueRestrictionUpdater
extends AbstractRestrictionUpdater {
    private static final transient Logger log = Log.getLogger(HasValueRestrictionUpdater.class);
    private Facet valuesFacet;

    public HasValueRestrictionUpdater(OWLModel oWLModel) {
        super(oWLModel);
        this.valuesFacet = oWLModel.getSystemFrames().getValuesFacet();
    }

    public void copyFacetValuesIntoNamedClass(RDFSNamedClass rDFSNamedClass, OWLRestriction oWLRestriction) {
        RDFProperty rDFProperty = oWLRestriction.getOnProperty();
        if (rDFProperty != null) {
            this.updateValuesFacet(rDFSNamedClass, rDFProperty);
        }
    }

    public void updateRestrictions(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, Facet facet) {
        this.removeRestrictions(oWLNamedClass, rDFProperty, this.owlModel.getCls(OWLNames.Cls.HAS_VALUE_RESTRICTION));
        if (oWLNamedClass.hasDirectlyOverriddenTemplateFacet(rDFProperty, this.valuesFacet)) {
            Collection collection = oWLNamedClass.getTemplateSlotValues(rDFProperty);
            for (Object e : collection) {
                OWLHasValue oWLHasValue = this.owlModel.createOWLHasValue(rDFProperty, e);
                oWLNamedClass.addSuperclass(oWLHasValue);
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("+ OWLHasValue " + oWLHasValue.getBrowserText() + " to " + oWLNamedClass.getName() + "." + rDFProperty.getName());
            }
        }
    }

    void updateValuesFacet(RDFSNamedClass rDFSNamedClass, Slot slot) {
        rDFSNamedClass.setTemplateFacetValues(slot, this.valuesFacet, Collections.EMPTY_LIST);
        if (log.isLoggable(Level.FINE)) {
            log.fine("- :VALUES override from " + rDFSNamedClass.getName() + "." + slot.getName());
        }
        for (OWLHasValue oWLHasValue : this.getDirectRestrictions(rDFSNamedClass, slot, OWLHasValue.class)) {
            Object object;
            if (oWLHasValue == null || (object = oWLHasValue.getHasValue()) == null) continue;
            if (object instanceof RDFSLiteral) {
                object = object.toString();
            }
            rDFSNamedClass.addTemplateFacetValue(slot, this.valuesFacet, object);
        }
    }
}

