/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.updater;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.updater.AbstractRestrictionUpdater;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CardinalityRestrictionUpdater
extends AbstractRestrictionUpdater {
    private static final transient Logger log = Log.getLogger(CardinalityRestrictionUpdater.class);
    private Facet maxCardinalityFacet;
    private Facet minCardinalityFacet;

    public CardinalityRestrictionUpdater(OWLModel oWLModel) {
        super(oWLModel);
        this.maxCardinalityFacet = oWLModel.getSystemFrames().getMaximumCardinalityFacet();
        this.minCardinalityFacet = oWLModel.getSystemFrames().getMinimumCardinalityFacet();
    }

    private OWLCardinalityBase createCardinalityRestriction(RDFProperty rDFProperty, Facet facet, int n) {
        if (facet.equals(this.minCardinalityFacet)) {
            return this.owlModel.createOWLMinCardinality(rDFProperty, n);
        }
        return this.owlModel.createOWLMaxCardinality(rDFProperty, n);
    }

    private void ensureCardinalityRestriction(Cls cls, RDFProperty rDFProperty, Facet facet) {
        int n;
        if (cls.hasDirectlyOverriddenTemplateFacet((Slot)rDFProperty, facet) && !this.hasCardinalityRestriction(cls, (Slot)rDFProperty, facet, n = ((Integer)cls.getTemplateFacetValue((Slot)rDFProperty, facet)).intValue())) {
            this.removeRestrictions(cls, rDFProperty, this.getCardinalityRestrictionCls(facet));
            OWLCardinalityBase oWLCardinalityBase = this.createCardinalityRestriction(rDFProperty, facet, n);
            cls.addDirectSuperclass((Cls)oWLCardinalityBase);
            if (log.isLoggable(Level.FINE)) {
                log.fine("+ " + oWLCardinalityBase.getClass().getName() + " " + oWLCardinalityBase.getBrowserText() + " to " + cls.getName() + "." + rDFProperty.getName());
            }
        }
    }

    private Cls getCardinalityRestrictionCls(Facet facet) {
        if (facet.equals(this.minCardinalityFacet)) {
            return this.owlModel.getCls(OWLNames.Cls.MIN_CARDINALITY_RESTRICTION);
        }
        return this.owlModel.getCls(OWLNames.Cls.MAX_CARDINALITY_RESTRICTION);
    }

    private boolean hasCardinalityRestriction(Cls cls, Slot slot, Facet facet, int n) {
        Cls cls2 = this.getCardinalityRestrictionCls(facet);
        return this.hasCardinalityRestriction(cls, slot, cls2, n);
    }

    private boolean hasCardinalityRestriction(Cls cls, Slot slot, Cls cls2, int n) {
        for (Cls cls3 : cls.getDirectSuperclasses()) {
            OWLCardinalityBase oWLCardinalityBase;
            if (!cls3.getDirectType().equals(cls2) || !slot.equals((oWLCardinalityBase = (OWLCardinalityBase)cls3).getOnProperty()) || oWLCardinalityBase.getCardinality() != n) continue;
            return true;
        }
        return false;
    }

    private void updateBothCardinalityFacets(RDFSNamedClass rDFSNamedClass, Slot slot) {
        rDFSNamedClass.setTemplateFacetValues(slot, this.minCardinalityFacet, Collections.EMPTY_LIST);
        rDFSNamedClass.setTemplateFacetValues(slot, this.maxCardinalityFacet, Collections.EMPTY_LIST);
        OWLCardinality oWLCardinality = (OWLCardinality)this.getDirectRestriction(rDFSNamedClass, slot, OWLCardinality.class);
        if (oWLCardinality != null) {
            int n = oWLCardinality.getCardinality();
            rDFSNamedClass.addTemplateFacetValue(slot, this.minCardinalityFacet, new Integer(n));
            rDFSNamedClass.addTemplateFacetValue(slot, this.maxCardinalityFacet, new Integer(n));
            if (log.isLoggable(Level.FINE)) {
                log.fine("+ :Max and :MinimumCardinality overrides to " + rDFSNamedClass.getName() + "." + slot.getName() + ": " + n);
            }
        }
    }

    private void updateCardinalityRestrictions(Cls cls, RDFProperty rDFProperty, Facet facet, Facet facet2) {
        if (cls.hasDirectlyOverriddenTemplateFacet((Slot)rDFProperty, facet)) {
            this.ensureCardinalityRestriction(cls, rDFProperty, facet);
            Integer n = (Integer)cls.getTemplateFacetValue((Slot)rDFProperty, facet);
            if (cls.hasDirectlyOverriddenTemplateFacet((Slot)rDFProperty, facet2) && n.equals(cls.getTemplateFacetValue((Slot)rDFProperty, facet2))) {
                this.removeRestrictions(cls, rDFProperty, this.owlModel.getCls(OWLNames.Cls.MIN_CARDINALITY_RESTRICTION));
                this.removeRestrictions(cls, rDFProperty, this.owlModel.getCls(OWLNames.Cls.MAX_CARDINALITY_RESTRICTION));
                if (!this.hasCardinalityRestriction(cls, (Slot)rDFProperty, this.owlModel.getCls(OWLNames.Cls.CARDINALITY_RESTRICTION), (int)n)) {
                    this.removeRestrictions(cls, rDFProperty, this.owlModel.getCls(OWLNames.Cls.CARDINALITY_RESTRICTION));
                    OWLCardinality oWLCardinality = this.owlModel.createOWLCardinality(rDFProperty, n);
                    cls.addDirectSuperclass((Cls)oWLCardinality);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("+ OWLCardinality " + oWLCardinality.getBrowserText() + " to " + cls.getName() + "." + rDFProperty.getName());
                    }
                }
            } else {
                this.removeRestrictions(cls, rDFProperty, this.owlModel.getCls(OWLNames.Cls.CARDINALITY_RESTRICTION));
                this.ensureCardinalityRestriction(cls, rDFProperty, facet);
                this.ensureCardinalityRestriction(cls, rDFProperty, facet2);
            }
        } else {
            this.removeRestrictions(cls, rDFProperty, this.getCardinalityRestrictionCls(facet));
            this.removeRestrictions(cls, rDFProperty, this.owlModel.getCls(OWLNames.Cls.CARDINALITY_RESTRICTION));
            this.ensureCardinalityRestriction(cls, rDFProperty, facet2);
        }
    }

    protected void updateMaximumCardinalityFacet(RDFSNamedClass rDFSNamedClass, Slot slot) {
        OWLMaxCardinality oWLMaxCardinality = (OWLMaxCardinality)this.getDirectRestriction(rDFSNamedClass, slot, OWLMaxCardinality.class);
        RDFSNamedClass rDFSNamedClass2 = rDFSNamedClass;
        List list = rDFSNamedClass2.getDirectTemplateFacetValues(slot, this.maxCardinalityFacet);
        if (oWLMaxCardinality != null) {
            int n = oWLMaxCardinality.getCardinality();
            Integer n2 = new Integer(n);
            if (!list.contains(n2)) {
                rDFSNamedClass2.setTemplateFacetValue(slot, this.maxCardinalityFacet, n2);
            }
        } else if (!list.isEmpty()) {
            rDFSNamedClass2.setTemplateFacetValues(slot, this.maxCardinalityFacet, Collections.EMPTY_LIST);
        }
    }

    protected void updateMinimumCardinalityFacet(RDFSNamedClass rDFSNamedClass, Slot slot) {
        RDFSNamedClass rDFSNamedClass2 = rDFSNamedClass;
        List list = rDFSNamedClass2.getDirectTemplateFacetValues(slot, this.minCardinalityFacet);
        OWLMinCardinality oWLMinCardinality = (OWLMinCardinality)this.getDirectRestriction(rDFSNamedClass, slot, OWLMinCardinality.class);
        if (oWLMinCardinality != null) {
            int n = oWLMinCardinality.getCardinality();
            Integer n2 = new Integer(n);
            if (!list.contains(n2)) {
                rDFSNamedClass2.setTemplateFacetValue(slot, this.minCardinalityFacet, n2);
            }
        } else if (!list.isEmpty()) {
            rDFSNamedClass2.setTemplateFacetValues(slot, this.minCardinalityFacet, Collections.EMPTY_LIST);
        }
    }

    public void copyFacetValuesIntoNamedClass(RDFSNamedClass rDFSNamedClass, OWLRestriction oWLRestriction) {
        RDFProperty rDFProperty = oWLRestriction.getOnProperty();
        if (rDFProperty != null) {
            if (oWLRestriction instanceof OWLCardinality) {
                this.updateBothCardinalityFacets(rDFSNamedClass, rDFProperty);
            } else if (oWLRestriction instanceof OWLMaxCardinality) {
                this.updateMaximumCardinalityFacet(rDFSNamedClass, rDFProperty);
            } else if (oWLRestriction instanceof OWLMinCardinality) {
                this.updateMinimumCardinalityFacet(rDFSNamedClass, rDFProperty);
            }
        }
    }

    public void updateRestrictions(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, Facet facet) {
        if (facet.equals(this.maxCardinalityFacet)) {
            this.updateCardinalityRestrictions(oWLNamedClass, rDFProperty, this.maxCardinalityFacet, this.minCardinalityFacet);
        } else if (facet.equals(this.minCardinalityFacet)) {
            this.updateCardinalityRestrictions(oWLNamedClass, rDFProperty, this.minCardinalityFacet, this.maxCardinalityFacet);
        }
    }
}

