/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.updater;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.framestore.updater.RestrictionUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRestrictionUpdater
implements RestrictionUpdater {
    private static final transient Logger log = Log.getLogger(AbstractRestrictionUpdater.class);
    protected OWLModel owlModel;

    public AbstractRestrictionUpdater(OWLModel oWLModel) {
        this.owlModel = oWLModel;
    }

    protected Cls getDirectRestriction(Cls cls, Slot slot, Class clazz) {
        for (Cls cls2 : cls.getDirectSuperclasses()) {
            RDFProperty rDFProperty;
            if (!clazz.isAssignableFrom(cls2.getClass()) || !slot.equals(rDFProperty = ((OWLRestriction)cls2).getOnProperty())) continue;
            return cls2;
        }
        return null;
    }

    protected <X extends OWLRestriction> Collection<X> getDirectRestrictions(Cls cls, Slot slot, Class<? extends X> clazz) {
        ArrayList<OWLRestriction> arrayList = new ArrayList<OWLRestriction>();
        for (Cls cls2 : cls.getDirectSuperclasses()) {
            if (!clazz.isAssignableFrom(cls2.getClass())) continue;
            OWLRestriction oWLRestriction = (OWLRestriction)cls2;
            RDFProperty rDFProperty = ((OWLRestriction)cls2).getOnProperty();
            if (rDFProperty == null || !rDFProperty.equals(slot)) continue;
            arrayList.add(oWLRestriction);
        }
        return arrayList;
    }

    protected void removeRestrictions(Cls cls, Slot slot, Cls cls2) {
        ArrayList arrayList = new ArrayList(cls.getDirectSuperclasses());
        for (Cls cls3 : arrayList) {
            OWLRestriction oWLRestriction;
            RDFProperty rDFProperty;
            if (!cls3.getDirectType().equals(cls2) || !(rDFProperty = (oWLRestriction = (OWLRestriction)cls3).getOnProperty()).equals(slot)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("- OWLRestriction " + oWLRestriction.getBrowserText() + " from " + cls.getName() + "." + slot.getName());
            }
            cls.removeDirectSuperclass((Cls)oWLRestriction);
        }
    }
}

