/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.OWLFactoryClassType;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.swrl.SWRLSystemFrames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class TypeUpdateFrameStore
extends FrameStoreAdapter {
    private RDFSNamedClass untypedResource;
    private RDFSNamedClass untypedClass;
    private RDFSNamedClass untypedProperty;
    private RDFSNamedClass functionalPropertyClass;
    private RDFSNamedClass restrictionClass;
    private RDFSNamedClass owlClass;
    private RDFProperty rdfType;
    private RDFProperty rdfSubClassOfProperty;
    private RDFSNamedClass annotationPropertyClass;
    private Map<RDFProperty, RDFSNamedClass> fillerToProtegeTypeMap = new HashMap<RDFProperty, RDFSNamedClass>();
    private static Set<String> fakeProtege3FactoryTypes = new HashSet<String>();

    public TypeUpdateFrameStore(OWLModel oWLModel) {
        this.untypedResource = oWLModel.getRDFUntypedResourcesClass();
        this.untypedClass = ((AbstractOWLModel)oWLModel).getRDFExternalClassClass();
        this.untypedProperty = ((AbstractOWLModel)oWLModel).getRDFExternalPropertyClass();
        this.functionalPropertyClass = oWLModel.getOWLFunctionalPropertyClass();
        this.restrictionClass = oWLModel.getSystemFrames().getOwlRestrictionClass();
        this.owlClass = oWLModel.getOWLNamedClassClass();
        this.annotationPropertyClass = oWLModel.getOWLAnnotationPropertyClass();
        this.rdfType = oWLModel.getRDFTypeProperty();
        this.rdfSubClassOfProperty = oWLModel.getRDFSSubClassOfProperty();
        this.initFillerMap(oWLModel);
    }

    private void initFillerMap(OWLModel oWLModel) {
        SWRLSystemFrames sWRLSystemFrames = oWLModel.getSystemFrames();
        this.fillerToProtegeTypeMap.put(sWRLSystemFrames.getOwlAllValuesFromProperty(), sWRLSystemFrames.getOwlAllValuesFromClass());
        this.fillerToProtegeTypeMap.put(sWRLSystemFrames.getOwlSomeValuesFromProperty(), sWRLSystemFrames.getOwlSomeValuesFromClass());
        this.fillerToProtegeTypeMap.put(sWRLSystemFrames.getOwlCardinalityProperty(), sWRLSystemFrames.getOwlCardinalityClass());
        this.fillerToProtegeTypeMap.put(sWRLSystemFrames.getOwlMinCardinalityProperty(), sWRLSystemFrames.getOwlMinCardinalityClass());
        this.fillerToProtegeTypeMap.put(sWRLSystemFrames.getOwlMaxCardinalityProperty(), sWRLSystemFrames.getOwlMaxCardinalityClass());
        this.fillerToProtegeTypeMap.put(sWRLSystemFrames.getOwlHasValueProperty(), sWRLSystemFrames.getOwlHasValueClass());
    }

    public Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Cls cls = super.createCls(frameID, collection, collection2, bl);
        if (cls instanceof RDFSNamedClass) {
            ((RDFSNamedClass)cls).setPropertyValues(this.rdfSubClassOfProperty, collection2);
            if (!collection.contains(this.untypedClass)) {
                super.setDirectOwnSlotValues((Frame)cls, (Slot)this.rdfType, collection);
            }
        } else if (cls instanceof OWLRestriction) {
            super.setDirectOwnSlotValues((Frame)cls, (Slot)this.rdfType, Collections.singleton(this.restrictionClass));
        } else if (cls instanceof OWLAnonymousClass) {
            super.setDirectOwnSlotValues((Frame)cls, (Slot)this.rdfType, Collections.singleton(this.owlClass));
        }
        return cls;
    }

    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Slot slot = super.createSlot(frameID, collection, collection2, bl);
        if (slot instanceof RDFProperty && !collection.contains(this.untypedProperty)) {
            super.setDirectOwnSlotValues((Frame)slot, (Slot)this.rdfType, collection);
        }
        return slot;
    }

    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection, boolean bl) {
        SimpleInstance simpleInstance = super.createSimpleInstance(frameID, collection, bl);
        if (simpleInstance instanceof RDFResource && !collection.contains(this.untypedResource)) {
            super.setDirectOwnSlotValues((Frame)simpleInstance, (Slot)this.rdfType, collection);
        }
        return simpleInstance;
    }

    public void addDirectType(Instance instance, Cls cls) {
        try {
            this.beginTransaction("Add to " + instance.getBrowserText() + " direct type : " + cls.getBrowserText() + " -- Apply to: " + instance.getName());
            super.addDirectType(instance, cls);
            instance = (Instance)super.getFrame(instance.getFrameID());
            if (instance instanceof RDFProperty && cls.equals(this.functionalPropertyClass)) {
                ((Slot)instance).setAllowsMultipleValues(false);
            }
            if (instance instanceof OWLRestriction) {
                super.setDirectOwnSlotValues((Frame)instance, (Slot)this.rdfType, Collections.singleton(this.restrictionClass));
            } else if (instance instanceof OWLAnonymousClass) {
                super.setDirectOwnSlotValues((Frame)instance, (Slot)this.rdfType, Collections.singleton(this.owlClass));
            } else if (instance instanceof RDFResource && !cls.equals(this.untypedResource)) {
                ArrayList<Cls> arrayList = new ArrayList<Cls>(super.getDirectOwnSlotValues((Frame)instance, (Slot)this.rdfType));
                arrayList.add(cls);
                super.setDirectOwnSlotValues((Frame)instance, (Slot)this.rdfType, arrayList);
            }
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.WARNING, "Error in transaction at adding to " + instance + " direct type: " + cls, throwable);
            this.rollbackTransaction();
            throw new RuntimeException(throwable);
        }
    }

    public void removeDirectType(Instance instance, Cls cls) {
        try {
            ArrayList arrayList;
            this.beginTransaction("Remove from " + instance.getBrowserText() + " direct type : " + cls.getBrowserText() + " -- Apply to: " + instance.getName());
            if (instance instanceof RDFProperty && cls.equals(this.functionalPropertyClass)) {
                ((Slot)instance).setAllowsMultipleValues(true);
            }
            if (instance instanceof OWLRestriction) {
                super.setDirectOwnSlotValues((Frame)instance, (Slot)this.rdfType, Collections.singleton(this.restrictionClass));
            } else if (instance instanceof OWLAnonymousClass) {
                super.setDirectOwnSlotValues((Frame)instance, (Slot)this.rdfType, Collections.singleton(this.owlClass));
            } else if (instance instanceof RDFResource && (arrayList = new ArrayList(super.getDirectOwnSlotValues((Frame)instance, (Slot)this.rdfType))).contains(cls)) {
                arrayList.remove(cls);
                super.setDirectOwnSlotValues((Frame)instance, (Slot)this.rdfType, arrayList);
            }
            super.removeDirectType(instance, cls);
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.WARNING, "Error in transaction at removing from " + instance + " direct type: " + cls, throwable);
            this.rollbackTransaction();
            throw new RuntimeException(throwable);
        }
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        super.setDirectOwnSlotValues(frame, slot, collection);
        if (frame instanceof OWLAnonymousClass) {
            return;
        }
        if (frame instanceof RDFResource && slot.equals(this.rdfType)) {
            List list = super.getDirectTypes((Instance)((RDFResource)frame));
            for (Object e : collection) {
                if (list.contains(e) || !(e instanceof Cls)) continue;
                super.addDirectType((Instance)((RDFResource)frame), (Cls)e);
            }
            for (Object e : list) {
                if (collection.contains(e) || !(e instanceof Cls)) continue;
                super.removeDirectType((Instance)((RDFResource)frame), (Cls)e);
            }
        } else {
            Cls cls = this.fillerToProtegeTypeMap.get(slot);
            if (cls != null && !super.getDirectTypes((Instance)frame).contains(cls)) {
                super.addDirectType((Instance)frame, cls);
            }
        }
    }

    public void addDirectSuperslot(Slot slot, Slot slot2) {
        RDFProperty rDFProperty;
        super.addDirectSuperslot(slot, slot2);
        if (slot instanceof RDFProperty && (rDFProperty = (RDFProperty)slot) instanceof OWLProperty && slot2 instanceof OWLProperty && ((OWLProperty)slot2).isAnnotationProperty()) {
            this.addDirectType((Instance)slot, this.annotationPropertyClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFacetValues(OWLModel oWLModel) {
        boolean bl = oWLModel.isUndoEnabled();
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
        oWLModel.setUndoEnabled(false);
        try {
            for (TripleStore tripleStore2 : tripleStoreModel.getTripleStores()) {
                tripleStoreModel.setActiveTripleStore(tripleStore2);
                this.updateCardinalityFacets(oWLModel, tripleStore2);
            }
        }
        finally {
            oWLModel.setUndoEnabled(bl);
            oWLModel.getTripleStoreModel().setActiveTripleStore(tripleStore);
        }
    }

    private void updateCardinalityFacets(OWLModel oWLModel, TripleStore tripleStore) {
        OWLNamedClass oWLNamedClass = ((AbstractOWLModel)oWLModel).getOWLFunctionalPropertyClass();
        NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
        List list = narrowFrameStore.getValues((Frame)oWLNamedClass, oWLModel.getSystemFrames().getDirectInstancesSlot(), null, false);
        for (RDFProperty rDFProperty : list) {
            rDFProperty.setAllowsMultipleValues(false);
        }
    }

    static {
        for (OWLFactoryClassType oWLFactoryClassType : OWLFactoryClassType.values()) {
            if (!oWLFactoryClassType.isFakeProtege3Type()) continue;
            fakeProtege3FactoryTypes.add(oWLFactoryClassType.getTypeName());
        }
    }
}

