/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.util.Collection;
import java.util.Collections;

public class RangeUpdateFrameStore
extends FrameStoreAdapter {
    private RDFProperty rdfsRangeProperty;
    private Slot valueType;

    public RangeUpdateFrameStore(OWLModel oWLModel) {
        this.rdfsRangeProperty = oWLModel.getRDFSRangeProperty();
        this.valueType = oWLModel.getSystemFrames().getValueTypeSlot();
    }

    public void synchronizeRDFSRangeWithProtegeAllowedValues(RDFProperty rDFProperty) {
        Collection collection = super.getOwnSlotValues((Frame)rDFProperty, (Slot)this.rdfsRangeProperty);
        this.updateAllowedValues(rDFProperty, collection);
    }

    private void updateAllowedValues(RDFProperty rDFProperty, Collection collection) {
        if (collection.size() > 1) {
            rDFProperty.setValueType(ValueType.ANY);
            return;
        }
        if (rDFProperty instanceof OWLObjectProperty && collection.isEmpty() && super.getSuperslots((Slot)rDFProperty).size() >= 1) {
            super.setDirectOwnSlotValues((Frame)rDFProperty, this.valueType, (Collection)Collections.EMPTY_LIST);
            return;
        }
        ValueType valueType = ValueType.ANY;
        if (rDFProperty instanceof OWLObjectProperty) {
            valueType = ValueType.INSTANCE;
        }
        if (!collection.isEmpty()) {
            RDFResource rDFResource;
            Object e = collection.iterator().next();
            if (e instanceof RDFSDatatype) {
                valueType = XMLSchemaDatatypes.getValueType(((RDFSDatatype)e).getURI());
            } else if (e instanceof RDFSClass) {
                valueType = ValueType.INSTANCE;
            } else if (e instanceof OWLDataRange && (rDFResource = ((OWLDataRange)e).getRDFDatatype()) != null) {
                valueType = XMLSchemaDatatypes.getValueType(rDFResource.getURI());
            }
            if (valueType == ValueType.INSTANCE && e instanceof RDFSClass) {
                rDFResource = (RDFSClass)e;
                if (rDFResource instanceof OWLUnionClass) {
                    super.setDirectOwnSlotValues((Frame)rDFProperty, this.valueType, (Collection)ValueTypeConstraint.getValues((ValueType)ValueType.INSTANCE, ((OWLUnionClass)rDFResource).getOperands()));
                } else {
                    super.setDirectOwnSlotValues((Frame)rDFProperty, this.valueType, (Collection)ValueTypeConstraint.getValues((ValueType)ValueType.INSTANCE, Collections.singleton(rDFResource)));
                }
                return;
            }
        }
        if (valueType == ValueType.INSTANCE) {
            rDFProperty.setAllowedClses(Collections.EMPTY_LIST);
        } else if (valueType != rDFProperty.getValueType()) {
            super.setDirectOwnSlotValues((Frame)rDFProperty, this.valueType, ValueTypeConstraint.getValues((ValueType)valueType));
        }
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        if (frame instanceof RDFProperty && slot.equals(this.rdfsRangeProperty)) {
            this.updateAllowedValues((RDFProperty)frame, collection);
        }
        super.setDirectOwnSlotValues(frame, slot, collection);
    }

    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Slot slot = super.createSlot(frameID, collection, collection2, bl);
        if (slot instanceof OWLObjectProperty && collection2.isEmpty()) {
            slot.setValueType(ValueType.INSTANCE);
        }
        return slot;
    }

    public void addDirectSuperslot(Slot slot, Slot slot2) {
        super.addDirectSuperslot(slot, slot2);
        if (slot instanceof OWLObjectProperty && ((RDFProperty)slot).getRange() == null) {
            slot.setDirectOwnSlotValue(this.valueType, null);
        }
    }

    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        super.removeDirectSuperslot(slot, slot2);
        if (slot instanceof OWLObjectProperty && slot.getDirectSuperslotCount() == 0 && slot.getAllowedClses().isEmpty()) {
            slot.setValueType(ValueType.INSTANCE);
        }
    }
}

