/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OwlSubclassFrameStore
extends FrameStoreAdapter {
    private static transient Logger log = Log.getLogger(OwlSubclassFrameStore.class);
    private OWLModel owlModel;
    private Slot directSuperclassesSlot;
    private Slot directSubclassesSlot;
    private RDFProperty rdfsSubClassOfProperty;
    private RDFProperty owlEquivalentClassProperty;

    public OwlSubclassFrameStore(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.directSuperclassesSlot = oWLModel.getSystemFrames().getDirectSuperclassesSlot();
        this.directSubclassesSlot = oWLModel.getSystemFrames().getDirectSubclassesSlot();
        this.rdfsSubClassOfProperty = oWLModel.getRDFSSubClassOfProperty();
        this.owlEquivalentClassProperty = oWLModel.getOWLEquivalentClassProperty();
    }

    private void addNamedOperandsToDirectSuperclasses(OWLNamedClass oWLNamedClass, OWLIntersectionClass oWLIntersectionClass) {
        for (RDFSClass rDFSClass : oWLIntersectionClass.getOperands()) {
            if (!(rDFSClass instanceof OWLNamedClass)) continue;
            oWLNamedClass.addSuperclass(rDFSClass);
        }
    }

    private void updateRDFSSubClassOf(RDFSNamedClass rDFSNamedClass) {
        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
        ArrayList<RDFSClass> arrayList2 = new ArrayList<RDFSClass>();
        for (Cls cls : super.getDirectSuperclasses((Cls)rDFSNamedClass)) {
            if (!(cls instanceof RDFSClass)) continue;
            if (super.getDirectSuperclasses(cls).contains(rDFSNamedClass)) {
                arrayList2.add((RDFSClass)cls);
                if (!(cls instanceof RDFSNamedClass)) continue;
                arrayList.add((RDFSClass)cls);
                continue;
            }
            arrayList.add((RDFSClass)cls);
        }
        super.setDirectOwnSlotValues((Frame)rDFSNamedClass, (Slot)this.rdfsSubClassOfProperty, arrayList);
        super.setDirectOwnSlotValues((Frame)rDFSNamedClass, (Slot)this.owlEquivalentClassProperty, arrayList2);
    }

    private void removeNamedOperandsFromDirectSuperclasses(OWLNamedClass oWLNamedClass, OWLIntersectionClass oWLIntersectionClass) {
        Collection<RDFSNamedClass> collection = oWLIntersectionClass.getNamedOperands();
        if (!collection.isEmpty()) {
            for (Cls cls : super.getDirectSuperclasses((Cls)oWLNamedClass)) {
                RDFSClass rDFSClass;
                if (!(cls instanceof RDFSClass) || !super.getDirectSuperclasses((Cls)((RDFSClass)cls)).contains(oWLNamedClass) || !((rDFSClass = (RDFSClass)cls) instanceof OWLIntersectionClass)) continue;
                collection.removeAll(((OWLIntersectionClass)rDFSClass).getNamedOperands());
            }
            for (RDFSNamedClass rDFSNamedClass : collection) {
                if (rDFSNamedClass.hasEquivalentClass(oWLNamedClass)) continue;
                oWLNamedClass.removeSuperclass(rDFSNamedClass);
            }
        }
    }

    public Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Cls cls = super.createCls(frameID, collection, collection2, bl);
        if (cls instanceof RDFSNamedClass) {
            super.setDirectOwnSlotValues((Frame)cls, (Slot)this.owlModel.getRDFSSubClassOfProperty(), collection2);
        }
        return cls;
    }

    public void addDirectSuperclass(Cls cls, Cls cls2) {
        List list = super.getDirectSuperclasses(cls);
        if (!list.contains(cls2)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("-> " + cls.getBrowserText() + " ADDED " + cls2.getBrowserText());
            }
            super.addDirectSuperclass(cls, cls2);
            if (cls2 instanceof OWLIntersectionClass && cls instanceof OWLNamedClass && super.getDirectSuperclasses(cls2).contains(cls)) {
                this.addNamedOperandsToDirectSuperclasses((OWLNamedClass)cls, (OWLIntersectionClass)cls2);
            } else if (cls instanceof OWLIntersectionClass && cls2 instanceof OWLNamedClass && super.getDirectSuperclasses(cls2).contains(cls)) {
                this.addNamedOperandsToDirectSuperclasses((OWLNamedClass)cls2, (OWLIntersectionClass)cls);
            }
            if (cls instanceof OWLNamedClass && cls2 instanceof OWLNamedClass && cls.isEditable() && ((OWLNamedClass)cls2).getSubclassesDisjoint()) {
                OWLUtil.ensureSubclassesDisjoint((OWLNamedClass)cls2);
            }
            if (cls instanceof RDFSNamedClass) {
                this.updateRDFSSubClassOf((RDFSNamedClass)cls);
            }
            if (cls2 instanceof RDFSNamedClass) {
                this.updateRDFSSubClassOf((RDFSNamedClass)cls2);
            }
        }
    }

    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        boolean bl = cls2.hasDirectSuperclass(cls);
        super.removeDirectSuperclass(cls, cls2);
        if (cls instanceof OWLNamedClass && cls2 instanceof OWLIntersectionClass && bl) {
            this.removeNamedOperandsFromDirectSuperclasses((OWLNamedClass)cls, (OWLIntersectionClass)cls2);
        } else if (cls2 instanceof OWLNamedClass && cls instanceof OWLIntersectionClass && bl) {
            this.removeNamedOperandsFromDirectSuperclasses((OWLNamedClass)cls2, (OWLIntersectionClass)cls);
        }
        if (cls instanceof RDFSNamedClass) {
            this.updateRDFSSubClassOf((RDFSNamedClass)cls);
        } else if (cls2 instanceof RDFSNamedClass) {
            this.updateRDFSSubClassOf((RDFSNamedClass)cls2);
        }
    }
}

