/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.DeleteSimplificationFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.framestore.DomainUpdateFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.DuplicateValuesFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.FacetUpdateFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.LocalClassificationFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.OWLDeleteSimplificationFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.OwlSubclassFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.RangeUpdateFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.TypeUpdateFrameStore;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.ArrayList;
import java.util.List;

public class OWLFrameStoreManager
extends FrameStoreManager {
    private OWLModel owlModel;
    private OWLFrameStore owlFrameStore;
    private DuplicateValuesFrameStore duplicateValuesFrameStore;
    private DomainUpdateFrameStore domainUpdateFrameStore;
    private FacetUpdateFrameStore facetUpdateFrameStore;
    private RangeUpdateFrameStore rangeUpdateFrameStore;
    private OwlSubclassFrameStore owlSubclassFrameStore;
    private TypeUpdateFrameStore typeUpdateFrameStore;
    private LocalClassificationFrameStore localClassificationFrameStore;
    private List<FrameStore> frameStores = new ArrayList<FrameStore>();

    public OWLFrameStoreManager(OWLModel oWLModel) {
        super((KnowledgeBase)oWLModel);
        this.owlModel = oWLModel;
        this.initializeOwlFrameStores();
    }

    private void initializeOwlFrameStores() {
        this.owlFrameStore = new OWLFrameStore((AbstractOWLModel)this.owlModel);
        this.addFrameStore((FrameStore)this.owlFrameStore);
        this.duplicateValuesFrameStore = new DuplicateValuesFrameStore();
        this.addFrameStore((FrameStore)this.duplicateValuesFrameStore);
        this.domainUpdateFrameStore = new DomainUpdateFrameStore(this.owlModel);
        this.addFrameStore((FrameStore)this.domainUpdateFrameStore);
        this.facetUpdateFrameStore = new FacetUpdateFrameStore(this.owlModel);
        this.addFrameStore((FrameStore)this.facetUpdateFrameStore);
        this.rangeUpdateFrameStore = new RangeUpdateFrameStore(this.owlModel);
        this.addFrameStore((FrameStore)this.rangeUpdateFrameStore);
        this.owlSubclassFrameStore = new OwlSubclassFrameStore(this.owlModel);
        this.addFrameStore((FrameStore)this.owlSubclassFrameStore);
        this.typeUpdateFrameStore = new TypeUpdateFrameStore(this.owlModel);
        this.addFrameStore((FrameStore)this.typeUpdateFrameStore);
        for (FrameStore frameStore : this.frameStores) {
            this.insertFrameStore(frameStore);
        }
        int n = this.getFrameStores().size() - 1;
        this.localClassificationFrameStore = new LocalClassificationFrameStore(this.owlModel);
        this.insertFrameStore((FrameStore)this.localClassificationFrameStore, n);
    }

    private void addFrameStore(FrameStore frameStore) {
        this.frameStores.add(0, frameStore);
    }

    protected FrameStore create(Class clazz) {
        if (clazz == DeleteSimplificationFrameStore.class) {
            return new OWLDeleteSimplificationFrameStore();
        }
        return super.create(clazz);
    }

    public void setOwlFrameStoresEnabled(boolean bl) {
        for (FrameStore frameStore : this.frameStores) {
            this.setEnabled(frameStore, bl);
        }
    }

    public OWLFrameStore getOWLFrameStore() {
        return this.owlFrameStore;
    }

    public DuplicateValuesFrameStore getDuplicateValuesFrameStore() {
        return this.duplicateValuesFrameStore;
    }

    public DomainUpdateFrameStore getDomainUpdateFrameStore() {
        return this.domainUpdateFrameStore;
    }

    public FacetUpdateFrameStore getFacetUpdateFrameStore() {
        return this.facetUpdateFrameStore;
    }

    public RangeUpdateFrameStore getRangeUpdateFrameStore() {
        return this.rangeUpdateFrameStore;
    }

    public OwlSubclassFrameStore getOwlSubclassFrameStore() {
        return this.owlSubclassFrameStore;
    }

    public TypeUpdateFrameStore getTypeUpdateFrameStore() {
        return this.typeUpdateFrameStore;
    }

    public LocalClassificationFrameStore getLocalClassificationFrameStore() {
        return this.localClassificationFrameStore;
    }
}

