/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.DeleteSimplificationFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLFrameStore
extends FrameStoreAdapter {
    private static final transient Logger log = Log.getLogger(OWLFrameStore.class);
    private AbstractOWLModel owlModel;
    public static final String IGNORE_PREFIXES_IN_SEARCH = "OWL-TOLERATE-PREFIXES-IN-SEARCH";
    private boolean deletingRDFSDatatype = false;
    public static boolean autoDeleteOfAnonymousClses = true;
    private Set<OWLAnonymousClass> deletionsInProgress = new HashSet<OWLAnonymousClass>();

    public OWLFrameStore(AbstractOWLModel abstractOWLModel) {
        this.owlModel = abstractOWLModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAnonymousClass(OWLAnonymousClass oWLAnonymousClass) {
        if (this.deletionsInProgress.contains(oWLAnonymousClass)) {
            return;
        }
        try {
            this.deletionsInProgress.add(oWLAnonymousClass);
            if (oWLAnonymousClass.getDirectSubclassCount() == 1) {
                Cls cls = (Cls)oWLAnonymousClass.getDirectSubclasses().iterator().next();
                cls.removeDirectSuperclass((Cls)oWLAnonymousClass);
            } else {
                Set<RDFSClass> set = this.getReferringAnonymousClassesAndDeleteDependingListInstances(oWLAnonymousClass);
                if (set.size() > 0) {
                    this.deleteAnonymousClses(set);
                }
            }
            this.deleteAnonymousClses(Collections.singleton(oWLAnonymousClass));
        }
        finally {
            this.deletionsInProgress.remove(oWLAnonymousClass);
        }
    }

    private Set<RDFSClass> getReferringAnonymousClassesAndDeleteDependingListInstances(OWLAnonymousClass oWLAnonymousClass) {
        Slot slot = oWLAnonymousClass.getKnowledgeBase().getSlot(":DIRECT-SUBCLASSES");
        RDFProperty rDFProperty = oWLAnonymousClass.getOWLModel().getRDFFirstProperty();
        RDFList rDFList = this.owlModel.getRDFNil();
        HashSet<RDFSClass> hashSet = new HashSet<RDFSClass>();
        for (Reference reference : oWLAnonymousClass.getReferences()) {
            Frame frame = reference.getFrame();
            Slot slot2 = reference.getSlot();
            if (frame instanceof OWLAnonymousClass) {
                if (slot.equals(slot2)) continue;
                hashSet.add((RDFSClass)frame);
                continue;
            }
            if (!(frame instanceof RDFList) || !rDFProperty.equals(slot2)) continue;
            RDFList rDFList2 = (RDFList)frame;
            RDFList rDFList3 = rDFList2.getStart();
            OWLUtil.getReferringLogicalClasses(rDFList3, hashSet);
            if (rDFList.equals(rDFList2)) continue;
            this.deleteListInstance(rDFList2);
        }
        if (oWLAnonymousClass instanceof RDFResource) {
            this.deleteRDFListsThatArePropertyValues(oWLAnonymousClass);
        }
        return hashSet;
    }

    private void deleteAnonymousClses(Collection collection) {
        this.deleteAnonymousClasses(collection, Collections.EMPTY_LIST);
    }

    private void deleteAnonymousClasses(Collection collection, Collection collection2) {
        if (!collection.isEmpty()) {
            HashSet<OWLAnonymousClass> hashSet = new HashSet<OWLAnonymousClass>();
            for (Object object : collection) {
                if (object instanceof OWLAnonymousClass) {
                    OWLAnonymousClass oWLAnonymousClass = ((OWLAnonymousClass)object).getExpressionRoot();
                    if (collection2.contains(oWLAnonymousClass)) continue;
                    hashSet.add(oWLAnonymousClass);
                    continue;
                }
                if (!(object instanceof OWLDataRange)) continue;
                ((OWLDataRange)object).delete();
            }
            for (OWLAnonymousClass oWLAnonymousClass : hashSet) {
                this.deleteAnonymousTree(oWLAnonymousClass);
            }
        }
    }

    private void deleteAnonymousTree(OWLAnonymousClass oWLAnonymousClass) {
        Object object;
        if (oWLAnonymousClass instanceof OWLIntersectionClass) {
            object = (OWLIntersectionClass)oWLAnonymousClass;
            this.ensureRDFSSubClassOfStatementsExistForNamedOperands((OWLIntersectionClass)object);
        }
        object = oWLAnonymousClass.getDependingClasses();
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            OWLAnonymousClass oWLAnonymousClass2 = (OWLAnonymousClass)object2.next();
            this.deleteAnonymousTree(oWLAnonymousClass2);
        }
        this.deleteRDFListsThatArePropertyValues(oWLAnonymousClass);
        if (oWLAnonymousClass instanceof OWLQuantifierRestriction && (object2 = ((OWLQuantifierRestriction)oWLAnonymousClass).getFiller()) instanceof RDFSDatatype && object2.isAnonymous()) {
            this.deletingRDFSDatatype = true;
            object2.delete();
            this.deletingRDFSDatatype = false;
        }
        super.deleteCls((Cls)oWLAnonymousClass);
    }

    private void deleteDependingAnonymousClses(Cls cls) {
        Collection collection = this.getClsesToDelete(cls);
        for (Cls cls2 : collection) {
            if (!(cls2 instanceof RDFSNamedClass)) continue;
            Set set = ((RDFSNamedClass)cls2).getReferringAnonymousClasses();
            this.deleteAnonymousClses(set);
            for (Cls cls3 : new ArrayList(cls2.getDirectSuperclasses())) {
                if (!(cls3 instanceof OWLAnonymousClass)) continue;
                cls3.delete();
            }
        }
    }

    private void deleteDependingAnonymousClses(Slot slot) {
        Collection collection = this.getSlotsToDelete(slot);
        for (Slot slot2 : collection) {
            if (!(slot2 instanceof RDFProperty)) continue;
            Set set = ((RDFProperty)slot2).getReferringAnonymousClasses();
            this.deleteAnonymousClses(set);
        }
    }

    private void deleteDependingListInstances(Instance instance) {
        RDFList rDFList = this.owlModel.getRDFNil();
        Set set = this.getReferences(instance);
        RDFProperty rDFProperty = this.owlModel.getRDFFirstProperty();
        for (Reference reference : set) {
            RDFList rDFList2;
            if (!rDFProperty.equals(reference.getSlot()) || rDFList.equals(rDFList2 = (RDFList)reference.getFrame())) continue;
            this.deleteListInstance(rDFList2);
        }
        if (instance instanceof RDFResource) {
            this.deleteRDFListsThatArePropertyValues((RDFResource)instance);
        }
    }

    private void deleteRDFListsThatArePropertyValues(RDFResource rDFResource) {
        RDFList rDFList = this.owlModel.getRDFNil();
        for (RDFProperty rDFProperty : rDFResource.getPossibleRDFProperties()) {
            ArrayList arrayList = new ArrayList(rDFResource.getPropertyValues(rDFProperty));
            for (Object e : arrayList) {
                if (!(e instanceof RDFList) || rDFList.equals(e)) continue;
                RDFList rDFList2 = (RDFList)e;
                rDFResource.removePropertyValue(rDFProperty, rDFList2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Deleting " + rDFList2.getBrowserText() + " at " + rDFList2.getBrowserText() + " . " + rDFProperty.getBrowserText());
                }
                rDFList2.delete();
            }
        }
    }

    private void deleteListInstance(RDFList rDFList) {
        RDFList rDFList2 = rDFList.getRest();
        if (this.owlModel.getRDFNil().equals(rDFList2)) {
            rDFList2 = null;
        }
        rDFList.setRest(null);
        if (rDFList2 != null) {
            RDFProperty rDFProperty = this.owlModel.getRDFRestProperty();
            for (Reference reference : this.getReferences(rDFList)) {
                Frame frame = reference.getFrame();
                Slot slot = reference.getSlot();
                if (slot.isSystem() && !slot.equals(rDFProperty) && !slot.equals(this.owlModel.getOWLIntersectionOfProperty()) && !slot.equals(this.owlModel.getOWLUnionOfProperty()) && !slot.equals(this.owlModel.getOWLOneOfProperty()) && !slot.equals(this.owlModel.getOWLDistinctMembersProperty())) continue;
                frame.addOwnSlotValue(slot, (Object)rDFList2);
            }
        }
        rDFList.delete();
    }

    private void deleteNamedClass(RDFSNamedClass rDFSNamedClass) {
        this.deleteNamedClassFromDomainsAndRanges(rDFSNamedClass);
        this.deleteDependingAnonymousClses(rDFSNamedClass);
        this.deleteAnonymousClses(rDFSNamedClass.getSuperclasses(false));
        this.deleteAnonymousClses(rDFSNamedClass.getReferringAnonymousClasses());
        this.deleteDependingListInstances(rDFSNamedClass);
        super.deleteCls((Cls)rDFSNamedClass);
    }

    private void deleteNamedClassFromDomainsAndRanges(RDFSNamedClass rDFSNamedClass) {
        Object object2;
        Set set = rDFSNamedClass.getReferringAnonymousClasses();
        for (Object object2 : set) {
            if (!(object2 instanceof OWLUnionClass)) continue;
            for (Object object3 : this.owlModel.getReferences((Frame)object2)) {
                if (!(object3.getFrame() instanceof RDFProperty)) continue;
                RDFProperty rDFProperty = (RDFProperty)object3.getFrame();
                if (object3.getSlot().equals(this.owlModel.getRDFSDomainProperty())) {
                    rDFProperty.removeUnionDomainClass(rDFSNamedClass);
                    continue;
                }
                if (!object3.getSlot().equals(this.owlModel.getRDFSRangeProperty())) continue;
                ArrayList arrayList = new ArrayList(rDFProperty.getUnionRangeClasses());
                arrayList.remove(rDFSNamedClass);
                rDFProperty.setUnionRangeClasses(arrayList);
            }
        }
        Collection collection = this.owlModel.getReferences((Frame)rDFSNamedClass);
        object2 = collection.iterator();
        while (object2.hasNext()) {
            Object object3;
            Reference reference = (Reference)object2.next();
            if (!reference.getSlot().equals(this.owlModel.getRDFSDomainProperty())) continue;
            object3 = (RDFProperty)reference.getFrame();
            object3.removeUnionDomainClass(rDFSNamedClass);
        }
    }

    public void deleteQuantifierRestrictions(OWLProperty oWLProperty) {
        HashSet<OWLAnonymousClass> hashSet = new HashSet<OWLAnonymousClass>();
        for (Reference object : this.owlModel.getReferences((Frame)oWLProperty)) {
            if (!(object.getFrame() instanceof OWLQuantifierRestriction)) continue;
            OWLQuantifierRestriction oWLQuantifierRestriction = (OWLQuantifierRestriction)object.getFrame();
            hashSet.add(oWLQuantifierRestriction.getExpressionRoot());
        }
        for (OWLAnonymousClass oWLAnonymousClass : hashSet) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("- Deleting quantifier restriction root " + oWLAnonymousClass.getBrowserText());
            }
            oWLAnonymousClass.delete();
        }
    }

    private void deleteListChain(RDFList rDFList) {
        RDFList rDFList2;
        Object object = rDFList.getFirst();
        if (object instanceof OWLAnonymousClass) {
            rDFList.setFirst(null);
            ((OWLAnonymousClass)object).delete();
        }
        if ((rDFList2 = rDFList.getRest()) != null && !this.owlModel.getRDFNil().equals(rDFList2)) {
            rDFList2.delete();
        }
    }

    private void ensureRDFSSubClassOfStatementsExistForNamedOperands(OWLIntersectionClass oWLIntersectionClass) {
        Collection collection = oWLIntersectionClass.getSuperclasses(false);
        if (collection.size() == 1) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)collection.iterator().next();
            RDFProperty rDFProperty = this.owlModel.getRDFSSubClassOfProperty();
            Iterator iterator = oWLIntersectionClass.listOperands();
            while (iterator.hasNext()) {
                RDFSClass rDFSClass = (RDFSClass)iterator.next();
                if (!(rDFSClass instanceof RDFSNamedClass) || rDFSNamedClass.getPropertyValues(rDFProperty).contains(rDFSClass)) continue;
                rDFSNamedClass.addPropertyValue(rDFProperty, rDFSClass);
            }
        }
    }

    public Collection getClsesToDelete(Cls cls) {
        Set set = this.getSubclasses(cls);
        HashSet<Cls> hashSet = new HashSet<Cls>(set);
        hashSet.add(cls);
        for (Cls cls2 : set) {
            if (cls2.equals(cls) || !this.isReachableByAnotherRoute(cls2, hashSet)) continue;
            hashSet.remove(cls2);
            HashSet hashSet2 = new HashSet(this.getSubclasses(cls2));
            hashSet2.remove(cls);
            hashSet.removeAll(hashSet2);
        }
        return hashSet;
    }

    private DeleteSimplificationFrameStore getDeleteSimplificationFrameStore() {
        for (FrameStore frameStore : this.owlModel.getFrameStores()) {
            if (!(frameStore instanceof DeleteSimplificationFrameStore)) continue;
            return (DeleteSimplificationFrameStore)frameStore;
        }
        return null;
    }

    @Deprecated
    public List getLiteralValues(List list) {
        ArrayList arrayList = new ArrayList();
        for (Object e : list) {
            if (e instanceof RDFSLiteral) {
                arrayList.add(e);
                continue;
            }
            arrayList.add(this.owlModel.createRDFSLiteral(e));
        }
        return arrayList;
    }

    private Collection getSlotsToDelete(Slot slot) {
        DeleteSimplificationFrameStore deleteSimplificationFrameStore = this.getDeleteSimplificationFrameStore();
        return deleteSimplificationFrameStore.getSlotsToDelete(slot);
    }

    public static boolean isIgnorePrefixesInSearch(OWLModel oWLModel) {
        return Boolean.TRUE.equals(oWLModel.getOWLProject().getSettingsMap().getBoolean(IGNORE_PREFIXES_IN_SEARCH));
    }

    private boolean isReachableByAnotherRoute(Cls cls, Collection collection) {
        ArrayList arrayList = new ArrayList(this.getDirectSuperclasses(cls));
        arrayList.remove(this.owlModel.getAnonymousRootCls());
        if (arrayList.size() > 1) {
            for (Cls cls2 : arrayList) {
                if (!(cls2 instanceof RDFSNamedClass) || collection.contains(cls2)) continue;
                return true;
            }
        }
        return false;
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        if (frame instanceof RDFProperty && slot.equals(this.owlModel.getRDFSRangeProperty())) {
            List list = frame.getDirectOwnSlotValues(slot);
            super.setDirectOwnSlotValues(frame, slot, collection);
            this.deleteAnonymousClasses(list, collection);
        } else if (frame instanceof RDFProperty && slot.equals(this.owlModel.getRDFSDomainProperty())) {
            List list = frame.getDirectOwnSlotValues(slot);
            super.setDirectOwnSlotValues(frame, slot, collection);
            this.deleteAnonymousClasses(list, collection);
        } else {
            super.setDirectOwnSlotValues(frame, slot, collection);
        }
    }

    public Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Cls cls = super.createCls(frameID, collection, collection2, bl);
        if (cls instanceof RDFSNamedClass) {
            ((RDFSNamedClass)cls).setPropertyValues(this.owlModel.getRDFSSubClassOfProperty(), collection2);
        }
        if (cls instanceof OWLNamedClass && cls.isEditable()) {
            for (Cls cls2 : collection2) {
                if (!(cls2 instanceof OWLNamedClass) || !((OWLNamedClass)cls2).getSubclassesDisjoint()) continue;
                OWLUtil.ensureSubclassesDisjoint((OWLNamedClass)cls2);
            }
        }
        return cls;
    }

    public void deleteCls(Cls cls) {
        if (cls instanceof OWLAnonymousClass) {
            this.deleteAnonymousClass((OWLAnonymousClass)cls);
        } else if (cls instanceof RDFSNamedClass) {
            this.deleteNamedClass((RDFSNamedClass)cls);
        } else {
            this.deleteDependingListInstances((Instance)cls);
            super.deleteCls(cls);
        }
    }

    public void deleteSlot(Slot slot) {
        this.deleteDependingListInstances((Instance)slot);
        if (slot instanceof RDFProperty) {
            RDFProperty rDFProperty = (RDFProperty)slot;
            this.deleteDependingAnonymousClses(rDFProperty);
            if (rDFProperty.hasObjectRange()) {
                this.deleteAnonymousClses(rDFProperty.getPropertyValues(this.owlModel.getRDFSRangeProperty()));
            }
            Collection collection = slot.getDirectDomain();
            this.deleteAnonymousClses(collection);
            RDFResource rDFResource = rDFProperty.getRange();
            if (rDFResource instanceof RDFSDatatype && rDFResource.isAnonymous()) {
                rDFResource.delete();
            }
        }
        super.deleteSlot(slot);
    }

    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        if (simpleInstance instanceof RDFList) {
            this.deleteListChain((RDFList)simpleInstance);
        }
        this.deleteDependingListInstances((Instance)simpleInstance);
        if (simpleInstance instanceof RDFResource && !this.deletingRDFSDatatype) {
            RDFResource rDFResource = (RDFResource)simpleInstance;
            this.deleteAnonymousClses(rDFResource.getReferringAnonymousClasses());
        }
        super.deleteSimpleInstance(simpleInstance);
    }

    public Set getClsesWithMatchingBrowserText(String string, Collection collection, int n) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(super.getClsesWithMatchingBrowserText(string, collection, n));
        if (OWLFrameStore.isIgnorePrefixesInSearch(this.owlModel)) {
            for (String string2 : this.owlModel.getNamespaceManager().getPrefixes()) {
                hashSet.addAll(super.getClsesWithMatchingBrowserText(string2 + ":" + string, collection, n));
            }
        }
        return hashSet;
    }

    public Set getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n) {
        Set set = super.getFramesWithMatchingDirectOwnSlotValue(slot, string, n);
        return set;
    }

    public Set getMatchingReferences(String string, int n) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(super.getMatchingReferences(string, n));
        if (OWLFrameStore.isIgnorePrefixesInSearch(this.owlModel)) {
            for (String string2 : this.owlModel.getNamespaceManager().getPrefixes()) {
                hashSet.addAll(super.getMatchingReferences(string2 + ":" + string, n));
            }
        }
        return hashSet;
    }

    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        super.removeDirectSuperclass(cls, cls2);
        if (cls2 instanceof OWLAnonymousClass && autoDeleteOfAnonymousClses) {
            cls2.delete();
        }
    }
}

