/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.EventDispatchFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalClassificationFrameStore
extends FrameStoreAdapter {
    private OWLModel owlModel;
    private Map<Slot, Map<Frame, List>> slotsMap = null;

    public LocalClassificationFrameStore(OWLModel oWLModel) {
        this.owlModel = oWLModel;
    }

    private Map<Slot, Map<Frame, List>> getSlotsMap() {
        if (this.slotsMap == null) {
            this.slotsMap = new HashMap<Slot, Map<Frame, List>>();
            this.slotsMap.put(this.owlModel.getRDFProperty(ProtegeNames.Slot.CLASSIFICATION_STATUS), new HashMap());
            this.slotsMap.put(this.owlModel.getRDFProperty(ProtegeNames.Slot.INFERRED_TYPE), new HashMap());
            this.slotsMap.put(this.owlModel.getRDFProperty(ProtegeNames.Slot.INFERRED_SUBCLASSES), new HashMap());
            this.slotsMap.put(this.owlModel.getRDFProperty(ProtegeNames.Slot.INFERRED_SUPERCLASSES), new HashMap());
        }
        return this.slotsMap;
    }

    public static boolean isLocalClassificationProperty(Slot slot) {
        String string = slot.getName();
        return string.equals(ProtegeNames.Slot.CLASSIFICATION_STATUS) || string.equals(ProtegeNames.Slot.INFERRED_TYPE) || string.equals(ProtegeNames.Slot.INFERRED_SUBCLASSES) || string.equals(ProtegeNames.Slot.INFERRED_SUPERCLASSES);
    }

    public void deleteCls(Cls cls) {
        for (Slot slot : this.getSlotsMap().keySet()) {
            Map<Frame, List> map = this.getSlotsMap().get(slot);
            map.remove(cls);
            for (Frame frame : new ArrayList<Frame>(map.keySet())) {
                Collection collection = map.get(frame);
                if (!collection.contains(cls)) continue;
                ArrayList arrayList = new ArrayList(collection);
                arrayList.remove(cls);
                frame.setDirectOwnSlotValues(slot, arrayList);
            }
        }
        super.deleteCls(cls);
    }

    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        Map<Frame, List> map = this.getSlotsMap().get(slot);
        if (map != null) {
            List list = map.get(frame);
            if (list == null) {
                return Collections.EMPTY_LIST;
            }
            return list;
        }
        return super.getDirectOwnSlotValues(frame, slot);
    }

    public Collection getOwnSlotValues(Frame frame, Slot slot) {
        Map<Frame, List> map = this.getSlotsMap().get(slot);
        if (map != null) {
            List list = map.get(frame);
            if (list == null) {
                return Collections.EMPTY_LIST;
            }
            return list;
        }
        return super.getOwnSlotValues(frame, slot);
    }

    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        Map<Frame, List> map = this.getSlotsMap().get(slot);
        if (map != null) {
            return this.getDirectOwnSlotValues(frame, slot).size();
        }
        return super.getDirectOwnSlotValuesCount(frame, slot);
    }

    private EventDispatchFrameStore getEventDispatchFrameStore() {
        for (FrameStore frameStore : this.owlModel.getFrameStores()) {
            if (!(frameStore instanceof EventDispatchFrameStore)) continue;
            return (EventDispatchFrameStore)frameStore;
        }
        return null;
    }

    public Set getFramesWithDirectOwnSlotValue(Slot slot, Object object) {
        Map<Frame, List> map = this.getSlotsMap().get(slot);
        if (map != null) {
            HashSet<Frame> hashSet = new HashSet<Frame>();
            for (Frame frame : map.keySet()) {
                Collection collection = map.get(frame);
                if (collection == null || !collection.contains(object)) continue;
                hashSet.add(frame);
            }
            return hashSet;
        }
        return super.getFramesWithDirectOwnSlotValue(slot, object);
    }

    public Set<Frame> getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n) {
        Map<Frame, List> map = this.getSlotsMap().get(slot);
        if (map != null) {
            SimpleStringMatcher simpleStringMatcher = new SimpleStringMatcher(string);
            HashSet<Frame> hashSet = new HashSet<Frame>();
            for (Map.Entry<Frame, List> entry : map.entrySet()) {
                Frame frame = entry.getKey();
                List list = entry.getValue();
                for (Object e : list) {
                    if (!(e instanceof String) || !simpleStringMatcher.isMatch((String)e)) continue;
                    hashSet.add(frame);
                }
            }
            return hashSet;
        }
        return super.getFramesWithMatchingDirectOwnSlotValue(slot, string, n);
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        Map<Frame, List> map = this.getSlotsMap().get(slot);
        if (map != null) {
            if (collection.isEmpty()) {
                map.remove(frame);
            } else {
                map.put(frame, new ArrayList(collection));
            }
        } else {
            super.setDirectOwnSlotValues(frame, slot, collection);
        }
    }
}

