/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.updater.AbstractRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.updater.AllValuesFromRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.updater.CardinalityRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.updater.HasValueRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.updater.RestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetUpdateFrameStore
extends FrameStoreAdapter {
    private OWLModel owlModel;
    protected boolean superclassHandlingBlocked;
    private Hashtable<Class, AbstractRestrictionUpdater> class2Updater = new Hashtable();
    private Hashtable<Facet, AbstractRestrictionUpdater> facet2Updater = new Hashtable();
    protected boolean facetHandlingBlocked;
    private AllValuesFromRestrictionUpdater allValuesFromRestrictionUpdater;
    private CardinalityRestrictionUpdater cardinalityRestrictionUpdater;
    private HasValueRestrictionUpdater hasValueRestrictionUpdater;

    public FacetUpdateFrameStore(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.initRestrictionUpdaters();
    }

    private void initRestrictionUpdaters() {
        this.allValuesFromRestrictionUpdater = new AllValuesFromRestrictionUpdater(this.owlModel);
        this.cardinalityRestrictionUpdater = new CardinalityRestrictionUpdater(this.owlModel);
        this.hasValueRestrictionUpdater = new HasValueRestrictionUpdater(this.owlModel);
        this.facet2Updater.put(this.owlModel.getSystemFrames().getValueTypeFacet(), this.allValuesFromRestrictionUpdater);
        this.facet2Updater.put(this.owlModel.getSystemFrames().getMaximumCardinalityFacet(), this.cardinalityRestrictionUpdater);
        this.facet2Updater.put(this.owlModel.getSystemFrames().getMinimumCardinalityFacet(), this.cardinalityRestrictionUpdater);
        this.facet2Updater.put(this.owlModel.getSystemFrames().getValuesFacet(), this.hasValueRestrictionUpdater);
        this.class2Updater.put(DefaultOWLAllValuesFrom.class, this.allValuesFromRestrictionUpdater);
        this.class2Updater.put(DefaultOWLCardinality.class, this.cardinalityRestrictionUpdater);
        this.class2Updater.put(DefaultOWLHasValue.class, this.hasValueRestrictionUpdater);
        this.class2Updater.put(DefaultOWLMaxCardinality.class, this.cardinalityRestrictionUpdater);
        this.class2Updater.put(DefaultOWLMinCardinality.class, this.cardinalityRestrictionUpdater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFacetValuesIntoNamedClses() {
        boolean bl = this.owlModel.isUndoEnabled();
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
        this.owlModel.setUndoEnabled(false);
        try {
            for (TripleStore tripleStore2 : tripleStoreModel.getTripleStores()) {
                tripleStoreModel.setActiveTripleStore(tripleStore2);
                for (OWLRestriction oWLRestriction : this.getRestrictionsForTS(tripleStore2)) {
                    this.copyFacetValuesIntoOWLNamedClass(oWLRestriction);
                }
            }
        }
        finally {
            this.owlModel.setUndoEnabled(bl);
            this.owlModel.getTripleStoreModel().setActiveTripleStore(tripleStore);
        }
    }

    private Collection<OWLRestriction> getRestrictionsForTS(TripleStore tripleStore) {
        ArrayList<OWLRestriction> arrayList = new ArrayList<OWLRestriction>();
        RDFSNamedClass rDFSNamedClass = ((AbstractOWLModel)this.owlModel).getOWLRestrictionClass();
        for (RDFSNamedClass rDFSNamedClass2 : rDFSNamedClass.getSubclasses(true)) {
            NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
            List list = narrowFrameStore.getValues((Frame)rDFSNamedClass2, this.owlModel.getSystemFrames().getDirectInstancesSlot(), null, false);
            for (Object e : list) {
                if (!(e instanceof OWLRestriction)) continue;
                arrayList.add((OWLRestriction)e);
            }
        }
        return arrayList;
    }

    private void copyFacetValuesIntoOWLNamedClass(OWLRestriction oWLRestriction) {
        Object[] objectArray = oWLRestriction.getSubclasses(false).toArray();
        if (objectArray.length == 1 && objectArray[0] instanceof RDFSNamedClass) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)objectArray[0];
            this.copyFacetValuesIntoOWLNamedClass(rDFSNamedClass, oWLRestriction);
        }
    }

    private void copyFacetValuesIntoOWLNamedClass(RDFSNamedClass rDFSNamedClass, OWLRestriction oWLRestriction) {
        Class<?> clazz = oWLRestriction.getClass();
        RestrictionUpdater restrictionUpdater = this.class2Updater.get(clazz);
        if (restrictionUpdater != null) {
            this.facetHandlingBlocked = true;
            restrictionUpdater.copyFacetValuesIntoNamedClass(rDFSNamedClass, oWLRestriction);
            this.facetHandlingBlocked = false;
        }
    }

    private void updateRestrictions(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, Facet facet) {
        RestrictionUpdater restrictionUpdater = this.facet2Updater.get(facet);
        if (restrictionUpdater != null) {
            this.superclassHandlingBlocked = true;
            restrictionUpdater.updateRestrictions(oWLNamedClass, rDFProperty, facet);
            this.superclassHandlingBlocked = false;
        }
    }

    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Slot slot = super.createSlot(frameID, collection, collection2, bl);
        if (slot instanceof RDFProperty) {
            RDFProperty rDFProperty = (RDFProperty)slot;
            slot.setAllowsMultipleValues(true);
        }
        return slot;
    }

    public void addDirectSuperclass(Cls cls, Cls cls2) {
        super.addDirectSuperclass(cls, cls2);
        if (!this.superclassHandlingBlocked && cls instanceof OWLNamedClass) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)cls;
            if (cls2 instanceof OWLRestriction) {
                this.copyFacetValuesIntoOWLNamedClass(oWLNamedClass, (OWLRestriction)cls2);
            }
        }
    }

    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        super.removeDirectSuperclass(cls, cls2);
        if (!this.superclassHandlingBlocked && cls instanceof OWLNamedClass && cls2 instanceof OWLRestriction) {
            this.copyFacetValuesIntoOWLNamedClass((OWLNamedClass)cls, (OWLRestriction)cls2);
        }
    }

    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        super.setDirectTemplateFacetValues(cls, slot, facet, collection);
        if (!this.facetHandlingBlocked && cls instanceof OWLNamedClass && slot instanceof RDFProperty) {
            this.updateRestrictions((OWLNamedClass)cls, (RDFProperty)slot, facet);
        }
        if (!this.superclassHandlingBlocked && cls instanceof OWLRestriction) {
            OWLRestriction oWLRestriction = (OWLRestriction)cls;
            this.copyFacetValuesIntoOWLNamedClass(oWLRestriction);
        }
    }

    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        super.setDirectTemplateSlotValues(cls, slot, collection);
        if (!this.facetHandlingBlocked && cls instanceof OWLNamedClass && slot instanceof RDFProperty) {
            this.updateRestrictions((OWLNamedClass)cls, (RDFProperty)slot, this.owlModel.getFacet(":VALUES"));
        }
    }
}

