/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DomainUpdateFrameStore
extends FrameStoreAdapter {
    private OWLModel owlModel;
    private OWLNamedClass owlThing;
    private RDFSNamedClass rdfPropertyClass;
    private RDFProperty rdfsDomainProperty;
    private Slot directDomainSlot;

    public DomainUpdateFrameStore(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.owlThing = oWLModel.getOWLThingClass();
        this.rdfPropertyClass = oWLModel.getRDFPropertyClass();
        this.rdfsDomainProperty = oWLModel.getRDFSDomainProperty();
        this.directDomainSlot = oWLModel.getSystemFrames().getDirectDomainSlot();
    }

    public void synchronizeRDFSDomainWithProtegeDomain(RDFProperty rDFProperty) {
        List list = super.getDirectOwnSlotValues((Frame)rDFProperty, (Slot)this.rdfsDomainProperty);
        this.updateSlotDomain(rDFProperty, list);
    }

    private void updateRDFSDomain(RDFProperty rDFProperty) {
        List list = super.getDirectDomain((Slot)rDFProperty);
        RDFSClass rDFSClass = null;
        rDFSClass = list.size() == 1 ? (RDFSClass)list.iterator().next() : this.owlModel.createOWLUnionClass(list);
        super.setDirectOwnSlotValues((Frame)rDFProperty, (Slot)this.rdfsDomainProperty, Collections.singleton(rDFSClass));
    }

    private void updateSlotDomain(Slot slot, Collection collection) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (collection.size() == 1 && collection.iterator().next() instanceof RDFSClass) {
            object = (RDFSClass)collection.iterator().next();
            if (object instanceof OWLUnionClass) {
                arrayList.addAll(((OWLUnionClass)object).getOperands());
            } else {
                arrayList.add(object);
            }
        }
        if (!arrayList.isEmpty()) {
            object = new ArrayList(super.getDirectDomain(slot));
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                if (!(object2 instanceof Cls) || arrayList.contains(object2)) continue;
                super.removeDirectTemplateSlot((Cls)object2, slot);
            }
            for (RDFSClass rDFSClass : arrayList) {
                if (object.contains(rDFSClass)) continue;
                super.addDirectTemplateSlot((Cls)rDFSClass, slot);
            }
        } else {
            super.setDirectOwnSlotValues((Frame)slot, this.directDomainSlot, Collections.singleton(this.owlThing));
        }
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection arrayList) {
        if (frame instanceof RDFProperty && slot.equals(this.rdfsDomainProperty)) {
            if (arrayList.size() > 1 && arrayList.contains(this.owlThing)) {
                arrayList = new ArrayList(arrayList);
                arrayList.remove(this.owlThing);
            }
            super.setDirectOwnSlotValues(frame, slot, (Collection)arrayList);
            this.updateSlotDomain((Slot)frame, arrayList);
            return;
        }
        if (slot.equals(this.owlModel.getRDFTypeProperty()) && arrayList.contains(this.rdfPropertyClass)) {
            super.setDirectOwnSlotValues(frame, slot, (Collection)arrayList);
            Slot slot2 = (Slot)super.getFrame(frame.getFrameID());
            List list = super.getDirectDomain(slot2);
            if (list != null && !list.isEmpty()) {
                return;
            }
            Set set = super.getSuperslots(slot2);
            if (set != null && !set.isEmpty()) {
                return;
            }
            super.setDirectOwnSlotValues((Frame)slot2, this.directDomainSlot, Collections.singleton(this.owlThing));
            return;
        }
        super.setDirectOwnSlotValues(frame, slot, (Collection)arrayList);
    }

    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        super.addDirectTemplateSlot(cls, slot);
        if (slot instanceof RDFProperty && cls instanceof RDFSClass) {
            this.updateRDFSDomain((RDFProperty)slot);
        }
    }

    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        super.removeDirectTemplateSlot(cls, slot);
        if (slot instanceof RDFProperty && cls instanceof RDFSClass) {
            this.updateRDFSDomain((RDFProperty)slot);
        }
    }

    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Slot slot = super.createSlot(frameID, collection, collection2, bl);
        if (slot instanceof RDFProperty) {
            super.addDirectTemplateSlot((Cls)this.owlModel.getOWLThingClass(), slot);
        }
        return slot;
    }
}

