/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.factory;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protegex.owl.database.DatabaseFactoryUtils;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerAdapter;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.factory.AlreadyImportedException;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;

public class FactoryUtils {
    public static String adjustOntologyName(String string) {
        if (string.endsWith("#")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOntologyToTripleStore(OWLModel oWLModel, TripleStore tripleStore, String string) throws AlreadyImportedException {
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        TripleStore tripleStore2 = tripleStoreModel.getActiveTripleStore();
        try {
            tripleStoreModel.setActiveTripleStore(tripleStore);
            if (oWLModel.getFrame(string) != null && oWLModel.getTripleStoreModel().getTripleStore(string) != null) {
                throw new AlreadyImportedException(string + " already imported");
            }
            if (oWLModel.getFrame(string) == null) {
                oWLModel.getOWLOntologyClass().createInstance(string);
            }
            tripleStore.setName(string);
            tripleStore.addIOAddress(string);
            NamespaceManager namespaceManager = tripleStore.getNamespaceManager();
            if (namespaceManager.getDefaultNamespace() == null) {
                namespaceManager.setDefaultNamespace(string + "#");
            }
            if (tripleStore.getOriginalXMLBase() == null) {
                tripleStore.setOriginalXMLBase(string);
            }
        }
        finally {
            tripleStoreModel.setActiveTripleStore(tripleStore2);
        }
        oWLModel.resetOntologyCache();
    }

    public static void loadEncodedNamespaceFromModel(OWLModel oWLModel, TripleStore tripleStore, Collection collection) {
        OWLOntology oWLOntology = tripleStore.getOWLOntology();
        RDFProperty rDFProperty = oWLModel.getSystemFrames().getOwlOntologyPrefixesProperty();
        NamespaceManager namespaceManager = tripleStore.getNamespaceManager();
        for (Object e : oWLOntology.getPropertyValues(rDFProperty)) {
            String string;
            String[] stringArray;
            if (!(e instanceof String) || (stringArray = FactoryUtils.splitEncodedNamespaceEntry(string = (String)e)) == null) continue;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            namespaceManager.setPrefix(string3, string2);
        }
    }

    public static void encodeNamespaceIntoModel(OWLModel oWLModel, TripleStore tripleStore) {
        if (DatabaseFactoryUtils.log.isLoggable(Level.FINE)) {
            DatabaseFactoryUtils.log.fine("Saving Prefixes to database, owl ontology = " + tripleStore.getOWLOntology());
            DatabaseFactoryUtils.log.fine("prefixes = " + tripleStore.getNamespaceManager().getPrefixes());
        }
        OWLOntology oWLOntology = tripleStore.getOWLOntology();
        RDFProperty rDFProperty = oWLModel.getSystemFrames().getOwlOntologyPrefixesProperty();
        NamespaceManager namespaceManager = tripleStore.getNamespaceManager();
        Iterator iterator = tripleStore.listObjects(oWLOntology, rDFProperty);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            tripleStore.remove(oWLOntology, rDFProperty, e);
        }
        for (String string : namespaceManager.getPrefixes()) {
            String string2 = namespaceManager.getNamespaceForPrefix(string);
            String string3 = FactoryUtils.joinEncodedNamespaceEntry(string, string2);
            tripleStore.add(oWLOntology, rDFProperty, string3);
        }
    }

    public static void addPrefixesToModelListener(final OWLModel oWLModel, final TripleStore tripleStore) {
        NamespaceManager namespaceManager = tripleStore.getNamespaceManager();
        namespaceManager.addNamespaceManagerListener(new NamespaceManagerAdapter(){

            public void namespaceChanged(String string, String string2, String string3) {
                OWLOntology oWLOntology = tripleStore.getOWLOntology();
                RDFProperty rDFProperty = oWLModel.getSystemFrames().getOwlOntologyPrefixesProperty();
                if (string2 != null) {
                    tripleStore.remove(oWLOntology, rDFProperty, FactoryUtils.joinEncodedNamespaceEntry(string, string2));
                }
                if (string3 != null) {
                    tripleStore.add(oWLOntology, rDFProperty, FactoryUtils.joinEncodedNamespaceEntry(string, string3));
                }
            }
        });
    }

    public static String[] splitEncodedNamespaceEntry(String string) {
        int n = string.indexOf(":");
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return new String[]{string2, string3};
    }

    public static String joinEncodedNamespaceEntry(String string, String string2) {
        return string + ":" + string2;
    }

    public static String getOntologyURIBase(String string, boolean bl, boolean bl2, boolean bl3) {
        if (string != null && string.trim().length() > 0) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if (bl) {
                int n = Calendar.getInstance().get(1);
                string = string + n + "/";
                if (bl2) {
                    int n2 = Calendar.getInstance().get(2) + 1;
                    string = string + n2 + "/";
                    if (bl3) {
                        int n3 = Calendar.getInstance().get(5);
                        string = string + n3 + "/";
                    }
                }
            }
        }
        return string;
    }

    public static String generateOntologyURIBase() {
        String string = ApplicationProperties.getString((String)"OntURIBase");
        if (string == null) {
            string = "http://www.owl-ontologies.com";
            ApplicationProperties.setString((String)"OntURIBase", (String)"http://www.owl-ontologies.com");
        }
        string = FactoryUtils.getOntologyURIBase(string, ApplicationProperties.getBooleanProperty((String)"OntURIBaseAppendYear", (boolean)false), ApplicationProperties.getBooleanProperty((String)"OntURIBaseAppendMonth", (boolean)false), ApplicationProperties.getBooleanProperty((String)"OntURIBaseAppendDay", (boolean)false));
        String string2 = "Ontology";
        string2 = string2 + System.currentTimeMillis() / 1000L;
        string2 = string2 + ".owl";
        return string + string2;
    }

    public static void writeOntologyAndPrefixInfo(OWLModel oWLModel, Collection collection) throws AlreadyImportedException {
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
        if (oWLModel.getDefaultOWLOntology() == null) {
            FactoryUtils.addOntologyToTripleStore(oWLModel, tripleStore, FactoryUtils.generateOntologyURIBase());
        }
        DatabaseFactoryUtils.writeOWLOntologyToDatabase(oWLModel, tripleStore);
        FactoryUtils.encodeNamespaceIntoModel(oWLModel, tripleStore);
        FactoryUtils.addPrefixesToModelListener(oWLModel, tripleStore);
        oWLModel.resetOntologyCache();
    }

    public static void adjustBrowserTextBasedOnPreferences(OWLModel oWLModel) {
        Slot slot = OWLUI.getDefaultBrowserSlot(oWLModel);
        if (slot != null) {
            OWLUI.setCommonBrowserSlot(oWLModel, slot);
        }
    }
}

