/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.factory;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.storage.OWLKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchClassDefinitionResourceDisplayPlugin;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOwlProjectCreator {
    private Class defaultClassView;
    private String profileURI;
    protected OWLKnowledgeBaseFactory factory;

    public AbstractOwlProjectCreator(OWLKnowledgeBaseFactory oWLKnowledgeBaseFactory) {
        this.factory = oWLKnowledgeBaseFactory;
    }

    public abstract void create(Collection var1) throws OntologyLoadException;

    public abstract OWLModel getOwlModel();

    public abstract Project getProject();

    protected void addViewSettings(PropertyList propertyList) {
        String string = null;
        string = this.defaultClassView == null ? SwitchClassDefinitionResourceDisplayPlugin.getDefaultClassView() : this.defaultClassView.getName();
        SwitchClassDefinitionResourceDisplayPlugin.setClassesView(propertyList, string);
        SwitchClassDefinitionResourceDisplayPlugin.setDefaultClassesView(string);
        if (this.profileURI != null) {
            ProfilesManager.setProfile(propertyList, this.profileURI);
        }
    }

    protected void insertRepositoriesIntoOwlModel(OWLModel oWLModel) {
        RepositoryManager repositoryManager = oWLModel.getRepositoryManager();
        for (Repository repository : this.getRepositories()) {
            repositoryManager.addProjectRepository(repository);
        }
    }

    public void setDefaultClassView(Class clazz) {
        this.defaultClassView = clazz;
    }

    public void setProfileURI(String string) {
        this.profileURI = string;
    }

    public Collection<Repository> getRepositories() {
        return Collections.emptyList();
    }

    public OWLKnowledgeBaseFactory getFactory() {
        return this.factory;
    }
}

