/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.dl;

import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.classparser.dl.DLSyntaxParser;
import edu.stanford.smi.protegex.owl.model.classparser.dl.DLSyntaxParserUtil;
import edu.stanford.smi.protegex.owl.model.classparser.dl.ParseException;

public class DLSyntaxClassParser
implements OWLClassParser {
    public void checkClass(OWLModel oWLModel, String string) throws OWLClassParseException {
        this.parse(oWLModel, string, false);
    }

    public void checkHasValueFiller(OWLModel oWLModel, String string) throws OWLClassParseException {
        this.parse(oWLModel, string, false);
    }

    public void checkQuantifierFiller(OWLModel oWLModel, String string) throws OWLClassParseException {
        this.parse(oWLModel, string, false);
    }

    public RDFSClass parseClass(OWLModel oWLModel, String string) throws OWLClassParseException {
        return this.parse(oWLModel, string, true);
    }

    public Object parseHasValueFiller(OWLModel oWLModel, String string) throws OWLClassParseException {
        return this.parse(oWLModel, string, true);
    }

    public RDFResource parseQuantifierFiller(OWLModel oWLModel, String string) throws OWLClassParseException {
        return this.parse(oWLModel, string, true);
    }

    private OWLClass parse(OWLModel oWLModel, String string, boolean bl) throws OWLClassParseException {
        try {
            String string2 = DLSyntaxParserUtil.getParseableString(string);
            OWLClass oWLClass = DLSyntaxParser.parseExpression(oWLModel, string2, bl);
            return oWLClass;
        }
        catch (ParseException parseException) {
            throw this.wrapAndThrowException(parseException);
        }
    }

    private OWLClassParseException wrapAndThrowException(ParseException parseException) {
        OWLClassParseException oWLClassParseException = new OWLClassParseException(parseException.getMessage());
        oWLClassParseException.nextCouldBeClass = this.contains(parseException.expectedTokenSequences, 25);
        oWLClassParseException.nextCouldBeProperty = this.contains(parseException.expectedTokenSequences, 27) | this.contains(parseException.expectedTokenSequences, 26);
        oWLClassParseException.nextCouldBeIndividual = this.contains(parseException.expectedTokenSequences, 28);
        oWLClassParseException.nextCouldBeDatatypeName = this.contains(parseException.expectedTokenSequences, 24);
        return oWLClassParseException;
    }

    private boolean contains(int[][] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray2[j] != n) continue;
                return true;
            }
        }
        return false;
    }
}

