/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser;

import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.AmbiguousNameException;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserUtils {
    public static final String RESTRICTIONS_CAN_USE_BROWSER_TEXT = "protege.owl.edit.restrictions.with.browser.text";
    public static final String SINGLE_QUOTE_STRING = "'";
    public static final String[] SUBSTRINGS_REQUIRING_QUOTES = new String[]{" ", ";", " ", "#"};
    public static final char[] INITIAL_CHARACTERS_REQUIRING_QUOTES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static boolean editUsingBrowserText = ApplicationProperties.getBooleanProperty((String)"protege.owl.edit.restrictions.with.browser.text", (boolean)true);

    public static RDFResource getFrameByName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return ParserUtils.getFrameByName(oWLModel, string, RDFResource.class);
    }

    public static OWLNamedClass getOWLClassFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return ParserUtils.getFrameByName(oWLModel, string, OWLNamedClass.class);
    }

    public static RDFProperty getRDFPropertyFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return ParserUtils.getFrameByName(oWLModel, string, RDFProperty.class);
    }

    public static OWLDatatypeProperty getOWLDatatypePropertyFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return ParserUtils.getFrameByName(oWLModel, string, OWLDatatypeProperty.class);
    }

    public static OWLObjectProperty getOWLObjectPropertyFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return ParserUtils.getFrameByName(oWLModel, string, OWLObjectProperty.class);
    }

    public static RDFResource getRDFResourceFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return ParserUtils.getFrameByName(oWLModel, string, RDFResource.class);
    }

    public static RDFResource getRDFResourceFromRDFSLabel(OWLModel oWLModel, String string) throws AmbiguousNameException {
        RDFResource rDFResource = null;
        rDFResource = ParserUtils.getFrameByRDFSLabel(oWLModel, string, RDFResource.class);
        return rDFResource;
    }

    public static RDFSClass getRDFSClassFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return ParserUtils.getFrameByName(oWLModel, string, RDFSClass.class);
    }

    public static OWLIndividual getOWLIndividualFromName(OWLModel oWLModel, String string) throws AmbiguousNameException {
        return ParserUtils.getFrameByName(oWLModel, string, OWLIndividual.class);
    }

    private static <X extends RDFResource> X getFrameByName(OWLModel oWLModel, String string, Class<? extends X> clazz) throws AmbiguousNameException {
        X x = ParserUtils.getFrameByURI(oWLModel, string, clazz);
        if (x != null) {
            return x;
        }
        x = ParserUtils.getFrameByRDFSLabel(oWLModel, string, clazz);
        if (x != null) {
            return x;
        }
        x = ParserUtils.getFrameByBrowserText(oWLModel, string, clazz);
        if (x != null) {
            return x;
        }
        return null;
    }

    private static <X extends RDFResource> X getFrameByURI(OWLModel oWLModel, String string, Class<? extends X> clazz) {
        RDFResource rDFResource = (RDFResource)oWLModel.getFrame(string);
        if (rDFResource != null && ParserUtils.resourceCorrectlyTyped((Frame)rDFResource, clazz)) {
            return (X)((RDFResource)clazz.cast(rDFResource));
        }
        rDFResource = null;
        String string2 = NamespaceUtil.getFullName(oWLModel, string);
        if (string2 != null && !string.equals(string2) && (rDFResource = (RDFResource)oWLModel.getFrame(string2)) != null && ParserUtils.resourceCorrectlyTyped((Frame)rDFResource, clazz)) {
            return (X)((RDFResource)clazz.cast(rDFResource));
        }
        return null;
    }

    private static <X extends RDFResource> X getFrameByRDFSLabel(OWLModel oWLModel, String string, Class<? extends X> clazz) {
        return ParserUtils.getFrameUsingDatatypeProperty(oWLModel, string, clazz, oWLModel.getRDFSLabelProperty());
    }

    private static <X extends RDFResource> X getFrameByBrowserText(OWLModel oWLModel, String string, Class<? extends X> clazz) throws AmbiguousNameException {
        Object object = null;
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        if (editUsingBrowserText) {
            Object object2;
            Project project = oWLModel.getProject();
            for (Cls object3 : project.getClsesWithDirectBrowserSlots()) {
                Slot slot;
                if (!(object3 instanceof RDFSNamedClass) || !(object2 = object3.getBrowserSlotPattern()).isSimple() || !((slot = object2.getFirstSlot()) instanceof RDFProperty)) continue;
                hashSet.add((RDFProperty)slot);
            }
            for (RDFProperty rDFProperty : hashSet) {
                object2 = ParserUtils.getFrameUsingDatatypeProperty(oWLModel, string, clazz, rDFProperty);
                if (object != null && object2 != null) {
                    throw new AmbiguousNameException("Multiple resources share the same name " + string);
                }
                if (object != null) continue;
                object = object2;
            }
        }
        return (X)object;
    }

    private static <X extends RDFResource> X getFrameUsingDatatypeProperty(OWLModel oWLModel, String string, Class<? extends X> clazz, RDFProperty rDFProperty) throws AmbiguousNameException {
        String string2 = oWLModel.getDefaultLanguage();
        RDFResource rDFResource = null;
        Collection collection = oWLModel.getFramesWithValue(rDFProperty, null, false, DefaultRDFSLiteral.getRawValue(string, string2));
        for (Object e : collection) {
            if (!ParserUtils.resourceCorrectlyTyped((Frame)e, clazz) || !ParserUtils.displaysWithProperty(oWLModel, (Instance)e, rDFProperty)) continue;
            if (rDFResource != null) {
                throw new AmbiguousNameException("Multiple resources share the same name " + string);
            }
            rDFResource = (RDFResource)e;
        }
        if (rDFResource != null) {
            return (X)((RDFResource)clazz.cast(rDFResource));
        }
        if (string2 != null) {
            collection = oWLModel.getFramesWithValue(rDFProperty, null, false, DefaultRDFSLiteral.getRawValue(string, (String)null));
            for (Object e : collection) {
                if (!ParserUtils.resourceCorrectlyTyped((Frame)e, clazz) || !ParserUtils.displaysWithProperty(oWLModel, (Instance)e, rDFProperty)) continue;
                if (rDFResource != null) {
                    throw new AmbiguousNameException("After falling back to the null language multiple resources share the same name " + string);
                }
                rDFResource = (RDFResource)e;
            }
        }
        return (X)((RDFResource)clazz.cast(rDFResource));
    }

    private static boolean displaysWithProperty(OWLModel oWLModel, Instance instance, RDFProperty rDFProperty) {
        BrowserSlotPattern browserSlotPattern;
        List list;
        Cls cls;
        if (instance instanceof OWLIndividual) {
            cls = OWLUI.getOneNamedDirectTypeWithBrowserPattern((OWLIndividual)instance);
            if (cls == null) {
                return false;
            }
        } else {
            cls = instance.getDirectType();
        }
        return (list = (browserSlotPattern = cls.getBrowserSlotPattern()).getSlots()).size() == 1 && list.contains(rDFProperty);
    }

    private static boolean resourceCorrectlyTyped(Frame frame, Class clazz) {
        if (clazz == null) {
            return true;
        }
        return clazz.isAssignableFrom(frame.getClass());
    }

    public static String quoteIfNeeded(String string) {
        if (string == null) {
            return null;
        }
        if (ParserUtils.quoteNeeded(string)) {
            return SINGLE_QUOTE_STRING + string + SINGLE_QUOTE_STRING;
        }
        return string;
    }

    public static boolean quoteNeeded(String string) {
        if (string.length() == 0) {
            return true;
        }
        for (String string2 : SUBSTRINGS_REQUIRING_QUOTES) {
            if (!string.contains(string2)) continue;
            return true;
        }
        char c = string.charAt(0);
        for (char c2 : INITIAL_CHARACTERS_REQUIRING_QUOTES) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    public static String dequoteIdentifier(String string) {
        if (string.startsWith(SINGLE_QUOTE_STRING) && string.endsWith(SINGLE_QUOTE_STRING)) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean isLexError(Error error) {
        String string = error.getClass().getCanonicalName();
        return string.endsWith("TokenMgrError");
    }

    public static int findSplittingPoint(String string) {
        int n;
        if (ParserUtils.countQuotes(string) % 2 == 1) {
            int n2 = string.lastIndexOf(SINGLE_QUOTE_STRING);
            return n2;
        }
        for (n = string.length() - 1; n >= 0 && ParserUtils.isIdChar(string.charAt(n)); --n) {
        }
        return n + 1;
    }

    private static int countQuotes(String string) {
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(SINGLE_QUOTE_STRING, n)) != -1) {
            ++n2;
            ++n;
        }
        return n2;
    }

    public static boolean isIdChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == ':' || c == '-';
    }
}

