/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classdisplay.dl;

import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.model.visitor.Visitable;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import java.util.Iterator;
import java.util.Stack;

public class DLSyntaxBrowserTextGenerator
implements OWLModelVisitor {
    private StringBuffer buffer = new StringBuffer();
    private Stack<Visitable> resourceStack = new Stack();

    public String getBrowserText() {
        return this.buffer.toString();
    }

    public void reset() {
        this.buffer = new StringBuffer();
    }

    protected StringBuffer getCurrentBuffer() {
        return this.buffer;
    }

    protected void write(String string) {
        this.getCurrentBuffer().append(string);
    }

    protected void write(char c) {
        this.getCurrentBuffer().append(c);
    }

    protected void writeSpace() {
        this.getCurrentBuffer().append(" ");
    }

    protected void writeOpenPar() {
        if (this.resourceStack.size() > 1) {
            this.getCurrentBuffer().append("(");
        }
    }

    protected void writeClosePar() {
        if (this.resourceStack.size() > 1) {
            this.getCurrentBuffer().append(")");
        }
    }

    public void visitOWLAllDifferent(OWLAllDifferent oWLAllDifferent) {
    }

    private void push(RDFSClass rDFSClass) {
        this.resourceStack.push(rDFSClass);
    }

    private void pop() {
        this.resourceStack.pop();
    }

    protected void writeCardinality(OWLCardinalityBase oWLCardinalityBase) {
        this.writeOpenPar();
        this.write(oWLCardinalityBase.getOperator());
        this.writeSpace();
        this.write(String.valueOf(oWLCardinalityBase.getCardinality()));
        this.writeSpace();
        if (oWLCardinalityBase.getOnProperty() != null) {
            oWLCardinalityBase.getOnProperty().accept(this);
        }
        if (oWLCardinalityBase.getQualifier() != null) {
            this.writeSpace();
            oWLCardinalityBase.getQualifier().accept(this);
        }
        this.writeClosePar();
    }

    protected void writeQuantifier(OWLQuantifierRestriction oWLQuantifierRestriction) {
        this.writeOpenPar();
        this.write(oWLQuantifierRestriction.getOperator());
        this.writeSpace();
        if (oWLQuantifierRestriction.getOnProperty() != null) {
            oWLQuantifierRestriction.getOnProperty().accept(this);
        }
        this.writeSpace();
        if (oWLQuantifierRestriction.getFiller() != null) {
            oWLQuantifierRestriction.getFiller().accept(this);
        }
        this.writeClosePar();
    }

    protected void writeNAryLocical(OWLNAryLogicalClass oWLNAryLogicalClass) {
        this.writeOpenPar();
        Iterator<RDFSClass> iterator = oWLNAryLogicalClass.getOperands().iterator();
        while (iterator.hasNext()) {
            RDFResource rDFResource = iterator.next();
            rDFResource.accept(this);
            if (!iterator.hasNext()) continue;
            this.writeSpace();
            this.write(oWLNAryLogicalClass.getOperatorSymbol());
            this.writeSpace();
        }
        this.writeClosePar();
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom oWLAllValuesFrom) {
        this.push(oWLAllValuesFrom);
        this.writeQuantifier(oWLAllValuesFrom);
        this.pop();
    }

    public void visitOWLCardinality(OWLCardinality oWLCardinality) {
        this.push(oWLCardinality);
        this.writeCardinality(oWLCardinality);
        this.pop();
    }

    public void visitOWLComplementClass(OWLComplementClass oWLComplementClass) {
        this.push(oWLComplementClass);
        this.writeOpenPar();
        this.write(oWLComplementClass.getOperatorSymbol());
        this.writeSpace();
        if (oWLComplementClass.getComplement() != null) {
            oWLComplementClass.getComplement().accept(this);
        }
        this.writeClosePar();
        this.pop();
    }

    public void visitOWLDataRange(OWLDataRange oWLDataRange) {
        this.write("{");
        Iterator iterator = oWLDataRange.getOneOfValueLiterals().iterator();
        while (iterator.hasNext()) {
            RDFSLiteral rDFSLiteral = (RDFSLiteral)iterator.next();
            rDFSLiteral.accept(this);
            if (!iterator.hasNext()) continue;
            this.writeSpace();
        }
        this.write("}");
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty oWLDatatypeProperty) {
        this.write(oWLDatatypeProperty.getBrowserText());
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass oWLEnumeratedClass) {
        this.push(oWLEnumeratedClass);
        this.write("{");
        Iterator iterator = oWLEnumeratedClass.getOneOf().iterator();
        while (iterator.hasNext()) {
            RDFResource rDFResource = (RDFResource)iterator.next();
            rDFResource.accept(this);
            if (!iterator.hasNext()) continue;
            this.writeSpace();
        }
        this.write("}");
        this.pop();
    }

    public void visitOWLHasValue(OWLHasValue oWLHasValue) {
        this.push(oWLHasValue);
        this.writeOpenPar();
        this.write('\u2203');
        this.writeSpace();
        if (oWLHasValue.getOnProperty() != null) {
            oWLHasValue.getOnProperty().accept(this);
        }
        this.writeSpace();
        this.write("{");
        if (oWLHasValue.getHasValue() != null) {
            Object object = oWLHasValue.getHasValue();
            if (object instanceof RDFResource) {
                ((RDFResource)object).accept(this);
            } else {
                oWLHasValue.getOWLModel().asRDFSLiteral(object).accept(this);
            }
        }
        this.write("}");
        this.writeClosePar();
        this.pop();
    }

    public void visitOWLIndividual(OWLIndividual oWLIndividual) {
        this.write(oWLIndividual.getBrowserText());
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass oWLIntersectionClass) {
        this.push(oWLIntersectionClass);
        this.writeNAryLocical(oWLIntersectionClass);
        this.pop();
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality oWLMaxCardinality) {
        this.push(oWLMaxCardinality);
        this.writeCardinality(oWLMaxCardinality);
        this.pop();
    }

    public void visitOWLMinCardinality(OWLMinCardinality oWLMinCardinality) {
        this.push(oWLMinCardinality);
        this.writeCardinality(oWLMinCardinality);
        this.pop();
    }

    public void visitOWLNamedClass(OWLNamedClass oWLNamedClass) {
        this.push(oWLNamedClass);
        this.write(oWLNamedClass.getBrowserText());
        this.pop();
    }

    public void visitOWLObjectProperty(OWLObjectProperty oWLObjectProperty) {
        this.write(oWLObjectProperty.getBrowserText());
    }

    public void visitOWLOntology(OWLOntology oWLOntology) {
        this.write("<OWLOntology>");
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom oWLSomeValuesFrom) {
        this.push(oWLSomeValuesFrom);
        this.writeQuantifier(oWLSomeValuesFrom);
        this.pop();
    }

    public void visitOWLUnionClass(OWLUnionClass oWLUnionClass) {
        this.push(oWLUnionClass);
        this.writeNAryLocical(oWLUnionClass);
        this.pop();
    }

    public void visitRDFDatatype(RDFSDatatype rDFSDatatype) {
        this.write(rDFSDatatype.getBrowserText());
    }

    public void visitRDFIndividual(RDFIndividual rDFIndividual) {
        this.write(rDFIndividual.getBrowserText());
    }

    public void visitRDFList(RDFList rDFList) {
        this.write("<RDFList>");
    }

    public void visitRDFProperty(RDFProperty rDFProperty) {
        this.write(rDFProperty.getBrowserText());
    }

    public void visitRDFSLiteral(RDFSLiteral rDFSLiteral) {
        this.write(rDFSLiteral.getBrowserText());
    }

    public void visitRDFSNamedClass(RDFSNamedClass rDFSNamedClass) {
        this.push(rDFSNamedClass);
        this.pop();
    }

    public void visitRDFUntypedResource(RDFUntypedResource rDFUntypedResource) {
        this.write(rDFUntypedResource.getURI());
    }

    public void visitSWRLIndividual(SWRLIndividual sWRLIndividual) {
        this.visitOWLIndividual(sWRLIndividual);
    }

    public void visitSWRLAtomListIndividual(SWRLAtomList sWRLAtomList) {
        this.visitRDFList(sWRLAtomList);
    }
}

